

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToVerify2GetJobStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToVerify2GetJobStatus.sp,v $ $Id: archChunkToVerify2GetJobStatus.sp,v 1.3.12.6 2020/08/05 00:52:18 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archChunkToVerify2GetJobStatus')
BEGIN
	print '>>> Drop Stored Procedure: archChunkToVerify2GetJobStatus <<<'
	drop procedure archChunkToVerify2GetJobStatus
END
IF EXISTS (select * from GxQscripts where name='archChunkToVerify2GetJobStatus')
	delete from GxQscripts where name = 'archChunkToVerify2GetJobStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerify2GetJobStatus')
	delete from GXDBVersions where aliasname = 'archChunkToVerify2GetJobStatus'
GO
print '... Creating Procedure: archChunkToVerify2GetJobStatus'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archChunkToVerify2GetJobStatus
  @i_AdminJobId integer,
  @i_includeAttemptState integer = 0
AS
  DECLARE @errorCode integer;
  DECLARE @jobStatus integer;
  DECLARE @agedChunksSkipped integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @now INTEGER;
SET		@now = dbo.GetUnixTime(GetUTCDate())
DECLARE @MAX_FAILURE_COUNT INT = 3
    SELECT  TOP 1 @MAX_FAILURE_COUNT = ISNULL(value, 3)
    FROM    MMConfigs WITH (NOLOCK)
    WHERE   name = 'MMS2_CONFIG_AUXCOPY_STREAM_RETRY_COUNT'
DECLARE @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS	INT = 10
-- SET @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS = ISNULL( (SELECT Value FROM MMConfigs WHERE NAME = 'MMCONFIG_DASHCOPY_JOB_SKIP_CHUNK_ON_NONE_SOURCE_ERROR_INTERVAL_MINS'), 10)
SET @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS = ISNULL( (SELECT Value FROM MMConfigs WHERE NAME = 'MMCONFIG_AUXCOPY_RETRY_STREAM_INTERVAL_MINUTES'), 10)
DECLARE @RETRY_TIME_INTERVAL INT = 180 -- SECONDS
    SELECT  TOP 1 @RETRY_TIME_INTERVAL = ISNULL(value, 180)
    FROM    MMConfigs WITH (NOLOCK)
    WHERE   name = 'MMCONFIG_AUXCOPY_RETRY_STREAM_INTERVAL_MINUTES'
SET	@errorCode = 0
DECLARE @l_SIDBStoreId INTEGER = dbo.GetOptionInt(229570007, @i_adminJobId, 0, 0)
DECLARE @l_currentPhase INTEGER = (SELECT currentPhase FROM JMJobInfo WITH (READUNCOMMITTED) WHERE	jobId = @i_adminJobId)
DECLARE @dedupeValidate INT = 0
DECLARE @defragment INT = 0
DECLARE @orphanListing INT = 0
DECLARE	@opId INT = 0
SELECT	@opId = id
FROM	JMOpTable WITH (READUNCOMMITTED)
WHERE	operation=31 /*ARCHIVECHECK*/
SELECT	 @dedupeValidate = phase
FROM	JMPhase WITH (READUNCOMMITTED)
WHERE	opTableId = @opId and name = 'Validate Dedupe Data'
SELECT	 @orphanListing = phase
FROM	JMPhase WITH (READUNCOMMITTED)
WHERE	opTableId = @opId and name = 'Orphan Chunk listing'
SELECT	 @defragment = phase
FROM	JMPhase WITH (READUNCOMMITTED)
WHERE	opTableId = @opId and name = 'Defragment Data'
if (@l_currentPhase = @dedupeValidate) -- DEDUPVALIDATE
BEGIN
	IF EXISTS(	SELECT	1
					FROM	JMAdminJobInfoTable J WITH (READUNCOMMITTED)
					WHERE	JobId = @i_adminJobId
							AND TotalObjects > 0
							AND TotalObjects <= ObjectsDone
				)
		SET @jobStatus = 4 --DASHCOPY_ARCHMGR_JOB_SUCCESS -- SUCCESS
	ELSE
		SET @jobStatus = 3 --DASHCOPY_ARCHMGR_MORE_TO_COPY -- More to process
END
ELSE IF (@l_currentPhase = @orphanListing) -- ORPHANLISTING
BEGIN
	IF EXISTS(	SELECT	1
					FROM	JMAdminJobInfoTable J WITH (READUNCOMMITTED)
					WHERE	JobId = @i_adminJobId
							AND TotalObjects > 0
							AND TotalObjects <= ObjectsDone
				)
		SET @jobStatus = 4 --DASHCOPY_ARCHMGR_JOB_SUCCESS -- SUCCESS
	ELSE
		SET @jobStatus = 3 --DASHCOPY_ARCHMGR_MORE_TO_COPY -- More to process
END
ELSE IF (@l_currentPhase = @defragment) -- DEFRAGMENT
BEGIN
	IF EXISTS(	SELECT	1
					FROM	JMAdminJobInfoTable J WITH (READUNCOMMITTED)
					WHERE	JobId = @i_adminJobId
							AND TotalObjects > 0
							AND TotalObjects <= ObjectsDone
				)
		SET @jobStatus = 4 --DASHCOPY_ARCHMGR_JOB_SUCCESS -- SUCCESS
	ELSE
		SET @jobStatus = 3 --DASHCOPY_ARCHMGR_MORE_TO_COPY -- More to process
END
ELSE
BEGIN
	-- When this store procedure is invoked it is assumed that we dont have any running stream and we are not able to create new readers
	-- If we have any chunks in sent state and mp reservation exist on dest copy then mark the sent chunks as populated chunks
	UPDATE	AR
SET		Status = 0
	FROM	ArchChunkToVerify2 AR
	WHERE	AR.adminJobId = @i_AdminJobId
AND AR.Status IN (1, 5)
	SELECT	@errorCode = @@ERROR
	IF	@errorCode <> 0 GOTO ERR_EXIT
	UPDATE	ArchChunkToVerify2
SET		Status = 0
	WHERE	adminJobId = @i_AdminJobId
AND	Status = 3
			AND SkippedCount < @MAX_FAILURE_COUNT
			AND (
					SkippedForSeconds = 0 AND (Modified + @RETRY_TIME_INTERVAL) < @NOW
					OR
					(Modified + SkippedForSeconds) < @NOW
				)
	SELECT	@errorCode = @@ERROR
	IF	@errorCode <> 0 GOTO ERR_EXIT
	UPDATE	ArchChunkToVerify2
SET		Status = 6
	FROM	ArchChunkToVerify2 R, JMJobDataStats JDS WITH (NOLOCK)
	WHERE	R.AdminJobId = @i_AdminJobId
ANd		R.Status IN ( 3, 5, 0)
			AND		R.BackupJobId = JDS.JobID
			AND		R.destCopyId = JDS.archGrpCopyId
			AND		R.fileType = JDS.dataType
			AND		R.CommCellid = JDS.CommCellId
AND		((JDS.disabled & (8192 | 1)) = (8192 | 1)
OR (JDS.disabled & (256)) > 0)
	SELECT	@errorCode = @@ERROR
	IF	@errorCode <> 0 GOTO ERR_EXIT
	DECLARE	@totalChunks INTEGER = 0
	DECLARE	@totalProcessedChunks INTEGER = 0
	DECLARE	@totalSentChunks INTEGER = 0
	DECLARE	@totalSkippedChunks INTEGER = 0
	DECLARE	@totalSkippedAgedChunks INTEGER = 0
	DECLARE	@totalFailedChunks INTEGER = 0
	DECLARE	@totalPopulatedChunks INTEGER = 0
	SELECT	@totalChunks = COUNT(*),
@totalPopulatedChunks = ISNULL(SUM(CASE WHEN ArchChunkToVerify2.Status = 0 THEN  1 ELSE 0 END), 0),
@totalSentChunks = ISNULL(SUM(CASE WHEN ArchChunkToVerify2.Status = 1 THEN  1 ELSE 0 END), 0),
@totalProcessedChunks = ISNULL(SUM(CASE WHEN ArchChunkToVerify2.Status = 2 THEN  1 ELSE 0 END), 0),
@totalSkippedChunks = ISNULL(SUM(CASE WHEN ArchChunkToVerify2.Status = 3 AND ArchChunkToVerify2.SkippedCount < @MAX_FAILURE_COUNT THEN  1 ELSE 0 END), 0),
	--		@totalSkippedChunks = ISNULL(SUM(CASE WHEN ((ArchChunkToVerify2.Status = CVA_CHUNK_SKIPPED AND ArchChunkToVerify2.SkippedCount < @MAX_FAILURE_COUNT AND ArchChunkToVerify2.SkippedReason IN (CVA_READ_SOURCE_DATA_ERROR, CVA_AUXCOPY_SOURCE_MEDIA_ERROR))
	--											OR  (ArchChunkToVerify2.Status = CVA_CHUNK_SKIPPED AND ArchChunkToVerify2.SkippedCount < 12 AND ArchChunkToVerify2.SkippedReason NOT IN (CVA_READ_SOURCE_DATA_ERROR, CVA_AUXCOPY_SOURCE_MEDIA_ERROR))) THEN  1 ELSE 0 END), 0),
@totalSkippedAgedChunks = ISNULL(SUM(CASE WHEN ArchChunkToVerify2.Status = 6 THEN  1 ELSE 0 END), 0),
@totalFailedChunks = ISNULL(SUM(CASE WHEN (ArchChunkToVerify2.Status = 4
OR ArchChunkToVerify2.Status = 5
OR ArchChunkToVerify2.Status = 3 AND ArchChunkToVerify2.SkippedCount >= @MAX_FAILURE_COUNT) THEN  1 ELSE 0 END), 0)
												-- OR (ArchChunkToVerify2.Status = CVA_CHUNK_SKIPPED AND ArchChunkToVerify2.SkippedCount >= @MAX_FAILURE_COUNT AND ArchChunkToVerify2.SkippedReason IN (CVA_READ_SOURCE_DATA_ERROR, CVA_AUXCOPY_SOURCE_MEDIA_ERROR))
												-- OR (ArchChunkToVerify2.Status = CVA_CHUNK_SKIPPED AND ArchChunkToVerify2.SkippedCount >= 12 AND ArchChunkToVerify2.SkippedReason NOT IN (CVA_READ_SOURCE_DATA_ERROR, CVA_AUXCOPY_SOURCE_MEDIA_ERROR))) THEN  1 ELSE 0 END), 0)
	FROM	ArchChunkToVerify2
	WHERE	adminJobId = @i_AdminJobId
	SELECT	@errorCode = @@ERROR
	IF	@errorCode <> 0 GOTO ERR_EXIT
	SELECT	@totalChunks = @totalChunks + COUNT(*),
@totalProcessedChunks = @totalProcessedChunks + ISNULL(SUM(CASE WHEN H.Status = 2 THEN  1  ELSE 0 END), 0)
	FROM	archChunkToVerify2History H WITH (READUNCOMMITTED)
	WHERE	adminJobId = @i_AdminJobId
	SELECT	@errorCode = @@ERROR
	IF	@errorCode <> 0 GOTO ERR_EXIT
	-- This function returns following four values
	--	DASHCOPY_ARCHMGR_MORE_TO_COPY : We still have some chunks to be copied either in populated state or skipped state with skipped count < 3
	--	DASHCOPY_ARCHMGR_JOB_SUCCESS: All chunks are processed
	--	DASHCOPY_ARCHMGR_JOB_FAIL: All chunks are failed
	--	DASHCOPY_ARCHMGR_JOB_CWE: All chunks are either processed, failed or skipped with skipped count >= 3
	DECLARE @attempStartTime INTEGER = 0
	DECLARE @dataProcessedInCurrentAttempt INTEGER = 0
	DECLARE @totalFailedChunksCurrentAttempt INTEGER = 0
	DECLARE @totalSkippedAgedChunksCurrentAttempt INTEGER = 0
	SELECT	@attempStartTime = ISNULL(attemptStartTime, 0)
	FROM	JMJobInfo
	WHERE	JobId = @i_AdminJobId
	IF  (@attempStartTime != 0) AND (@i_includeAttemptState = 1)
	BEGIN
		IF EXISTS ( SELECT  TOP 1 R.adminJobId
						FROM	ArchChunkToVerify2 R
						WHERE	R.adminJobId = @i_AdminJobId
AND R.Status = 2
								AND R.Modified >= @attempStartTime)
			OR
		   EXISTS ( SELECT  TOP 1 R.adminJobId
						FROM	ArchChunkToVerify2History R
						WHERE	R.adminJobId = @i_AdminJobId
AND R.Status = 2
								AND R.Modified >= @attempStartTime)
			SET @dataProcessedInCurrentAttempt = 1
SELECT  @totalSkippedAgedChunksCurrentAttempt = ISNULL( SUM(CASE WHEN ArchChunkToVerify2.Status = 6 THEN  1 ELSE 0 END), 0),
@totalFailedChunksCurrentAttempt = ISNULL( SUM(CASE WHEN (ArchChunkToVerify2.Status = 4
OR ArchChunkToVerify2.Status = 5
OR ArchChunkToVerify2.Status = 3 AND ArchChunkToVerify2.SkippedCount >= @MAX_FAILURE_COUNT) THEN  1 ELSE 0 END), 0)
												-- OR (ArchChunkToVerify2.Status = CVA_CHUNK_SKIPPED AND ArchChunkToVerify2.SkippedCount >= @MAX_FAILURE_COUNT AND ArchChunkToVerify2.SkippedReason IN (CVA_READ_SOURCE_DATA_ERROR, CVA_AUXCOPY_SOURCE_MEDIA_ERROR))
												-- OR (ArchChunkToVerify2.Status = CVA_CHUNK_SKIPPED AND ArchChunkToVerify2.SkippedCount >= 12 AND ArchChunkToVerify2.SkippedReason NOT IN (CVA_READ_SOURCE_DATA_ERROR, CVA_AUXCOPY_SOURCE_MEDIA_ERROR))) THEN  1 ELSE 0 END), 0)
		FROM	ArchChunkToVerify2
		WHERE	adminJobId = @i_AdminJobId
				AND Modified  >= @attempStartTime
		IF (@totalPopulatedChunks > 0 OR @totalSkippedChunks > 0 OR @totalSentChunks > 0)
		BEGIN
			IF (@totalPopulatedChunks = 0 AND @totalSentChunks = 0)
			BEGIN
				IF  (@dataProcessedInCurrentAttempt = 1)
					SET @jobStatus = 11 --DASHCOPY_ARCHMGR_MORE_TO_COPY_PARTIAL_SUCCESS -- More to process
				ELSE
					SET @jobStatus = 12 --DASHCOPY_ARCHMGR_MORE_TO_COPY_FAILED -- More to process
			END
			ELSE
				SET @jobStatus = 3 --DASHCOPY_ARCHMGR_MORE_TO_COPY -- More to process
		END
		ELSE IF (@totalChunks = @totalProcessedChunks) OR (@dataProcessedInCurrentAttempt = 1 AND @totalSkippedAgedChunksCurrentAttempt = 0 AND @totalFailedChunksCurrentAttempt = 0)
			SET @jobStatus = 4 --DASHCOPY_ARCHMGR_JOB_SUCCESS -- SUCCESS
		ELSE IF (@totalChunks = @totalFailedChunks) OR (@dataProcessedInCurrentAttempt = 0 AND @totalSkippedAgedChunksCurrentAttempt = 0 AND @totalFailedChunksCurrentAttempt > 0)
			SET @jobStatus = 5 --DASHCOPY_ARCHMGR_JOB_FAIL -- FAILED
		ELSE IF (@dataProcessedInCurrentAttempt = 0 AND @totalSkippedAgedChunksCurrentAttempt > 0 AND @totalFailedChunksCurrentAttempt = 0)
			SET @jobStatus = 9 --DASHCOPY_ARCHMGR_JOB_CWW -- CWW
		ELSE IF ( @dataProcessedInCurrentAttempt = 0)
				SET @jobStatus = 5 --DASHCOPY_ARCHMGR_JOB_FAIL -- FAILED
		ELSE
			SET @jobStatus = 6 --DASHCOPY_ARCHMGR_JOB_CWE -- PARTIALSUCCESS
	END
	ELSE
	BEGIN
		IF (@totalPopulatedChunks > 0 OR @totalSkippedChunks > 0 OR @totalSentChunks > 0)
		BEGIN
			IF (@i_includeAttemptState = 0 AND @totalPopulatedChunks = 0 AND @totalSentChunks = 0)
				SET @jobStatus = 10 --DASHCOPY_ARCHMGR_MORE_TO_COPY_ALL_SKIPPED
			ELSE
				SET @jobStatus = 3 --DASHCOPY_ARCHMGR_MORE_TO_COPY -- More to process
		END
		ELSE IF (@totalChunks = @totalProcessedChunks)
			SET @jobStatus = 4 --DASHCOPY_ARCHMGR_JOB_SUCCESS -- SUCCESS
		ELSE IF (@totalChunks = @totalFailedChunks)
			SET @jobStatus = 5 --DASHCOPY_ARCHMGR_JOB_FAIL -- FAILED
		ELSE IF (@totalFailedChunks = 0 AND @totalSkippedChunks = 0 AND (@totalSkippedAgedChunks > 0))
			SET @jobStatus = 9 --DASHCOPY_ARCHMGR_JOB_CWW -- CWW
		ELSE
			SET @jobStatus = 6 --DASHCOPY_ARCHMGR_JOB_CWE -- PARTIALSUCCESS
	END
END
ERR_EXIT:
SELECT @errorCode, @jobStatus, @totalSkippedAgedChunks
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToVerify2GetJobStatus')
	delete from GxQscripts where name = 'archChunkToVerify2GetJobStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerify2GetJobStatus')
	delete from GXDBVersions where aliasname = 'archChunkToVerify2GetJobStatus'
GO

insert into GXDBVersions values(2, 'archChunkToVerify2GetJobStatus',  '00010003001200060000', 'archChunkToVerify2GetJobStatus', '00010003001200060000')
GO

