

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToVerify2GetJobProgress.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToVerify2GetJobProgress.sp,v $ $Id: archChunkToVerify2GetJobProgress.sp,v 1.1.54.3 2020/05/23 13:52:01 chandru Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archChunkToVerify2GetJobProgress')
BEGIN
	print '>>> Drop Stored Procedure: archChunkToVerify2GetJobProgress <<<'
	drop procedure archChunkToVerify2GetJobProgress
END
IF EXISTS (select * from GxQscripts where name='archChunkToVerify2GetJobProgress')
	delete from GxQscripts where name = 'archChunkToVerify2GetJobProgress'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerify2GetJobProgress')
	delete from GXDBVersions where aliasname = 'archChunkToVerify2GetJobProgress'
GO
print '... Creating Procedure: archChunkToVerify2GetJobProgress'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archChunkToVerify2GetJobProgress
  @i_adminJobId int,
  @i_archCopyId int
AS
  DECLARE @TotalData bigint
  DECLARE @TotalDataProcessed bigint
  DECLARE @TotalDataTobeProcessed bigint
-- Chunk status
/*
--Values for Status column in archChunkToReplicate table
*/
SET		@TotalData = 0
SET		@TotalDataProcessed = 0
SET		@TotalDataTobeProcessed = 0
DECLARE @l_SIDBStoreId INTEGER = dbo.GetOptionInt(229570007, @i_adminJobId, 0, 0)
DECLARE @l_currentPhase INTEGER
DECLARE @l_jobStartTime INTEGER
SELECT	@l_currentPhase = currentPhase, @l_jobStartTime = jobStartTime
FROM	JMJobInfo WITH (READUNCOMMITTED)
WHERE	jobId = @i_adminJobId
DECLARE @dedupeValidate INT = 0
DECLARE @defragment INT = 0
DECLARE @orphanListing INT = 0
DECLARE	@opId INT = 0
SELECT	@opId = id
FROM	JMOpTable WITH (READUNCOMMITTED)
WHERE	operation=31 /*ARCHIVECHECK*/
SELECT	 @dedupeValidate = phase
FROM	JMPhase WITH (READUNCOMMITTED)
WHERE	opTableId = @opId and name = 'Validate Dedupe Data'
SELECT	 @orphanListing = phase
FROM	JMPhase WITH (READUNCOMMITTED)
WHERE	opTableId = @opId and name = 'Orphan Chunk listing'
SELECT	 @defragment = phase
FROM	JMPhase WITH (READUNCOMMITTED)
WHERE	opTableId = @opId and name = 'Defragment Data'
if (@l_currentPhase = @dedupeValidate) -- DEDUPVALIDATE
BEGIN
	SELECT	@TotalData = TotalObjects, @TotalDataProcessed = ObjectsDone
	FROM	JMAdminJobInfoTable J WITH (READUNCOMMITTED)
	WHERE	JobId = @i_adminJobId
	-- For GDSP case, some copies may not have any chunks
	-- IF EXISTS (SELECT 1	FROM archChunkToVerify2 WHERE adminJobId = @i_adminJobId )
	IF (@TotalData = 0)
	BEGIN
		-- We are tracking progress for store based DV on phase 1 based on primary entries (unique blocks)
		-- @TotalData will have total number of primary entries present on this store
		SELECT	@TotalData = SUM(ISNULL(PrimaryEntries, 0))
		FROM	IdxSIDBUsageHistory H WITH (READUNCOMMITTED),
				(SELECT	SIDBStoreId, SubStoreId, MAX(ISNULL(ModifiedTime, 0)) MaxModifiedTime
				FROM	IdxSIDBUsageHistory WITH (READUNCOMMITTED)
				WHERE	SIDBStoreId = @l_SIDBStoreId
						AND ModifiedTime <= @l_jobStartTime
				GROUP BY SIDBStoreId, SubStoreId) MH
		WHERE	H.SIDBStoreId = MH.SIDBStoreId
				AND H.SubStoreId = MH.SubStoreId
				AND H.ModifiedTime = MH.MaxModifiedTime
	END
END
ELSE IF (@l_currentPhase = @orphanListing) -- ORPHANLISTING
BEGIN
	SELECT	@TotalDataProcessed = ObjectsDone
	FROM	JMAdminJobInfoTable J WITH (READUNCOMMITTED)
	WHERE	JobId = @i_adminJobId
	DECLARE @l_maxVolumeId INTEGER = 0
    SELECT @l_maxVolumeId = attributeValueInt
	FROM JMJobOptions WITH (READUNCOMMITTED)
    WHERE jobId = @i_adminJobId AND commcellId = 2
AND attributeId = 65
	IF (@l_maxVolumeId = 0)
	BEGIN
		SELECT	@TotalData = COUNT(*),  @l_maxVolumeId = MAX(VolumeId)
		FROM	MMVolume WITH (READUNCOMMITTED)
		WHERE	SIDBStoreID = @l_SIDBStoreId
				AND CreationTime < @l_jobStartTime
		INSERT INTO JMJobOptions(jobId, commCellId, attributeId, attributeName, attributeValueInt, attributeValue)
VALUES (@i_adminJobId, 2, 65, 'Maximum Volume id for Deduplication Database', @l_maxVolumeId, N'')
	END
	ELSE
	BEGIN
		SELECT	@TotalData = COUNT(*),  @l_maxVolumeId = MAX(VolumeId)
		FROM	MMVolume WITH (READUNCOMMITTED)
		WHERE	SIDBStoreID = @l_SIDBStoreId
				AND VolumeId <= @l_maxVolumeId
	END
END
ELSE IF (@l_currentPhase = @defragment) -- DEFRAGMENT
BEGIN
	SELECT	@TotalDataProcessed = ObjectsDone
	FROM	JMAdminJobInfoTable J WITH (READUNCOMMITTED)
	WHERE	JobId = @i_adminJobId
    SELECT @TotalData = attributeValueInt
	FROM JMJobOptions WITH (READUNCOMMITTED)
    WHERE jobId = @i_adminJobId AND commcellId = 2
AND attributeId = 54
	IF @TotalData = 0 AND @@ROWCOUNT = 0
	BEGIN
		-- We are tracking progress for store based DV on phase 1 based on primary entries (unique blocks)
		-- @TotalData will have total number of primary entries present on this store
		-- We are changing the code to populated fewer number of rows
		SELECT	@TotalData = COUNT(*)
		FROM	archFileCopyDedup AFCD WITH (READUNCOMMITTED), archChunkMapping ACM WITH (READUNCOMMITTED)
		WHERE	AFCD.SIDBStoreId = @l_SIDBStoreId
				AND AFCD.archFileId = ACM.archFileid
				AND AFCD.commCellId = ACM.commCellId
				AND AFCD.archCopyId = ACM.archCopyId
	END
END
ELSE
BEGIN
	SELECT	@TotalData  =  SUM(unCompBytesSize),
			@TotalDataProcessed = SUM(CASE WHEN (R.Status = 2) THEN (unCompBytesSize) ELSE 0 END)
	FROM	ArchChunkToVerify2 R WITH (NOLOCK)
	WHERE	R.AdminJobId = @i_adminJobId
			AND (@i_archCopyId = 0 OR R.SrcCopyId = @i_archCopyId)
	SELECT	@TotalData  +=  ISNULL(SUM(unCompBytesSize), 0),
			@TotalDataProcessed = ISNULL(SUM(CASE WHEN (R.Status = 2) THEN (unCompBytesSize) ELSE 0 END), 0)
	FROM	ArchChunkToVerify2History R WITH (NOLOCK)
	WHERE	R.AdminJobId = @i_adminJobId
			AND (@i_archCopyId = 0 OR R.SrcCopyId = @i_archCopyId)
END
SELECT @TotalDataTobeProcessed = @TotalData - @TotalDataProcessed
SELECT @TotalData, @TotalDataProcessed, @TotalDataTobeProcessed
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToVerify2GetJobProgress')
	delete from GxQscripts where name = 'archChunkToVerify2GetJobProgress'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerify2GetJobProgress')
	delete from GXDBVersions where aliasname = 'archChunkToVerify2GetJobProgress'
GO

insert into GXDBVersions values(2, 'archChunkToVerify2GetJobProgress',  '00010001005400030000', 'archChunkToVerify2GetJobProgress', '00010001005400030000')
GO

