

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToSyncDDBSetStream.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToSyncDDBSetStream.sp,v $ $Id: archChunkToSyncDDBSetStream.sp,v 1.3.86.2 2018/03/22 00:59:35 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archChunkToSyncDDBSetStream <<<'

IF EXISTS (select * from sysobjects where name='archChunkToSyncDDBSetStream')
	drop procedure archChunkToSyncDDBSetStream
IF EXISTS (select * from GxQscripts where name='archChunkToSyncDDBSetStream')
	delete from GxQscripts where name = 'archChunkToSyncDDBSetStream'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToSyncDDBSetStream')
	delete from GXDBVersions where aliasname = 'archChunkToSyncDDBSetStream'
GO
print '... Creating Procedure: archChunkToSyncDDBSetStream'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archChunkToSyncDDBSetStream
  @i_archCopyId int,
  @i_streamNum int,
  @i_maxConcurrency int,
  @i_jobId int
AS
  DECLARE @o_error integer;
  DECLARE @o_errorString varchar(1024);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
BEGIN TRAN SyncDDBSetStream_tran
	DECLARE	@errVal	INTEGER
	DECLARE	@errStr	VARCHAR(1024)
	SET @errVal = 0
	SET @errStr = 'NO ERROR'
	IF	@i_streamNum > 0
			AND EXISTS (SELECT * FROM ArchChunkToSyncDDB WITH (NOLOCK)
						WHERE archCopyId = @i_archCopyId
						AND streamNum = @i_streamNum
						AND adminJobId = @i_jobId)
		GOTO CX_EXIT
	DECLARE @tblSegmentStream TABLE (
		streamNum			integer,
		segmentId			integer
	)
	-- Do not support dynamic stream allocation for snap copy
	IF EXISTS (SELECT * FROM ArchGroupCopy WITH (NOLOCK) WHERE id = @i_archCopyId AND isSnapCopy = 1)
		GOTO CX_EXIT
	DECLARE @max_streamNum	INTEGER
	SELECT	@max_streamNum = B.maxStreams
	FROM	archGroupCopy A WITH (NOLOCK), archGroup B WITH (NOLOCK)
	WHERE	A.id = @i_archCopyId
	AND		A.archGroupId = B.id
	IF @max_streamNum > @i_maxConcurrency
		set @max_streamNum = @i_maxConcurrency
	DECLARE @streamNum		INTEGER
	DECLARE @nextStream		INTEGER
	SET @nextStream = 0
	SET @streamNum = 1
	IF	@i_streamNum > 0
	BEGIN
		SET @streamNum = @i_streamNum
	END
	INSERT INTO @tblSegmentStream
	SELECT DISTINCT streamNum, segmentId
	FROM ArchChunkToSyncDDB WITH (NOLOCK)
	WHERE archCopyId = @i_archCopyId
	AND segmentId > 0
	AND adminJobId = @i_jobId
	WHILE 1 = 1
	BEGIN
		IF NOT EXISTS (SELECT * FROM @tblSegmentStream WHERE streamNum = 0)
			BREAK
		IF EXISTS (SELECT * FROM @tblSegmentStream WHERE streamNum = @streamNum)
			SET @nextStream = 1
		IF @nextStream > 0
		BEGIN
			IF	@i_streamNum > 0
				BREAK
			SET @streamNum = @streamNum + 1
			IF @streamNum > @max_streamNum
				BREAK
			SET @nextStream = 0
			CONTINUE
		END
		DECLARE @t_segmentId INTEGER
		SET @t_segmentId = (SELECT MIN(segmentId) FROM @tblSegmentStream WHERE streamNum = 0)
		IF @t_segmentId IS NOT null
		BEGIN
				UPDATE @tblSegmentStream
				SET streamNum = @streamNum
				WHERE segmentId = @t_segmentId
				UPDATE ArchChunkToSyncDDB
				SET streamNum = @streamNum
				FROM ArchChunkToSyncDDB
				WHERE segmentId = @t_segmentId
				AND archCopyId = @i_archCopyId
				AND adminJobId = @i_jobId
				SELECT @errVal = @@ERROR
				IF @errVal <> 0
				BEGIN
						SET @errStr = 'Failed to update StreamNum for archive files in ArchChunkToSyncDDB: DB error!'
						GOTO CX_EXIT_ERROR
				END
				CONTINUE
		END
		SET @nextStream = 1
	END
CX_EXIT:
	SET @errStr = 'All streams are assigned for copy with max stream: [' + convert(varchar(10), @max_streamNum) + ']'
	COMMIT TRAN SyncDDBSetStream_tran
	SELECT 0, ''
	RETURN
CX_EXIT_ERROR:
	ROLLBACK TRAN SyncDDBSetStream_tran
	SELECT @errVal, @errStr
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToSyncDDBSetStream')
	delete from GxQscripts where name = 'archChunkToSyncDDBSetStream'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToSyncDDBSetStream')
	delete from GXDBVersions where aliasname = 'archChunkToSyncDDBSetStream'
GO

insert into GXDBVersions values(2, 'archChunkToSyncDDBSetStream',  '00010003008600020000', 'archChunkToSyncDDBSetStream', '00010003008600020000')
GO

