

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToSyncDDBSegment.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToSyncDDBSegment.sp,v $ $Id: archChunkToSyncDDBSegment.sp,v 1.4.48.4 2018/12/01 23:23:04 anarulkar Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archChunkToSyncDDBSegment')
BEGIN
	print '>>> Drop Stored Procedure: archChunkToSyncDDBSegment <<<'
	drop procedure archChunkToSyncDDBSegment
END
IF EXISTS (select * from GxQscripts where name='archChunkToSyncDDBSegment')
	delete from GxQscripts where name = 'archChunkToSyncDDBSegment'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToSyncDDBSegment')
	delete from GXDBVersions where aliasname = 'archChunkToSyncDDBSegment'
GO
print '... Creating Procedure: archChunkToSyncDDBSegment'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archChunkToSyncDDBSegment
  @i_archCopyId int,
  @i_minSegmentGB bigint,
  @i_adminJobId int
AS
  DECLARE @o_error integer;
  DECLARE @o_errorString varchar(1024);
  DECLARE @o_lastSegmentId integer;
SET NOCOUNT ON
BEGIN TRAN SyncDDBSegment_tran
	IF object_id('tempdb.dbo.#tblChunkToSyncDDB') IS NOT NULL DROP TABLE #tblChunkToSyncDDB
	IF object_id('tempdb.dbo.#tblChunkInSegment') IS NOT NULL DROP TABLE #tblChunkInSegment
	DECLARE	@cursor	INTEGER
	DECLARE	@errVal	INTEGER
	DECLARE	@errStr	VARCHAR(1024)
	DECLARE @segmentId	INTEGER
	SET @segmentId = 0
	SET @errVal = 0
	SET @errStr = 'NO ERROR'
	SET @cursor = 0
	IF @i_minSegmentGB = 0
		SET @i_minSegmentGB = 2
	create table #tblChunkToSyncDDB (
		id					integer IDENTITY (1,1),
		archCopyId			integer,
		archChunkId			bigint,
		archFileId			integer,
		commCellId			integer,
		mediaGroupId		integer,
		physicalSize		bigint,
		segmentID			integer,
		primary key (id)
	)
	create index ChunkToSyncDDB_temp_idx_1 on #tblChunkToSyncDDB (archFileId, commCellId)
	create index ChunkToSyncDDB_temp_idx_2 on #tblChunkToSyncDDB (archChunkId, commCellId)
	create table #tblChunkInSegment (
		id					integer,
		archCopyId			integer,
		archChunkId			bigint,
		archFileId			integer,
		commCellId			integer,
		mediaGroupId		integer,
		physicalSize		bigint,
		segmentID			integer,
		primary key (id)
	)
	create index ChunkInSegment_temp_idx_1 on #tblChunkInSegment (archFileId, commCellId)
	create index ChunkInSegment_temp_idx_2 on #tblChunkInSegment (archChunkId, commCellId)
	-- Do not support dynamic stream allocation for snap copy
	IF EXISTS (SELECT * FROM ArchGroupCopy WITH (NOLOCK) WHERE id = @i_archCopyId AND isSnapCopy = 1)
		GOTO CX_EXIT
	DECLARE @multiplex         INTEGER = 0
    if exists (
            select archCopyId, archChunkId
            from ArchChunkToSyncDDB with (NOLock)
            where archCopyId = @i_archCopyId
            group by archCopyId, archChunkId having count(archFileId) > 1
            )
    SET @multiplex = 1
	INSERT INTO #tblChunkToSyncDDB
	SELECT a.archCopyId, a.archChunkId, a.archFileId, a.commCellId, a.mediaGroupId, a.physicalSize, 0
	FROM ArchChunkToSyncDDB a WITH (NOLOCK), MMVolume b WITH (NOLOCK), MMMedia c WITH (NOLOCK)
	WHERE a.archCopyId = @i_archCopyId
	AND a.adminJobId = @i_adminJobId
	AND a.volumeId = b.volumeId
	AND b.mediaId = c.mediaId
	AND c.mediaTypeId = 10001
	AND a.segmentId = 0
	IF @@ROWCOUNT = 0
		GOTO CX_EXIT
	-- Clear source stream and media group info
	UPDATE ArchChunkToSyncDDB
	SET streamNum = 0
	FROM ArchChunkToSyncDDB a, #tblChunkToSyncDDB b
	WHERE a.archChunkId = b.archChunkId
	AND a.archFileId = b.archFileId
	AND a.commCellId = b.commCellId
	AND a.archCopyId = @i_archCopyId
	AND a.archCopyId = b.archCopyId
	AND a.adminJobId = @i_adminJobId
	SELECT @errVal = @@ERROR
	IF @errVal <> 0
	BEGIN
			SET @errStr = 'Failed to clear streams for ArchChunkToSyncDDB: DB error!'
			GOTO CX_EXIT_ERROR
	END
	DECLARE @archFileId		INTEGER
	DECLARE @commCellId		INTEGER
	DECLARE @archCopyId		INTEGER
	DECLARE @mediaGroupId	INTEGER
	DECLARE @mediaGroupId_prev INTEGER
	SET @mediaGroupId_prev = -1
	DECLARE AFCursor CURSOR FOR
			SELECT DISTINCT archCopyId, archFileId, commCellId, mediaGroupId
			FROM #tblChunkToSyncDDB
			ORDER BY archCopyId, mediaGroupId, commCellId, archFileId
	OPEN AFCursor
	SET @cursor = 1
	FETCH NEXT from AFCursor INTO @archCopyId, @archFileId, @commCellId, @mediaGroupId
	WHILE (1 = 1)
	BEGIN
		DECLARE @fetchNext INTEGER
		SET @fetchNext = 1
		IF @@FETCH_STATUS <> 0
			GOTO CREATE_SEGMENT
		IF EXISTS (select * from #tblChunkToSyncDDB WITH (NOLOCK)
					where archFileId = @archFileId
					and commCellId = @commCellId
					and archCopyId = @archCopyId
					and segmentId > 0
					)
			GOTO FETCH_NEXT
		IF @mediaGroupId_prev < 0
			SET @mediaGroupId_prev = @mediaGroupId
		IF @mediaGroupId_prev <> @mediaGroupId
		BEGIN
			-- MediaGroupId changed, needs to group previous chunks
			-- This archive file will be processed again
			SET @mediaGroupId_prev = @mediaGroupId
			SET @fetchNext = 0
			GOTO CREATE_SEGMENT
		END
		-- Set flag for all chunks of given archive file
		INSERT INTO #tblChunkInSegment
		SELECT a.*
		FROM #tblChunkToSyncDDB a LEFT OUTER JOIN #tblChunkInSegment b ON a.id = b.id
		WHERE a.archFileId = @archFileId
		AND a.commCellId = @commCellId
		AND b.id IS NULL
		-- No new chunks of this archive file found
		IF @@ROWCOUNT = 0
			GOTO FETCH_NEXT
		WHILE (1 = 1)
		BEGIN
			DECLARE @sumSegmentSize bigint = 0
			DECLARE @numChunks integer = 0
			IF @multiplex > 0
			BEGIN
				-- Get linked chunks through multiplexing
				INSERT INTO #tblChunkInSegment
				SELECT DISTINCT b.*
				FROM #tblChunkInSegment a right outer join #tblChunkToSyncDDB b on a.id = b.id INNER JOIN #tblChunkInSegment c ON c.archChunkId = b.archChunkId AND c.commCellId = b.commCellId
				WHERE a.id is null
				SET @numChunks = @@ROWCOUNT
				IF @numChunks > 0
				BEGIN
					-- Add linked archive files.
					INSERT INTO #tblChunkInSegment
					SELECT DISTINCT b.*
					FROM #tblChunkInSegment a right outer join #tblChunkToSyncDDB b on a.id = b.id INNER JOIN #tblChunkInSegment c ON c.archFileId = b.archFileId AND c.commCellId = b.commCellId
					WHERE a.id is null
					SET @numChunks = @@ROWCOUNT
				END
			END
			SET @sumSegmentSize = (SELECT SUM(physicalSize) FROM #tblChunkInSegment)
			IF @sumSegmentSize < @i_minSegmentGB * 1024 * 1024 * 1024
			BEGIN
				IF @numChunks = 0
					GOTO FETCH_NEXT
				ELSE
					CONTINUE
			END
			IF @numChunks = 0
				BREAK;
		END
CREATE_SEGMENT:
		IF EXISTS (SELECT * FROM #tblChunkInSegment)
		BEGIN
			INSERT INTO archChunkSegment
			SELECT @i_archCopyId, @archCopyId, 0
			SELECT @errVal = @@ERROR, @segmentId = @@IDENTITY
			IF @errVal <> 0 OR @segmentId = 0
			BEGIN
					SET @errStr = 'Failed to create new segment for aux copy: DB error!'
					GOTO CX_EXIT_ERROR
			END
			DELETE FROM archChunkSegment WITH (ROWLOCK)
			WHERE segmentId = @segmentId
			SELECT @errVal = @@ERROR
			IF @errVal <> 0
			BEGIN
					SET @errStr = 'Failed to delete segment ID for aux copy: DB error!'
					GOTO CX_EXIT_ERROR
			END
			UPDATE #tblChunkToSyncDDB
			SET segmentId = @segmentId
			FROM #tblChunkToSyncDDB a, #tblChunkInSegment b
			WHERE a.archChunkId = b.archChunkId
			AND a.archFileId = b.archFileId
			AND a.commCellId = b.commCellId
			AND a.archCopyId = b.archCopyId
			SELECT @errVal = @@ERROR
			IF @errVal <> 0
			BEGIN
					SET @errStr = 'Failed to update segmentId for ArchChunkToSyncDDB: DB error!'
					GOTO CX_EXIT_ERROR
			END
			-- Clear temp table
			DELETE FROM #tblChunkInSegment
		END
		IF @@FETCH_STATUS <> 0
			GOTO CX_EXIT
FETCH_NEXT:
		IF @fetchNext = 1
			FETCH NEXT from AFCursor INTO @archCopyId, @archFileId, @commCellId, @mediaGroupId
	END
CX_EXIT:
	UPDATE ArchChunkToSyncDDB
	SET segmentId = b.segmentId
	FROM ArchChunkToSyncDDB a, #tblChunkToSyncDDB b
	WHERE a.archChunkId = b.archChunkId
	AND a.archFileId = b.archFileId
	AND a.commCellId = b.commCellId
	AND a.archCopyId = b.archCopyId
	AND a.adminJobId = @i_adminJobId
	IF object_id('tempdb.dbo.#tblChunkToSyncDDB') IS NOT NULL DROP TABLE #tblChunkToSyncDDB
	IF object_id('tempdb.dbo.#tblChunkInSegment') IS NOT NULL DROP TABLE #tblChunkInSegment
	IF @cursor = 1
	BEGIN
		CLOSE AFCursor
		DEALLOCATE AFCursor
	END
	COMMIT TRAN SyncDDBSegment_tran
	SELECT 0, '', @segmentId
	RETURN
CX_EXIT_ERROR:
	IF object_id('tempdb.dbo.#tblChunkToSyncDDB') IS NOT NULL DROP TABLE #tblChunkToSyncDDB
	IF object_id('tempdb.dbo.#tblChunkInSegment') IS NOT NULL DROP TABLE #tblChunkInSegment
	IF @cursor = 1
	BEGIN
		CLOSE AFCursor
		DEALLOCATE AFCursor
	END
	ROLLBACK TRAN SyncDDBSegment_tran
	SELECT @errVal, @errStr, @segmentId
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToSyncDDBSegment')
	delete from GxQscripts where name = 'archChunkToSyncDDBSegment'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToSyncDDBSegment')
	delete from GXDBVersions where aliasname = 'archChunkToSyncDDBSegment'
GO

insert into GXDBVersions values(2, 'archChunkToSyncDDBSegment',  '00010004004800040000', 'archChunkToSyncDDBSegment', '00010004004800040000')
GO

