

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToSyncDDBListMedia.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToSyncDDBListMedia.sp,v $ $Id: archChunkToSyncDDBListMedia.sp,v 1.3.86.3 2018/08/30 22:54:33 chandru Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archChunkToSyncDDBListMedia <<<'

IF EXISTS (select * from sysobjects where name='archChunkToSyncDDBListMedia')
	drop procedure archChunkToSyncDDBListMedia
IF EXISTS (select * from GxQscripts where name='archChunkToSyncDDBListMedia')
	delete from GxQscripts where name = 'archChunkToSyncDDBListMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToSyncDDBListMedia')
	delete from GXDBVersions where aliasname = 'archChunkToSyncDDBListMedia'
GO
print '... Creating Procedure: archChunkToSyncDDBListMedia'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archChunkToSyncDDBListMedia
  @i_archCopyId int,
  @i_streamNum int,
  @i_jobId int,
  @i_reconByAF int
AS
  DECLARE @o_srcStream int;
  DECLARE @o_volumeId int;
  DECLARE @o_mediaId int;
  DECLARE @o_mediaGroupId int;
  DECLARE @o_barcode varchar(256);
  DECLARE @o_firstChunkId bigint;
  DECLARE @o_lastChunkId bigint;
  DECLARE @o_archFileId int;
  DECLARE @o_commCellId int;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
IF (@i_reconByAF = 0)
BEGIN
	SELECT streamNum, volumeId, mediaId, mediaGroupId,
			(SELECT barcode FROM MMMedia WITH (READUNCOMMITTED) WHERE MediaId = archChunkToSyncDDB.mediaId),
			MIN(archChunkId) AS firstChunkId, MAX(archChunkId) AS lastChunkId,
			0, 0
	FROM archChunkToSyncDDB WITH (READUNCOMMITTED)
	WHERE archCopyId = @i_archCopyId
	AND adminJobId = @i_jobId
	AND (@i_streamNum = 0 AND streamNum > 0 OR @i_streamNum > 0 AND @i_streamNum = streamNum)
	GROUP BY streamNum, volumeId, mediaId, mediaGroupId
	ORDER BY streamNum, firstChunkId, lastChunkId
END
ELSE
BEGIN
	DECLARE	@tblMediaInfo	TABLE (
		srcCopyId int, srcStream int,
		volumeId int, mediaId int, mediaGroupId int,
		archFileId int, commCellId int, fileMarkerNo int, archChunkId bigint)
	DECLARE	@tblMedia	TABLE (
		srcCopyId int, srcStream int,
		volumeId int, mediaId int, mediaGroupId int,
archFileId int, commCellId int, barcode varchar(256),
		firstChunkId bigint, lastChunkId bigint)
	INSERT	INTO @tblMediaInfo
	SELECT	archCopyId, streamNum, volumeId, mediaId, mediaGroupId,
			CASE WHEN extraFlags & 1 > 0 THEN archFileId ELSE 0 END,
			CASE WHEN extraFlags & 1 > 0 THEN commCellId ELSE 0 END,
			fileMarkerNo, archChunkId
	FROM archChunkToSyncDDB WITH (READUNCOMMITTED)
	WHERE archCopyId = @i_archCopyId
	AND adminJobId = @i_jobId
	AND (@i_streamNum = 0 AND streamNum > 0 OR @i_streamNum > 0 AND @i_streamNum = streamNum)
DECLARE	@tblMediaName TABLE ( mediaId int, barcode varchar(256))
	INSERT INTO @tblMediaName
	select mediaId, MountPathName
	from MMS2getMountPathNameGUIView WITH (NOLOCK)
	where mediaId in (SELECT DISTINCT mediaId from @tblMediaInfo)
	INSERT INTO @tblMediaName
	select mediaId, Barcode
	from MMMedia WITH (NOLOCK)
	where mediaId in (SELECT DISTINCT mediaId from @tblMediaInfo)
	and mediaId not in (SELECT DISTINCT mediaId from @tblMediaName)
	INSERT	INTO @tblMedia
	SELECT	a.srcCopyId, a.srcStream,
			a.volumeId, a.mediaId, a.mediaGroupId,
			a.archFileId, a.commCellId, b.barcode,
			MIN(a.archChunkId), MAX(a.archChunkId)
	FROM	@tblMediaInfo a, @tblMediaName b
	WHERE	A.mediaId = B.mediaId AND B.mediaId > 0
	GROUP BY a.srcCopyId, a.srcStream,
			a.volumeId, a.mediaId, a.mediaGroupId,
			a.archFileId, a.commCellId, b.barcode
	INSERT	INTO @tblMedia
	SELECT	a.srcCopyId, a.srcStream,
			a.volumeId, MIN(a.fileMarkerNo), a.mediaGroupId,
			0, 0, '',
			MIN(a.archChunkId), MAX(a.archChunkId)
	FROM	@tblMediaInfo a
	WHERE	A.mediaId = 0
	GROUP BY a.srcCopyId, a.srcStream,
			a.volumeId, a.mediaGroupId
	select srcStream, volumeId, mediaId, mediaGroupId, barcode, firstChunkId, lastChunkId, archFileId, commCellId
	from @tblMedia
	ORDER BY srcStream, archFileId, commCellId, firstChunkId
END
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToSyncDDBListMedia')
	delete from GxQscripts where name = 'archChunkToSyncDDBListMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToSyncDDBListMedia')
	delete from GXDBVersions where aliasname = 'archChunkToSyncDDBListMedia'
GO

insert into GXDBVersions values(2, 'archChunkToSyncDDBListMedia',  '00010003008600030000', 'archChunkToSyncDDBListMedia', '00010003008600030000')
GO

