

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToSyncDDBInsert.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToSyncDDBInsert.sp,v $ $Id: archChunkToSyncDDBInsert.sp,v 1.35.12.20 2020/05/11 15:22:28 cliu Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archChunkToSyncDDBInsert')
BEGIN
	print '>>> Drop Stored Procedure: archChunkToSyncDDBInsert <<<'
	drop procedure archChunkToSyncDDBInsert
END
IF EXISTS (select * from GxQscripts where name='archChunkToSyncDDBInsert')
	delete from GxQscripts where name = 'archChunkToSyncDDBInsert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToSyncDDBInsert')
	delete from GXDBVersions where aliasname = 'archChunkToSyncDDBInsert'
GO
print '... Creating Procedure: archChunkToSyncDDBInsert'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archChunkToSyncDDBInsert
  @i_adminJobId int,
  @i_archCopyId int,
  @i_SIDBStoreId int,
  @i_reconByAF int
AS
  DECLARE @retVal integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @AllowResumOnReconDDBJob INT = 0
SET		@AllowResumOnReconDDBJob = ISNULL((SELECT TOP 1 value FROM MMConfigs WHERE name = 'MMCONFIG_ALLOW_RESTARTABILITY_ON_DDB_RECON_JOB'), 0)
-- When reconnByAF is expected, resumability cannot be supported due to caching on MA
IF (@AllowResumOnReconDDBJob > 0 AND (@i_reconByAF = 1))
	SET @AllowResumOnReconDDBJob = 0
WHILE 1 = 1
BEGIN
	-- This is mainly to create a clean slate for recon to start. With multiple recons being allowed and with resumability allowed conditions have changed.
	-- If resume is allowed then cleanup should not happen for a running job since the other adminJob may be for some other partition.
	-- else if resume is not allowed then cleanup should happen only for the storeId and a job which is not running (as it may be for some other parition).
	-- Clean up for non running job is needed as otherwise we may keep accumulating stale rows.
	IF (@AllowResumOnReconDDBJob <= 0)
		DELETE TOP (10000) C
		FROM archChunkToSyncDDB C
			LEFT OUTER JOIN JMJobInfo J WITH (READUNCOMMITTED) ON J.JobId = C.adminJobId
		WHERE C.archCopyId IN (SELECT CopyId FROM archCopySIDBStore WITH (READUNCOMMITTED) WHERE SIDBStoreId = @i_SIDBStoreId)
		AND ((J.JobId IS NULL) OR (J.JobId = @i_adminJobId))
	ELSE
		DELETE TOP (10000) C
		FROM archChunkToSyncDDB C
			LEFT OUTER JOIN JMJobInfo J WITH (READUNCOMMITTED) ON J.JobId = C.adminJobId
		WHERE C.archCopyId IN (SELECT CopyId FROM archCopySIDBStore WITH (READUNCOMMITTED) WHERE SIDBStoreId = @i_SIDBStoreId)
		AND J.JobId IS NULL
	IF @@ROWCOUNT = 0
		BREAK
END
SELECT	@retVal = @@ERROR
IF  @retVal <> 0 GOTO FINISH
IF NOT EXISTS (SELECT 1 FROM JMMisc WHERE jobId = @i_adminJobId AND commCellId = 2 AND itemType = 75 AND (intData & 2 /*MM_RECON_CLEANUP_ON_JOBSTART_SUCCESS_FLAG*/) > 0)
BEGIN
	--For capturing return value of stored procedure
	IF OBJECT_ID('tempdb..#retValTemp') IS NOT NULL  DROP TABLE #retValTemp
	CREATE TABLE #retValTemp ( rVal INT)
	-- Call the following store procedures to clean chunks for this store
	EXEC	archDeleteInvalidChunks 0, @i_SIDBStoreId
	SELECT	@retVal = @@ERROR
	IF  @retVal <> 0 GOTO FINISH
	SELECT @retVal = rVal FROM #retValTemp
	IF  @retVal <> 0 GOTO FINISH
	DELETE #retValTemp
	EXEC	cleanPrunedMagneticChunks 0
	SELECT	@retVal = @@ERROR
	IF  @retVal <> 0 GOTO FINISH
	SELECT @retVal = rVal FROM #retValTemp
	IF  @retVal <> 0 GOTO FINISH
	EXEC	MMCleanArchFileSubStore @i_SIDBStoreId
	SELECT	@retVal = @@ERROR
	IF  @retVal <> 0 GOTO FINISH
	SELECT @retVal = rVal FROM #retValTemp
	IF  @retVal <> 0 GOTO FINISH
IF  EXISTS (SELECT 1 FROM JMMisc WHERE jobId = @i_adminJobId AND commCellId = 2 AND itemType = 75)
	BEGIN
		UPDATE	JMMisc
		SET		intData |= 2 /*MM_RECON_CLEANUP_ON_JOBSTART_SUCCESS_FLAG*/
		WHERE	jobId = @i_adminJobId
AND commCellId = 2
AND itemType = 75
	END
	ELSE
	BEGIN
INSERT INTO JMMisc (jobId, selfRefId, itemType, attribute, intData, data, commCellId) VALUES (@i_adminJobId, 0, 75, 0, 2 /*MM_RECON_CLEANUP_ON_JOBSTART_SUCCESS_FLAG*/, '', 2)
	END
	SELECT	@retVal = @@ERROR
	IF  @retVal <> 0 GOTO FINISH
END
DECLARE	@l_NumOfRows	INT
DECLARE	@oneConstReal REAL = 1.0
DECLARE @reconFlags INT = 0
SET @reconFlags = dbo.GetOptionInt(93390483, @i_adminJobId, 0, 0)
DECLARE	@l_LastSnapTime	INT = 0
DECLARE @l_corruptionTime INT = 0
DECLARE @retReconInfo TABLE ( CommCellId INT, SIDBStoreId INT, ReconLevel INT, MemDbTimeStamp INT, CorruptionTime INT)
DECLARE @memDbRecon INT = 0
DECLARE @archFilesFromSyncDDB TABLE(archFileId INT, commCellId INT, archCopyId INT PRIMARY KEY(archFileId, commCellId, archcopyId))
DECLARE @l_jobStartTime INT = 0
INSERT INTO @retReconInfo
exec MMGetDDBReconInfo 2, @i_SIDBStoreId, @i_adminJobId, 0
SELECT @l_corruptionTime = CorruptionTime FROM @retReconInfo
SELECT	@l_jobStartTime = jobStartTime
FROM	JMJobInfo WITH (READUNCOMMITTED)
WHERE	JobId = @i_adminJobId
IF @l_corruptionTime <= 0
BEGIN
	SET @l_corruptionTime = @l_jobStartTime
END
IF @reconFlags <> 1
BEGIN
	IF (1 = (SELECT ReconLevel FROM @retReconInfo))
	BEGIN
		SELECT @l_LastSnapTime = MemDbTimeStamp FROM @retReconInfo
		SET @memDbRecon = 1
	END
	ELSE
	BEGIN
		SELECT	@l_LastSnapTime = MIN(LastSnapTime)
		FROM IdxSIDBSubStore,
				(
					SELECT sb.value('@val', 'INT') AS t_substoreId
					FROM
					(
						select CAST(value AS XML) AS xmlstr
						from dbo.GetAllJobOptions(@i_adminJobId)
						where optionId=34449693 -- DEDUPDBSYNCOPTION__SUB_STORE_ID_LIST
					) AS O
					CROSS APPLY O.xmlstr.nodes ('SubStoreIdList') R(sb)
				) T
		WHERE SIDBStoreId = @i_SIDBStoreId AND Status = 1
				AND T.t_substoreId = SubStoreId
	END
END
DECLARE	@additionalChunksForReconstrunctionPeriodInMin int = 0
IF @memDbRecon = 0
BEGIN
	SET		@additionalChunksForReconstrunctionPeriodInMin = ISNULL((SELECT TOP 1 value FROM MMConfigs WHERE name = 'MMS2_MMCONFIG_ADDITIONAL_MINUTES_FROM_LASTSNAPTIME_FOR_DDB_RECOVER'), 30)
	IF (@additionalChunksForReconstrunctionPeriodInMin < 0)
		SET	@additionalChunksForReconstrunctionPeriodInMin = 30
END
ELSE IF @memDbRecon = 1
BEGIN
	-- for delta recon add 5 mins of buffer and read more chunks.
	SET @additionalChunksForReconstrunctionPeriodInMin = 5
END
IF (@AllowResumOnReconDDBJob <= 0)
BEGIN
IF (@i_reconByAF = 1)
	BEGIN
		INSERT INTO archChunkToSyncDDB
		SELECT	@i_adminJobId, AF.appId, AF.jobId, a.archChunkId, a.archFileId, a.commCellId,
				a.archCopyId, 0, AF.fileType, 0, 0,
				a.chunkNumber, a.physicalOffset, a.logicalOffset, a.physicalSize, a.logicalSize,
				c.VolumeId, c.MediaId, c.MediaGroupId,
				b.fileMarkerNo,	b.createTime, b.version, b.physicalSize, b.logicalSize, b.hwEncKey, @i_reconByAF, 0, a.unCompSize
		FROM	archFile AF WITH (READUNCOMMITTED),
				archChunkMapping a WITH (READUNCOMMITTED),
				archChunk b WITH (READUNCOMMITTED), MMVolume c WITH (READUNCOMMITTED)
WHERE	a.archFileId = AF.id AND a.commCellId = AF.commCellId AND (a.flags & 256) = 0
			AND a.archChunkId = b.id AND a.chunkCommCellId = b.commCellId
			AND b.volumeId = c.VolumeId
			AND b.createTime > (@l_LastSnapTime - (@additionalChunksForReconstrunctionPeriodInMin * 60))
AND ((b.createTime - b.writeTime) < @l_corruptionTime OR ((b.flags & 524288) = 524288))
			AND c.SIDBStoreId = @i_SIDBStoreId
		--	Send the invalid chunks in add record phase
		--	AND a.physicalSize > 0
		INSERT INTO @archFilesFromSyncDDB
		SELECT DISTINCT archFileId, commCellId, archcopyId
		FROM	archChunkToSyncDDB S WITH (READUNCOMMITTED)
		WHERE	S.adminJobId = @i_adminJobId
		INSERT INTO archChunkToSyncDDB
		SELECT	DISTINCT @i_adminJobId, AF.appId, AF.jobId, a.archChunkId, a.archFileId, a.commCellId,
				a.archCopyId, 0, AF.fileType, 0, 0,
				a.chunkNumber, a.physicalOffset, a.logicalOffset, a.physicalSize, a.logicalSize,
				c.VolumeId, c.MediaId, c.MediaGroupId,
				b.fileMarkerNo,	b.createTime, b.version, b.physicalSize, b.logicalSize, b.hwEncKey, @i_reconByAF, 0, a.unCompSize
		FROM	archFile AF WITH (READUNCOMMITTED),
				@archFilesFromSyncDDB AFS
					INNER JOIN archChunkMapping a WITH (READUNCOMMITTED) ON A.archFileId = AFS.archFileId AND A.commCellId = AFS.commCellId AND A.archCopyId = AFS.archCopyId
					LEFT OUTER JOIN archChunkToSyncDDB S WITH (READUNCOMMITTED) ON
						a.archChunkId = S.archChunkId AND a.archFileId = S.archFileId AND a.commCellId = S.commCellId AND a.archCopyId = S.archCopyId AND S.adminJobId = @i_adminJobId,
				archChunk b WITH (READUNCOMMITTED), MMVolume c WITH (READUNCOMMITTED)
		WHERE	AF.id = AFS.archFileId AND AF.commCellId = AFS.commCellId
			AND a.archChunkId = b.id AND a.chunkCommCellId = b.commCellId
			AND b.volumeId = c.VolumeId
AND ((b.createTime - b.writeTime) < @l_corruptionTime OR ((b.flags & 524288) = 524288))
			AND S.archChunkId IS NULL
	END
	ELSE
	BEGIN
		INSERT INTO archChunkToSyncDDB
		SELECT	@i_adminJobId, AF.appId, AF.jobId, a.archChunkId, a.archFileId, a.commCellId,
				a.archCopyId, 0, AF.fileType, 0, 0,
				a.chunkNumber, a.physicalOffset, a.logicalOffset, a.physicalSize, a.logicalSize,
				c.VolumeId, c.MediaId, c.MediaGroupId,
				b.fileMarkerNo,	b.createTime, b.version, b.physicalSize, b.logicalSize, b.hwEncKey, @i_reconByAF, 0, a.unCompSize
		FROM	archFile AF WITH (READUNCOMMITTED),
				archChunkMapping a WITH (READUNCOMMITTED), archChunk b WITH (READUNCOMMITTED), MMVolume c WITH (READUNCOMMITTED)
WHERE	a.archFileId = AF.id AND a.commCellId = AF.commCellId AND (a.flags & 256) = 0
			AND a.archChunkId = b.id AND a.chunkCommCellId = b.commCellId
			AND b.volumeId = c.VolumeId
			AND b.createTime > (@l_LastSnapTime - (@additionalChunksForReconstrunctionPeriodInMin * 60))
AND ((b.createTime - b.writeTime) < @l_corruptionTime OR ((b.flags & 524288) = 524288))
			AND c.SIDBStoreId = @i_SIDBStoreId
		--	Send the invalid chunks in add record phase
		--	AND a.physicalSize > 0
	END
END
ELSE
BEGIN
	IF (@i_reconByAF = 1)
	BEGIN
		INSERT INTO archChunkToSyncDDB
		SELECT	TOP 100000 @i_adminJobId, AF.appId, AF.jobId, a.archChunkId, a.archFileId, a.commCellId,
				a.archCopyId, 0, AF.fileType, 0, 0,
				a.chunkNumber, a.physicalOffset, a.logicalOffset, a.physicalSize, a.logicalSize,
				c.VolumeId, c.MediaId, c.MediaGroupId,
				b.fileMarkerNo,	b.createTime, b.version, b.physicalSize, b.logicalSize, b.hwEncKey, @i_reconByAF, 0, a.unCompSize
		FROM	archFile AF WITH (READUNCOMMITTED),
				archChunkMapping a WITH (READUNCOMMITTED) LEFT OUTER JOIN archChunkToSyncDDB S WITH (READUNCOMMITTED) ON
						a.archChunkId = S.archChunkId AND a.archFileId = S.archFileId AND a.commCellId = S.commCellId AND a.archCopyId = S.archCopyId AND S.adminJobId = @i_adminJobId
														 LEFT OUTER JOIN archChunkToSyncDDBHistory SH WITH (READUNCOMMITTED) ON
						a.archChunkId = SH.archChunkId AND a.archFileId = SH.archFileId AND a.commCellId = SH.commCellId AND a.archCopyId = SH.archCopyId AND SH.adminJobId = @i_adminJobId
AND (SH.extraFlags & (1 | 2 | 4)) > 0,
				archChunk b WITH (READUNCOMMITTED), MMVolume c WITH (READUNCOMMITTED)
WHERE	a.archFileId = AF.id AND a.commCellId = AF.commCellId AND (a.flags & 256) = 0
			AND a.archChunkId = b.id AND a.chunkCommCellId = b.commCellId
			AND b.volumeId = c.VolumeId
			AND b.createTime > (@l_LastSnapTime - (@additionalChunksForReconstrunctionPeriodInMin * 60))
AND ((b.createTime - b.writeTime) < @l_corruptionTime OR ((b.flags & 524288) = 524288))
			AND c.SIDBStoreId = @i_SIDBStoreId
		--	Send the invalid chunks in add record phase
		--	AND a.physicalSize > 0
			AND S.archChunkId IS NULL
			AND SH.archChunkId IS NULL
		ORDER BY a.archFileId, a.archChunkId
		INSERT INTO @archFilesFromSyncDDB
		SELECT DISTINCT archFileId, commCellId, archcopyId
		FROM	archChunkToSyncDDB S WITH (READUNCOMMITTED)
		WHERE	S.adminJobId = @i_adminJobId
		INSERT INTO archChunkToSyncDDB
		SELECT	DISTINCT @i_adminJobId, AF.appId, AF.jobId, a.archChunkId, a.archFileId, a.commCellId,
				a.archCopyId, 0, AF.fileType, 0, 0,
				a.chunkNumber, a.physicalOffset, a.logicalOffset, a.physicalSize, a.logicalSize,
				c.VolumeId, c.MediaId, c.MediaGroupId,
				b.fileMarkerNo,	b.createTime, b.version, b.physicalSize, b.logicalSize, b.hwEncKey, @i_reconByAF, 0, a.unCompSize
		FROM	archFile AF WITH (READUNCOMMITTED),
				@archFilesFromSyncDDB AFS
					INNER JOIN archChunkMapping a WITH (READUNCOMMITTED) ON A.archFileId = AFS.archFileId AND A.commCellId = AFS.commCellId AND A.archCopyId = AFS.archCopyId
					LEFT OUTER JOIN archChunkToSyncDDB S WITH (READUNCOMMITTED) ON
						a.archChunkId = S.archChunkId AND a.archFileId = S.archFileId AND a.commCellId = S.commCellId AND a.archCopyId = S.archCopyId AND S.adminJobId = @i_adminJobId,
				archChunk b WITH (READUNCOMMITTED), MMVolume c WITH (READUNCOMMITTED)
		WHERE	AF.id = AFS.archFileId AND AF.commCellId = AFS.commCellId
			AND a.archChunkId = b.id AND a.chunkCommCellId = b.commCellId
			AND b.volumeId = c.VolumeId
AND ((b.createTime - b.writeTime) < @l_corruptionTime OR ((b.flags & 524288) = 524288))
			AND S.archChunkId IS NULL
	END
	ELSE
		INSERT INTO archChunkToSyncDDB
		SELECT	TOP 100000 @i_adminJobId, AF.appId, AF.jobId, a.archChunkId, a.archFileId, a.commCellId,
				a.archCopyId, 0, AF.fileType, 0, 0,
				a.chunkNumber, a.physicalOffset, a.logicalOffset, a.physicalSize, a.logicalSize,
				c.VolumeId, c.MediaId, c.MediaGroupId,
				b.fileMarkerNo,	b.createTime, b.version, b.physicalSize, b.logicalSize, b.hwEncKey, @i_reconByAF, 0, a.unCompSize
		FROM	archFile AF WITH (READUNCOMMITTED),
				archChunkMapping a WITH (READUNCOMMITTED) LEFT OUTER JOIN archChunkToSyncDDB S WITH (READUNCOMMITTED) ON
						a.archChunkId = S.archChunkId AND a.archFileId = S.archFileId AND a.commCellId = S.commCellId AND a.archCopyId = S.archCopyId AND S.adminJobId = @i_adminJobId
														 LEFT OUTER JOIN archChunkToSyncDDBHistory SH WITH (READUNCOMMITTED) ON
						a.archChunkId = SH.archChunkId AND a.archFileId = SH.archFileId AND a.commCellId = SH.commCellId AND a.archCopyId = SH.archCopyId AND SH.adminJobId = @i_adminJobId
AND (SH.extraFlags & (1 | 2 | 4)) > 0,
				archChunk b WITH (READUNCOMMITTED), MMVolume c WITH (READUNCOMMITTED)
WHERE	a.archFileId = AF.id AND a.commCellId = AF.commCellId AND (a.flags & 256) = 0
			AND a.archChunkId = b.id AND a.chunkCommCellId = b.commCellId
			AND b.volumeId = c.VolumeId
			AND b.createTime > (@l_LastSnapTime - (@additionalChunksForReconstrunctionPeriodInMin * 60))
AND ((b.createTime - b.writeTime) < @l_corruptionTime OR ((b.flags & 524288) = 524288))
			AND c.SIDBStoreId = @i_SIDBStoreId
		--	Send the invalid chunks in add record phase
		--	AND a.physicalSize > 0
			AND S.archChunkId IS NULL
			AND SH.archChunkId IS NULL
		ORDER BY b.id
END
SELECT	@retVal = @@ERROR
IF  @retVal <> 0 GOTO FINISH
IF (EXISTS (SELECT * FROM IdxSIDBStore WHERE SIDBStoreId = @i_SIDBStoreId AND Version > 2))
BEGIN
	IF (@AllowResumOnReconDDBJob <= 0)
	BEGIN
		-- Do not send none deduped arch file chunks for recon
		DELETE	archChunkToSyncDDB
		FROM	archChunkToSyncDDB S,
				archFileCopyDedup D LEFT OUTER JOIN archFileSubStore AFSS
					ON	AFSS.archFileId	= D.archFileId
						AND	AFSS.CommCellId	= D.CommCellId
						AND AFSS.SIDBStoreId	= D.SIDBStoreId
		WHERE	S.adminJobId = @i_adminJobId
				AND S.archFileId	= D.archFileId
				AND S.CommCellId	= D.CommCellId
				AND S.archCopyId	= D.archCopyId
				AND D.primaryObjects = 0
				AND D.secondaryObjects = 0
				AND ISNULL(AFSS.primaryObjects, 0) = 0
				AND ISNULL(AFSS.secondaryObjects, 0) = 0
				AND S.chunkNumber > 0
	END
	ELSE
	BEGIN
		IF OBJECT_ID('tempdb..#deletedChunksTemp') IS NOT NULL  DROP TABLE #deletedChunksTemp
		CREATE TABLE #deletedChunksTemp ( archFileId INT, commCellId INT, archChunkId BIGINT, archCopyId INT PRIMARY KEY(archCopyId, archFileId, commCellId, archChunkId))
		-- Do not send none deduped arch file chunks for recon
		DELETE	archChunkToSyncDDB
		OUTPUT	DELETED.archFileId, DELETED.commCellId, DELETED.archChunkId, DELETED.archCopyId INTO #deletedChunksTemp
		FROM	archChunkToSyncDDB S,
				archFileCopyDedup D LEFT OUTER JOIN archFileSubStore AFSS
					ON	AFSS.archFileId	= D.archFileId
						AND	AFSS.CommCellId	= D.CommCellId
						AND AFSS.SIDBStoreId	= D.SIDBStoreId
		WHERE	S.adminJobId = @i_adminJobId
				AND S.archFileId	= D.archFileId
				AND S.CommCellId	= D.CommCellId
				AND S.archCopyId	= D.archCopyId
				AND D.primaryObjects = 0
				AND D.secondaryObjects = 0
				AND ISNULL(AFSS.primaryObjects, 0) = 0
				AND ISNULL(AFSS.secondaryObjects, 0) = 0
				AND S.chunkNumber > 0
		SELECT	@retVal = @@ERROR
		IF  @retVal <> 0 GOTO FINISH
		UPDATE	SH
SET		SH.extraFlags |= 4
		FROM	archChunkToSyncDDBHistory SH, #deletedChunksTemp T
		WHERE	T.archChunkId = SH.archChunkId AND T.archFileId = SH.archFileId AND T.commCellId = SH.commCellId AND T.archCopyId = SH.archCopyId AND SH.adminJobId = @i_adminJobId
		IF OBJECT_ID('tempdb..#deletedChunksTemp') IS NOT NULL  DROP TABLE #deletedChunksTemp
	END
END
SELECT	@retVal = @@ERROR
IF  @retVal <> 0 GOTO FINISH
IF	EXISTS (SELECT 1 FROM archChunkToSyncDDB WHERE adminJobId = @i_adminJobId)
BEGIN
	-- For compacted store we need to send lastChunkNumber among the set of chunks we are sending.
	-- This is especially needed for secondary copy with resiliency where we may write more chunks to same AF after corruption time.
	IF (@i_reconByAF = 1)
	BEGIN
		UPDATE a
		SET lastChunkNumber = b.lastChunkNumber
		FROM archChunkToSyncDDB a,
			(SELECT adminJobId, archFileId, commCellId, archCopyId, MAX(chunkNumber) as lastChunkNumber
			FROM archChunkToSyncDDB
			WHERE adminJobId = @i_adminJobId
			GROUP BY adminJobId, archFileId, commCellId, archCopyId) b
		WHERE a.adminJobId = b.adminJobId AND a.archFileId = b.archFileId AND a.commCellId = b.commCellId AND a.archCopyId = b.archCopyId
	END
	UPDATE	archChunkToSyncDDB
	SET		streamNum = b.streamNum,
archFileCopyFlags = (b.flags | 2 | 4 | 16),
			lastChunkNumber = (CASE WHEN a.lastChunkNumber = 0  THEN b.lastChunkNumber
								ELSE a.lastChunkNumber END)
	FROM	archChunkToSyncDDB a WITH (READUNCOMMITTED), archFileCopy b WITH (READUNCOMMITTED)
	WHERE	b.archFileId = a.archFileId AND b.commCellId = a.commCellId AND b.archCopyId = a.archCopyId AND a.adminJobId = @i_adminJobId
END
ELSE
BEGIN
	IF (@AllowResumOnReconDDBJob <= 0)
	BEGIN
		-- Add a fake chunk so DDB Reconstruction can start when there is no new chunk after the last snapshot
		INSERT INTO archChunkToSyncDDB
		SELECT	TOP 1 @i_adminJobId, 0, 0, 0, 0, 2,
				S.archGroupCopyId, S.stream, 0, 0, 0,
				0, 0, 0, 0, 0,
				V.VolumeId, V.MediaId, V.MediaGroupId,
				0, 0, 0, 0, 0, '', 0, 0, 0
		FROM	MMVolume V WITH (READUNCOMMITTED), archStream S WITH (READUNCOMMITTED)
		WHERE	S.mediaGroupId = V.MediaGroupId AND V.SIDBStoreId = @i_SIDBStoreId AND S.MediagroupId > 0
		ORDER BY V.VolumeId DESC
	END
	ELSE
	BEGIN
		-- Add a fake chunk so DDB Reconstruction can start when there is no new chunk after the last snapshot
		INSERT INTO archChunkToSyncDDB
		SELECT	TOP 1 @i_adminJobId, 0, 0, 0, 0, 2,
				S.archGroupCopyId, S.stream, 0, 0, 0,
				0, 0, 0, 0, 0,
				V.VolumeId, V.MediaId, V.MediaGroupId,
				0, 0, 0, 0, 0, '', 0, 0, 0
		FROM	MMVolume V WITH (READUNCOMMITTED), archStream S WITH (READUNCOMMITTED)
		WHERE	S.mediaGroupId = V.MediaGroupId AND V.SIDBStoreId = @i_SIDBStoreId AND S.MediagroupId > 0
				AND NOT EXISTS (SELECT TOP 1 archChunkId
								FROM	archChunkToSyncDDBHistory SH WITH (READUNCOMMITTED)
								WHERE	SH.archChunkId = 0 AND SH.archFileId = 0 AND SH.commCellId = 2 AND SH.adminJobId = @i_adminJobId
AND (SH.extraFlags & (1 | 2 | 4)) > 0)
		ORDER BY V.VolumeId DESC
	END
END
SELECT	@retVal = @@ERROR
IF  @retVal <> 0 GOTO FINISH
IF OBJECT_ID('tempdb..#tmpJobSizeInfo') IS NOT NULL  DROP TABLE #tmpJobSizeInfo
CREATE TABLE #tmpJobSizeInfo (
	JobId INT, CommCellId INT, totalBackupSize BIGINT, totalAppSize BIGINT, totalIndexSize BIGINT
 	PRIMARY KEY (JobId, CommCellId))
INSERT INTO #tmpJobSizeInfo
SELECT	DISTINCT backupJobId, CommCellId, 0, 0, 0
FROM archChunkToSyncDDB
WHERE adminJobId = @i_adminJobId
	  AND archCopyId IN (SELECT CopyId FROM archCopySIDBStore WITH (READUNCOMMITTED) WHERE SIDBStoreId = @i_SIDBStoreId)
	  AND unCompBytesSize = -1
EXEC  @retVal = archGetJobSizeInfo 0
SELECT	@retVal = @@ERROR
IF  @retVal <> 0 GOTO FINISH
UPDATE	archChunkToSyncDDB
SET		unCompBytesSize = (CASE WHEN totalBackupSize > 0 THEN CAST(((@oneConstReal * (totalAppSize+totalIndexSize)*physicalSize)/totalBackupSize) AS BIGINT) ELSE physicalSize END)
FROM	#tmpJobSizeInfo J
WHERE	adminJobId = @i_adminJobId
		AND archCopyId IN (SELECT CopyId FROM archCopySIDBStore WITH (READUNCOMMITTED) WHERE SIDBStoreId = @i_SIDBStoreId)
		AND archChunkToSyncDDB.backupJobId = J.JobId
		AND archChunkToSyncDDB.CommCellId = J.CommCellId
		AND archChunkToSyncDDB.unCompBytesSize = -1
-- Adjust hwEncKey based on media
UPDATE	R
SET		chunkHwEncKey = M.hwEncKey
FROM	archChunkToSyncDDB R WITH (READUNCOMMITTED), MMMedia M WITH (READUNCOMMITTED), ArchChunk chunk WITH (READUNCOMMITTED)
WHERE	R.adminJobId = @i_adminJobId
		AND R.archCopyId IN (SELECT CopyId FROM archCopySIDBStore WITH (READUNCOMMITTED) WHERE SIDBStoreId = @i_SIDBStoreId)
		AND R.MediaId = M.MediaId
		AND M.MediaTypeId != 10001
		AND R.chunkHwEncKey = ''
		AND	R.ArchChunkId = chunk.Id
		AND	R.CommCellId = chunk.CommCellId
AND chunk.flags & 1048576 > 0
SELECT	@retVal = @@ERROR
FINISH:
IF OBJECT_ID('tempdb..#retValTemp') IS NOT NULL  DROP TABLE #retValTemp
IF OBJECT_ID('tempdb..#tmpJobSizeInfo') IS NOT NULL  DROP TABLE #tmpJobSizeInfo
SELECT @retVal
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToSyncDDBInsert')
	delete from GxQscripts where name = 'archChunkToSyncDDBInsert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToSyncDDBInsert')
	delete from GXDBVersions where aliasname = 'archChunkToSyncDDBInsert'
GO

insert into GXDBVersions values(2, 'archChunkToSyncDDBInsert',  '00010035001200200000', 'archChunkToSyncDDBInsert', '00010035001200200000')
GO

