

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToSyncDDBGetNext.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToSyncDDBGetNext.sp,v $ $Id: archChunkToSyncDDBGetNext.sp,v 1.6.80.5 2019/03/20 17:17:07 chandru Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archChunkToSyncDDBGetNext')
BEGIN
	print '>>> Drop Stored Procedure: archChunkToSyncDDBGetNext <<<'
	drop procedure archChunkToSyncDDBGetNext
END
IF EXISTS (select * from GxQscripts where name='archChunkToSyncDDBGetNext')
	delete from GxQscripts where name = 'archChunkToSyncDDBGetNext'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToSyncDDBGetNext')
	delete from GXDBVersions where aliasname = 'archChunkToSyncDDBGetNext'
GO
print '... Creating Procedure: archChunkToSyncDDBGetNext'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archChunkToSyncDDBGetNext
  @i_adminJobId int,
  @i_archCopyId int,
  @i_streamNum int,
  @i_volumeId int,
  @i_numOfChunks int,
  @i_archFileId int,
  @i_commCellId int,
  @i_reconByAF int
AS
  DECLARE @o_appId integer;
  DECLARE @o_appType integer;
  DECLARE @o_clientId integer;
  DECLARE @o_fullCycleNum integer;
  DECLARE @o_backupJobId integer;
  DECLARE @o_backupStartTime integer;
  DECLARE @o_backupEndTime integer;
  DECLARE @o_archChunkId bigint;
  DECLARE @o_archFileId integer;
  DECLARE @o_commCellId integer;
  DECLARE @o_archCopyId integer;
  DECLARE @o_streamNum integer;
  DECLARE @o_fileType integer;
  DECLARE @o_archFileCopyFlags integer;
  DECLARE @o_encType integer;
  DECLARE @o_lastChunkNumber integer;
  DECLARE @o_chunkNumber integer;
  DECLARE @o_physicalOffset bigint;
  DECLARE @o_logicalOffset bigint;
  DECLARE @o_physicalSize bigint;
  DECLARE @o_logicalSize bigint;
  DECLARE @o_volumeId integer;
  DECLARE @o_mediaId integer;
  DECLARE @o_mediaGroupId integer;
  DECLARE @o_fileMarkerNo integer;
  DECLARE @o_chunkCreateTime integer;
  DECLARE @o_chunkVersion integer;
  DECLARE @o_chunkPhysicalSize bigint;
  DECLARE @o_chunkLogicalSize bigint;
  DECLARE @o_chunkHwEncKey varchar(2048);
  DECLARE @o_extraFlags integer;
  DECLARE @o_destPhysicalSize bigint;		
  DECLARE @o_destLogicalSize bigint;		
  DECLARE @o_destDrivePoolId integer;	
  DECLARE @o_destAFCopyFlags integer;	
  DECLARE @o_destEncKeyType integer;	
  DECLARE @o_encKeyCreated integer;	
  DECLARE @o_unCompBytesSize bigint;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @tblNextChunks	TABLE (archChunkId bigint)
IF (@i_reconByAF = 0) --Process by chunk order
BEGIN
	INSERT	INTO @tblNextChunks
	SELECT	DISTINCT TOP(@i_numOfChunks) archChunkId
	FROM	archChunkToSyncDDB
	WHERE	volumeId = @i_volumeId
	AND		adminJobId = @i_adminJobId
	AND		archCopyId = @i_archCopyId
	AND		streamNum = @i_streamNum
	ORDER BY archChunkId
	SELECT	a.appId, 0, 0, 0, a.backupJobId, 0, 0,
			a.archChunkId, a.archFileId, a.commCellId, a.archCopyId,
			a.streamNum, a.fileType, a.archFileCopyFlags, 0, a.lastChunkNumber,
			a.chunkNumber, a.physicalOffset, a.logicalOffset, a.physicalSize, a.logicalSize,
			a.volumeId, a.mediaId, a.mediaGroupId, a.fileMarkerNo,
			a.chunkCreateTime, a.chunkVersion, a.chunkPhysicalSize, a.chunkLogicalSize, a.chunkHwEncKey, a.extraFlags, 0, 0, 0, 0, 0, 0, a.unCompBytesSize
	FROM	@tblNextChunks b, archChunkToSyncDDB a
	WHERE	a.archChunkId = b.archChunkId
			AND @i_archCopyId = a.archCopyId
			AND @i_adminJobId = a.adminJobId
	DELETE	archChunkToSyncDDB
	FROM	@tblNextChunks b, archChunkToSyncDDB a
	WHERE	a.archChunkId = b.archChunkId
			AND @i_archCopyId = a.archCopyId
			AND @i_adminJobId = a.adminJobId
END
ELSE -- process by archive file order
BEGIN
	DECLARE @tblAFChunk TABLE
	(
		adminJobId			integer,
		appId				integer,
		backupJobId			integer,
		archChunkId			bigint,
		archFileId			integer,
		commCellId			integer,
		archCopyId			integer,
		streamNum			integer,
		fileType			integer,
		archFileCopyFlags	integer,
		lastChunkNumber		integer,
		chunkNumber			integer,
		physicalOffset		bigint,
		logicalOffset		bigint,
		physicalSize		bigint,
		logicalSize			bigint,
		volumeId			integer,
		mediaId				integer,
		mediaGroupId		integer,
		fileMarkerNo		integer,
		chunkCreateTime		integer,
		chunkVersion		integer,
		chunkPhysicalSize	bigint,
		chunkLogicalSize	bigint,
chunkHwEncKey		varchar(2048),
		extraFlags			integer,
		segmentId			integer,
		unCompBytesSize		bigint,
		ChunkNoRowNumber	integer,
		ChunkIdRowNumber	integer,
		primary key (archChunkId, archFileId, commCellId, archCopyId)
	)
	DECLARE	@l_error	INT
	DECLARE	@l_rowcount	INT
	DECLARE	@l_nAFChunk	INT
	DECLARE	@l_destAFCopyFlags INT
	SET @l_destAFCopyFlags = -1
	INSERT	INTO @tblAFChunk
	SELECT	a.*,
		ROW_NUMBER() OVER (PARTITION BY a.VolumeId, a.archCopyId, a.archFileId, a.commCellId ORDER BY a.chunkNumber) AS ChunkNoRowNumber,
		ROW_NUMBER() OVER (PARTITION BY a.VolumeId, a.archCopyId, a.archFileId, a.commCellId ORDER BY a.archChunkId) AS ChunkIdRowNumber
	FROM	archChunkToSyncDDB a
	WHERE	a.volumeId = @i_volumeId
	AND		a.adminJobId = @i_adminJobId
	AND		a.archCopyId = @i_archCopyId
	AND		a.streamNum = @i_streamNum
	AND		(@i_archFileId = 0 or a.archFileId = @i_archFileId)
	AND		(@i_commCellId = 0 or a.commCellId = @i_commCellId)
	IF @i_archFileId > 0 AND NOT EXISTS (SELECT * FROM @tblAFChunk)
	BEGIN
		-- Return the first un-copied chunk of given archive file in another volume with @l_destAFCopyFlags = -2
		-- Current volume for given archive file is fully copied.
		-- If not data is returned, aux copy will go to next volume/archive file in volume list.
		-- If a row is returned, aux copy will set currVolumeId to the returned volumeId and copy from there.
		SET @l_destAFCopyFlags = -2
		SELECT	TOP 1 appId, 0, 0, 0, backupJobId, 0, 0,
				archChunkId, archFileId, commCellId, archCopyId,
				streamNum, fileType, archFileCopyFlags, 0, lastChunkNumber,
				streamNum, physicalOffset, logicalOffset, physicalSize, logicalSize,
				volumeId, mediaId, mediaGroupId, fileMarkerNo,
				chunkCreateTime, chunkVersion, chunkPhysicalSize, chunkLogicalSize, chunkHwEncKey, 0,
				-1, -1, -1, @l_destAFCopyFlags, -1, -1, unCompBytesSize
		FROM	archChunkToSyncDDB WITH (NOLOCK)
		WHERE	(@i_archFileId = 0 or archFileId = @i_archFileId)
				AND		(@i_commCellId = 0 or commCellId = @i_commCellId)
				AND		streamNum = @i_streamNum
				AND		adminJobID = @i_adminJobId
		ORDER BY archChunkId ASC
		RETURN
	END
	DECLARE @tblAFWithChunkNumber0 TABLE (archFileId INT, commCellId INT, archCopyId INT, lastChunkNumber INT, PRIMARY KEY(archFileId, commCellId, archCopyId))
	INSERT INTO @tblAFWithChunkNumber0
	SELECT	DISTINCT A.archFileId, A.commCellId, A.archCopyId, 0
	FROM	archChunkToSyncDDB a WITH (NOLOCK), @tblAFChunk T
	WHERE	A.archFileId = T.archFileId
			AND A.commCellId = T.commCellId
			AND A.archCopyId = T.archCopyId
			AND A.adminJobId = @i_adminJobId
			AND A.chunkNumber = 0
	IF (@@ROWCOUNT > 0)
	BEGIN
		DECLARE @tblAFWithChunkNumber0Chunks TABLE (archFileId INT, commCellId INT, archCopyId INT, archChunkId INT, chunkNumber INT PRIMARY KEY(archFileId, commCellId, archCopyId, archChunkId))
		INSERT INTO @tblAFWithChunkNumber0Chunks
		SELECT	A.archFileId, A.commCellId, A.archCopyId, A.ArchChunkId,
				ROW_NUMBER() OVER (PARTITION BY a.archCopyId, a.archFileId, a.commCellId ORDER BY a.archChunkId) AS ChunkIdRowNumber
		FROM	@tblAFWithChunkNumber0 T, archChunkToSyncDDB a WITH (NOLOCK)
		WHERE	A.archFileId = T.archFileId
				AND A.commCellId = T.commCellId
				AND A.archCopyId = T.archCopyId
				AND A.adminJobId = @i_adminJobId
		UPDATE	A
		SET		chunkNumber = T.chunkNumber, lastChunkNumber = TAF.lastChunkNumber
		FROM	archChunkToSyncDDB a WITH (NOLOCK), @tblAFWithChunkNumber0Chunks T,
				(SELECT archFileId, commCellId, archCopyId, MAX(chunkNumber) lastChunkNumber
				FROM @tblAFWithChunkNumber0Chunks
				GROUP BY archFileId, commCellId, archCopyId) TAF
		WHERE	A.archChunkId = T.archChunkId
				AND A.archFileId = T.archFileId
				AND A.commCellId = T.commCellId
				AND A.archCopyId = T.archCopyId
				AND A.adminJobId = @i_adminJobId
				AND TAF.archFileId = T.archFileId
				AND TAF.commCellId = T.commCellId
				AND TAF.archCopyId = T.archCopyId
		DELETE FROM @tblAFChunk
		INSERT	INTO @tblAFChunk
		SELECT	a.*,
			ROW_NUMBER() OVER (PARTITION BY a.VolumeId, a.archCopyId, a.archFileId, a.commCellId ORDER BY a.chunkNumber) AS ChunkNoRowNumber,
			ROW_NUMBER() OVER (PARTITION BY a.VolumeId, a.archCopyId, a.archFileId, a.commCellId ORDER BY a.archChunkId) AS ChunkIdRowNumber
		FROM	archChunkToSyncDDB a
		WHERE	a.volumeId = @i_volumeId
		AND		a.adminJobId = @i_adminJobId
		AND		a.archCopyId = @i_archCopyId
		AND		a.streamNum = @i_streamNum
		AND		(@i_archFileId = 0 or a.archFileId = @i_archFileId)
		AND		(@i_commCellId = 0 or a.commCellId = @i_commCellId)
	END
	DECLARE @tblOrderChunks	TABLE (VolumeId integer, archCopyId integer, archFileId integer, commCellId integer, chunkNumber integer)
	IF OBJECT_ID('tempdb.dbo.#tblOtherVolumeChunksToCopy') is not null
		DROP TABLE #tblOtherVolumeChunksToCopy
	CREATE TABLE #tblOtherVolumeChunksToCopy (archFileId int, commcellId int, archCopyId int, chunkNumber int)
	INSERT #tblOtherVolumeChunksToCopy
	SELECT a.archFileId, a.commCellId, a.archCopyId, MIN(a.chunkNumber) from
	archChunkToSyncDDB a WITH (NOLOCK)
	WHERE a.volumeId <> @i_volumeId AND a.adminJobId = @i_adminJobId
	group by a.archFileId, a.commCellId, a.archCopyId
	-- Delete the chunks if there exist chunks with lower chunk number in other volumes for this archive file
	DELETE	@tblAFChunk
	FROM	@tblAFChunk a, #tblOtherVolumeChunksToCopy b
	WHERE	a.archFileId = b.archFileId AND a.commCellId = b.commCellId AND a.archCopyId = b.archCopyId
			AND a.chunkNumber > b.chunkNumber
	-- Delete the chunks if the chunkid is not in sequence for given archive file
	INSERT INTO @tblOrderChunks
	SELECT	VolumeId, archCopyId, archFileId, commCellId, Min(chunkNumber)
	FROM	@tblAFChunk
	WHERE	ChunkNoRowNumber > ChunkIdRowNumber
	GROUP BY VolumeId, archCopyId, archFileId, commCellId
	DELETE	@tblAFChunk
	FROM	@tblAFChunk AFC, @tblOrderChunks OC
	WHERE	AFC.VolumeId = OC.VolumeId
			AND AFC.archCopyId = OC.archCopyId
			AND AFC.archFileId = OC.archFileId
			AND AFC.commCellId = OC.commCellId
			AND AFC.chunkNumber >= OC.chunkNumber
	INSERT	INTO @tblNextChunks
	SELECT	DISTINCT TOP(@i_numOfChunks) archChunkId
	FROM	@tblAFChunk
	ORDER BY archChunkId
	DELETE	@tblAFChunk
	WHERE	archChunkId NOT IN
		(SELECT archChunkId from @tblNextChunks)
	SET	@l_nAFChunk = (SELECT COUNT(*) FROM @tblAFChunk)
	IF @l_nAFChunk > 0
	BEGIN
		DELETE	archChunkToSyncDDB
		FROM	archChunkToSyncDDB a, @tblAFChunk b
		WHERE	a.archChunkId = b.archChunkId AND a.archFileId = b.archFileId AND a.commCellId = b.commCellId
			AND a.archCopyId = b.archCopyId AND a.volumeId =  b.volumeId --fix: join volumeIds too, to be safe
			AND a.adminJobID = @i_adminJobId
		SELECT	@l_error = @@ERROR, @l_rowcount = @@ROWCOUNT
		SELECT	a.appId, 0, 0, 0, a.backupJobId, 0, 0,
			a.archChunkId, a.archFileId, a.commCellId, a.archCopyId,
			a.streamNum, a.fileType, a.archFileCopyFlags, 0, a.lastChunkNumber,
			a.chunkNumber, a.physicalOffset, a.logicalOffset, a.physicalSize, a.logicalSize,
			a.volumeId, a.mediaId, a.mediaGroupId, a.fileMarkerNo,
			a.chunkCreateTime, a.chunkVersion, a.chunkPhysicalSize, a.chunkLogicalSize, a.chunkHwEncKey, a.extraFlags, 0, 0, 0, 0, 0, 0, a.unCompBytesSize
		FROM	@tblAFChunk a
		ORDER BY a.archCopyId, a.archChunkId, a.archFileId
	END
	ELSE IF @i_archFileId > 0
	BEGIN
		-- Return the first un-copied chunk of given archive file in another volume with @l_destAFCopyFlags = -3
		-- Current volume will be skipped and copied later.
		SET @l_destAFCopyFlags = -3
		SELECT	TOP 1 appId, 0, 0, 0, backupJobId, 0, 0,
				archChunkId, archFileId, commCellId, archCopyId,
				streamNum, fileType, archFileCopyFlags, 0, lastChunkNumber,
				chunkNumber, physicalOffset, logicalOffset, physicalSize, logicalSize,
				volumeId, mediaId, mediaGroupId, fileMarkerNo,
				chunkCreateTime, chunkVersion, chunkPhysicalSize, chunkLogicalSize, chunkHwEncKey, 0,
				-1, -1, -1, @l_destAFCopyFlags, -1, -1, unCompBytesSize
		FROM	archChunkToSyncDDB WITH (NOLOCK)
		WHERE	(@i_archFileId = 0 or archFileId = @i_archFileId)
				AND		(@i_commCellId = 0 or commCellId = @i_commCellId)
				AND		streamNum = @i_streamNum
				AND		adminJobID = @i_adminJobId
		ORDER BY archChunkId ASC
	END
	ELSE
	BEGIN
		-- Either all archive files in this volume have been copied or remaining archive files are out of order of chunk number.
		-- Return the first to-be-copied chunk ID in the same volume with @l_destAFCopyFlags = -1 if there is any.
		-- So AuxCopyMgr knows some archive files have been skipped and should be copied later.
		SET @l_destAFCopyFlags = -1
		SELECT	TOP 1 appId, 0, 0, 0, backupJobId, 0, 0,
				archChunkId, archFileId, commCellId, archCopyId,
				streamNum, fileType, archFileCopyFlags, 0, lastChunkNumber,
				chunkNumber, physicalOffset, logicalOffset, physicalSize, logicalSize,
				volumeId, mediaId, mediaGroupId, fileMarkerNo,
				chunkCreateTime, chunkVersion, chunkPhysicalSize, chunkLogicalSize, chunkHwEncKey, 0,
				-1, -1, -1, @l_destAFCopyFlags, -1, -1, unCompBytesSize
		FROM	archChunkToSyncDDB WITH (NOLOCK)
		WHERE	streamNum = @i_streamNum
				AND		adminJobID = @i_adminJobId
		ORDER BY archChunkId ASC
	END
END
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToSyncDDBGetNext')
	delete from GxQscripts where name = 'archChunkToSyncDDBGetNext'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToSyncDDBGetNext')
	delete from GXDBVersions where aliasname = 'archChunkToSyncDDBGetNext'
GO

insert into GXDBVersions values(2, 'archChunkToSyncDDBGetNext',  '00010006008000050000', 'archChunkToSyncDDBGetNext', '00010006008000050000')
GO

