

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToSFUpdateStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToSFUpdateStatus.sp,v $ $Id: archChunkToSFUpdateStatus.sp,v 1.1.42.2 2017/02/10 21:16:17 sjohnson Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archChunkToSFUpdateStatus <<<'

IF EXISTS (select * from sysobjects where name='archChunkToSFUpdateStatus')
	drop procedure archChunkToSFUpdateStatus
IF EXISTS (select * from GxQscripts where name='archChunkToSFUpdateStatus')
	delete from GxQscripts where name = 'archChunkToSFUpdateStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToSFUpdateStatus')
	delete from GXDBVersions where aliasname = 'archChunkToSFUpdateStatus'
GO
print '... Creating Procedure: archChunkToSFUpdateStatus'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archChunkToSFUpdateStatus
  @i_AdminJobId integer
AS
  DECLARE @errorCode integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @now INTEGER;
SET		@now = dbo.GetUnixTime(GetUTCDate())
SET	@errorCode = 0
IF @i_AdminJobId > 0
BEGIN
	-- For the job @i_jobId in JMBkpJobInfo, find the chunks on all destination copies in ArchChunkToSF
	-- with the corresponding destinationcopy/archFilesIds in archFilecopy.
	-- And update the status of the chunk to CVA_CHUNK_PROCESSED if the physical size of the archFile is > the chunk's physicalOffset+physcialsize.
	UPDATE	ArchChunkToSF
SET		status = 2, Modified = @now
	FROM	ArchChunkToSF R, ArchChunkToSFArchFiles ASF
	WHERE	R.adminJobId = @i_AdminJobId
			AND R.adminJobId = ASF.adminJobId
			AND R.archFileId = ASF.archFileId
			AND R.CommCellId = ASF.CommCellId
			AND R.SrcCopyId = ASF.SrcCopyId
			AND (ASF.TotalItems <= ASF.ProcessedItems OR ASF.ProcessedItems = -1)
AND R.Status <> 2
	SELECT	@errorCode = @@ERROR
	IF	@errorCode <> 0 GOTO ERR_EXIT
END
ELSE
BEGIN
	-- If @i_jobId is non zero, do for all running jobs in JMBkpJobInfo
	-- For the running jobs in JMBkpJobInfo, find the chunks on all destination copies in ArchChunkToSF
	-- with the corresponding destinationcopy/archFilesIds in archFilecopy.
	-- And update the status of the chunk to CVA_CHUNK_PROCESSED if the physical size of the archFile is > the chunk's physicalOffset+physcialsize.
	UPDATE	ArchChunkToSF
SET		status = 2, Modified = @now
	FROM	ArchChunkToSF R, JMBkpJobInfo JMB, ArchChunkToSFArchFiles ASF
	WHERE	R.adminJobId = JMB.JobId
			AND R.adminJobId = ASF.adminJobId
			AND R.archFileId = ASF.archFileId
			AND R.CommCellId = ASF.CommCellId
			AND R.SrcCopyId = ASF.SrcCopyId
			AND (ASF.TotalItems <= ASF.ProcessedItems OR ASF.ProcessedItems = -1)
AND R.Status <> 2
	SELECT	@errorCode = @@ERROR
	IF	@errorCode <> 0 GOTO ERR_EXIT
END
ERR_EXIT:
SELECT @errorCode
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToSFUpdateStatus')
	delete from GxQscripts where name = 'archChunkToSFUpdateStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToSFUpdateStatus')
	delete from GXDBVersions where aliasname = 'archChunkToSFUpdateStatus'
GO

insert into GXDBVersions values(2, 'archChunkToSFUpdateStatus',  '00010001004200020000', 'archChunkToSFUpdateStatus', '00010001004200020000')
GO

