

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToSFSegment.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToSFSegment.sp,v $ $Id: archChunkToSFSegment.sp,v 1.3.34.8 2018/03/20 19:48:40 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archChunkToSFSegment <<<'

IF EXISTS (select * from sysobjects where name='archChunkToSFSegment')
	drop procedure archChunkToSFSegment
IF EXISTS (select * from GxQscripts where name='archChunkToSFSegment')
	delete from GxQscripts where name = 'archChunkToSFSegment'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToSFSegment')
	delete from GXDBVersions where aliasname = 'archChunkToSFSegment'
GO
print '... Creating Procedure: archChunkToSFSegment'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archChunkToSFSegment
  @i_adminJobId int,
  @i_archCopyId int,
  @i_minSegmentGB bigint
AS
  DECLARE @o_error integer;
  DECLARE @o_errorString varchar(1024);
  DECLARE @o_lastSegmentId integer;
SET NOCOUNT ON
BEGIN TRAN archChunkToSFSegment_tran
	IF object_id('tempdb.dbo.#tblChunkToSF') IS NOT NULL DROP TABLE #tblChunkToSF
	IF object_id('tempdb.dbo.#tblChunkInSegment') IS NOT NULL DROP TABLE #tblChunkInSegment
	DECLARE	@cursor	INTEGER
	DECLARE	@errVal	INTEGER
	DECLARE	@errStr	VARCHAR(1024)
	DECLARE @segmentId	INTEGER
	SET @segmentId = 0
	SET @errVal = 0
	SET @errStr = 'NO ERROR'
	SET @cursor = 0
	IF @i_minSegmentGB = 0
		SET @i_minSegmentGB = 2
	create table #tblChunkToSF (
		id					integer IDENTITY (1,1),
		SrcCopyId			integer,
		archChunkId			bigint,
		ChunkCommCellId		integer,
		archFileId			integer,
		commCellId			integer,
		mediaGroupId		integer,
		srcStreamNum		integer,
		physicalSize		bigint,
		mediaId				integer,
		segmentID			integer,
		primary key (id)
	)
	create index ChunkToCopy_temp_idx_1 on #tblChunkToSF (archFileId, commCellId)
	create index ChunkToCopy_temp_idx_2 on #tblChunkToSF (archChunkId, ChunkCommCellId)
	create table #tblChunkInSegment (
		id					integer,
		SrcCopyId			integer,
		archChunkId			bigint,
		ChunkCommCellId		integer,
		archFileId			integer,
		commCellId			integer,
		mediaGroupId		integer,
		srcStreamNum		integer,
		physicalSize		bigint,
		mediaId				integer,
		segmentID			integer,
		primary key (id)
	)
	create index ChunkInSegment_temp_idx_1 on #tblChunkInSegment (archFileId, commCellId)
	create index ChunkInSegment_temp_idx_2 on #tblChunkInSegment (archChunkId, ChunkCommCellId)
	-- Do not support dynamic stream allocation for snap copy
	IF EXISTS (SELECT * FROM ArchGroupCopy WITH (NOLOCK) WHERE id = @i_archCopyId AND isSnapCopy = 1)
		GOTO CX_EXIT
	DECLARE @multiplex         INTEGER = 0
    if exists (
            select SrcCopyId, archChunkId
            from ArchChunkToSF with (NOLock)
            where SrcCopyId = @i_archCopyId
            group by SrcCopyId, archChunkId having count(archFileId) > 1
            )
    SET @multiplex = 1
	INSERT INTO #tblChunkToSF
	SELECT a.SrcCopyId, a.archChunkId, a.ChunkCommCellId, a.archFileId, a.commCellId, a.mediaGroupId, a.srcStreamNum, AFC.TotalAppSize, a.mediaId, 0
	FROM ArchChunkToSF a WITH (NOLOCK), MMVolume b WITH (NOLOCK), MMMedia c WITH (NOLOCK), ArchChunkToSFArchFiles AFC WITH (NOLOCK)
	WHERE a.adminJobId = @i_adminJobId
	AND a.SrcCopyId = @i_archCopyId
	AND a.mediaId = b.mediaId
	AND b.mediaId = c.mediaId
	AND c.mediaTypeId != 10001
	AND a.segmentId = 0
	AND a.archFileId = AFC.archFileId
	AND a.CommCellId = AFC.commcellId
	AND a.SrcCopyId = AFC.SrcCopyId
	-- For tape copy source ignore DSA
	IF EXISTS (SELECT * FROM #tblChunkToSF)
	BEGIN
		INSERT INTO ArchChunkToSFSegmentTable (DestCopyId, ArchCopyId, MediaGroupId, DestMediaGroupId)
		SELECT	0, T1.SrcCopyId, T1.MediaGroupId, T1.MediaId
		FROM	(SELECT DISTINCT A.SrcCopyId, A.MediaGroupId, A.MediaId
				FROM ArchChunkToSF a WITH (NOLOCK), #tblChunkToSF T
				WHERE a.adminJobId = @i_adminJobId
				AND a.segmentId = 0
				AND A.SrcCopyId = @i_archCopyId
				AND A.archChunkId = T.archChunkId
				AND A.chunkCommCellId = T.chunkCommCellid
				AND A.archFileId = T.archFileId
				AND A.commCellId = T.commCellId	) T1 LEFT OUTER JOIN ArchChunkToSFSegmentTable S
					ON	T1.SrcCopyId = S.ArchCopyId
						AND T1.MediaGroupId = S.MediaGroupId
						AND T1.MediaId = S.DestMediaGroupId
		WHERE	S.ArchCopyId IS NULL
		UPDATE ArchChunkToSF
		SET	segmentId = S.SegmentId
		FROM ArchChunkToSF a, ArchChunkToSFSegmentTable S
		WHERE a.adminJobId = @i_adminJobId
		AND a.SrcCopyId = @i_archCopyId
		AND a.segmentId = 0
		AND S.ArchCopyId = A.SrcCopyId
		AND S.MediaGroupId = A.MediaGroupId
		AND S.DestMediaGroupId = A.MediaId
		SELECT	@segmentId = MAX(segmentId)
		FROM	ArchChunkToSF a
		WHERE	a.adminJobId = @i_adminJobId
				AND a.srcCopyId = @i_archCopyId
	END
	DELETE FROM #tblChunkToSF
	INSERT INTO #tblChunkToSF
	SELECT a.SrcCopyId, a.archChunkId, a.ChunkCommCellId, a.archFileId, a.commCellId, a.mediaGroupId, a.srcStreamNum, AFC.TotalAppSize, a.mediaId, 0
	FROM ArchChunkToSF a WITH (NOLOCK), ArchChunkToSFArchFiles AFC WITH (NOLOCK)
	WHERE a.adminJobId = @i_adminJobId
	AND a.srcCopyId = @i_archCopyId
	AND a.mediaType = 10001
	AND a.segmentId = 0
	AND a.archFileId = AFC.archFileId
	AND a.CommCellId = AFC.commcellId
	AND a.SrcCopyId = AFC.SrcCopyId
	IF @@ROWCOUNT = 0
		GOTO CX_EXIT
	UPDATE #tblChunkToSF
	SET srcStreamNum = 0
	FROM #tblChunkToSF a, ArchChunkToSFArchFiles b WITH (NOLOCK)
	WHERE   b.adminJobid = @i_adminJobId
	AND a.archFileId = b.archFileId
	AND a.commCellId = b.commCellId
	AND b.SrcCopyId = @i_archCopyId
	-- Clear source stream and media group info
	UPDATE ArchChunkToSF
	SET SrcStreamNum = 0, DestStreamNum = 0
	FROM ArchChunkToSF a, #tblChunkToSF b
	WHERE  a.adminJobId = @i_adminJobId
	AND a.archChunkId = b.archChunkId
	AND a.ChunkCommCellId = b.ChunkCommCellId
	AND a.archFileId = b.archFileId
	AND a.commCellId = b.commCellId
	AND a.SrcCopyId = @i_archCopyId
	AND a.SrcCopyId = b.SrcCopyId
	SELECT @errVal = @@ERROR
	IF @errVal <> 0
	BEGIN
			SET @errStr = 'Failed to clear streams for ArchChunkToSF: DB error!'
			GOTO CX_EXIT_ERROR
	END
	DECLARE @archFileId		INTEGER
	DECLARE @commCellId		INTEGER
	DECLARE @SrcCopyId		INTEGER
	DECLARE @mediaGroupId	INTEGER
	DECLARE @srcStreamNum		INTEGER
	DECLARE @mediaId		INTEGER
	DECLARE @mediaGroupId_prev INTEGER
	SET @mediaGroupId_prev = -1
	DECLARE @mediaId_prev INTEGER
	SET @mediaId_prev = -1
	DECLARE @srcStream_prev INTEGER
	SET @srcStream_prev = -1
	DECLARE AFCursor CURSOR FOR
			SELECT DISTINCT SrcCopyId, archFileId, commCellId, mediaGroupId, srcStreamNum, mediaId
			FROM #tblChunkToSF
			ORDER BY SrcCopyId, mediaGroupId, mediaId, commCellId, archFileId
	OPEN AFCursor
	SET @cursor = 1
	FETCH NEXT from AFCursor INTO @SrcCopyId, @archFileId, @commCellId, @mediaGroupId, @srcStreamNum, @mediaId
	WHILE (1 = 1)
	BEGIN
		DECLARE @fetchNext INTEGER
		SET @fetchNext = 1
		IF @@FETCH_STATUS <> 0
			GOTO CREATE_SEGMENT
		IF EXISTS (select * from #tblChunkToSF WITH (NOLOCK)
					where  archFileId = @archFileId
					and commCellId = @commCellId
					and SrcCopyId = @SrcCopyId
					and segmentId > 0
					)
			GOTO FETCH_NEXT
		IF @mediaGroupId_prev < 0
			SET @mediaGroupId_prev = @mediaGroupId
		IF @srcStream_prev < 0
			SET @srcStream_prev = @srcStreamNum
		IF @mediaId_prev < 0
			SET	@mediaId_prev = @mediaId
		IF @mediaId_prev <> @mediaId
		BEGIN
			-- Src MA ID changed, needs to group previous chunks
			-- This archive file will be processed again
			SET @mediaId_prev = @mediaId
			SET @fetchNext = 0
			GOTO CREATE_SEGMENT
		END
		IF @mediaGroupId_prev <> @mediaGroupId
		BEGIN
			-- MediaGroupId changed, needs to group previous chunks
			-- This archive file will be processed again
			SET @mediaGroupId_prev = @mediaGroupId
			SET @fetchNext = 0
			GOTO CREATE_SEGMENT
		END
		IF @srcStream_prev <> @srcStreamNum
		BEGIN
			-- destStreamNum changed, needs to group previous chunks
			-- This archive file will be processed again
			SET @srcStream_prev = @srcStreamNum
			SET @fetchNext = 0
			GOTO CREATE_SEGMENT
		END
		-- Set flag for all chunks of given archive file
		INSERT INTO #tblChunkInSegment
		SELECT a.*
		FROM #tblChunkToSF a LEFT OUTER JOIN #tblChunkInSegment b ON a.id = b.id
		WHERE a.archFileId = @archFileId
		AND a.commCellId = @commCellId
		AND b.id IS NULL
		-- No new chunks of this archive file found
		IF @@ROWCOUNT = 0
			GOTO FETCH_NEXT
		WHILE (1 = 1)
		BEGIN
			DECLARE @sumSegmentSize bigint = 0
			DECLARE @numChunks integer = 0
			IF @multiplex > 0
			BEGIN
				-- Get linked chunks through multiplexing
				INSERT INTO #tblChunkInSegment
				SELECT DISTINCT b.*
				FROM #tblChunkInSegment a right outer join #tblChunkToSF b on a.id = b.id INNER JOIN #tblChunkInSegment c ON c.archChunkId = b.archChunkId AND c.ChunkCommCellId = b.ChunkCommCellId
				WHERE a.id is null
				SET @numChunks = @@ROWCOUNT
				IF @numChunks > 0
				BEGIN
					-- Add linked archive files.
					INSERT INTO #tblChunkInSegment
					SELECT DISTINCT b.*
					FROM #tblChunkInSegment a right outer join #tblChunkToSF b on a.id = b.id INNER JOIN #tblChunkInSegment c ON c.archFileId = b.archFileId AND c.commCellId = b.commCellId
					WHERE a.id is null
					SET @numChunks = @@ROWCOUNT
				END
			END
			SET @sumSegmentSize = (SELECT SUM(physicalSize) FROM #tblChunkInSegment)
			IF @sumSegmentSize < @i_minSegmentGB * 1024 * 1024 * 1024
			BEGIN
				IF @numChunks = 0
					GOTO FETCH_NEXT
				ELSE
					CONTINUE
			END
			IF @numChunks = 0
				BREAK;
		END
CREATE_SEGMENT:
		IF EXISTS (SELECT * FROM #tblChunkInSegment)
		BEGIN
			INSERT INTO archChunkToSFSegmentTable (DestCopyId, ArchCopyId, MediaGroupId, DestMediaGroupId)
			SELECT 0, @i_archCopyId, 0, 0
			SELECT @errVal = @@ERROR, @segmentId = @@IDENTITY
			IF @errVal <> 0 OR @segmentId = 0
			BEGIN
					SET @errStr = 'Failed to create new segment for data verification: DB error!'
					GOTO CX_EXIT_ERROR
			END
            DELETE FROM archChunkToSFSegmentTable WITH (ROWLOCK)
            WHERE segmentId = @segmentId
            SELECT @errVal = @@ERROR
            IF @errVal <> 0
            BEGIN
                SET @errStr = 'Failed to delete segment ID for data verification: DB error!'
                GOTO CX_EXIT_ERROR
            END
			UPDATE #tblChunkToSF
			SET segmentId = @segmentId
			FROM #tblChunkToSF a, #tblChunkInSegment b
			WHERE  a.archChunkId = b.archChunkId
			AND a.ChunkCommCellId = b.ChunkCommCellId
			AND a.archFileId = b.archFileId
			AND a.commCellId = b.commCellId
			AND a.SrcCopyId = b.SrcCopyId
			SELECT @errVal = @@ERROR
			IF @errVal <> 0
			BEGIN
					SET @errStr = 'Failed to update segmentId for ArchChunkToSF: DB error!'
					GOTO CX_EXIT_ERROR
			END
			-- Clear temp table
			DELETE FROM #tblChunkInSegment
		END
		IF @@FETCH_STATUS <> 0
			GOTO CX_EXIT
FETCH_NEXT:
		IF @fetchNext = 1
			FETCH NEXT from AFCursor INTO @SrcCopyId, @archFileId, @commCellId, @mediaGroupId, @srcStreamNum, @mediaId
	END
CX_EXIT:
	UPDATE ArchChunkToSF
	SET segmentId = b.segmentId
	FROM ArchChunkToSF a, #tblChunkToSF b
	WHERE a.adminJobId = @i_adminJobId
	AND a.archChunkId = b.archChunkId
	AND a.ChunkCommCellId = b.ChunkCommCellId
	AND a.archFileId = b.archFileId
	AND a.commCellId = b.commCellId
	AND a.SrcCopyId = b.SrcCopyId
	IF object_id('tempdb.dbo.#tblChunkToSF') IS NOT NULL DROP TABLE #tblChunkToSF
	IF object_id('tempdb.dbo.#tblChunkInSegment') IS NOT NULL DROP TABLE #tblChunkInSegment
	IF @cursor = 1
	BEGIN
		CLOSE AFCursor
		DEALLOCATE AFCursor
	END
	-- for parallel copy i might have reused segment id from other parallel copy
	IF (@segmentId = 0)
	BEGIN
		SELECT	@segmentId = MAX(segmentId)
		FROM	ArchChunkToSF a
		WHERE	a.adminJobId = @i_adminJobId
				AND a.srcCopyId = @i_archCopyId
	END
	COMMIT TRAN archChunkToSFSegment_tran
	SELECT 0, '', @segmentId
	RETURN
CX_EXIT_ERROR:
	IF object_id('tempdb.dbo.#tblChunkToSF') IS NOT NULL DROP TABLE #tblChunkToSF
	IF object_id('tempdb.dbo.#tblChunkInSegment') IS NOT NULL DROP TABLE #tblChunkInSegment
	IF @cursor = 1
	BEGIN
		CLOSE AFCursor
		DEALLOCATE AFCursor
	END
	ROLLBACK TRAN archChunkToSFSegment_tran
	SELECT @errVal, @errStr, @segmentId
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToSFSegment')
	delete from GxQscripts where name = 'archChunkToSFSegment'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToSFSegment')
	delete from GXDBVersions where aliasname = 'archChunkToSFSegment'
GO

insert into GXDBVersions values(2, 'archChunkToSFSegment',  '00010003003400080000', 'archChunkToSFSegment', '00010003003400080000')
GO

