

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToSFPopulateCopyInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToSFPopulateCopyInfo.sp,v $ $Id: archChunkToSFPopulateCopyInfo.sp,v 1.1.42.5 2018/03/20 19:53:39 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archChunkToSFPopulateCopyInfo <<<'

IF EXISTS (select * from sysobjects where name='archChunkToSFPopulateCopyInfo')
	drop procedure archChunkToSFPopulateCopyInfo
IF EXISTS (select * from GxQscripts where name='archChunkToSFPopulateCopyInfo')
	delete from GxQscripts where name = 'archChunkToSFPopulateCopyInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToSFPopulateCopyInfo')
	delete from GXDBVersions where aliasname = 'archChunkToSFPopulateCopyInfo'
GO
print '... Creating Procedure: archChunkToSFPopulateCopyInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archChunkToSFPopulateCopyInfo
  @i_adminJobId integer,
  @i_isNewAttempt integer
AS
  DECLARE @retVal int;
  DECLARE @nSkippedAFs int;
  DECLARE @skippedAFs VARCHAR(MAX);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#tblAFC') IS NOT NULL DROP TABLE #tblAFC
IF OBJECT_ID('tempdb.dbo.#tblAFC2') IS NOT NULL DROP TABLE #tblAFC2
CREATE TABLE #tblAFC(
		archFileId int, commCellId int, archGroupId int, defaultCopyId int, srcCopyId int
		primary key (archFileId, commCellId) )
CREATE TABLE #tblAFC2 (
		archFileId int, commCellId int, archGroupId int, defaultCopyId int, srcCopyId int, copyPrecedence int,  VolumeId int, isMagnetic int, isAccessible int, physicalSize bigint, failureType int
		primary key (archFileId, commCellId, srcCopyId) )
DECLARE @archChunkToSFUpdateStatusReturn TABLE(errorCode INTEGER)
DECLARE @tblMA_DP TABLE (
	mmErrorCode			integer,
mediaAgentName		varchar(1024),
	clientId			integer,
	nasClientId			integer,
	clientReleaseId     integer,
filerName			varchar(1024),
	hostId				integer,
	drivepoolId			integer,
	drivepoolType		integer,
	libraryId			integer,
	libraryTypeId		integer,
	libraryAttribute	integer,
libraryName			varchar(128),
libraryAliasName	varchar(128),
barCode				varchar(256),
	volumeId			integer,
	mediaLocation		integer,
	jobOpType			integer,
	failureType			integer)
DECLARE @l_lastCommCellId	int = 0
DECLARE	@l_lastArchFileId	int = 0
DECLARE @l_commCellId	int = 0
DECLARE	@l_archFileId	int = 0
DECLARE	@l_archCopyId	int = 0
DECLARE @l_volumeId		int = 0
DECLARE @errorCode	int = 0
DECLARE @l_errorCode int = 0
DECLARE @l_destCopyId		integer = (SELECT defaultCopy FROM archGroup AG, JMBkpJobInfo J WHERE J.JobId = @i_adminJobId AND AG.id = J.dataPolicy)
DECLARE @l_includeAgedData	integer = 0
DECLARE @l_preferMagnetic	integer = 1
DECLARE @l_preferAccessible	integer = 1
IF NOT EXISTS(SELECT * FROM	ArchChunkToSFArchFiles SA WHERE SA.adminJobID = @i_adminJobId )
BEGIN
	SET @errorCode = -2
	GOTO ERR_EXIT
END
SELECT @l_includeAgedData = (CASE WHEN (ISNUMERIC(value) = 1) THEN  CAST(value AS INTEGER) ELSE 0 END)
FROm	GxGlobalParam
WHERE	name = 'ShowAgedDataForBrowseAndRecovery' --SHOW_AGED_DATA
SELECT @l_preferMagnetic = (CASE WHEN (ISNUMERIC(value) = 1) THEN  CAST(value AS INTEGER) ELSE 0 END)
FROm	GxGlobalParam
WHERE	name = 'AutoCopyPrecedence' --AUTO_COPY_PRECEDENCE
SET @l_preferAccessible = @l_preferMagnetic
DECLARE @now INTEGER;
SET		@now = dbo.GetUnixTime(GetUTCDate())
IF EXISTS (SELECT TOP 1 * FROM ArchChunkToSF WHERE adminJobID = @i_adminJobId)
BEGIN
	-- Mark the copied chunks as processed
	INSERT INTO @archChunkToSFUpdateStatusReturn
	EXEC archChunkToSFUpdateStatus @i_adminJobId
	SELECT	@errorCode = @@ERROR
	IF	@errorCode <> 0 GOTO ERR_EXIT
	SELECT TOP 1 @errorCode = errorCode
	FROM	@archChunkToSFUpdateStatusReturn
	IF	@errorCode <> 0 GOTO ERR_EXIT
	UPDATE	SA
	SET		SA.srcCopyId = 0
	FROM	ArchChunkToSFArchFiles SA,
			archChunkToSF S LEFT OUTER JOIN JMJobDataStats JDS
				ON 	S.adminJobID = @i_adminJobId
					AND S.BackupJobId = JDS.JobID
					AND S.CommCellId = JDS.CommCellId
					AND S.SrcCopyId = JDS.archGrpCopyId
					AND S.fileType = JDS.dataType
	WHERE	SA.adminJobID = @i_adminJobId
			AND SA.adminJobId = S.adminJobId
			AND SA.archFileId = S.archFileId
			AND SA.CommCellId = S.CommCellId
ANd	S.Status IN ( 6, 3, 5, 0)
			AND (JDS.Status IS NULL
				 OR JDS.Status = 1000
OR (@l_includeAgedData = 0 AND ((JDS.disabled & (8192 | 1)) = (8192 | 1)
OR (JDS.disabled & (256)) > 0)))
	SELECT	@errorCode = @@ERROR
	IF	@errorCode <> 0 GOTO ERR_EXIT
	UPDATE	SA
	SET		SA.srcCopyId = 0
	FROM	ArchChunkToSFArchFiles SA, archChunkToSF S
	WHERE	SA.adminJobID = @i_adminJobId
			AND SA.adminJobId = S.adminJobId
			AND SA.archFileId = S.archFileId
			AND SA.CommCellId = S.CommCellId
AND S.Status = 4
AND (S.ErrorCode = 30017 OR S.ErrorCode = 30032 OR
S.ErrorCode = 30074   OR S.ErrorCode = 1208 OR
S.ErrorCode = 65103   )
	SELECT	@errorCode = @@ERROR
	IF	@errorCode <> 0 GOTO ERR_EXIT
	DELETE	S
	FROM	archChunkToSF S, ArchChunkToSFArchFiles SA
	WHERE	SA.adminJobID = @i_adminJobId
			AND SA.adminJobId = S.adminJobId
			AND SA.archFileId = S.archFileId
			AND SA.CommCellId = S.CommCellId
			-- AND S.Status = CVA_CHUNK_FAILED
			AND SA.srcCopyId = 0
	SELECT	@errorCode = @@ERROR
	IF	@errorCode <> 0 GOTO ERR_EXIT
END
INSERT INTO #tblAFC (archFileId, commcellId, archGroupId, defaultCopyId, srcCopyId)
SELECT	SA.archFileId, SA.CommCellId, AG.id, AG.defaultCopy, 0
FROM	ArchChunkToSFArchFiles SA, archFile AF, archGroup AG
WHERE	SA.adminJobId = @i_adminJobId
		AND	SA.archFileId = AF.id
		AND SA.commCellId = AF.CommCellId
		AND AF.archGroupId = AG.id
SELECT	@errorCode = @@ERROR
IF	@errorCode <> 0 GOTO ERR_EXIT
IF EXISTS (SELECT 1 from MMConfigs where name = 'ARMGR_CONFIG_ALLOW_CVA_COPY_CLASSIC_PRIMARY_AND_PRECEDENCE_ANY' and value > 0)
BEGIN
	UPDATE	T
	SET		T.SrcCopyId = T.defaultCopyId
	FROM	#tblAFC T, archFileCopy AFC
	WHERE	T.archFileId = AFC.archFileId
			AND T.commCellid = AFC.CommCellId
			AND T.defaultCopyId = AFC.archCopyId
			AND AFC.isValid = 1
AND (@l_includeAgedData <> 0 OR (AFC.flags & 256) = 0)
	SELECT	@errorCode = @@ERROR
	IF	@errorCode <> 0 GOTO ERR_EXIT
END
INSERT INTO #tblAFC2 (archFileId, commcellId, archGroupId, defaultCopyId, srcCopyId, copyPrecedence, VolumeId, isMagnetic, isAccessible, physicalSize )
SELECT	T.archFileId, T.commcellId, T.archGroupId, T.defaultCopyId, AFC.archCopyId, AGC.copy, 0, 0,
(CASE WHEN (AFC.flags & 2) = 2  THEN 1 ELSE 0 END), AFC.physicalSize
FROM	#tblAFC T, archFileCopy AFC, archGroupCopy AGC
WHERE	T.archFileId = AFC.archFileId
		AND T.commCellid = AFC.CommCellId
		AND T.srcCopyId = 0
		AND AFC.isValid = 1
AND (@l_includeAgedData <> 0 OR (AFC.flags & 256) = 0)
		AND AFC.archCopyId = AGC.id
		AND AGC.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
SELECT	@errorCode = @@ERROR
IF	@errorCode <> 0 GOTO ERR_EXIT
IF (@l_preferMagnetic <> 0 OR @l_preferAccessible <> 0)
BEGIN
	WITH tblAFC2_CTE(archFileId, commcellId, srcCopyId, RowNumber)
	AS
	(
		SELECT	archFileId, commcellId, srcCopyId,
		ROW_NUMBER() OVER (PARTITION BY archFileId, commcellId ORDER BY copyPrecedence) AS RowNumber
		FROM	#tblAFC2
		WHERE	physicalSize = 0
	)
	UPDATE	T
	SET		SrcCopyId = CTE.SrcCopyId
	FROM	#tblAFC T, tblAFC2_CTE CTE
	WHERE	T.archFileId = CTE.archFileId
			AND T.CommCellId = CTE.CommCellId
			AND CTE.RowNumber = 1
			AND T.srcCopyId = 0
	SELECT	@errorCode = @@ERROR
	IF	@errorCode <> 0 GOTO ERR_EXIT
	DELETE	T2
	FROM	#tblAFC2 T2, #tblAFC T
	WHERE	T2.archFileId = T.archFileId
			AND T2.CommCellId = T.CommCellId
			AND T.SrcCopyId  > 0
	SELECT	@errorCode = @@ERROR
	IF	@errorCode <> 0 GOTO ERR_EXIT
	IF (@l_preferAccessible = 0)
	BEGIN
		WITH tblAFC2_CTE(archFileId, commcellId, srcCopyId, RowNumber)
		AS
		(
			SELECT	archFileId, commcellId, srcCopyId,
			ROW_NUMBER() OVER (PARTITION BY archFileId, commcellId ORDER BY isMagnetic desc, copyPrecedence) AS RowNumber
			FROM	#tblAFC2
		)
		UPDATE	T
		SET		SrcCopyId = CTE.SrcCopyId
		FROM	#tblAFC T, tblAFC2_CTE CTE
		WHERE	T.archFileId = CTE.archFileId
				AND T.CommCellId = CTE.CommCellId
				AND CTE.RowNumber = 1
				AND T.srcCopyId = 0
		SELECT	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO ERR_EXIT
		DELETE	T2
		FROM	#tblAFC2 T2, #tblAFC T
		WHERE	T2.archFileId = T.archFileId
				AND T2.CommCellId = T.CommCellId
				AND T.SrcCopyId  > 0
		SELECT	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO ERR_EXIT
	END
	UPDATE	T
	SET		T.VolumeId = AC.VolumeId
	FROM	#tblAFC2 T, archChunkMapping ACM, archChunk AC
	WHERE	T.archFileId = ACM.archFileId
			AND T.CommCellId = ACM.CommCellId
			AND T.SrcCopyId = ACM.archCopyId
			AND ACM.archChunkId = AC.id
			AND ACM.chunkCommCellId = AC.CommCellId
	SELECT	@errorCode = @@ERROR
	IF	@errorCode <> 0 GOTO ERR_EXIT
	IF @l_preferMagnetic = 0
		DECLARE curGetCopy CURSOR FOR
		SELECT	archFileId, CommCellId, srcCopyId, volumeId
		FROM	#tblAFC2
		ORDER BY archfileid ASC, commcellid ASC, copyPrecedence ASC
	ELSE
		DECLARE curGetCopy CURSOR FOR
		SELECT	archFileId, CommCellId, srcCopyId, volumeId
		FROM	#tblAFC2
		ORDER BY archfileid ASC, commcellid ASC, isMagnetic DESC, copyPrecedence ASC
	OPEN  curGetCopy
	FETCH NEXT FROM curGetCopy
	INTO  @l_archFileId, @l_commCellId, @l_archCopyId, @l_volumeId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF (@l_lastArchFileId != @l_archFileId OR @l_lastCommCellId != @l_commCellId)
		BEGIN
			INSERT	INTO @tblMA_DP
			EXEC	@l_errorCode = MMS2GetMAAndDPForVolume @l_volumeId, 0, 0, 0, 0, 0
IF @l_errorCode = 0
			BEGIN
				SET	@l_errorCode = 0
				IF EXISTS (
					SELECT *
					FROM	@tblMA_DP
					WHERE	volumeId = @l_volumeId AND failureType = 0 AND mediaLocation IN (1, 2)
					)
				BEGIN
					UPDATE	T
					SET		T.SrcCopyId = @l_archCopyId
					FROM	#tblAFC T
					WHERE	T.archFileId = @l_archFileId
							AND T.CommCellId = @l_commCellId
					SELECT	@errorCode = @@ERROR
					IF	@errorCode <> 0 GOTO ERR_EXIT
					SET	@l_lastArchFileId = @l_archFileId
					SET	@l_lastCommCellId = @l_commCellId
				END
			END
			ELSE
			BEGIN
				UPDATE	T
				SET		T.failureType = DP.FailureType
				FROM	#tblAFC2 T, @tblMA_DP DP
				WHERE	T.archFileId = @l_archFileId
						AND T.CommCellId = @l_commCellId
						AND T.SrcCopyId = @l_archCopyId
				SELECT	@errorCode = @@ERROR
				IF	@errorCode <> 0 GOTO ERR_EXIT
			END
		END
		SET @l_volumeId = 0
		FETCH NEXT FROM curGetCopy
		INTO  @l_archFileId, @l_commCellId, @l_archCopyId, @l_volumeId
		DELETE	FROM @tblMA_DP
	END
	DONE_WITH_CURSOR:
	CLOSE curGetCopy
	DEALLOCATE curGetCopy
	DELETE	T2
	FROM	#tblAFC2 T2, #tblAFC T
	WHERE	T2.archFileId = T.archFileId
			AND T2.CommCellId = T.CommCellId
			AND T.SrcCopyId  > 0
	SELECT	@errorCode = @@ERROR
	IF	@errorCode <> 0 GOTO ERR_EXIT
	IF (@l_preferMagnetic <> 0)
	BEGIN
		WITH tblAFC2_CTE(archFileId, commcellId, srcCopyId, RowNumber)
		AS
		(
			SELECT	archFileId, commcellId, SrcCopyId,
			ROW_NUMBER() OVER (PARTITION BY archFileId, commcellId  ORDER BY isMagnetic desc, failureType, copyPrecedence) AS RowNumber
			FROM	#tblAFC2
		)
		UPDATE	T
		SET		SrcCopyId = CTE.SrcCopyId
		FROM	#tblAFC T, tblAFC2_CTE CTE
		WHERE	T.archFileId = CTE.archFileId
				AND T.CommCellId = CTE.CommCellId
				AND CTE.RowNumber = 1
				AND T.srcCopyId = 0
		SELECT	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO ERR_EXIT
		DELETE	T2
		FROM	#tblAFC2 T2, #tblAFC T
		WHERE	T2.archFileId = T.archFileId
				AND T2.CommCellId = T.CommCellId
				AND T.SrcCopyId  > 0
		SELECT	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO ERR_EXIT
	END
	ELSE
	BEGIN
		WITH tblAFC2_CTE(archFileId, commcellId, srcCopyId, RowNumber)
		AS
		(
			SELECT	archFileId, commcellId, SrcCopyId,
			ROW_NUMBER() OVER (PARTITION BY archFileId, commcellId ORDER BY failureType, copyPrecedence) AS RowNumber
			FROM	#tblAFC2
		)
		UPDATE	T
		SET		SrcCopyId = CTE.SrcCopyId
		FROM	#tblAFC T, tblAFC2_CTE CTE
		WHERE	T.archFileId = CTE.archFileId
				AND T.CommCellId = CTE.CommCellId
				AND CTE.RowNumber = 1
				AND T.srcCopyId = 0
		SELECT	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO ERR_EXIT
		DELETE	T2
		FROM	#tblAFC2 T2, #tblAFC T
		WHERE	T2.archFileId = T.archFileId
				AND T2.CommCellId = T.CommCellId
				AND T.SrcCopyId  > 0
		SELECT	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO ERR_EXIT
	END
END
ELSE
BEGIN
	WITH tblAFC2_CTE(archFileId, commcellId, srcCopyId, RowNumber)
	AS
	(
		SELECT	archFileId, commcellId, srcCopyId,
		ROW_NUMBER() OVER (PARTITION BY archFileId, commcellId ORDER BY copyPrecedence) AS RowNumber
		FROM	#tblAFC2
	)
	UPDATE	T
	SET		T.SrcCopyId = CTE.SrcCopyId
	FROM	#tblAFC T, tblAFC2_CTE CTE
	WHERE	T.archFileId = CTE.archFileId
			AND T.CommCellId = CTE.CommCellId
			AND CTE.RowNumber = 1
			AND T.srcCopyId = 0
	SELECT	@errorCode = @@ERROR
	IF	@errorCode <> 0 GOTO ERR_EXIT
END
UPDATE	SFA
SET		SFA.SrcCopyId = T.SrcCopyId,
		SFA.DestCopyId = @l_destCopyId
FROM	archChunkToSFArchFiles SFA, #tblAFC T
WHERE	SFA.adminJobID = @i_adminJobId
		AND SFA.archFileId = T.archFileId
		AND SFA.CommCellId = T.CommCellId
		AND SFA.SrcCopyId = 0
ERR_EXIT:
IF OBJECT_ID('tempdb.dbo.#tblAFC') IS NOT NULL DROP TABLE #tblAFC
IF OBJECT_ID('tempdb.dbo.#tblAFC2') IS NOT NULL DROP TABLE #tblAFC2
IF	@errorCode = 0 AND EXISTS (SELECT TOP 1 * FROM archChunkToSFArchFiles SFA WHERE SFA.adminJobID = @i_adminJobId AND SFA.SrcCopyId = 0)
BEGIN
	DECLARE @listStr VARCHAR(MAX)
	SELECT	 TOP 100 @listStr = COALESCE(@listStr+', ' ,'') + '(' + CAST(ArchFileId AS VARCHAR(10)) + ', ' + CAST(CommCellId AS VARCHAR(10)) + ')'
	FROm	ArchChunkToSFArchFiles
	WHERE	adminJobId = @i_adminJobId
			AND SrcCopyId = 0
	ORDER BY archFileId, CommCellId
	SELECT -1 AS retVal,
			(SELECT	 COUNT(*)
			FROm	ArchChunkToSFArchFiles
			WHERE	adminJobId = @i_adminJobId
					AND SrcCopyId = 0) AS nSkippedAFS,
			@listStr AS skippedAFs
END
ELSE
	SELECT	@errorCode AS retVal,
			0 AS nSkippedAFS,
			'' AS skippedAFs
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToSFPopulateCopyInfo')
	delete from GxQscripts where name = 'archChunkToSFPopulateCopyInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToSFPopulateCopyInfo')
	delete from GXDBVersions where aliasname = 'archChunkToSFPopulateCopyInfo'
GO

insert into GXDBVersions values(2, 'archChunkToSFPopulateCopyInfo',  '00010001004200050000', 'archChunkToSFPopulateCopyInfo', '00010001004200050000')
GO

