

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToSFIsReaderAvailableForReservation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToSFIsReaderAvailableForReservation.sp,v $ $Id: archChunkToSFIsReaderAvailableForReservation.sp,v 1.1.4.6 2018/03/20 19:48:49 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archChunkToSFIsReaderAvailableForReservation <<<'

IF EXISTS (select * from sysobjects where name='archChunkToSFIsReaderAvailableForReservation')
	drop procedure archChunkToSFIsReaderAvailableForReservation
IF EXISTS (select * from GxQscripts where name='archChunkToSFIsReaderAvailableForReservation')
	delete from GxQscripts where name = 'archChunkToSFIsReaderAvailableForReservation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToSFIsReaderAvailableForReservation')
	delete from GXDBVersions where aliasname = 'archChunkToSFIsReaderAvailableForReservation'
GO
print '... Creating Procedure: archChunkToSFIsReaderAvailableForReservation'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archChunkToSFIsReaderAvailableForReservation
  @i_AdminJobId integer,
  @i_includeAttemptState integer
AS
  DECLARE @IsReaderAvailableForReservation integer;
  DECLARE @errorCode integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET	@IsReaderAvailableForReservation = 0
SET	@errorCode = 0
IF EXISTS (	SELECT	TOP 1 segmentid
			FROM	archChunkToSF WITH (READUNCOMMITTED)
			WHERE	adminJobID = @i_AdminJobId
AND Status IN (0, 1)
			GROUP BY segmentId
HAVING (SUM(CASE WHEN Status = 0 THEN 1 ELSE 0 END) > 0 AND SUM(CASE WHEN Status = 1 THEN 1 ELSE 0 END) = 0)
			)
BEGIN
	SET	@IsReaderAvailableForReservation = 1
	GOTO ERR_EXIT
END
ELSE IF EXISTS (	SELECT TOP 1 *
			FROM	archChunkToSF AR WITH (READUNCOMMITTED)
			WHERE	AR.adminJobId = @i_AdminJobId
AND AR.Status IN (1, 5, 3)) AND
		EXISTS (	SELECT *
					FROM	JMJobInfo WITH (READUNCOMMITTED)
					WHERE	JobId = @i_AdminJobId
							AND (State = 3 OR displayState = 3) /*WAINTING*/)
BEGIN
	DECLARE @archChunkToSFGetJobStatusResultTable TABLE (
		errorCode	integer,
		jobStatus	integer,
		agedChunksSkipped	integer)
	INSERT INTO @archChunkToSFGetJobStatusResultTable
	EXEC archChunkToSFGetJobStatus @i_AdminJobId, @i_includeAttemptState
	IF (EXISTS (	SELECT TOP 1 *
			FROM	@archChunkToSFGetJobStatusResultTable
			WHERE	jobStatus IN (3 /*DASHCOPY_ARCHMGR_MORE_TO_COPY*/,
								  10 /*DASHCOPY_ARCHMGR_MORE_TO_COPY_ALL_SKIPPED*/,
								  11 /*DASHCOPY_ARCHMGR_MORE_TO_COPY_PARTIAL_SUCCESS*/,
								  12 /*DASHCOPY_ARCHMGR_MORE_TO_COPY_FAILED*/
								  )
					AND errorCode = 0))
	BEGIN
		SET	@IsReaderAvailableForReservation = 1
		GOTO ERR_EXIT
	END
END
ERR_EXIT:
	SELECT @IsReaderAvailableForReservation, @errorCode
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToSFIsReaderAvailableForReservation')
	delete from GxQscripts where name = 'archChunkToSFIsReaderAvailableForReservation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToSFIsReaderAvailableForReservation')
	delete from GXDBVersions where aliasname = 'archChunkToSFIsReaderAvailableForReservation'
GO

insert into GXDBVersions values(2, 'archChunkToSFIsReaderAvailableForReservation',  '00010001000400060000', 'archChunkToSFIsReaderAvailableForReservation', '00010001000400060000')
GO

