

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToSFInsert.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToSFInsert.sp,v $ $Id: archChunkToSFInsert.sp,v 1.4.14.12 2020/05/11 15:19:58 cliu Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archChunkToSFInsert')
BEGIN
	print '>>> Drop Stored Procedure: archChunkToSFInsert <<<'
	drop procedure archChunkToSFInsert
END
IF EXISTS (select * from GxQscripts where name='archChunkToSFInsert')
	delete from GxQscripts where name = 'archChunkToSFInsert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToSFInsert')
	delete from GXDBVersions where aliasname = 'archChunkToSFInsert'
GO
print '... Creating Procedure: archChunkToSFInsert'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archChunkToSFInsert
  @i_adminJobId int,
  @i_destCopyId int, 
  @i_srcCopyId int, 
  @i_isNewAttempt int
AS
  DECLARE @retVal int;
  DECLARE @nSkippedAFs int;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#tblAFC') IS NOT NULL DROP TABLE #tblAFC
CREATE TABLE #tblAFC(
		archFileId int, commCellId int, fileType int, appId int, backupJobId int,
		DestStreamNum int, flags int, physicalSize bigint, logicalSize bigint,
		srcStreamNum int, srcFlags int, srcPhysicalSize bigint, srcLogicalSize bigint,
		srcEncKeyType int, srcEncRSA int, srcEncKey varchar(1024), lastChunkNumber int,
		primary key (archFileId, commCellId) )
DECLARE @archChunkToSFUpdateStatusReturn TABLE(errorCode INTEGER)
DECLARE @l_dsaEnabled	int
DECLARE @l_commCellId	int
DECLARE @l_archGroupId	int
DECLARE @l_isSnapCopy	int
DECLARE @useLogicalSize	int
DECLARE @amErrCode		int
DECLARE	@oneConstReal REAL = 1.0
DECLARE	@l_isParallelCopy	int
DECLARE @errorCode	int
SET		@useLogicalSize	= 0
SET		@amErrCode		= 0
SET		@nSkippedAFs	= 0
SET		@l_dsaEnabled	= 0
DECLARE @now INTEGER;
SET		@now = dbo.GetUnixTime(GetUTCDate())
DECLARE @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS	INT = 10
-- SET @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS = ISNULL( (SELECT Value FROM MMConfigs WHERE NAME = 'MMCONFIG_DASHCOPY_JOB_SKIP_CHUNK_ON_NONE_SOURCE_ERROR_INTERVAL_MINS'), 10)
SET @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS = ISNULL( (SELECT Value FROM MMConfigs WHERE NAME = 'MMCONFIG_AUXCOPY_RETRY_STREAM_INTERVAL_MINUTES'), 10)
DECLARE @MAX_FAILURE_COUNT INT = 3
    SELECT  TOP 1 @MAX_FAILURE_COUNT = ISNULL(value, 3)
    FROM    MMConfigs WITH (NOLOCK)
    WHERE   name = 'MMS2_CONFIG_AUXCOPY_STREAM_RETRY_COUNT'
DECLARE @RETRY_TIME_INTERVAL INT = 180 -- SECONDS
    SELECT  TOP 1 @RETRY_TIME_INTERVAL = ISNULL(value, 180)
    FROM    MMConfigs WITH (NOLOCK)
    WHERE   name = 'MMCONFIG_AUXCOPY_RETRY_STREAM_INTERVAL_MINUTES'
UPDATE	SA
SET		destCopyId = @i_destCopyId
FROM	ArchChunkToSFArchFiles SA
WHERE	SA.adminJobID = @i_adminJobId
		AND SA.destCopyId = 0
-- Mark the copied chunks as processed
INSERT INTO @archChunkToSFUpdateStatusReturn
EXEC archChunkToSFUpdateStatus @i_adminJobId
SELECT	@errorCode = @@ERROR
IF	@errorCode <> 0
BEGIN
SET	@amErrCode = (153 | (CAST(POWER(2, 24) AS BIGINT) * 80))
	SET @nSkippedAFs = 1
	SET	@retVal = 0
	GOTO ERR_EXIT
END
SELECT TOP 1 @errorCode = errorCode
FROM	@archChunkToSFUpdateStatusReturn
SELECT	@errorCode = @@ERROR
IF	@errorCode <> 0
BEGIN
SET	@amErrCode = (153 | (CAST(POWER(2, 24) AS BIGINT) * 80))
	SET @nSkippedAFs = 1
	SET	@retVal = 0
	GOTO ERR_EXIT
END
IF (@i_isNewAttempt = 1)
BEGIN
	-- On new attempt move all chunks from SENT status to POPULATE Status
	UPDATE archChunkToSF
SET		Status = 0,
			Modified = @now
	WHERE	archChunkToSF.adminjobId = @i_adminJobId
			AND archChunkToSF.destCopyId = @i_destCopyId
			AND archChunkToSF.SrcCopyId = @i_srcCopyId
AND (Status = 1
OR (archChunkToSF.Status = 3)) -- AND archChunkToSF.SkippedCount < @MAX_FAILURE_COUNT))
				 --  AND archChunkToSF.SkippedReason IN (CVA_READ_SOURCE_DATA_ERROR, CVA_AUXCOPY_SOURCE_MEDIA_ERROR))
				 --  OR (archChunkToSF.Status = CVA_CHUNK_SKIPPED AND archChunkToSF.SkippedCount < 12 AND archChunkToSF.SkippedReason NOT IN (CVA_READ_SOURCE_DATA_ERROR, CVA_AUXCOPY_SOURCE_MEDIA_ERROR)))
	UPDATE archChunkToSF
	SET		SegmentId = 0,
			Modified = @now
	WHERE	archChunkToSF.adminjobId = @i_adminJobId
			AND archChunkToSF.SrcCopyId = @i_srcCopyId
AND Status = 0
END
ELSE
BEGIN
	-- Move all chunks from SENT status to POPULATE Status if we dont have any reservations
	UPDATE	AR
SET		Status = 0,
			Modified = @now
	FROM	archChunkToSF AR, ArchChunkToSFArchFiles ASF  WITH (NOLOCK)
	WHERE	AR.adminJobId = @i_adminJobId
AND AR.Status = 1
			AND NOT EXISTS ( SELECT	*
							FROM	MMResource R WITH (NOLOCK), MMResourceToJob RJ WITH (NOLOCK), JMBkpJobInfo J WITH (NOLOCK)
							WHERE	R.CopyId = AR.DestCopyId
									AND R.ReservationId = RJ.ReservationId
									AND RJ.ReservationType = 2
									AND (RJ.InUse = 1 OR RJ.ReserveBitMask <> 0)
									AND J.jobId = RJ.JobId_l
									AND J.commCellId = 2)
			AND AR.archFileId = ASF.archFileId
			AND AR.commCellId = ASF.commCellId
			AND AR.SrcCopyId = ASF.SrcCopyId
			AND AR.destCopyId = @i_destCopyId
			AND AR.SrcCopyId = @i_srcCopyId
			AND (ASF.TotalItems > ASF.ProcessedItems AND ASF.ProcessedItems != -1)
END
IF	(SELECT	COUNT(DISTINCT PT.CopyId)
	FROM	MMDrivePool PL WITH (NOLOCK), MMDataPath PT WITH (NOLOCK)
	WHERE	PL.DrivePoolId = PT.DrivePoolId AND PT.CopyId IN (@i_srcCopyId, @i_destCopyId) AND PL.DrivePoolType = 3) = 1
BEGIN
		SET	@useLogicalSize = 1
END
SELECT	@l_archGroupId = archGroupId,
		@l_isSnapCopy  = isSnapCopy,
@l_isParallelCopy = case when (flags & 2048) > 0 then 1 else 0 end
FROM	archGroupCopy WITH (NOLOCK) WHERE id = @i_destCopyId
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
SELECT	@l_dsaEnabled = case when (flags & 131072) = 131072 then 1 else 0 end
FROM	archGroup WITH (NOLOCK) WHERE id = @l_archGroupId
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
INSERT INTO #tblAFC
SELECT	A.archFileId, A.commCellId, 0, 0, 0,
		0, 0, A.ProcessedItems, 0,
		B.streamNum, B.flags, B.physicalSize, B.logicalSize,
		B.encKeyType, B.encRSA, B.encKey, B.lastChunkNumber
FROM   (SELECT * FROM ArchChunkToSFArchFiles WITH (NOLOCK) WHERE adminJobId = @i_adminJobId) A,
		archFileCopy B WITH (NOLOCK)
WHERE	A.archFileId = B.archFileId AND A.commCellId = B.commCellId
AND (B.flags & 256) = 0
	AND (A.TotalItems > A.ProcessedItems AND A.ProcessedItems != -1)
	AND B.archCopyId = A.SrcCopyId
	AND B.archCopyId = @i_srcCopyId
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
UPDATE	#tblAFC
SET		fileType = b.fileType, appId = b.appId, backupJobId = b.jobId
FROM	#tblAFC a, archFile b WITH (NOLOCK)
WHERE	b.id = a.archFileId AND b.commCellId = a.commCellId
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
-- Remove Already populated archive Files
DELETE	#tblAFC
FROM	#tblAFC AFC LEFT JOIN archChunkToSF R WITH (NOLOCK)
	ON	R.archFileId = AFC.archFileId AND R.commCellId = AFC.commCellId
	AND R.SrcCopyId = @i_srcCopyId
	AND R.DestCopyId = @i_destCopyId
WHERE	R.AdminJobID = @i_adminJobId
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
INSERT	INTO archChunkToSF (AdminJobId, BackupJobId, ArchFileId, CommCellId, ArchChunkId, ChunkCommCellId, ChunkNumber, lastChunkNumber,
		ArchGroupId, SrcCopyId, SrcStreamNum, DestCopyId, DestStreamNum,
		PhysicalStartOffset, PhysicalOffset, LogicalOffset, PhysicalSize, LogicalSize, unCompBytesSize,
		VolumeId, MediaId, MediaGroupId, MediaType,
		SrcMAId, SrcDrivePoolId,
		Status, Modified, SkippedReason, SkippedCount, SkippedForSeconds, ErrorCode,
		appId, fileType, archFileCopyFlags, encKeyType, fileMarkerNo,
		chunkCreateTime, chunkVersion, chunkPhysicalSize, chunkLogicalSize, chunkHwEncKey, archFileEncKey,
		extraFlags, segmentId, IsParallelCopy, streamReaderID)
SELECT
		@i_adminJobId, a.BackupJobId, a.ArchFileId, a.CommCellId, a.ArchChunkId, a.ChunkCommCellId, a.ChunkNumber, a.lastChunkNumber,
		@l_archGroupId, a.archCopyId, a.SrcStreamNum, @i_destCopyId, a.DestStreamNum,
		0 /*PhysicalStartOffset*/, a.PhysicalOffset, a.LogicalOffset, a.PhysicalSize, a.LogicalSize, a.unCompSize,
		b.VolumeId, 0, 0, 10001 /*MediaType*/,
		0, 0,
		0, @now, 0, 0, 0, 0,
		a.appId, a.fileType, a.srcFlags, a.srcEncKeyType, b.fileMarkerNo,
		b.createTime, b.version, b.physicalSize, b.logicalSize, b.hwEncKey, a.srcEncKey,
		0, 0, @l_isParallelCopy,0
FROM	(SELECT AFC.DestStreamNum, AFC.appId, AFC.backupJobId, AFC.srcStreamNum,
				AFC.fileType, AFC.srcFlags, AFC.srcEncKeyType, AFC.srcEncKey, AFC.lastChunkNumber, ACM.*
		FROM #tblAFC AFC, archChunkMapping ACM WITH (NOLOCK)
		WHERE	(@l_isSnapCopy = 0 OR AFC.DestStreamNum = 1)
			AND ACM.archFileId = AFC.archFileId AND ACM.commCellId = AFC.commCellId AND ACM.archCopyId = @i_srcCopyId
			AND ACM.chunkNumber = 1
		) a, archChunk b with (NOLOCK)
WHERE	b.id = a.archChunkId AND b.commCellId = a.chunkCommCellId
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
UPDATE	archChunkToSF SET mediaId = b.MediaId, mediaGroupId = b.MediaGroupId, MediaType = M.MediaTypeId
FROM	archChunkToSF a, MMVolume b WITH (NOLOCK), MMMedia M WITH (NOLOCK)
WHERE	a.adminJobId = @i_adminJobId AND a.destCopyId = @i_destCopyId AND a.volumeId = b.VolumeId AND b.MediaId = M.MediaId
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
IF OBJECT_ID('tempdb.dbo.#tmpJobSizeInfo') IS NOT NULL DROP TABLE #tmpJobSizeInfo
CREATE TABLE #tmpJobSizeInfo (
	JobId INT, CommCellId INT, totalBackupSize BIGINT, totalAppSize BIGINT, totalIndexSize BIGINT
 	PRIMARY KEY (JobId, CommCellId))
INSERT INTO #tmpJobSizeInfo
SELECT	DISTINCT backupJobId, CommCellId, 0, 0, 0
FROM archChunkToSF
WHERE adminJobId = @i_adminJobId
	AND destCopyId = @i_destCopyId
	AND SrcCopyId = @i_srcCopyId
	AND unCompBytesSize = -1
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
EXEC  @retVal = archGetJobSizeInfo 0
UPDATE	archChunkToSF
SET		unCompBytesSize = (CASE WHEN totalBackupSize > 0 THEN CAST(((@oneConstReal * (totalAppSize+totalIndexSize)*physicalSize)/totalBackupSize) AS BIGINT) ELSE physicalSize END)
FROM	#tmpJobSizeInfo J
WHERE	adminJobId = @i_adminJobId
		AND destCopyId = @i_destCopyId
		AND SrcCopyId = @i_srcCopyId
		AND archChunkToSF.backupJobId = J.JobId
		AND archChunkToSF.CommCellId = J.CommCellId
		AND archChunkToSF.unCompBytesSize = -1
-- Adjust hwEncKey based on media
UPDATE	R
SET		chunkHwEncKey = M.hwEncKey
FROM	archChunkToSF R WITH (READUNCOMMITTED), MMMedia M WITH (READUNCOMMITTED), ArchChunk chunk WITH (READUNCOMMITTED)
WHERE	R.adminJobId = @i_adminJobId
		AND R.destCopyId = @i_destCopyId
		AND R.SrcCopyId = @i_srcCopyId
		AND M.MediaTypeId != 10001
		AND R.MediaId = M.MediaId
		AND R.chunkHwEncKey = ''
		AND	R.ArchChunkId = chunk.Id
		AND	R.ChunkCommCellId = chunk.CommCellId
AND chunk.flags & 1048576 > 0
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
ERR_EXIT:
IF OBJECT_ID('tempdb.dbo.#tblAFC') IS NOT NULL DROP TABLE #tblAFC
IF OBJECT_ID('tempdb.dbo.#tmpJobSizeInfo') IS NOT NULL DROP TABLE #tmpJobSizeInfo
IF	@retVal = 0 AND @nSkippedAFs <> 0
	SELECT @amErrCode, @nSkippedAFs
ELSE
	SELECT @retVal, @nSkippedAFs
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToSFInsert')
	delete from GxQscripts where name = 'archChunkToSFInsert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToSFInsert')
	delete from GXDBVersions where aliasname = 'archChunkToSFInsert'
GO

insert into GXDBVersions values(2, 'archChunkToSFInsert',  '00010004001400120000', 'archChunkToSFInsert', '00010004001400120000')
GO

