

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToSFHandleFailedReportStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToSFHandleFailedReportStatus.sp,v $ $Id: archChunkToSFHandleFailedReportStatus.sp,v 1.3.32.5 2018/03/20 20:03:23 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archChunkToSFHandleFailedReportStatus <<<'

IF EXISTS (select * from sysobjects where name='archChunkToSFHandleFailedReportStatus')
	drop procedure archChunkToSFHandleFailedReportStatus
IF EXISTS (select * from GxQscripts where name='archChunkToSFHandleFailedReportStatus')
	delete from GxQscripts where name = 'archChunkToSFHandleFailedReportStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToSFHandleFailedReportStatus')
	delete from GXDBVersions where aliasname = 'archChunkToSFHandleFailedReportStatus'
GO
print '... Creating Procedure: archChunkToSFHandleFailedReportStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archChunkToSFHandleFailedReportStatus
  @i_adminJobId int,
  @i_chunkId bigint,
  @i_chunkCommCellId int,
  @i_srcCopyId int,
  @i_srcStreamNum int,
  @i_destCopyId int,
  @i_destStreamNum int,
  @i_readerId int,
  @i_isSrcError int,
  @i_errorCode int,
  @i_mmErrorCode int,
  @i_type int
AS
  DECLARE @o_error integer;
  DECLARE @o_errorString varchar(2048);
  DECLARE @o_barcode varchar(256);
  DECLARE @o_libraryName NVARCHAR(128);
  DECLARE @o_mediaTypeId integer;
  DECLARE @o_mountPathName NVARCHAR(1024); 
  DECLARE @o_policyName NVARCHAR(144);
  DECLARE @o_copyName NVARCHAR(64);
  DECLARE @o_mediaAgentName NVARCHAR(255);
  DECLARE @o_jobIdString varchar(1024);
SET NOCOUNT ON
DECLARE @error			integer
DECLARE @errorString	varchar(1024)
DECLARE @barcode		varchar(256)
DECLARE @libraryName	NVARCHAR(128)
DECLARE @mediaTypeId	integer
DECLARE @mountPathName	NVARCHAR(1024)
DECLARE @policyName		NVARCHAR(144)
DECLARE @copyName		NVARCHAR(64)
DECLARE @mediaAgentName	NVARCHAR(255)
DECLARE @jobIdString	varchar(1024)
DECLARE @srcMAId		integer
DECLARE @destMAId		integer
DECLARE @srcDPId		integer
DECLARE @destDPId		integer
DECLARE @segmentId		integer = 0
DECLARE	@volumeId integer
DECLARE	@mediaId integer
DECLARE	@skipSourceMedia INTEGER = 0
DECLARE @now INTEGER = dbo.GetUnixTime(GetUTCDate())
DECLARE @SKIP_INTERVAL_ON_SOURCE_ERROR_MINS	INT = 60
SET @SKIP_INTERVAL_ON_SOURCE_ERROR_MINS = ISNULL( (SELECT Value FROM MMConfigs WHERE NAME = 'MMCONFIG_DASHCOPY_JOB_SKIP_CHUNK_ON_SOURCE_ERROR_INTERVAL_MINS'), 60)
DECLARE @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS	INT = 10
-- SET @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS = ISNULL( (SELECT Value FROM MMConfigs WHERE NAME = 'MMCONFIG_DASHCOPY_JOB_SKIP_CHUNK_ON_NONE_SOURCE_ERROR_INTERVAL_MINS'), 10)
SET @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS = ISNULL( (SELECT Value FROM MMConfigs WHERE NAME = 'MMCONFIG_AUXCOPY_RETRY_STREAM_INTERVAL_MINUTES'), 10)
-- Mark the processed chunks
DECLARE @archChunkToSFUpdateStatusReturn TABLE (errorCode INTEGER)
INSERT INTO @archChunkToSFUpdateStatusReturn
EXEC archChunkToSFUpdateStatus @i_adminJobId
SELECT	TOP 1 @segmentId = segmentId
FROM	archChunkToSF WITH (NOLOCK)
WHERE	adminJobId = @i_adminJobId
		AND archChunkId = @i_chunkId
		AND chunkCommCellId = @i_chunkCommCellId
		AND destCopyId = @i_destCopyId
SELECT	@srcMAId	= SrcMAId,
		@destMAId	= DestMAId,
		@srcDPId	= SrcDrivePoolId,
		@destDPId	= DestDrivePoolId
FROM	ArchJobStreamStatus S  WITH (NOLOCK)
WHERE	S.JobId = @i_adminJobId
		AND S.SrcCopyId = @i_srcCopyId
		AND S.SrcStreamNum = @i_srcStreamNum
		AND S.DestCopyId = @i_destCopyId
		AND S.DestStreamNum = @i_destStreamNum
		AND S.StreamReaderId = @i_readerId
IF EXISTS (SELECT * FROM MMConfigs  WITH (NOLOCK) WHERE	name = 'MMCONFIG_AUXCOPY_SKIP_UNAVAILABLE_MEDIA' and Value > 0)
	SET	@skipSourceMedia = 1
SELECT	@mediaAgentName = name
FROM	APP_Client C  WITH (NOLOCK)
WHERE	C.Id = (CASE WHEN (@i_isSrcError = 1) THEN @srcMAId ELSE @destMAId END)
IF ((@i_isSrcError = 1)
	AND @skipSourceMedia = 1
AND 273 = @i_mmErrorCode
	AND	EXISTS (SELECT	1
			FROM	MMDrivePool DP WITH (NOLOCK), MMMasterPool MP WITH (NOLOCK), MMLibrary L WITH (NOLOCK)
			WHERE	DP.DrivePoolId = @srcDPId
					AND DP.MasterPoolId = MP.MasterPoolId
					AND MP.LibraryId = L.LibraryId
AND L.LibraryTypeId NOT IN (4, 5)))
SET @i_errorCode = 0x10;
DECLARE	@archFileToSkip TABLE (archFileId integer, commCellId integer, minChunkNumber integer, backupJobId integer, segmentId integer)
-- IF (@i_errorCode = 0x3)
-- Since we dont know the exact error code from restore/backup modules, lets skip the archive files for 60 mins
BEGIN
	INSERT INTO @archFileToSkip
	SELECT	archFileId, CommCellId, MIN(chunkNumber), BackupJobId, MIN(SegmentId)
	FROM	archChunkToSF WITH (NOLOCK)
	WHERE	adminJobId = @i_adminJobId
			AND archChunkId = @i_chunkId
			AND chunkCommCellId = @i_chunkCommCellId
			AND destCopyId = @i_destCopyId
AND Status IN (0, 1)
			AND segmentId = @segmentId
	GROUP BY archFileId, CommCellId, BackupJobId
	UPDATE	archChunkToSF
SET		Status = 3,
			SkippedCount += 1,
			SkippedForSeconds = (@SKIP_INTERVAL_ON_SOURCE_ERROR_MINS * 60),
			SkippedReason = @i_errorCode,
			ErrorCode = @i_mmErrorCode,
			Modified = @now
	FROM	archChunkToSF R, @archFileToSkip S
	WHERE	R.adminJobId = @i_adminJobID
			-- AND R.backupJobId = S.backupJobId
			AND R.archFileId = S.archFileId
			AND R.CommCellId = S.commCellId
			AND R.destCopyId = @i_destCopyId
AND Status IN (0, 1)
	UPDATE	archChunkToSF
SET		Status = 0,
			Modified = @now
	FROM	archChunkToSF R LEFT OUTER JOIN  @archFileToSkip S
					ON	R.adminJobId = @i_adminJobID
						-- AND R.backupJobId = S.backupJobId
						AND R.archFileId = S.archFileId
						AND R.CommCellId = S.commCellId
	WHERE R.adminJobId = @i_adminJobID
			AND R.SrcCopyId = @i_srcCopyId
			AND R.SrcStreamNum = @i_srcStreamNum
			AND R.destCopyId = @i_destCopyId
AND R.Status IN ( 1)
			AND S.archFileId IS NULL
			AND R.segmentId = @segmentId
END
-- SET @jobIdString = ' Backup Job ['
-- SELECT	@jobIdString = @jobIdString + ' ' + CAST(backupJobId AS VARCHAR(10))
-- FROM	(SELECT DISTINCT backupJobId, CommCellId FROM @archFileToSkip) S
-- ORDER BY backupJobId, CommCellId
-- SET		@jobIdString += ' ]'
SELECT	TOP 1 @volumeId = VolumeId, @mediaId = mediaId, @mediaTypeId = MediaType
FROM	archChunkToSF WITH (NOLOCK)
WHERE	adminJobId = @i_adminJobId
		AND archChunkId = @i_chunkId
		AND chunkCommCellId = @i_chunkCommCellId
		AND destCopyId = @i_destCopyId
SELECT	@jobIdString = @jobIdString + CAST(backupJobId AS varchar(10)) + (CASE WHEN (LEN(@JobIdString) > 0) THEN ', ' ELSE '' END)
FROM	@archFileToSkip
SELECT	@barCode = barcode, @libraryName = L.AliasName
FROM	MMMedia M WITH (NOLOCK), MMLibrary L WITH (NOLOCK)
WHERE	M.MediaId = @mediaId
		AND M.LibraryId = L.LibraryId
SELECT	@policyName = AG.name, @copyName = AGC.name
FROM	archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
WHERE	AG.id = AGC.archGroupId
		AND AGC.id = (CASE WHEN (@i_destCopyId = 0) THEN @i_srcCopyId ELSE @i_destCopyId END)
IF (@mediaTypeId = 10001)
BEGIN
	SELECT	@barCode = VolumeName
	FROM	MMVolume
	WHERE	VolumeId = @volumeId
	SELECT	@mountPathName = MountPathName
	FROM	MMS2getMountPathNameGUIView
	WHERE	MediaId = @mediaId
END
-- Move the chunks in sent state back to populated state to send them again
UPDATE	archChunkToSF
SET		Status = 0
FROM	archChunkToSF R
WHERE	R.DestCopyId = @i_destCopyId
		AND R.DestStreamNum = @i_destStreamNum
AND R.Status = 1
		AND R.segmentId = @segmentId
SELECT	@error, @errorString, @barcode, @libraryName, @mediaTypeId, @mountPathName,
		@policyName, @copyName, @mediaAgentName, @jobIdString
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToSFHandleFailedReportStatus')
	delete from GxQscripts where name = 'archChunkToSFHandleFailedReportStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToSFHandleFailedReportStatus')
	delete from GXDBVersions where aliasname = 'archChunkToSFHandleFailedReportStatus'
GO

insert into GXDBVersions values(2, 'archChunkToSFHandleFailedReportStatus',  '00010003003200050000', 'archChunkToSFHandleFailedReportStatus', '00010003003200050000')
GO

