

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToSFGetJobStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToSFGetJobStatus.sp,v $ $Id: archChunkToSFGetJobStatus.sp,v 1.3.34.8 2020/05/05 17:56:16 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archChunkToSFGetJobStatus')
BEGIN
	print '>>> Drop Stored Procedure: archChunkToSFGetJobStatus <<<'
	drop procedure archChunkToSFGetJobStatus
END
IF EXISTS (select * from GxQscripts where name='archChunkToSFGetJobStatus')
	delete from GxQscripts where name = 'archChunkToSFGetJobStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToSFGetJobStatus')
	delete from GXDBVersions where aliasname = 'archChunkToSFGetJobStatus'
GO
print '... Creating Procedure: archChunkToSFGetJobStatus'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archChunkToSFGetJobStatus
  @i_AdminJobId integer,
  @i_includeAttemptState integer
AS
  DECLARE @errorCode integer;
  DECLARE @jobStatus integer;
  DECLARE @agedChunksSkipped integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @archChunkToSFUpdateStatusReturn TABLE (errorCode INTEGER)
DECLARE @now INTEGER;
SET		@now = dbo.GetUnixTime(GetUTCDate())
DECLARE @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS	INT = 10
-- SET @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS = ISNULL( (SELECT Value FROM MMConfigs WITH (READUNCOMMITTED)  WHERE NAME = 'MMCONFIG_DASHCOPY_JOB_SKIP_CHUNK_ON_NONE_SOURCE_ERROR_INTERVAL_MINS'), 10)
SET @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS = ISNULL( (SELECT Value FROM MMConfigs WITH (READUNCOMMITTED)  WHERE NAME = 'MMCONFIG_AUXCOPY_RETRY_STREAM_INTERVAL_MINUTES'), 10)
DECLARE @MAX_FAILURE_COUNT INT = 3
    SELECT  TOP 1 @MAX_FAILURE_COUNT = ISNULL(value, 3)
    FROM    MMConfigs WITH (READUNCOMMITTED)
    WHERE   name = 'MMS2_CONFIG_AUXCOPY_STREAM_RETRY_COUNT'
DECLARE @RETRY_TIME_INTERVAL INT = 180 -- SECONDS
    SELECT  TOP 1 @RETRY_TIME_INTERVAL = ISNULL(value, 180)
    FROM    MMConfigs WITH (READUNCOMMITTED)
    WHERE   name = 'MMCONFIG_AUXCOPY_RETRY_STREAM_INTERVAL_MINUTES'
SET	@errorCode = 0
-- When this store procedure is invoked it is assumed that we dont have any running stream and we are not able to create new readers
-- If we have any chunks in sent state and reservation exist on dest copy then mark the rest of the chunks of that archive file as sent
DECLARE	@archFileToSkip TABLE (archFileId integer, commCellId integer, DestCopyId integer, minChunkNumber integer, backupJobId integer, segmentId integer, SrcStreamNum int, DestStreamNum int)
INSERT INTO @archFileToSkip
SELECT	archFileId, CommCellId, DestCopyId, MIN(chunkNumber), BackupJobId, MIN(SegmentId), MAX(SrcStreamNum), MAX(DestStreamNum)
FROM	archChunkToSF AR WITH (READUNCOMMITTED)
WHERE	AR.adminJobId = @i_AdminJobId
AND AR.Status = (1)
		AND EXISTS ( SELECT	*
						FROM	MMResource R WITH (READUNCOMMITTED) , MMResourceToJob RJ WITH (READUNCOMMITTED) , JMAdminJobInfoTable J WITH (READUNCOMMITTED)
						WHERE	R.CopyId = AR.DestCopyId
								AND R.ReservationId = RJ.ReservationId
								AND RJ.ReservationType = 2
								AND (RJ.InUse = 1 OR RJ.ReserveBitMask <> 0)
								AND J.jobId = RJ.JobId_l
								AND J.commCellId = 2)
GROUP BY archFileId, CommCellId, BackupJobId, DestCopyId
UPDATE	archChunkToSF
SET		Status = 5,
-- 		SkippedCount += 1,
-- 		SkippedForSeconds = (@SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS * 60),
-- 		SkippedReason = CVA_CHUNK_STATUS_UNKNOWN_ERROR,
-- 		ErrorCode = E_MM_DATA_REPLICATE_UNKNOWN_CHUNK_STATUS,
		Modified = @now,
		SrcStreamNum = S.SrcStreamNum,
		DestStreamNum = S.DestStreamNum
FROM	archChunkToSF R, @archFileToSkip S
WHERE	R.adminJobId = @i_AdminJobId
		--AND R.backupJobId = S.backupJobId
		AND R.archFileId = S.archFileId
		AND R.CommCellId = S.commCellId
		AND R.destCopyId = S.DestCopyId
AND Status IN (0)
-- When this store procedure is invoked it is assumed that we dont have any running stream and we are not able to create new readers
-- If we have any chunks in sent state and mp reservation exist on dest copy then mark the sent chunks as populated chunks
UPDATE	AR
SET		Status = 0
FROM	archChunkToSF AR,
		ArchChunkToSFArchFiles ASF  WITH (READUNCOMMITTED)
		LEFT OUTER JOIN @archFileToSkip S ON ASF.archFileId = S.archFileId AND ASF.commCellId = S.commCellId AND ASF.destCopyId = S.DestCopyId
WHERE	AR.adminJobId = @i_AdminJobId
AND AR.Status IN (1, 5)
		AND S.archFileId IS NULL
		AND AR.adminJobId = ASF.adminJobId
		AND AR.archFileId = ASF.archFileId
		AND AR.commCellId = ASF.commCellId
		AND AR.srcCopyId = ASF.srcCopyId
		AND (ASF.TotalItems > ASF.ProcessedItems AND ASF.ProcessedItems != -1)
DECLARE	@totalChunks INTEGER = 0
DECLARE	@totalProcessedChunks INTEGER = 0
DECLARE	@totalSentChunks INTEGER = 0
DECLARE	@totalSkippedChunks INTEGER = 0
DECLARE	@totalSkippedAgedChunks INTEGER = 0
DECLARE	@totalFailedChunks INTEGER = 0
DECLARE	@totalPopulatedChunks INTEGER = 0
SELECT	@totalChunks = COUNT(*),
@totalPopulatedChunks = ISNULL(SUM(CASE WHEN archChunkToSF.Status = 0 THEN  1 ELSE 0 END), 0),
@totalSentChunks = ISNULL(SUM(CASE WHEN archChunkToSF.Status = 1 THEN  1 ELSE 0 END), 0),
@totalProcessedChunks = ISNULL(SUM(CASE WHEN archChunkToSF.Status = 2 THEN  1 ELSE 0 END), 0),
@totalSkippedChunks = ISNULL(SUM(CASE WHEN archChunkToSF.Status = 3 THEN  1 ELSE 0 END), 0),
--		@totalSkippedChunks = ISNULL(SUM(CASE WHEN archChunkToSF.Status = 3 AND archChunkToSF.SkippedCount < @MAX_FAILURE_COUNT THEN  1 ELSE 0 END), 0),
--		@totalSkippedChunks = ISNULL(SUM(CASE WHEN ((archChunkToSF.Status = CVA_CHUNK_SKIPPED AND archChunkToSF.SkippedCount < @MAX_FAILURE_COUNT AND archChunkToSF.SkippedReason IN (CVA_READ_SOURCE_DATA_ERROR, CVA_AUXCOPY_SOURCE_MEDIA_ERROR))
--											OR  (archChunkToSF.Status = CVA_CHUNK_SKIPPED AND archChunkToSF.SkippedCount < 12 AND archChunkToSF.SkippedReason NOT IN (CVA_READ_SOURCE_DATA_ERROR, CVA_AUXCOPY_SOURCE_MEDIA_ERROR))) THEN  1 ELSE 0 END), 0),
@totalSkippedAgedChunks = ISNULL(SUM(CASE WHEN archChunkToSF.Status = 6 THEN  1 ELSE 0 END), 0),
@totalFailedChunks = ISNULL(SUM(CASE WHEN (archChunkToSF.Status = 4
OR archChunkToSF.Status = 5) THEN  1 ELSE 0 END), 0)
-- OR archChunkToSF.Status = 3 AND archChunkToSF.SkippedCount >= @MAX_FAILURE_COUNT) THEN  1 ELSE 0 END), 0)
											-- OR (archChunkToSF.SkippedCount >= @MAX_FAILURE_COUNT AND archChunkToSF.SkippedReason IN (CVA_READ_SOURCE_DATA_ERROR, CVA_AUXCOPY_SOURCE_MEDIA_ERROR))
											-- OR (archChunkToSF.SkippedCount >= 12 AND archChunkToSF.SkippedReason NOT IN (CVA_READ_SOURCE_DATA_ERROR, CVA_AUXCOPY_SOURCE_MEDIA_ERROR))) THEN  1 ELSE 0 END)
FROM	archChunkToSF WITH (READUNCOMMITTED)
WHERE	adminJobId = @i_AdminJobId
SELECT	@errorCode = @@ERROR
IF	@errorCode <> 0 GOTO ERR_EXIT
-- This function returns following four values
--	DASHCOPY_ARCHMGR_MORE_TO_COPY : We still have some chunks to be copied either in populated state or skipped state with skipped count < 3
--	DASHCOPY_ARCHMGR_JOB_SUCCESS: All chunks are processed
--	DASHCOPY_ARCHMGR_JOB_FAIL: All chunks are failed
--	DASHCOPY_ARCHMGR_JOB_CWE: All chunks are either processed, failed or skipped with skipped count >= 3
DECLARE @attempStartTime INTEGER = 0
DECLARE @dataProcessedInCurrentAttempt INTEGER = 0
DECLARE @totalFailedChunksCurrentAttempt INTEGER = 0
DECLARE @totalSkippedAgedChunksCurrentAttempt INTEGER = 0
SELECT	@attempStartTime = ISNULL(attemptStartTime, 0)
FROM	JMJobInfo WITH (READUNCOMMITTED)
WHERE	JobId = @i_AdminJobId
IF  (@attempStartTime != 0) AND (@i_includeAttemptState = 1)
BEGIN
	DECLARE @destCopyId INT = 0
	SELECT TOP 1 @destCopyID = destCopyId
	FROM	archChunkToSF WITH (READUNCOMMITTED)
	WHERE	adminJobId = @i_AdminJobId
	IF EXISTS ( SELECT  TOP 1 AC.id
			FROM	ArchChunk AC WITH (READUNCOMMITTED), archChunkMapping ACM WITH (READUNCOMMITTED)
			WHERE	ACM.jobId = @i_AdminJobId
					AND ACM.archCopyId = @destCopyID
					AND ACM.archChunkId = AC.id
					AND ACM.chunkCommCellId = AC.commCellId
					AND ACM.chunkNumber > 0
					AND AC.createTime >= @attempStartTime)
		SET @dataProcessedInCurrentAttempt = 1
SELECT  @totalSkippedAgedChunksCurrentAttempt = ISNULL( SUM(CASE WHEN archChunkToSF.Status = 6 THEN  1 ELSE 0 END), 0),
@totalFailedChunksCurrentAttempt = ISNULL( SUM(CASE WHEN (archChunkToSF.Status = 4
OR archChunkToSF.Status = 5) THEN  1 ELSE 0 END), 0)
-- OR archChunkToSF.Status = 3 AND archChunkToSF.SkippedCount >= @MAX_FAILURE_COUNT) THEN  1 ELSE 0 END), 0)
											-- OR (archChunkToSF.Status = CVA_CHUNK_SKIPPED AND archChunkToSF.SkippedCount >= @MAX_FAILURE_COUNT AND archChunkToSF.SkippedReason IN (CVA_READ_SOURCE_DATA_ERROR, CVA_AUXCOPY_SOURCE_MEDIA_ERROR))
											-- OR (archChunkToSF.Status = CVA_CHUNK_SKIPPED AND archChunkToSF.SkippedCount >= 12 AND archChunkToSF.SkippedReason NOT IN (CVA_READ_SOURCE_DATA_ERROR, CVA_AUXCOPY_SOURCE_MEDIA_ERROR))) THEN  1 ELSE 0 END), 0)
	FROM	archChunkToSF WITH (READUNCOMMITTED)
	WHERE	adminJobId = @i_AdminJobId
			AND Modified  >= @attempStartTime
	IF (@totalChunks = 0)
		SET @jobStatus = 5 --DASHCOPY_ARCHMGR_JOB_FAIL -- FAILED
	ELSE IF (@totalPopulatedChunks > 0 OR @totalSkippedChunks > 0 OR @totalSentChunks > 0 OR @totalSkippedAgedChunks > 0)
	BEGIN
		IF (@totalPopulatedChunks = 0 AND @totalSentChunks = 0)
		BEGIN
			IF  (@dataProcessedInCurrentAttempt = 1)
				SET @jobStatus = 11 --DASHCOPY_ARCHMGR_MORE_TO_COPY_PARTIAL_SUCCESS -- More to process
			ELSE
				SET @jobStatus = 12 --DASHCOPY_ARCHMGR_MORE_TO_COPY_FAILED -- More to process
		END
		ELSE
			SET @jobStatus = 3 --DASHCOPY_ARCHMGR_MORE_TO_COPY -- More to process
	END
	ELSE IF (@totalChunks = @totalProcessedChunks) OR (@dataProcessedInCurrentAttempt = 1 AND @totalSkippedAgedChunksCurrentAttempt = 0 AND @totalFailedChunksCurrentAttempt = 0)
		SET @jobStatus = 4 --DASHCOPY_ARCHMGR_JOB_SUCCESS -- SUCCESS
	ELSE
		SET @jobStatus = 5 --DASHCOPY_ARCHMGR_JOB_FAIL -- FAILED
	/*
	ELSE IF (@totalChunks = @totalFailedChunks) OR (@dataProcessedInCurrentAttempt = 0 AND @totalSkippedAgedChunksCurrentAttempt = 0 AND @totalFailedChunksCurrentAttempt > 0)
		SET @jobStatus = 5 --DASHCOPY_ARCHMGR_JOB_FAIL -- FAILED
	-- ELSE IF (@dataProcessedInCurrentAttempt = 0 AND @totalSkippedAgedChunksCurrentAttempt > 0 AND @totalFailedChunksCurrentAttempt = 0)
	--	SET @jobStatus = 9 --DASHCOPY_ARCHMGR_JOB_CWW -- CWW
	ELSE IF ( @dataProcessedInCurrentAttempt = 0)
			SET @jobStatus = 5 --DASHCOPY_ARCHMGR_JOB_FAIL -- FAILED
	ELSE
		SET @jobStatus = 6 --DASHCOPY_ARCHMGR_JOB_CWE -- PARTIALSUCCESS
	*/
END
ELSE
BEGIN
	IF (@totalChunks = 0)
		SET @jobStatus = 5 --DASHCOPY_ARCHMGR_JOB_FAIL -- FAILED
	ELSE IF (@totalPopulatedChunks > 0 OR @totalSkippedChunks > 0 OR @totalSentChunks > 0 OR @totalSkippedAgedChunks > 0)
	BEGIN
		IF (@i_includeAttemptState = 0 AND @totalPopulatedChunks = 0 AND @totalSentChunks = 0)
			SET @jobStatus = 10 --DASHCOPY_ARCHMGR_MORE_TO_COPY_ALL_SKIPPED
		ELSE
			SET @jobStatus = 3 --DASHCOPY_ARCHMGR_MORE_TO_COPY -- More to process
	END
	ELSE IF (@totalChunks = @totalProcessedChunks)
		SET @jobStatus = 4 --DASHCOPY_ARCHMGR_JOB_SUCCESS -- SUCCESS
	ELSE
		SET @jobStatus = 5 --DASHCOPY_ARCHMGR_JOB_FAIL -- FAILED
	/*
	ELSE IF (@totalChunks = @totalFailedChunks)
		SET @jobStatus = 5 --DASHCOPY_ARCHMGR_JOB_FAIL -- FAILED
	-- ELSE IF (@totalFailedChunks = 0 AND @totalSkippedChunks = 0 AND (@totalSkippedAgedChunks > 0))
	--	SET @jobStatus = 9 --DASHCOPY_ARCHMGR_JOB_CWW -- CWW
	ELSE
		SET @jobStatus = 6 --DASHCOPY_ARCHMGR_JOB_CWE -- PARTIALSUCCESS
	*/
END
/*
IF (@totalChunks = 0)
	SET @jobStatus = 5 --DASHCOPY_ARCHMGR_JOB_FAIL -- FAILED
ELSE IF (@totalPopulatedChunks > 0 OR @totalSkippedChunks > 0 OR @totalSentChunks > 0 OR @totalSkippedAgedChunks > 0)
	SET @jobStatus = 3 --DASHCOPY_ARCHMGR_MORE_TO_COPY -- More to process
ELSE IF (@totalChunks = @totalProcessedChunks)
	SET @jobStatus = 4 --DASHCOPY_ARCHMGR_JOB_SUCCESS -- SUCCESS
ELSE IF (@totalChunks = @totalFailedChunks)
	SET @jobStatus = 5 --DASHCOPY_ARCHMGR_JOB_FAIL -- FAILED
-- ELSE IF (@totalFailedChunks = 0 AND @totalSkippedAgedChunks > 0)
-- 	SET @jobStatus = 9 --DASHCOPY_ARCHMGR_JOB_CWW -- FAILED
ELSE
	SET @jobStatus = 6 --DASHCOPY_ARCHMGR_JOB_CWE -- PARTIALSUCCESS
*/
ERR_EXIT:
/*
IF ((@jobStatus = 6 /*DASHCOPY_ARCHMGR_JOB_CWE*/)
	AND NOT EXISTS
			(SELECT	TOP 1 JS.SrcMAId
			FROM	APP_AdvanceSettings A WITH (READUNCOMMITTED) ,
						(SELECT DISTINCT SrcMAId
						FROM	ArchJobStreamStatus WITH (READUNCOMMITTED)
						WHERE	JobID = @i_AdminJobId
						UNION
						SELECT	DISTINCT SrcMAId
						FROM	ArchJobStreamStatusHistory WITH (READUNCOMMITTED)
						WHERE	JobID = @i_AdminJobId) JS
			WHERE	JS.SrcMAId = A.entityId
					AND A.keyname = N'nIGNOREERRORSINSYNTHFULL'
					AND A.entityType = 3
					AND A.enabled = 1
					AND A.deleted = 0
					--AND A.value = N'1'
					AND CONVERT(int, CONVERT(VARCHAR(5), ISNULL(A.value,'0'))) != 0))
	SET @jobStatus = 5 --DASHCOPY_ARCHMGR_JOB_FAIL -- FAILED
*/
SELECT @errorCode, @jobStatus, @totalSkippedAgedChunks
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToSFGetJobStatus')
	delete from GxQscripts where name = 'archChunkToSFGetJobStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToSFGetJobStatus')
	delete from GXDBVersions where aliasname = 'archChunkToSFGetJobStatus'
GO

insert into GXDBVersions values(2, 'archChunkToSFGetJobStatus',  '00010003003400080000', 'archChunkToSFGetJobStatus', '00010003003400080000')
GO

