

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToSFCopyProperties.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToSFCopyProperties.sp,v $ $Id: archChunkToSFCopyProperties.sp,v 1.1.42.5 2018/12/05 07:02:44 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archChunkToSFCopyProperties')
BEGIN
	print '>>> Drop Stored Procedure: archChunkToSFCopyProperties <<<'
	drop procedure archChunkToSFCopyProperties
END
IF EXISTS (select * from GxQscripts where name='archChunkToSFCopyProperties')
	delete from GxQscripts where name = 'archChunkToSFCopyProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToSFCopyProperties')
	delete from GXDBVersions where aliasname = 'archChunkToSFCopyProperties'
GO
print '... Creating Procedure: archChunkToSFCopyProperties'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archChunkToSFCopyProperties
  @i_JobId integer
AS
  DECLARE @errorCode integer;	-- newly added for error code.
  DECLARE @id integer; -- -- copy id
  DECLARE @policyName VARCHAR(1024);
  DECLARE @copyName VARCHAR(1024);
  DECLARE @archGroupId integer;
  DECLARE @destCopyId integer;
  DECLARE @copyStartTime integer;
  DECLARE @copyType integer;
  DECLARE @spFlags integer;
  DECLARE @copyFlags integer;
  DECLARE @copyFlagsExt integer;
  DECLARE @copyLevel integer;
  DECLARE @deferredDays integer;
--:DECLARE--  startReadTime integer;
  DECLARE @markCopiedTime integer;
  DECLARE @maxMultiplex integer;
  DECLARE @dedupeFlags integer;
  DECLARE @encType integer;
  DECLARE @encKeyLen integer;
  DECLARE @isSnapCopy integer;
  DECLARE @isMirrorCopy integer;
  DECLARE @isNasCopy integer;
  DECLARE @isActive integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
--#define  MAX_DEFAULT_REC_SIZE              64
--#define CVA_SIDB_STORE_ENABLED_FLAG        262144
--#define CVA_BACKUP_SILO_ENABLED_FLAG		2097152
DECLARE @m_iPrimaryCopyId INTEGER = 0
DECLARE @m_iPrimarySnapCopyId	  INTEGER = 0
DECLARE @isCopyActive INTEGER = 0
--- Start Code
IF object_id('tempdb.dbo.#archGroupCopyTemp') IS NOT null DROP TABLE #archGroupCopyTemp
-- Define errocodes for time being HERE. Need to put them into some header.
-- success 0
-- copy not active 1
-- copy does not exists 2
-- snapcopy auxcopy can't be run 3
-- no secondary copy for sp      4
-- These are defined in AuxCopyDefs.h
-- /* getJonParameters sp return codes. */
--#define CVA_AUXCOPY_COPY_NOT_ACTIVE						1
--#define CVA_AUXCOPY_POLICY_COPY_NOT_EXISTS						2
--#define CVA_AUXCOPY_AUXCOPY_NOT_RUN_DUETO_SNAP			3
--#define CVA_AUXCOPY_NO_SECONDARY_COPY						4
-- We need to get copy properties in an map.
-- Given copyid, we need to get its poperties and its srcopy properties.
-- If the copy id is 0 then we need to get all copy propertie except snapcopies.
-- remove the unneccessary fields in #archGroupCopyTemp
CREATE TABLE #archGroupCopyTemp
	(
	errorCode			integer, -- newly added for error code.
	id					integer, -- copy id
    policyName VARCHAR(1024),
    copyName VARCHAR(1024),
    archGroupId integer,
    destCopyId integer,
    copyStartTime integer,
    copyType integer,
    spFlags integer,
    copyFlags integer,
    copyFlagsExt integer,
    copyLevel integer,
    deferredDays integer,
--  startReadTime integer;
    markCopiedTime integer,
    maxMultiplex integer,
    dedupeFlags integer,
    encType integer,
    encKeyLen integer,
    isSnapCopy integer,
    isMirrorCopy integer,
    isNasCopy integer,
    isActive integer
	);;
INSERT INTO #archGroupCopyTemp
SELECT 0, AGC.id,
AG.name, AGC.name,AG.id,
T.DestCopyId,
AGC.startTime, AGC.type, AG.flags /*spFlags*/, AGC.flags, AGC.extendedFlags,
--1 /* copyLevel*/,
CASE
		WHEN AGC.id = AG.defaultCopy OR AGC.id = AG.defaultSnapCopy THEN -1 ELSE 1 END,
0 /* defered days */, 0 /* markCopiedTime */,
CASE WHEN (((AGC.dedupeFlags & (262144 | 2097152)) = 262144)) THEN 1 ELSE AGC.maxMultiplex END,
AGC.dedupeFlags, AGC.encType, AGC.encKeyLen, AGC.isSnapCopy,
AGC.isMirrorCopy,
0, /* isNasCopy */ -- need to update after this
AGC.isActive
FROM archGroupCopy AGC, archGroup AG, (SELECT DISTINCT archGroupId, DestCopyId FROM ArchChunktosfarchfiles, archGroupCopy  WHERE adminJobId = @i_JobId AND SrcCopyId = id) T
WHERE AGC.archGroupId = T.archGroupId AND AG.id = AGC.archGroupId
-- Find whether copy is nasCopy. If it is a nasCopy set the flag isNasCopy to true.
UPDATE #archGroupCopyTemp SET isNasCopy = 1
FROM #archGroupCopyTemp AGCT
	JOIN archGroupCopy AGC ON AGCT.id = AGC.id
	JOIN MMDataPath MMD ON MMD.CopyId = AGCT.id
	JOIN MMDrivePool MMDP ON MMDP.DrivePoolId = MMD.DrivePoolId
WHERE MMDP.DrivePoolType = 3 --3
-- order by errorCode so that caller can check error first.
SELECT *
FROM #archGroupCopyTemp
ORDER BY errorCode
GO
-- End code

IF EXISTS (select * from GxQscripts where name = 'archChunkToSFCopyProperties')
	delete from GxQscripts where name = 'archChunkToSFCopyProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToSFCopyProperties')
	delete from GXDBVersions where aliasname = 'archChunkToSFCopyProperties'
GO

insert into GXDBVersions values(2, 'archChunkToSFCopyProperties',  '00010001004200050000', 'archChunkToSFCopyProperties', '00010001004200050000')
GO

