

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToSFArchFilesUpdateStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToSFArchFilesUpdateStatus.sp,v $ $Id: archChunkToSFArchFilesUpdateStatus.sp,v 1.1.42.2 2017/02/10 21:16:17 sjohnson Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archChunkToSFArchFilesUpdateStatus <<<'

IF EXISTS (select * from sysobjects where name='archChunkToSFArchFilesUpdateStatus')
	drop procedure archChunkToSFArchFilesUpdateStatus
IF EXISTS (select * from GxQscripts where name='archChunkToSFArchFilesUpdateStatus')
	delete from GxQscripts where name = 'archChunkToSFArchFilesUpdateStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToSFArchFilesUpdateStatus')
	delete from GXDBVersions where aliasname = 'archChunkToSFArchFilesUpdateStatus'
GO
print '... Creating Procedure: archChunkToSFArchFilesUpdateStatus'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archChunkToSFArchFilesUpdateStatus
  @i_AdminJobId integer,
  @i_afsStatusStr VARCHAR(MAX)
AS
  DECLARE @errorCode integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @now INTEGER;
SET		@now = dbo.GetUnixTime(GetUTCDate())
SET	@errorCode = 0
DECLARE @archFileProcessed TABLE (archFileId INTEGER, commCellId INTEGER, ProcessedItems BIGINT)
DECLARE @afStatusStr VARCHAR(256)
DECLARE @afId INTEGER
DECLARE @ccId INTEGER
DECLARE @processedItems BIGINT
SET @i_afsStatusStr = REPLACE(@i_afsStatusStr, ' ', '')
SET @i_afsStatusStr = REPLACE(@i_afsStatusStr, '-o', '')
DECLARE afCursor CURSOR FOR
	SELECT _ID
	FROM dbo.SplitStringByDelimiter(@i_afsStatusStr, '@')
OPEN afCursor
FETCH NEXT FROM afCursor INTO @afStatusStr
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @afId = SUBSTRING(@afStatusStr, 0, PATINDEX('%-%', @afStatusStr))
	SET	@afStatusStr = SUBSTRING(@afStatusStr, LEN(CAST(@afId AS VARCHAR(20)) + '-') + 1,LEN(@afStatusStr))
	SET @ccId = SUBSTRING(@afStatusStr, 0, PATINDEX('%|%', @afStatusStr))
	SET	@processedItems = SUBSTRING(@afStatusStr, LEN(CAST(@ccId AS VARCHAR(20)) + '|') + 1, LEN(@afStatusStr))
	INSERT INTO @archFileProcessed
	SELECT @afId, @ccId, @processedItems
	FETCH NEXT FROM afCursor INTO @afStatusStr
END
CLOSE afCursor
DEALLOCATE afCursor
UPDATE	AF
SET		ProcessedItems = (CASE WHEN (AF.TotalItems = P.ProcessedItems) THEN -1 ELSE P.ProcessedItems END)
FROM	ArchChunkToSFArchFiles AF, @archFileProcessed P
WHERE	AF.AdminJobId = @i_AdminJobId
		AND AF.ArchFileId = P.archFileId
		AND AF.CommCellId = P.commCellId
SELECT	@errorCode = @@ERROR
IF	@errorCode <> 0 GOTO ERR_EXIT
UPDATE	SF
SET		status = 2, Modified = @now
FROM	ArchChunkToSF SF, @archFileProcessed P, ArchChunkToSFArchFiles ASF
WHERE	SF.AdminJobId = @i_AdminJobId
		AND SF.ArchFileId = P.archFileId
		AND SF.CommCellId = P.commCellId
AND SF.Status <> 2
		AND SF.AdminJobId = ASF.AdminJobId
		AND SF.archFileId = ASF.archFileId
		AND SF.CommCellId = ASF.CommCellId
		AND SF.SrcCopyId = ASF.SrcCopyId
		AND (ASF.TotalItems <= ASF.ProcessedItems OR ASF.ProcessedItems = -1)
SELECT	@errorCode = @@ERROR
IF	@errorCode <> 0 GOTO ERR_EXIT
ERR_EXIT:
SELECT @errorCode
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToSFArchFilesUpdateStatus')
	delete from GxQscripts where name = 'archChunkToSFArchFilesUpdateStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToSFArchFilesUpdateStatus')
	delete from GXDBVersions where aliasname = 'archChunkToSFArchFilesUpdateStatus'
GO

insert into GXDBVersions values(2, 'archChunkToSFArchFilesUpdateStatus',  '00010001004200020000', 'archChunkToSFArchFilesUpdateStatus', '00010001004200020000')
GO

