

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToReplicateUpdateStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToReplicateUpdateStatus.sp,v $ $Id: archChunkToReplicateUpdateStatus.sp,v 1.4.54.3 2019/05/09 20:17:15 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archChunkToReplicateUpdateStatus')
BEGIN
	print '>>> Drop Stored Procedure: archChunkToReplicateUpdateStatus <<<'
	drop procedure archChunkToReplicateUpdateStatus
END
IF EXISTS (select * from GxQscripts where name='archChunkToReplicateUpdateStatus')
	delete from GxQscripts where name = 'archChunkToReplicateUpdateStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToReplicateUpdateStatus')
	delete from GXDBVersions where aliasname = 'archChunkToReplicateUpdateStatus'
GO
print '... Creating Procedure: archChunkToReplicateUpdateStatus'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archChunkToReplicateUpdateStatus
  @i_AuxCopyJobId integer
AS
  DECLARE @errorCode integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @now INTEGER;
SET		@now = dbo.GetUnixTime(GetUTCDate())
SET	@errorCode = 0
IF @i_AuxCopyJobId > 0
BEGIN
	-- For the job @i_jobId in JMAdminJobInfoTable, find the chunks on all destination copies in ArchChunkToReplicate
	-- with the corresponding destinationcopy/archFilesIds in archFilecopy.
	-- And update the status of the chunk to CVA_CHUNK_PROCESSED if the physical size of the archFile is > the chunk's physicalOffset+physcialsize.
	DELETE	R
	OUTPUT  DELETED.AdminJobId,DELETED.BackupJobId,DELETED.ArchFileId,DELETED.CommCellId,DELETED.ArchChunkId,DELETED.ChunkCommCellId,DELETED.ChunkNumber,
			DELETED.SrcCopyId,DELETED.SrcStreamNum,DELETED.DestCopyId,DELETED.DestStreamNum,
			DELETED.PhysicalStartOffset,DELETED.PhysicalOffset,DELETED.LogicalOffset,DELETED.PhysicalSize,DELETED.LogicalSize,DELETED.unCompBytesSize,DELETED.SrcMAId,
2,DELETED.Modified,DELETED.SkippedReason,DELETED.SkippedCount,DELETED.SkippedForSeconds,DELETED.ErrorCode,
			DELETED.extraFlags,DELETED.segmentId ,DELETED.IsParallelCopy,@now,DELETED.streamReaderID
			INTO HistoryDB..ArchChunkToReplicateHistory
	FROM	archChunkToReplicate R, archFileCopy AFC
	WHERE	R.adminJobId = @i_AuxCopyJobId
			AND R.archFileId = AFC.archFileId
			AND R.CommCellId = AFC.CommCellId
			AND R.DestCopyId = AFC.archCopyId
AND (((R.extraFlags & 4) > 0 AND (R.LogicalOffset + R.LogicalSize) <= AFC.LogicalSize) OR ((R.extraFlags & 4) = 0 AND (R.PhysicalOffset + R.PhysicalSize) <= AFC.PhysicalSize))
AND R.Status NOT IN (2,9)
END
ELSE
BEGIN
	-- If @i_jobId is non zero, do for all running jobs in JMAdminJobInfoTable
	-- For the running jobs in JMAdminJobInfoTable, find the chunks on all destination copies in ArchChunkToReplicate
	-- with the corresponding destinationcopy/archFilesIds in archFilecopy.
	-- And update the status of the chunk to CVA_CHUNK_PROCESSED if the physical size of the archFile is > the chunk's physicalOffset+physcialsize.
	DELETE	R
	OUTPUT  DELETED.AdminJobId,DELETED.BackupJobId,DELETED.ArchFileId,DELETED.CommCellId,DELETED.ArchChunkId,DELETED.ChunkCommCellId,DELETED.ChunkNumber,
			DELETED.SrcCopyId,DELETED.SrcStreamNum,DELETED.DestCopyId,DELETED.DestStreamNum,
			DELETED.PhysicalStartOffset,DELETED.PhysicalOffset,DELETED.LogicalOffset,DELETED.PhysicalSize,DELETED.LogicalSize,DELETED.unCompBytesSize,DELETED.SrcMAId,
2,DELETED.Modified,DELETED.SkippedReason,DELETED.SkippedCount,DELETED.SkippedForSeconds,DELETED.ErrorCode,
			DELETED.extraFlags,DELETED.segmentId ,DELETED.IsParallelCopy,@now,DELETED.streamReaderID
			INTO HistoryDB..ArchChunkToReplicateHistory
	FROM	archChunkToReplicate R, JMAdminJobInfoTable JMA, archFileCopy AFC
	WHERE	R.adminJobId = JMA.JobId
			AND R.archFileId = AFC.archFileId
			AND R.CommCellId = AFC.CommCellId
			AND R.DestCopyId = AFC.archCopyId
AND (((R.extraFlags & 4) > 0 AND (R.LogicalOffset + R.LogicalSize) <= AFC.LogicalSize) OR ((R.extraFlags & 4) = 0 AND (R.PhysicalOffset + R.PhysicalSize) <= AFC.PhysicalSize))
AND R.Status NOT IN (2,9)
END
SELECT @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToReplicateUpdateStatus')
	delete from GxQscripts where name = 'archChunkToReplicateUpdateStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToReplicateUpdateStatus')
	delete from GXDBVersions where aliasname = 'archChunkToReplicateUpdateStatus'
GO

insert into GXDBVersions values(2, 'archChunkToReplicateUpdateStatus',  '00010004005400030000', 'archChunkToReplicateUpdateStatus', '00010004005400030000')
GO

