

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToReplicateSegment.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToReplicateSegment.sp,v $ $Id: archChunkToReplicateSegment.sp,v 1.6.2.8 2018/09/23 00:30:40 chandru Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archChunkToReplicateSegment <<<'

IF EXISTS (select * from sysobjects where name='archChunkToReplicateSegment')
	drop procedure archChunkToReplicateSegment
IF EXISTS (select * from GxQscripts where name='archChunkToReplicateSegment')
	delete from GxQscripts where name = 'archChunkToReplicateSegment'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToReplicateSegment')
	delete from GXDBVersions where aliasname = 'archChunkToReplicateSegment'
GO
print '... Creating Procedure: archChunkToReplicateSegment'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archChunkToReplicateSegment
  @i_adminJobId int,
  @i_destCopyId int,
  @i_minSegmentGB bigint
AS
  DECLARE @o_error integer;
  DECLARE @o_errorString varchar(1024);
  DECLARE @o_lastSegmentId integer;
SET NOCOUNT ON
BEGIN TRAN archChunkToReplicateSegment_tran
	IF object_id('tempdb.dbo.#tblChunkToReplicate') IS NOT NULL DROP TABLE #tblChunkToReplicate
	IF object_id('tempdb.dbo.#tblChunkInSegment') IS NOT NULL DROP TABLE #tblChunkInSegment
		create table #tblChunkToReplicate (
		id					integer IDENTITY (1,1),
		SrcCopyId			integer,
		archChunkId			bigint,
		ChunkCommCellId		integer,
		archFileId			integer,
		commCellId			integer,
		mediaGroupId		integer,
		destStreamNum		integer,
		destSIDBStoreId		integer,
		physicalSize		bigint,
		segmentID			integer,
		primary key (id)
	)
	create index ChunkToCopy_temp_idx_1 on #tblChunkToReplicate (archFileId, commCellId)
	create index ChunkToCopy_temp_idx_2 on #tblChunkToReplicate (archChunkId, ChunkCommCellId)
	create table #tblChunkInSegment (
		id					integer,
		SrcCopyId			integer,
		archChunkId			bigint,
		ChunkCommCellId		integer,
		archFileId			integer,
		commCellId			integer,
		mediaGroupId		integer,
		destStreamNum		integer,
		destSIDBStoreId		integer,
		physicalSize		bigint,
		segmentID			integer,
		primary key (id)
	)
	create index ChunkInSegment_temp_idx_1 on #tblChunkInSegment (archFileId, commCellId)
	create index ChunkInSegment_temp_idx_2 on #tblChunkInSegment (archChunkId, ChunkCommCellId)
	DECLARE	@isRepopulateSegmentNeeded INTEGER = 0
	IF EXISTS ( SELECT 1
			FROM ArchJobStreamStatus AJ WITH (NOLOCK), JMJobStreams JS WITH (NOLOCK)
			WHERE AJ.DestRCId = JS.destRcId
			AND AJ.DestReservationId = JS.destReservationId
			AND AJ.Status IN ( 1,2) AND JS.status = 1)
		AND EXISTS ( SELECT 1 FROM MMConfigs WITH (NOLOCK)
					WHERE name = 'MMS2_CONFIG_AUXCOPY_PICK_NEW_BACKUP_DATA'
					AND value > 0 )
		SET @isRepopulateSegmentNeeded = 1
	IF @isRepopulateSegmentNeeded = 1
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#tblChunkToReplicateRepopulateSegment') IS NOT NULL DROP TABLE #tblChunkToReplicateRepopulateSegment
		SELECT * INTO #tblChunkToReplicateRepopulateSegment
		FROM archChunkToReplicate WITH (NOLOCK)
		WHERE destCopyId = @i_destCopyId
		AND adminJobId = @i_adminJobId
		AND segmentId = 0
	END
	DECLARE	@cursor	INTEGER
	DECLARE	@errVal	INTEGER
	DECLARE	@errStr	VARCHAR(1024)
	DECLARE @segmentId	INTEGER
	DECLARE	@isSnapCopy INTEGER
	SET @segmentId = 0
	SET @errVal = 0
	SET @errStr = 'NO ERROR'
	SET @cursor = 0
	SET	@isSnapCopy = 0
	SELECT @isSnapCopy = isSnapCopy  FROM ArchGroupCopy WITH (NOLOCK) WHERE id = @i_destCopyId AND isSnapCopy = 1
	-- If DSA flag is not set on the copy, set segment as the source copy archstream
	-- Do not support dynamic stream allocation for snap copy
	IF (@isSnapCopy = 1)
		OR EXISTS (SELECT * FROM ArchGroup sp WITH (NOLOCK), ArchGroupCopy copy WITH (NOLOCK)
				WHERE copy.Id = @i_destCopyId
				AND		copy.ArchGroupId = sp.Id
AND		(sp.flags & 131072/*CVA_SP_DYNAMIC_STREAM_ALLOCATION_FLAG*/) = 0)
	BEGIN
		UPDATE	A
		SET	segmentId = B.segmentId
		FROM	ArchChunkToReplicate A, archChunkToReplicate B
		WHERE	A.adminJobId = @i_adminJobId
				AND A.destCopyId = @i_destCopyId
				AND A.IsParallelCopy = 1
				AND A.adminJobId = B.adminJobId
				AND A.archChunkId = B.archChunkId
				AND A.chunkCommCellId = B.chunkCommCellId
				AND A.archFileId = B.archFileId
				AND A.commCellId = B.commCellId
				AND A.SrcCopyId = B.SrcCopyId
				AND B.IsParallelCopy = 1
				AND A.segmentId = 0
				AND B.segmentId != 0
		INSERT INTO archChunkToReplicateSegmentTable (DestCopyId, ArchCopyId, MediaGroupId, DestMediaGroupId, destSIDBStoreId)
		SELECT	T.DestCopyId, T.SrcCopyId, T.MediaGroupId, T.DestMediaGroupId, T.destSIDBStoreId
		FROM	(SELECT DISTINCT A.DestCopyId, A.SrcCopyId, A.MediaGroupId, D.MediaGroupId AS DestMediaGroupId, A.destSIDBStoreId
				FROM ArchChunkToReplicate a WITH (NOLOCK), archStream D
				WHERE a.adminJobId = @i_adminJobId
				AND a.destCopyId = @i_destCopyId
				AND a.segmentId = 0
				AND A.destCopyId = D.archGroupCopyId
				AND A.DestStreamNum = D.stream
				AND (@isSnapCopy = 0 OR A.DestStreamNum = 1)) T LEFT OUTER JOIN archChunkToReplicateSegmentTable S
					ON	T.DestCopyId = S.DestCopyid
						AND T.SrcCopyId = S.ArchCopyId
						AND T.MediaGroupId = S.MediaGroupId
						AND T.DestMediaGroupId = S.DestMediaGroupId
						AND T.destSIDBStoreId = S.destSIDBStoreId
		WHERE	S.DestCopyId IS NULL
		INSERT INTO archChunkToReplicateSegmentTable (DestCopyId, ArchCopyId, MediaGroupId, DestMediaGroupId)
		SELECT	T.DestCopyId, T.SrcCopyId, T.MediaGroupId, T.DestMediaGroupId
		FROM	(SELECT DISTINCT A.DestCopyId, A.SrcCopyId, A.MediaGroupId, A.MediaGroupId AS DestMediaGroupId
				FROM ArchChunkToReplicate a WITH (NOLOCK)
				WHERE a.adminJobId = @i_adminJobId
				AND a.destCopyId = @i_destCopyId
				AND a.segmentId = 0
				AND @isSnapCopy = 1
				AND A.DestStreamNum > 1) T LEFT OUTER JOIN archChunkToReplicateSegmentTable S
					ON	T.DestCopyId = S.DestCopyid
						AND T.SrcCopyId = S.ArchCopyId
						AND T.MediaGroupId = S.MediaGroupId
						AND T.DestMediaGroupId = S.DestMediaGroupId
		WHERE	S.DestCopyId IS NULL
		UPDATE ArchChunkToReplicate
		SET	segmentId = S.SegmentId
		FROM ArchChunkToReplicate a, archStream ST, archChunkToReplicateSegmentTable S
		WHERE a.adminJobId = @i_adminJobId
		AND a.destCopyId = @i_destCopyId
		AND a.segmentId = 0
		AND A.destCopyId = ST.archGroupCopyId
		AND A.DestStreamNum = ST.stream
		AND S.ArchCopyId = A.SrcCopyId
		AND S.MediaGroupId = A.MediaGroupId
		AND S.DestMediaGroupId = ST.MediaGroupId
		AND S.DestCopyId = ST.archGroupCopyId
		AND A.destSIDBStoreId = S.destSIDBStoreId
		AND (@isSnapCopy = 0 OR A.DestStreamNum = 1)
		UPDATE ArchChunkToReplicate
		SET	segmentId = S.SegmentId
		FROM ArchChunkToReplicate a, archChunkToReplicateSegmentTable S
		WHERE a.adminJobId = @i_adminJobId
		AND a.destCopyId = @i_destCopyId
		AND a.segmentId = 0
		AND S.ArchCopyId = A.SrcCopyId
		AND S.MediaGroupId = A.MediaGroupId
		AND S.DestMediaGroupId = A.MediaGroupId
		AND S.DestCopyId = A.DestCopyId
		AND @isSnapCopy = 1
		AND A.DestStreamNum > 1
		SELECT	@segmentId = MAX(segmentId)
		FROM	ArchChunkToReplicate a
		WHERE	a.adminJobId = @i_adminJobId
				AND a.destCopyId = @i_destCopyId
		GOTO CX_EXIT
	END
	UPDATE	A
	SET	segmentId = B.segmentId, SrcStreamNum = B.SrcStreamNum, DestStreamNum = B.DestStreamNum
	FROM	ArchChunkToReplicate A INNER JOIN ArchFileCopy AFC WITH (NOLOCK)
				ON	A.archFileId = AFC.archFileId
					AND A.commCellId = AFC.commCellId
					AND AFC.archCopyId = @i_destCopyId
AND AFC.flags & 2048 = 0
					and AFC.lastChunkNumber = 0 AND AFC.physicalSize = 0
			, archChunkToReplicate B
	WHERE	A.adminJobId = @i_adminJobId
			AND A.destCopyId = @i_destCopyId
			AND A.IsParallelCopy = 1
			AND A.adminJobId = B.adminJobId
			AND A.archChunkId = B.archChunkId
			AND A.chunkCommCellId = B.chunkCommCellId
			AND A.archFileId = B.archFileId
			AND A.commCellId = B.commCellId
			AND A.SrcCopyId = B.SrcCopyId
			AND B.IsParallelCopy = 1
			AND A.segmentId = 0
			AND B.segmentId != 0
	IF @i_minSegmentGB = 0
		SET @i_minSegmentGB = 2
	DECLARE @multiplex         INTEGER = 0
    if exists (
            select destCopyId, archChunkId
            from ArchChunkToReplicate with (NOLock)
            where destCopyId = @i_destCopyId AND adminJobId = @i_adminJobId
            group by destCopyId, archChunkId having count(archFileId) > 1
            )
    SET @multiplex = 1
	INSERT INTO #tblChunkToReplicate
	SELECT a.SrcCopyId, a.archChunkId, a.ChunkCommCellId, a.archFileId, a.commCellId, a.mediaGroupId, a.destStreamNum, 0, a.physicalSize, 0
	FROM ArchChunkToReplicate a WITH (NOLOCK)
	WHERE a.adminJobId = @i_adminJobId
	AND a.destCopyId = @i_destCopyId
	AND a.mediaType != 10001
	AND a.segmentId = 0
	-- For tape copy source ignore DSA
	IF EXISTS (SELECT * FROM #tblChunkToReplicate)
	BEGIN
		INSERT INTO archChunkToReplicateSegmentTable (DestCopyId, ArchCopyId, MediaGroupId, DestMediaGroupId)
		SELECT	T.DestCopyId, T.SrcCopyId, T.MediaGroupId, T.DestMediaGroupId
		FROM	(SELECT DISTINCT A.DestCopyId, A.SrcCopyId, A.MediaGroupId, D.MediaGroupId AS DestMediaGroupId
				FROM ArchChunkToReplicate a WITH (NOLOCK), archStream D, #tblChunkToReplicate T
				WHERE a.adminJobId = @i_adminJobId
				AND a.destCopyId = @i_destCopyId
				AND a.segmentId = 0
				AND A.destCopyId = D.archGroupCopyId
				AND A.DestStreamNum = D.stream
				AND A.archChunkId = T.archChunkId
				AND A.chunkCommCellId = T.chunkCommCellid
				AND A.archFileId = T.archFileId
				AND A.commCellId = T.commCellId	) T LEFT OUTER JOIN archChunkToReplicateSegmentTable S
					ON	T.DestCopyId = S.DestCopyid
						AND T.SrcCopyId = S.ArchCopyId
						AND T.MediaGroupId = S.MediaGroupId
						AND T.DestMediaGroupId = S.DestMediaGroupId
		WHERE	S.DestCopyId IS NULL
		UPDATE ArchChunkToReplicate
		SET	segmentId = S.SegmentId
		FROM ArchChunkToReplicate a, archStream ST, archChunkToReplicateSegmentTable S
		WHERE a.adminJobId = @i_adminJobId
		AND a.destCopyId = @i_destCopyId
		AND a.segmentId = 0
		AND A.destCopyId = ST.archGroupCopyId
		AND A.DestStreamNum = ST.stream
		AND S.ArchCopyId = A.SrcCopyId
		AND S.MediaGroupId = A.MediaGroupId
		AND S.DestMediaGroupId = ST.MediaGroupId
		AND S.DestCopyId = ST.archGroupCopyId
		SELECT	@segmentId = MAX(segmentId)
		FROM	ArchChunkToReplicate a
		WHERE	a.adminJobId = @i_adminJobId
				AND a.destCopyId = @i_destCopyId
	END
	DELETE FROM #tblChunkToReplicate
	INSERT INTO #tblChunkToReplicate
	SELECT a.SrcCopyId, a.archChunkId, a.ChunkCommCellId, a.archFileId, a.commCellId, a.mediaGroupId, a.destStreamNum, a.destSIDBStoreId, a.physicalSize, 0
	FROM ArchChunkToReplicate a WITH (NOLOCK)
	WHERE a.adminJobId = @i_adminJobId
	AND a.destCopyId = @i_destCopyId
	AND a.mediaType = 10001
	AND a.segmentId = 0
	IF @@ROWCOUNT = 0
		GOTO CX_EXIT
	UPDATE #tblChunkToReplicate
	SET destStreamNum = 0
	FROM #tblChunkToReplicate a, ArchFileCopy b WITH (NOLOCK)
	WHERE a.archFileId = b.archFileId
	AND a.commCellId = b.commCellId
	AND b.archCopyId = @i_destCopyId
AND b.flags & 2048 = 0
	and b.lastChunkNumber = 0 AND b.physicalSize = 0
	-- Clear source stream and media group info
	UPDATE ArchChunkToReplicate
	SET SrcStreamNum = 0, destStreamNum = b.destStreamNum
	FROM ArchChunkToReplicate a, #tblChunkToReplicate b
	WHERE  a.adminJobId = @i_adminJobId
	AND a.archChunkId = b.archChunkId
	AND a.ChunkCommCellId = b.ChunkCommCellId
	AND a.archFileId = b.archFileId
	AND a.commCellId = b.commCellId
	AND a.destCopyId = @i_destCopyId
	AND a.SrcCopyId = b.SrcCopyId
	SELECT @errVal = @@ERROR
	IF @errVal <> 0
	BEGIN
			SET @errStr = 'Failed to clear streams for ArchChunkToReplicate: DB error!'
			GOTO CX_EXIT_ERROR
	END
	DECLARE @archFileId		INTEGER
	DECLARE @commCellId		INTEGER
	DECLARE @SrcCopyId		INTEGER
	DECLARE @mediaGroupId	INTEGER
	DECLARE @destStreamNum		INTEGER
	DECLARE @destSIDBStoreId	INTEGER
	DECLARE @maxDestStreamNum	INTEGER
	DECLARE @mediaGroupId_prev INTEGER
	SET @mediaGroupId_prev = -1
	DECLARE @destStream_prev INTEGER
	SET @destStream_prev = -1
	DECLARE @destSIDBStoreId_prev INTEGER
	SET	@destSIDBStoreId_prev = -1
	DECLARE AFCursor CURSOR FOR
			SELECT DISTINCT SrcCopyId, archFileId, commCellId, mediaGroupId, destStreamNum, destSIDBStoreId
			FROM #tblChunkToReplicate
			ORDER BY SrcCopyId, mediaGroupId, commCellId, archFileId
	OPEN AFCursor
	SET @cursor = 1
	FETCH NEXT from AFCursor INTO @SrcCopyId, @archFileId, @commCellId, @mediaGroupId, @destStreamNum, @destSIDBStoreId
	WHILE (1 = 1)
	BEGIN
		DECLARE @fetchNext INTEGER
		SET @fetchNext = 1
		IF @@FETCH_STATUS <> 0
			GOTO CREATE_SEGMENT
		IF EXISTS (select * from #tblChunkToReplicate WITH (NOLOCK)
					where archFileId = @archFileId
					and commCellId = @commCellId
					and SrcCopyId = @SrcCopyId
					and segmentId > 0
					--AND status = CVA_CHUNK_POPULATED
					)
			GOTO FETCH_NEXT
		IF @mediaGroupId_prev < 0
			SET @mediaGroupId_prev = @mediaGroupId
		IF @destStream_prev < 0
			SET @destStream_prev = @destStreamNum
		IF @destSIDBStoreId_prev < 0
			SET @destSIDBStoreId_prev = @destSIDBStoreId
		IF @mediaGroupId_prev <> @mediaGroupId
		BEGIN
			-- MediaGroupId changed, needs to group previous chunks
			-- This archive file will be processed again
			SET @mediaGroupId_prev = @mediaGroupId
			SET @fetchNext = 0
			GOTO CREATE_SEGMENT
		END
		IF @destStream_prev <> @destStreamNum
		BEGIN
			-- destStreamNum changed, needs to group previous chunks
			-- This archive file will be processed again
			SET @destStream_prev = @destStreamNum
			SET @fetchNext = 0
			GOTO CREATE_SEGMENT
		END
		IF @destSIDBStoreId_prev <> @destSIDBStoreId
		BEGIN
			-- destSIDBStoreId changed, needs to group previous chunks
			-- This archive file will be processed again
			SET @destSIDBStoreId_prev = @destSIDBStoreId
			SET @fetchNext = 0
			GOTO CREATE_SEGMENT
		END
		-- Set flag for all chunks of given archive file
		INSERT INTO #tblChunkInSegment
		SELECT a.*
		FROM #tblChunkToReplicate a LEFT OUTER JOIN #tblChunkInSegment b ON a.id = b.id
		WHERE a.archFileId = @archFileId
		AND a.commCellId = @commCellId
		AND b.id IS NULL
		-- No new chunks of this archive file found
		IF @@ROWCOUNT = 0
			GOTO FETCH_NEXT
		WHILE (1 = 1)
		BEGIN
			DECLARE @sumSegmentSize bigint = 0
			DECLARE @numChunks integer = 0
			IF @multiplex > 0
            BEGIN
				-- Get linked chunks through multiplexing
				INSERT INTO #tblChunkInSegment
				SELECT DISTINCT b.*
				FROM #tblChunkInSegment a right outer join #tblChunkToReplicate b on a.id = b.id INNER JOIN #tblChunkInSegment c ON c.archChunkId = b.archChunkId AND c.ChunkCommCellId = b.ChunkCommCellId
				WHERE a.id is null
				SET @numChunks = @@ROWCOUNT
				IF @numChunks > 0
				BEGIN
					-- Add linked archive files.
					INSERT INTO #tblChunkInSegment
					SELECT DISTINCT b.*
					FROM #tblChunkInSegment a right outer join #tblChunkToReplicate b on a.id = b.id INNER JOIN #tblChunkInSegment c ON c.archFileId = b.archFileId AND c.commCellId = b.commCellId
					WHERE a.id is null
					SET @numChunks = @@ROWCOUNT
				END
			END
			SET @sumSegmentSize = (SELECT SUM(physicalSize) FROM #tblChunkInSegment)
			IF @sumSegmentSize < @i_minSegmentGB * 1024 * 1024 * 1024
			BEGIN
				IF @numChunks = 0
					GOTO FETCH_NEXT
				ELSE
					CONTINUE
			END
			IF @numChunks = 0
				BREAK;
		END
CREATE_SEGMENT:
		IF EXISTS (SELECT * FROM #tblChunkInSegment)
		BEGIN
			INSERT INTO ArchChunkToReplicateSegmentTable (DestCopyId, ArchCopyId, MediaGroupId, DestMediaGroupId)
			SELECT @i_destCopyId, @SrcCopyId, 0, 0
			SELECT @errVal = @@ERROR, @segmentId = @@IDENTITY
			IF @errVal <> 0 OR @segmentId = 0
			BEGIN
					SET @errStr = 'Failed to create new segment for aux copy: DB error!'
					GOTO CX_EXIT_ERROR
			END
            DELETE FROM ArchChunkToReplicateSegmentTable WITH (ROWLOCK)
            WHERE segmentId = @segmentId
            SELECT @errVal = @@ERROR
            IF @errVal <> 0
            BEGIN
                SET @errStr = 'Failed to delete segment ID for aux copy: DB error!'
                GOTO CX_EXIT_ERROR
            END
			SET	@maxDestStreamNum = 0
			SELECT	@maxDestStreamNum = MAX(A.destStreamNum)
			FROM	#tblChunkInSegment A
			SELECT @errVal = @@ERROR
			IF @errVal <> 0
			BEGIN
					SET @errStr = 'Failed to get max destStreamNum for segment from tblChunkInSegment: DB error!'
					GOTO CX_EXIT_ERROR
			END
			UPDATE #tblChunkToReplicate
			SET segmentId = @segmentId, destStreamNum = @maxDestStreamNum
			FROM #tblChunkToReplicate a, #tblChunkInSegment b
			WHERE  a.archChunkId = b.archChunkId
			AND a.ChunkCommCellId = b.ChunkCommCellId
			AND a.archFileId = b.archFileId
			AND a.commCellId = b.commCellId
			AND a.SrcCopyId = b.SrcCopyId
			SELECT @errVal = @@ERROR
			IF @errVal <> 0
			BEGIN
					SET @errStr = 'Failed to update segmentId for ArchChunkToReplicate: DB error!'
					GOTO CX_EXIT_ERROR
			END
			-- Clear temp table
			DELETE FROM #tblChunkInSegment
		END
		IF @@FETCH_STATUS <> 0
			GOTO CX_EXIT
FETCH_NEXT:
		IF @fetchNext = 1
			FETCH NEXT from AFCursor INTO @SrcCopyId, @archFileId, @commCellId, @mediaGroupId, @destStreamNum, @destSIDBStoreId
	END
CX_EXIT:
	UPDATE ArchChunkToReplicate
	SET segmentId = b.segmentId, destStreamNum = b.destStreamNum
	FROM ArchChunkToReplicate a, #tblChunkToReplicate b
	WHERE  a.adminJobId = @i_adminJobId
	AND a.archChunkId = b.archChunkId
	AND a.ChunkCommCellId = b.ChunkCommCellId
	AND a.archFileId = b.archFileId
	AND a.commCellId = b.commCellId
	AND a.SrcCopyId = b.SrcCopyId
	AND a.destCopyId = @i_destCopyId
	IF object_id('tempdb.dbo.#tblChunkToReplicate') IS NOT NULL DROP TABLE #tblChunkToReplicate
	IF object_id('tempdb.dbo.#tblChunkInSegment') IS NOT NULL DROP TABLE #tblChunkInSegment
	-- When we repopulate the archChunkToReplicate and if the populated data is having the same segementId as running stream  segmentId then we need to correct TotalSizeToprocess
	-- In archChunkReplicateGetNextChunks is having a logic to update TotalSizeToprocess on changing segementId, so that happens once for each segmentId
	-- So if the segementId is same and we add more data in the same segment then we need to correct the size
	-- For every other case while starting or changing the new segmentId the data size will get populated accordingly
	-- and here we are checking for running stream so this case is only applicable for when job is progressing every other call we do not need to correct,
	-- as every other time we will start all streams again.
	IF @isRepopulateSegmentNeeded = 1
	BEGIN
		UPDATE T
		SET T.segmentId = ACR.segmentId
		FROM #tblChunkToReplicateRepopulateSegment T, archChunkToReplicate ACR WITH (NOLOCK)
		WHERE T.archChunkId = ACR.archChunkId
		AND T.destCopyId = ACR.destCopyId
		AND T.srcCopyId = ACR.srcCopyId
		AND T.commCellId = ACR.commCellId
		AND T.chunkCommCellid = ACR.chunkCommCellId
		AND T.adminJobId = ACR.adminJobId
		AND T.archFileId = ACR.archFileId
		UPDATE AJ
		SET AJ.TotalSizeToProcess = AJ.TotalSizeToProcess + T.AddedDataSize
		FROM ArchJobStreamStatus AJ ,
		(
		SELECT AJ.SegmentId , SUM( ACR.unCompBytesSize)   'AddedDataSize'
		FROM ArchJobStreamStatus AJ WITH (NOLOCK), JMJobStreams JS WITH (NOLOCK), #tblChunkToReplicateRepopulateSegment ACR
		WHERE AJ.DestRCId = JS.destRcId
			AND AJ.DestReservationId = JS.destReservationId
			AND AJ.Status IN ( 1,2) AND JS.status = 1
			AND AJ.SegmentId = ACR.segmentId
			AND ACR.AdminJobId = @i_adminJobId
			AND ACR.DestCopyId = @i_destCopyId
			AND AJ.JobId = ACR.AdminJobId
AND ACR.Status = 0
			GROUP BY AJ.segmentId ) T
		WHERE AJ.SegmentId = T.SegmentId AND AJ.JobId = @i_adminJobId AND AJ.DestCopyId = @i_destCopyId
	END
	IF @cursor = 1
	BEGIN
		CLOSE AFCursor
		DEALLOCATE AFCursor
	END
	-- for parallel copy i might have reused segment id from other parallel copy
	IF (@segmentId = 0)
	BEGIN
		SELECT	@segmentId = MAX(segmentId)
		FROM	ArchChunkToReplicate a
		WHERE	a.adminJobId = @i_adminJobId
				AND a.destCopyId = @i_destCopyId
	END
	COMMIT TRAN archChunkToReplicateSegment_tran
	SELECT 0, '', @segmentId
	RETURN
CX_EXIT_ERROR:
	IF object_id('tempdb.dbo.#tblChunkToReplicate') IS NOT NULL DROP TABLE #tblChunkToReplicate
	IF object_id('tempdb.dbo.#tblChunkInSegment') IS NOT NULL DROP TABLE #tblChunkInSegment
	IF object_id('tempdb.dbo.#tblChunkToReplicateRepopulateSegment') IS NOT NULL DROP TABLE #tblChunkToReplicateRepopulateSegment
	IF @cursor = 1
	BEGIN
		CLOSE AFCursor
		DEALLOCATE AFCursor
	END
	ROLLBACK TRAN archChunkToReplicateSegment_tran
	SELECT @errVal, @errStr, @segmentId
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToReplicateSegment')
	delete from GxQscripts where name = 'archChunkToReplicateSegment'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToReplicateSegment')
	delete from GXDBVersions where aliasname = 'archChunkToReplicateSegment'
GO

insert into GXDBVersions values(2, 'archChunkToReplicateSegment',  '00010006000200080000', 'archChunkToReplicateSegment', '00010006000200080000')
GO

