

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToReplicateSanitizeStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToReplicateSanitizeStatus.sp,v $ $Id: archChunkToReplicateSanitizeStatus.sp,v 1.3.60.7 2018/03/22 01:11:43 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archChunkToReplicateSanitizeStatus <<<'

IF EXISTS (select * from sysobjects where name='archChunkToReplicateSanitizeStatus')
	drop procedure archChunkToReplicateSanitizeStatus
IF EXISTS (select * from GxQscripts where name='archChunkToReplicateSanitizeStatus')
	delete from GxQscripts where name = 'archChunkToReplicateSanitizeStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToReplicateSanitizeStatus')
	delete from GXDBVersions where aliasname = 'archChunkToReplicateSanitizeStatus'
GO
print '... Creating Procedure: archChunkToReplicateSanitizeStatus'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archChunkToReplicateSanitizeStatus
  @i_AuxCopyJobId integer,
  @i_SrcCopyId integer,
  @i_SrcStreamNum integer,
  @i_DestCopyId integer,
  @i_DestStreamNum integer
AS
  DECLARE @errorCode integer;
  DECLARE @jobStatus integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @archChunkToReplicateUpdateStatusReturn TABLE (errorCode INTEGER)
DECLARE @now INTEGER;
SET		@now = dbo.GetUnixTime(GetUTCDate())
DECLARE @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS	INT = 10
-- SET @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS = ISNULL( (SELECT Value FROM MMConfigs WHERE NAME = 'MMCONFIG_DASHCOPY_JOB_SKIP_CHUNK_ON_NONE_SOURCE_ERROR_INTERVAL_MINS'), 10)
SET @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS = ISNULL( (SELECT Value FROM MMConfigs WHERE NAME = 'MMCONFIG_AUXCOPY_RETRY_STREAM_INTERVAL_MINUTES'), 10)
DECLARE @SKIP_INTERVAL_ON_SOURCE_ERROR_MINS	INT = 60
SET @SKIP_INTERVAL_ON_SOURCE_ERROR_MINS = ISNULL( (SELECT Value FROM MMConfigs WHERE NAME = 'MMCONFIG_DASHCOPY_JOB_SKIP_CHUNK_ON_SOURCE_ERROR_INTERVAL_MINS'), 60)
DECLARE @MAX_FAILURE_COUNT INT = 3
SELECT  TOP 1 @MAX_FAILURE_COUNT = ISNULL(value, 3)
    FROM    MMConfigs WITH (READUNCOMMITTED)
    WHERE   name = 'MMS2_CONFIG_AUXCOPY_STREAM_RETRY_COUNT'
DECLARE @RETRY_TIME_INTERVAL INT = 180 -- SECONDS
    SELECT  TOP 1 @RETRY_TIME_INTERVAL = ISNULL(value, 180)
    FROM    MMConfigs WITH (READUNCOMMITTED)
    WHERE   name = 'MMCONFIG_AUXCOPY_RETRY_STREAM_INTERVAL_MINUTES'
SET	@errorCode = 0
-- Mark the copied chunks as processed
INSERT INTO @archChunkToReplicateUpdateStatusReturn
EXEC archChunkToReplicateUpdateStatus @i_AuxCopyJobId
SELECT	@errorCode = @@ERROR
IF	@errorCode <> 0 GOTO ERR_EXIT
SELECT TOP 1 @errorCode = errorCode
FROM	@archChunkToReplicateUpdateStatusReturn
IF	@errorCode <> 0 GOTO ERR_EXIT
-- When this store procedure is invoked it is assumed that we dont have any running stream and we are not able to create new readers
-- If we have any chunks in sent state and reservation exist on dest copy then mark the rest of the chunks of that archive file as sent
DECLARE	@archFileToSkip TABLE (archFileId integer, commCellId integer, DestCopyId integer, minChunkNumber integer, backupJobId integer, segmentId integer, SrcStreamNum int, DestStreamNum int, StreamReaderId int)
INSERT INTO @archFileToSkip
SELECT	archFileId, CommCellId, DestCopyId, MIN(chunkNumber), BackupJobId, MIN(SegmentId), MAX(SrcStreamNum), MAX(DestStreamNum), MAX(StreamReaderId)
FROM	archChunkToReplicate AR
WHERE	AR.adminJobId = @i_AuxCopyJobId
AND AR.Status = (1)
		AND EXISTS ( SELECT	*
						FROM	MMResource R, MMResourceToJob RJ, JMAdminJobInfoTable J
						WHERE	R.CopyId = AR.DestCopyId
								AND R.ReservationId = RJ.ReservationId
								AND RJ.ReservationType = 2
								AND (RJ.InUse = 1 OR RJ.ReserveBitMask <> 0)
								AND J.jobId = RJ.JobId_l
								AND J.commCellId = 2)
GROUP BY archFileId, CommCellId, BackupJobId, DestCopyId
UPDATE	archChunkToReplicate
SET		Status = 5,
 		SkippedCount += 1,
 		SkippedForSeconds = (@SKIP_INTERVAL_ON_SOURCE_ERROR_MINS * 60), -- Skip for 6 hours or till next attempts, modified to 1 hour because auxcopy does not have ways to recognize errors resulting many streams skipped for longer durations
SkippedReason = 0x12,
ErrorCode = 67000,
		Modified = @now,
		SrcStreamNum = S.SrcStreamNum,
		DestStreamNum = S.DestStreamNum,
		StreamReaderId = S.StreamReaderId
FROM	archChunkToReplicate R, @archFileToSkip S
WHERE	R.adminJobId = @i_AuxCopyJobId
		--AND R.backupJobId = S.backupJobId
		AND R.archFileId = S.archFileId
		AND R.CommCellId = S.commCellId
		AND R.destCopyId = S.DestCopyId
AND Status IN (0)
-- When this store procedure is invoked it is assumed that we dont have any running stream and we are not able to create new readers
-- If we have any chunks in sent state and mp reservation exist on dest copy then mark the sent chunks as populated chunks
UPDATE	AR
SET		Status = 0
FROM	archChunkToReplicate AR LEFT OUTER JOIN ArchJobStreamStatus S WITH (NOLOCK) ON S.jobId = AR.AdminJobId AND S.StreamReaderId = AR.StreamReaderId
WHERE	AR.adminJobId = @i_AuxCopyJobId
AND AR.Status IN (1, 5)
			AND S.JobId IS NULL
			AND (
					AR.SkippedForSeconds = 0 AND (AR.Modified + @RETRY_TIME_INTERVAL) < @NOW
					OR
					(AR.Modified + AR.SkippedForSeconds) < @NOW
				)
AND (AR.SkippedCount < @MAX_FAILURE_COUNT OR AR.ExtraFlags & 64 > 0)
ERR_EXIT:
SELECT @errorCode, @jobStatus
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToReplicateSanitizeStatus')
	delete from GxQscripts where name = 'archChunkToReplicateSanitizeStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToReplicateSanitizeStatus')
	delete from GXDBVersions where aliasname = 'archChunkToReplicateSanitizeStatus'
GO

insert into GXDBVersions values(2, 'archChunkToReplicateSanitizeStatus',  '00010003006000070000', 'archChunkToReplicateSanitizeStatus', '00010003006000070000')
GO

