

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToReplicateIsRepopulateRequired.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2015  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archChunkToReplicateIsRepopulateRequired')
BEGIN
	print '>>> Drop Stored Procedure: archChunkToReplicateIsRepopulateRequired <<<'
	drop procedure archChunkToReplicateIsRepopulateRequired
END
IF EXISTS (select * from GxQscripts where name='archChunkToReplicateIsRepopulateRequired')
	delete from GxQscripts where name = 'archChunkToReplicateIsRepopulateRequired'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToReplicateIsRepopulateRequired')
	delete from GXDBVersions where aliasname = 'archChunkToReplicateIsRepopulateRequired'
GO
print '... Creating Procedure: archChunkToReplicateIsRepopulateRequired'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archChunkToReplicateIsRepopulateRequired
  @i_adminJobId int
AS
  DECLARE @retCode int
  DECLARE @repopulate int
SET NOCOUNT ON
-- repopulate [ 0 : No ]  [ 1 : Yes ]
DECLARE @l_retCode INT = 0
DECLARE @l_repopulate INT = 0
DECLARE @l_archGroupId INT = 0
DECLARE @l_archGroupCopyId INT = 0
IF OBJECT_ID('tempdb.dbo.#archReplicateDestCopy') IS NOT NULL DROP TABLE #archReplicateDestCopy
CREATE TABLE #archReplicateDestCopy ( archCopyId INT , sourceCopyId INT, delayedDays SMALLINT, extendedFlags BIGINT, type TINYINT)
IF OBJECT_ID('tempdb.dbo.#jobsNotPicked') IS NOT NULL DROP TABLE #jobsNotPicked
CREATE TABLE #jobsNotPicked( jobId int, dataType int, commcellId int, archCopyId int, sourceCopyId int)
IF OBJECT_ID('tempdb.dbo.#chunksNotPicked') IS NOT NULL DROP TABLE #chunksNotPicked
CREATE TABLE #chunksNotPicked( jobId int, commcellId int, archCopyId int, sourceCopyId int)
SELECT @l_archGroupId = archGrpId, @l_archGroupCopyId = archGrpCopyId
FROM JMAdminJobInfoTable WITH (NOLOCK)
WHERE jobId = @i_adminJobId
SELECT	@l_retCode = @@ERROR
IF	@l_retCode <> 0 GOTO ERR_EXIT
-- Get the copy id from JMAdminJobInfoTable
INSERT #archReplicateDestCopy
SELECT AGC.id, CASE WHEN AGC.sourceCopyId > 0 THEN AGC.sourceCopyId ELSE AG.defaultCopy END, AGC.delayedDays ,AGC.extendedflags,AGC.type
FROM JMAdminJobInfoTable  JA WITH (NOLOCK), archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
WHERE jobId = @i_adminJobId
	AND (JA.archGrpCopyId = 0 OR (JA.archGrpCopyId > 0  AND JA.archGrpCopyId = AGC.id ))
	AND JA.archGrpId = AG.id
	AND AGC.archGroupId = AG.id
	AND AGC.id <> AG.defaultCopy
	AND AGC.id <> AG.defaultSnapCopy
AND AGC.type <> 5
AND AGC.flags & 524288   = 0    --SILO copy
AND AGC.extendedflags & 8  = 0
	AND AGC.isActive > 0
-- AND AGC.isSnapCopy = 0      -- Snap Copy
-- AND AGC.isMirrorCopy = 0    -- Mirror Copy
SELECT	@l_retCode = @@ERROR
IF	@l_retCode <> 0 GOTO ERR_EXIT
IF @l_archGroupCopyId = 0
BEGIN
	DELETE	DC
	FROM	#archReplicateDestCopy DC, JMAdminJobInfoTable  JA WITH (NOLOCK) INNER JOIN JMJobInfo J WITH (NOLOCK) ON JA.JobID = J.JobID AND JA.CommCellId = JA.CommCellId
	WHERE	JA.jobId != @i_adminJobId
			AND JA.opType IN (13, 104) /*AUXCOPY, AUXCOPY2*/
			AND JA.archGrpId = @l_archGroupId
			AND DC.archCopyId = JA.archGrpCopyId
			AND J.State NOT IN (4,5,6,7,8,9,10,11,12,13,19)   -- COMPLETED,STOPPED,KILLPENDING,STOPPENDING,INTERRUPTPENDING,COMPLETEDSUCCESS, COMPLETEDFAIL,STATEKILLED,COMPLETEDPARTIAL,COMPLETEDWITHWARNINGS
END
-- find the jobs which are not picked for copy
INSERT #jobsNotPicked
SELECT J.jobId, J.datatype, J.commCellId, A.archCopyId, A.sourceCopyId
FROM #archReplicateDestCopy A, JMJobDataStats J WITH (NOLOCK)
WHERE  J.disabled & (8192 + 256  + 1 ) = 0
AND A.archCopyId = J.archGrpCopyId
AND J.status = 101
SELECT	@l_retCode = @@ERROR
IF	@l_retCode <> 0 GOTO ERR_EXIT
DELETE #jobsNotPicked
FROM #jobsNotPicked J INNER JOIN archChunktoReplicate AC
ON J.jobId = AC.backupJobId AND J.commCellId = AC.commCellId AND AC.destCopyId = J.archCopyId AND AC.adminJobId = @i_adminJobId
-- Find chunks which are not picked for copy
-- also this is only for synchronous copy only
-- Check for delayed days as well, if delayed days set then just skip the insert
INSERT #chunksNotPicked
SELECT DISTINCT ACM.jobId, ACM.commCellId, A.archCopyId, A.sourceCopyId
FROM #archReplicateDestCopy A, JMJobInfo JI WITH (READUNCOMMITTED), archCHunkMapping ACM  WITH (READUNCOMMITTED)
	LEFT OUTER JOIN   (SELECT DISTINCT ArchChunkId,destCopyId, backupJobId, commCellId, chunkCommCellId FROM  archChunktoReplicate WITH (NOLOCK) WHERE adminJobId = @i_adminJobId) ACR
	ON ACM.ArchChunkId = ACR.ArchChunkId AND ACM.commCellId = ACR.commCellId AND ACM.chunkCommCellId = ACR.chunkCommCellId,
	ArchFile AF
WHERE  ACM.flags & (8192 + 256  + 1 ) = 0
		AND A.sourceCopyId = ACM.archCopyId
		AND AF.id = ACM.archFileId AND AF.commCellId = ACM.commCellId
		AND ACM.jobId = JI.jobId AND ACM.commCellId = JI.commCellId
		AND JI.state not in (4,9,10,11)
		AND A.delayedDays = 0
		AND ACR.backupJobId IS NULL
AND A.type = 1
AND A.extendedFlags & 32768 > 0
AND AF.flags & 32768 = 0
SELECT	@l_retCode = @@ERROR
IF	@l_retCode <> 0 GOTO ERR_EXIT
DELETE A
FROM #jobsNotPicked A, #archReplicateDestCopy B, JMBkpStats C WITH (NOLOCK)
WHERE  A.archCopyId = B.archCopyId
AND A.jobId = C.jobId
AND A.commCellId = C.commCellId
AND B.delayedDays > 0
AND C.servEndDate > (dbo.GetUnixTime(GETUTCDATE()) - B.delayedDays*24*60*60 )
SELECT	@l_retCode = @@ERROR
IF	@l_retCode <> 0 GOTO ERR_EXIT
-- Delete the jobs which are not available on source copy
DELETE JP
FROM #jobsNotPicked JP , JMJobDataStats J WITH (NOLOCK)
WHERE JP.jobId = J.jobId
AND JP.sourceCopyId = J.archGrpCopyId
AND JP.commCellId = J.commCellId
AND JP.dataType = J.dataType
AND ( J.disabled & (256  + 1 ) > 0
		OR J.status IN ( 101,102,103) )
SELECT	@l_retCode = @@ERROR
IF	@l_retCode <> 0 GOTO ERR_EXIT
IF EXISTS ( SELECT 1 FROM #jobsNotPicked) OR EXISTS ( SELECT 1 FROM #chunksNotPicked)
BEGIN
	SET @l_repopulate = 1
END
SELECT	@l_retCode = @@ERROR
ERR_EXIT:
SELECT @l_retCode, @l_repopulate
IF OBJECT_ID('tempdb.dbo.#archReplicateDestCopy') IS NOT NULL DROP TABLE #archReplicateDestCopy
IF OBJECT_ID('tempdb.dbo.#jobsNotPicked') IS NOT NULL DROP TABLE #jobsNotPicked
IF OBJECT_ID('tempdb.dbo.#chunksNotPicked') IS NOT NULL DROP TABLE #chunksNotPicked
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToReplicateIsRepopulateRequired')
	delete from GxQscripts where name = 'archChunkToReplicateIsRepopulateRequired'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToReplicateIsRepopulateRequired')
	delete from GXDBVersions where aliasname = 'archChunkToReplicateIsRepopulateRequired'
GO

insert into GXDBVersions values(2, 'archChunkToReplicateIsRepopulateRequired',  '00000000000000000000', 'archChunkToReplicateIsRepopulateRequired', '00000000000000000000')
GO

