

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToReplicateInsert.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToReplicateInsert.sp,v $ $Id: archChunkToReplicateInsert.sp,v 1.25.2.73.4.1 2021/02/20 01:45:05 chandru Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archChunkToReplicateInsert')
BEGIN
	print '>>> Drop Stored Procedure: archChunkToReplicateInsert <<<'
	drop procedure archChunkToReplicateInsert
END
IF EXISTS (select * from GxQscripts where name='archChunkToReplicateInsert')
	delete from GxQscripts where name = 'archChunkToReplicateInsert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToReplicateInsert')
	delete from GXDBVersions where aliasname = 'archChunkToReplicateInsert'
GO
print '... Creating Procedure: archChunkToReplicateInsert'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archChunkToReplicateInsert
  @i_adminJobId int,
  @i_destCopyId int,
  @i_destStream int,
  @i_srcCopyId int, 
  @i_srcStream int,
  @i_whichCommCell int,
  @i_AuxCopyMgr int,
  @i_isNewAttempt int,
  @i_isForNewData int
AS
  DECLARE @retVal int;
  DECLARE @nSkippedAFs int;
  DECLARE @nInsertedChunks int;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#tblAFC') IS NOT NULL DROP TABLE #tblAFC
IF OBJECT_ID('tempdb.dbo.#destArchFileCopy') IS NOT NULL DROP TABLE #destArchFileCopy
IF OBJECT_ID('tempdb.dbo.#tempJobsInput') IS NOT NULL DROP TABLE #tempJobsInput
IF OBJECT_ID('tempdb.dbo.#tmpJobSizeInfo') IS NOT NULL DROP TABLE #tmpJobSizeInfo
IF OBJECT_ID('tempdb.dbo.#tblFullJobs') IS NOT NULL DROP TABLE #tblFullJobs
IF OBJECT_ID('tempdb.dbo.#tblApp') IS NOT NULL DROP TABLE #tblApp
IF OBJECT_ID('tempdb.dbo.#tblFirstFullToBeCopied') IS NOT NULL DROP TABLE #tblFirstFullToBeCopied
IF OBJECT_ID('tempdb.dbo.#tblFullAppId') IS NOT NULL DROP TABLE #tblFullAppId
IF OBJECT_ID('tempdb.dbo.#tblSubclients') IS NOT NULL DROP TABLE #tblSubclients
IF object_id('tempdb.dbo.#tempJobsToProcess') IS NOT null DROP TABLE #tempJobsToProcess
IF OBJECT_ID('tempdb.dbo.#tblChunksSkippedDueToMediaOutisde') IS NOT NULL DROP TABLE #tblChunksSkippedDueToMediaOutisde
CREATE TABLE #tblChunksSkippedDueToMediaOutisde (adminJobId int,archFileiD int, CommcellId int, destCopyId int, BarCode varchar(256) )
CREATE TABLE #tempJobsToProcess (archCopyId INTEGER, jobId INTEGER, commCellId INTEGER PRIMARY KEY(archCopyId, jobId, CommCellId))
CREATE TABLE #tempJobsInput
(
	jobId		integer,
	commcellId	integer
)
CREATE TABLE #tblFullJobs ( appId int, backupJobId int, commCellId int, status int PRIMARY KEY (backupJobId, CommCellId, AppId))
CREATE TABLE #tblAFC (
		archFileId int, commCellId int, fileType int, appId int, backupJobId int,
		DestStreamNum int, flags int, physicalSize bigint, logicalSize bigint,
		srcStreamNum int, srcFlags int, srcPhysicalSize bigint, srcLogicalSize bigint,
		srcEncKeyType int, srcEncRSA int, srcEncKey varchar(1024), lastChunkNumber int, isJobRunning int, extraFlags int,afFlags int,
		backupLevel int, destSIDBStoreId int
		primary key (archFileId, commCellId) )
CREATE TABLE #tblApp (appId int PRIMARY KEY(appId))
CREATE TABLE #destArchFileCopy
	(
	archFileId			integer,		-- From archFile table
	commCellId     		integer,
	flags				integer,
	streamNum			integer,
	physicalSize		bigint,
	logicalSize			bigint,
	primary key (archFileId, commCellId),
	);;
DECLARE @tblDestCopyStoreList TABLE
(
	SIDBStoreId		integer,
	flags				integer,
	PRIMARY KEY(SIDBStoreId)
)
DECLARE @archChunkToReplicateUpdateStatusReturn TABLE(errorCode INTEGER)
DECLARE @l_dsaEnabled	int
DECLARE @l_commCellId	int
DECLARE @l_archGroupId	int
DECLARE @l_isSnapCopy	int
DECLARE @l_dedupeFlags	int
DECLARE @l_ReencryptAF	int
DECLARE @useLogicalSize	int
DECLARE @amErrCode		int
DECLARE	@oneConstReal REAL = 1.0
DECLARE	@l_isParallelCopy	int
DECLARE @errorCode	int
DECLARE	@l_insertedChunksCount int = 0
DECLARE @l_copyExtendedFlags INTEGER = 0
DECLARE @l_rowCount	int = 0
DECLARE @maxJobId INT = 0
DECLARE @maxCommCellId INT = 0
DECLARE @l_ignoreDVFailedJobs INTEGER = ISNULL(dbo.GetOptionInt(2064661278, @i_adminJobId, 0, 0), 0)
DECLARE @l_totalJobsToProcess INTEGER = ISNULL(dbo.GetOptionInt(1654993746, @i_adminJobId, 0, 0), 1000)
--DECLARE @l_totalJobsToProcess INTEGER = 5000
SET		@useLogicalSize	= 0
SET		@amErrCode		= 0
SET		@nSkippedAFs	= 0
SET		@l_dsaEnabled	= 0
DECLARE @now INTEGER;
SET		@now = dbo.GetUnixTime(GetUTCDate())
DECLARE @xmlJobsList XML = NULL
-- Mark the copied chunks as processed
INSERT INTO @archChunkToReplicateUpdateStatusReturn
EXEC archChunkToReplicateUpdateStatus @i_adminJobId
SELECT	@errorCode = @@ERROR
IF	@errorCode <> 0
BEGIN
SET	@amErrCode = 132
	SET @nSkippedAFs = 1
	SET	@retVal = 0
	GOTO ERR_EXIT
END
SELECT TOP 1 @errorCode = errorCode
FROM	@archChunkToReplicateUpdateStatusReturn
SELECT	@errorCode = @@ERROR
IF	@errorCode <> 0
BEGIN
SET	@amErrCode = 132
	SET @nSkippedAFs = 1
	SET	@retVal = 0
	GOTO ERR_EXIT
END
DECLARE @MAX_FAILURE_COUNT INT = 3
    SELECT  TOP 1 @MAX_FAILURE_COUNT = ISNULL(value, 3)
    FROM    MMConfigs WITH (READUNCOMMITTED)
    WHERE   name = 'MMS2_CONFIG_AUXCOPY_STREAM_RETRY_COUNT'
DECLARE @SKIP_INTERVAL_ON_SOURCE_ERROR_MINS	INT = 60
SET @SKIP_INTERVAL_ON_SOURCE_ERROR_MINS = ISNULL( (SELECT Value FROM MMConfigs WHERE NAME = 'MMCONFIG_DASHCOPY_JOB_SKIP_CHUNK_ON_SOURCE_ERROR_INTERVAL_MINS'), 60)
DECLARE @isIBMcopy INT = 0
IF (@i_destStream = 0 AND @i_srcStream = 0 AND @i_isNewAttempt = 1)
BEGIN
	-- On new attempt move all chunks from SENT status to POPULATE Status
	UPDATE archChunkToReplicate
SET		Status = 0,
			Modified = @now
	WHERE	archChunkToReplicate.adminjobId = @i_adminJobId
			AND archChunkToReplicate.destCopyId = @i_destCopyId
AND (Status = 1
OR (archChunkToReplicate.Status = 3 AND (archChunkToReplicate.SkippedCount < @MAX_FAILURE_COUNT OR archChunkToReplicate.ExtraFlags & 64 > 0))
OR (archChunkToReplicate.Status = 5 AND (archChunkToReplicate.SkippedCount < @MAX_FAILURE_COUNT) OR archChunkToReplicate.ExtraFlags & 64 > 0))
	UPDATE archChunkToReplicate
	SET		SegmentId = 0,
			Modified = @now
	WHERE	archChunkToReplicate.adminjobId = @i_adminJobId
			AND archChunkToReplicate.destCopyId = @i_destCopyId
AND Status = 0
END
ELSE IF @i_isForNewData = 0
BEGIN
	-- When this store procedure is invoked it is assumed that we dont have any running stream and we are not able to create new readers
	-- If we have any chunks in sent state and reservation exist on dest copy then mark the rest of the chunks of that archive file as sent
	DECLARE	@archFileToSkip TABLE (archFileId integer, commCellId integer, DestCopyId integer, minChunkNumber integer, backupJobId integer, segmentId integer, SrcStreamNum int, DestStreamNum int, StreamReaderId int)
	INSERT INTO @archFileToSkip
	SELECT	archFileId, CommCellId, DestCopyId, MIN(chunkNumber), BackupJobId, MIN(SegmentId), MAX(SrcStreamNum), MAX(DestStreamNum), MAX(StreamReaderId)
	FROM	archChunkToReplicate AR
	WHERE	AR.adminJobId = @i_adminJobId
			AND AR.destCopyId = @i_destCopyId
AND AR.Status = (1)
			AND EXISTS (SELECT TOP 1 JobId FROM ArchJobStreamStatus WITH (READUNCOMMITTED) WHERE jobId = AR.AdminJobId AND StreamReaderId = AR.StreamReaderId)
	GROUP BY archFileId, CommCellId, BackupJobId, DestCopyId
	UPDATE	archChunkToReplicate
SET		Status = 5,
			SkippedCount += 1,
 			SkippedForSeconds = (@SKIP_INTERVAL_ON_SOURCE_ERROR_MINS * 60), -- Skip for 6 hours or till next attempts, modified to 1 hour because auxcopy does not have ways to recognize errors resulting many streams skipped for longer durations
SkippedReason = 0x12,
ErrorCode = 67000,
			Modified = @now,
			SrcStreamNum = S.SrcStreamNum,
			DestStreamNum = S.DestStreamNum,
			StreamReaderId = S.StreamReaderId
	FROM	archChunkToReplicate R, @archFileToSkip S
	WHERE	R.adminJobId = @i_adminJobId
			--AND R.backupJobId = S.backupJobId
			AND R.archFileId = S.archFileId
			AND R.CommCellId = S.commCellId
			AND R.destCopyId = S.DestCopyId
AND Status IN (0, 1)
	-- Move all chunks from SENT status to POPULATE Status if we dont have any reservations
	UPDATE	AR
SET		Status = 0
	FROM	archChunkToReplicate AR LEFT OUTER JOIN ArchJobStreamStatus S WITH (READUNCOMMITTED) ON S.jobId = AR.AdminJobId AND S.StreamReaderId = AR.StreamReaderId
	WHERE	AR.adminJobId = @i_adminJobId
AND AR.Status IN (1, 5)
			AND S.JobId IS NULL
			AND	(Modified + SkippedForSeconds) < @NOW
AND		(SkippedCount < @MAX_FAILURE_COUNT OR ExtraFlags & 64 > 0)
END
IF	(SELECT	COUNT(DISTINCT PT.CopyId)
	FROM	MMDrivePool PL WITH (READUNCOMMITTED), MMDataPath PT WITH (READUNCOMMITTED)
	WHERE	PL.DrivePoolId = PT.DrivePoolId AND PT.CopyId IN (@i_srcCopyId, @i_destCopyId) AND PL.DrivePoolType = 3) = 1
BEGIN
		SET	@useLogicalSize = 1
END
SELECT	@l_archGroupId = archGroupId,
		@l_isSnapCopy  = isSnapCopy,
		@l_dedupeFlags = dedupeFlags,
@l_ReencryptAF = case when encType > 0 then (flags & 8388608) else 0 end,
@l_isParallelCopy = case when (flags & 2048) > 0 then 1 else 0 end,
		@l_copyExtendedFlags = extendedFlags
FROM	archGroupCopy WITH (READUNCOMMITTED) WHERE id = @i_destCopyId
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
SELECT TOP 1 @isIBMcopy = 1 FROM archGroup WITH (READUNCOMMITTED) WHERE id = @l_archGroupId AND flags & 67108864 > 0
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
INSERT INTO @tblDestCopyStoreList
SELECT	SIDBStoreId, flags
FROM	archCopySIDBStore
WHERE	copyId = @i_destCopyId
AND (flags & 4) > 0
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
SELECT	@l_dsaEnabled = case when (flags & 131072) = 131072 then 1 else 0 end
FROM	archGroup WITH (READUNCOMMITTED) WHERE id = @l_archGroupId
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
IF EXISTS(SELECT	TOP 1 JobId
	FROM	JMAdminJobInfoTable WITH (READUNCOMMITTED)
	WHERE	jobId = @i_adminJobId
		AND (TotalObjects = 0 OR EXISTS(	SELECT TOP 1 Value
											FROM	MMConfigs WITH (READUNCOMMITTED)
											WHERE	name = 'MMS2_CONFIG_AUXCOPY_SHOULD_COPY_PREFERRED_JOBS_EVEN_AFTER_INTERRUPTIONS'
													AND Value = 1)))
BEGIN
	DECLARE @filename NVARCHAR(MAX)
	DECLARE @filename2 NVARCHAR(MAX)
	SELECT	@filename = (SELECT	TOP 1 install_dir FROM	APP_Platform WHERE	platformType = 1) + '\Base\' + AG.name + '_' + AGC.name + '_Jobs.txt',
			@filename2 = (SELECT	TOP 1 install_dir FROM	APP_Platform WHERE	platformType = 1) + '\Base\SP_'  + CAST(AG.id AS VARCHAR(10)) + '_SPC_' + CAST(AGC.id AS VARCHAR(10)) + '_Jobs.txt'
	FROM	archGroup AG, archGroupCopy AGC
	WHERE	AG.id = AGC.archGroupId
			AND AGC.id = @i_destCopyId
	BEGIN TRY
	    -- load data into temporary table
		DECLARE @SQLQuery NVARCHAR(MAX) = '
		BULK
		INSERT  #tempJobsInput
		FROM    ''' + @filename + '''
		WITH    (ROWTERMINATOR=''\n'', FIELDTERMINATOR='','', KEEPNULLS)'
		EXEC SQLAdminUtilExecQuery @SQLQuery, 1
	END TRY
	BEGIN CATCH
	/*
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	*/
		BEGIN TRY
			-- load data into temporary table
			DECLARE @SQLQuery2 NVARCHAR(MAX) = '
			BULK
			INSERT  #tempJobsInput
			FROM    ''' + @filename2 + '''
			WITH    (ROWTERMINATOR=''\n'', FIELDTERMINATOR='','', KEEPNULLS)'
			EXEC SQLAdminUtilExecQuery @SQLQuery2, 1
		END TRY
		BEGIN CATCH
		/*
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		*/
		END CATCH
	END CATCH
	UPDATE	JDS
SET		flags |= 1
	FROM	JMJobDataStats JDS WITH (NOLOCK), #tempJobsInput TJ
	WHERE	JDS.JobId = TJ.JobId
		AND JDS.CommCellId = TJ.CommCellId
		AND archGrpCopyId = @i_destCopyId
		AND status IN (101, 102, 103)
AND (disabled & (1 + 256)) = 0
	DELETE FROM #tempJobsInput
END
INSERT INTO #tempJobsInput
SELECT DISTINCT J.JobId, J.CommCellId
FROM   JMJobDataStats J WITH (READUNCOMMITTED)
WHERE	J.archGrpCopyId = @i_destCopyId
		AND J.Status IN (101, 102, 103)
AND (J.disabled & (1 + 256) = 0)
AND (J.flags & 1) > 0
SELECT @maxJobId = maxJobId,@maxCommCellId = commCellId
FROM archAddToBeCopiedAfilesBatchDetails
WHERE archGroupID = @l_archGroupId AND destCopyID = @i_destCopyId
AND AuxCopyjobId = @i_adminJobId AND hasMoreBatchesToRun = 1
IF @@ROWCOUNT = 0
	SET @maxJobId = 0
IF @i_srcStream = 0 AND @i_destStream = 0
BEGIN
	SELECT	@xmlJobsList = CAST(attributeValue AS XML)
	FROM	JMJobOptions
	WHERE	jobId = @i_adminJobId
			AND CommCellId = 2
AND attributeId = 70
			AND LEN(attributeValue) > 0
	IF (@l_totalJobsToProcess > 0 AND @xmlJobsList IS NOT NULL)
	BEGIN
		BEGIN
			INSERT INTO #tempJobsToProcess
			SELECT	Jobs.Node.value('@cp', 'INTEGER') archCopyIdId,
					Jobs.Node.value('@j', 'INTEGER') jobId,
					Jobs.Node.value('@c', 'INTEGER') CommCellId
			FROM	@xmlJobsList.nodes('//JobIds/I') Jobs(Node)
		END
		INSERT INTO #destArchFileCopy
		SELECT AFC.archFileId, AFC.commCellId, AFC.flags, AFC.streamNum, AFC.physicalSize, AFC.logicalSize
		FROM #tempJobsToProcess J WITH (READUNCOMMITTED), archFile AF WITH (READUNCOMMITTED), archFileCopy AFC WITH (READUNCOMMITTED)
			WHERE	J.JobId = AF.JobId
					AND J.CommCellId = AF.commCellId
					AND J.archCopyID = @i_destCopyId
					AND AF.id = AFC.archFileId
					AND AF.CommCellId = AFC.commCellId
					AND AFC.archCopyId = @i_destCopyId
					AND AFC.streamNum > 0
					AND (@i_destStream = 0 OR AFC.streamNum = @i_destStream)
					--AND (AFC.isValid = 0)
AND (AFC.flags & 256) = 0
		OPTION  (FORCE ORDER)
	END
	ELSE
	BEGIN
		INSERT INTO #destArchFileCopy
		SELECT AFC.archFileId, AFC.commCellId, AFC.flags, AFC.streamNum, AFC.physicalSize, AFC.logicalSize
		FROM JMJobDataStats J WITH (READUNCOMMITTED), archFile AF WITH (READUNCOMMITTED), archFileCopy AFC WITH (READUNCOMMITTED)
			WHERE	J.JobId = AF.JobId
					AND J.CommCellId = AF.commCellId
					AND J.archGrpCopyId = @i_destCopyId
					AND J.dataType = AF.fileType
					AND J.Status IN (101, 102, 103)
AND J.disabled & (1 + 256) = 0
					AND AF.id = AFC.archFileId
					AND AF.CommCellId = AFC.commCellId
					AND AFC.archCopyId = @i_destCopyId
					AND AFC.streamNum > 0
					AND (@i_destStream = 0 OR AFC.streamNum = @i_destStream)
					--AND (AFC.isValid = 0)
AND (AFC.flags & 256) = 0
		OPTION	(FORCE ORDER)
		INSERT INTO #destArchFileCopy
		SELECT AFC.archFileId, AFC.commCellId, AFC.flags, AFC.streamNum, AFC.physicalSize, AFC.logicalSize
		FROM JMJobInfo J WITH (READUNCOMMITTED), archFile AF WITH (READUNCOMMITTED), archFileCopy AFC WITH (READUNCOMMITTED)
			WHERE	J.JobId = AF.JobId
					AND J.CommCellId = AF.commCellId
					--AND J.archGrpCopyId = @i_destCopyId
					-- AND J.dataType = AF.fileType
					-- AND J.Status IN (101, 102, 103)
-- AND J.disabled & (1 + 256) = 0
					AND J.state NOT IN (4,9,10,11)
					AND AF.id = AFC.archFileId
					AND AF.CommCellId = AFC.commCellId
					AND AFC.archCopyId = @i_destCopyId
					AND AFC.streamNum > 0
					AND (@i_destStream = 0 OR AFC.streamNum = @i_destStream)
					--AND (AFC.isValid = 0)
AND (AFC.flags & 256) = 0
					AND NOT EXISTS (SELECT 1 FROM #destArchFileCopy t WHERE t.archFileId = AFC.archFileId AND t.commCellID = AFC.commCellID)
		OPTION  (FORCE ORDER)
	END
	INSERT #tblAFC
	SELECT	A.archFileId, A.commCellId, AF.fileType, AF.appId, AF.jobId,
			A.streamNum, A.flags, A.physicalSize, A.logicalSize,
			B.streamNum, B.flags, B.physicalSize, B.logicalSize,
			B.encKeyType, B.encRSA, B.encKey, B.lastChunkNumber, 0,
(CASE WHEN @l_copyExtendedFlags & 64 > 0 THEN 64 ELSE 0 END), AF.flags, AF.backupLevel, 0
	FROM   #destArchFileCopy A,
			archFileCopy B WITH (READUNCOMMITTED),archFile AF WITH (READUNCOMMITTED)
	WHERE	A.archFileId = B.archFileId AND A.commCellId = B.commCellId
		AND B.archFileId = AF.id AND B.commCellId = AF.commCellId
		AND B.archCopyId = @i_srcCopyId AND (@l_isSnapCopy > 0 OR B.streamNum > 0)
		AND (@maxJobId = 0 OR (AF.jobID <= @maxJobId AND AF.CommCellId <= @maxCommCellId))
-- For batching the below query would not make a whole lot of difference as there shouldn't be many afs having more size in dest than source
	DELETE #tblAFC
	WHERE  (srcPhysicalSize <> 0 AND srclogicalSize <> 0
			AND ( @useLogicalSize = 0 AND physicalSize >= srcphysicalSize
			OR @useLogicalSize = 1 AND logicalSize >= srclogicalSize))
OR (srcFlags & 256) <> 0
END
 IF @i_srcStream > 0 AND @i_destStream > 0
 BEGIN
 	IF object_id('dbo.archChunkToReplicateDSA') IS NOT NULL
 		and @l_dsaEnabled > 0
 	BEGIN
 		-- Remove non-DSA archive files which use different source stream.
 		DELETE #tblAFC
 		FROM #tblAFC A LEFT OUTER JOIN archChunkToReplicateDSA B
 		ON		A.archFileId = B.archFileId
 			AND A.commCellId = B.commCellId
 			AND B.adminJobId = @i_adminJobId
 			AND B.destCopyId = @i_destCopyId
 			AND B.archCopyId = @i_srcCopyId
 		WHERE B.archFileId IS NULL AND A.srcStreamNum <> @i_srcStream
 		-- Remove DSA archive files which use different source streams
 		DELETE #tblAFC
 		FROM #tblAFC A, archChunkToReplicateDSA B
 		WHERE	A.archFileId = B.archFileId
 			AND A.commCellId = B.commCellId
 			AND B.adminJobId = @i_adminJobId
 			AND B.destCopyId = @i_destCopyId
 			AND B.archCopyId = @i_srcCopyId
 			AND (B.streamNum <> @i_srcStream OR B.destStream <> @i_destStream)
 	END
 	ELSE
 	BEGIN
 		DELETE #tblAFC
 		WHERE srcStreamNum <> @i_srcStream
 	END
 END
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
IF @l_copyExtendedFlags & 32768 > 0
BEGIN
	UPDATE	#tblAFC
	SET		isJobRunning = 1
	FROM	#tblAFC a, JMJobInfo j WITH (READUNCOMMITTED)
	WHERE	a.backupJobId = j.jobID AND j.commCellID = a.commCellID
			AND state not in (4,9,10,11)
AND a.afFlags & (32768|2097152)  = 0 -- we dont want to pick edge chunks for fast copy
END
DELETE	#tblAFC
FROM	#tblAFC AFC LEFT JOIN JMJobDataStats J WITH (READUNCOMMITTED)
	ON	J.jobId = AFC.backupJobId AND J.commCellId = AFC.commCellId
	AND J.archGrpCopyId = @i_destCopyId AND J.dataType = AFC.fileType
AND J.status IN (101, 102, 103) AND J.disabled & (1 + 256) = 0
WHERE	J.jobId IS NULL
AND ((@l_copyExtendedFlags & 32768 = 0) OR AFC.isJobRunning = 0)
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
DELETE	#tblAFC
FROM	#tblAFC AFC LEFT JOIN JMJobDataStats J WITH (READUNCOMMITTED)
	ON	J.jobId = AFC.backupJobId AND J.commCellId = AFC.commCellId
	AND J.archGrpCopyId = @i_srcCopyId AND J.dataType = AFC.fileType
AND J.status = 100 AND J.disabled & (1 + 256) = 0
	AND (@l_ignoreDVFailedJobs = 0 OR J.archCheckStatus != 6 /*ACS_FAILED */)
WHERE	J.jobId IS NULL
AND ((@l_copyExtendedFlags & 32768 = 0) OR AFC.isJobRunning = 0)
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
-- Delete snap archive files which are marked valid on destination
DELETE	T
FROM	#tblAFC T, archFileCopy AFC
WHERE	T.archFileId = AFC.archFileId
		AND T.commCellId = AFC.commCellId
		AND AFC.archCopyId = @i_destCopyId
AND (T.afFlags & 2) > 0
		AND AFC.isValid = 1
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
UPDATE	ArchChunkToReplicate
SET		Status = (CASE WHEN JDS.disabled & (8192 | 256) > 0 THEN 6 ELSE 7 END)
FROM	ArchChunkToReplicate R, JMJobDataStats JDS WITH (READUNCOMMITTED)
WHERE	R.AdminJobId = @i_adminJobId
		AND		R.DestCopyId = @i_destCopyId
ANd		R.Status IN ( 3, 5, 0)
		AND		R.BackupJobId = JDS.JobID
		AND		R.destCopyId = JDS.archGrpCopyId
		AND		R.fileType = JDS.dataType
		AND		R.CommCellid = JDS.CommCellId
AND		(JDS.disabled & (1 | 256)) > 0
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
UPDATE	ArchChunkToReplicate
SET		Status = (CASE WHEN JDS.disabled & (8192 | 256) > 0 THEN 6 ELSE 7 END)
FROM	ArchChunkToReplicate R, JMJobDataStats JDS WITH (READUNCOMMITTED)
WHERE	R.AdminJobId = @i_adminJobId
		AND		R.DestCopyId = @i_destCopyId
ANd		R.Status IN ( 3, 5, 0)
		AND		R.BackupJobId = JDS.JobID
		AND		R.SrcCopyId = JDS.archGrpCopyId
		AND		R.fileType = JDS.dataType
		AND		R.CommCellid = JDS.CommCellId
AND		(JDS.disabled & (1 | 256)) > 0
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
UPDATE	ArchChunkToReplicate
SET		Status = (CASE WHEN JDS.disabled & 8192 = 8192 THEN 6 ELSE 7 END)
FROM	ArchChunkToReplicate R LEFT OUTER JOIN archFileCopy AFC
			ON	R.archFileId = AFC.archFileId
				AND R.CommCellId = AFC.CommCellId
				AND R.DestCopyid = AFC.archCopyId
		, JMJobDataStats JDS WITH (READUNCOMMITTED)
WHERE	R.AdminJobId = @i_adminJobId
		AND		R.DestCopyId = @i_destCopyId
ANd		R.Status IN ( 3, 5, 1)
		AND		R.BackupJobId = JDS.JobID
		AND		R.destCopyId = JDS.archGrpCopyId
		AND		R.fileType = JDS.dataType
		AND		R.CommCellid = JDS.CommCellId
AND		(JDS.disabled & 1) = 1
		AND		AFC.archFileId IS NULL
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
IF @i_whichCommCell = 1
	SET @l_commCellId = (SELECT ISNULL(MIN(commCellId), 2) FROM #tblAFC)
ELSE
IF @i_whichCommCell = 2
	SET @l_commCellId = (SELECT ISNULL(MAX(commCellId), 2) FROM #tblAFC)
ELSE
	SET @l_commCellId = 2
DELETE FROM #tblAFC WHERE commCellId <> @l_commCellId
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
-- Delete the jobs which does not have archFileCopy entries for copying, this can happen if the job is already copied or arch file entries are in MMDeletedAF table
DELETE	#tempJobsInput
FROM	#tempJobsInput J LEFT JOIN #tblAFC AFC
	ON	J.jobId = AFC.backupJobId AND J.commCellId = AFC.commCellId
WHERE	AFC.backupJobId IS NULL
IF EXISTS (SELECT TOP 1 JobId FROM #tempJobsInput)
BEGIN
	DELETE	#tblAFC
	FROM	#tblAFC AFC LEFT JOIN #tempJobsInput J
		ON	J.jobId = AFC.backupJobId AND J.commCellId = AFC.commCellId
	WHERE	J.JobId IS NULL
END
-- Do not send VSA appaware child job data archfiles/chunks
DELETE	AFC
FROM	#tblAFC AFC, JMVSAAppJobLink J (READUNCOMMITTED)
WHERE	AFC.backupJobId = J.childJobId
		AND AFC.CommCellId = J.CommCellId
		AND AFC.fileType = 1
UPDATE	AFC
SET		destSIDBStoreId = AFCD.SIDBStoreId
FROM	#tblAFC AFC,  archFileCopy AFCopy WITH (READUNCOMMITTED), archFileCopyDedup AFCD WITH (READUNCOMMITTED)
WHERE	AFC.archFileId = AFCopy.archFileId
		AND AFC.CommCellId = AFCopy.CommCellId
		AND AFCopy.archCopyId = @i_destCopyId
		AND AFCopy.lastChunkNumber > 0
		AND AFCopy.archFileId = AFCD.archFileId
		AND AFCopy.commCellId = AFCD.commCellId
		AND AFCopy.archCopyId = AFCD.archCopyId
UPDATE	AFC
SET		destSIDBStoreId = SCD.SIDBStoreId
FROM	#tblAFC AFC,  archSubclientCopyDDBMap SCD WITH (READUNCOMMITTED)
WHERE	SCD.appId = AFC.appId AND SCD.copyId = @i_destCopyId
		AND AFC.destSIDBStoreId = 0
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
IF ((@l_dedupeFlags  & 262144) > 0)
BEGIN
	CREATE TABLE #tblSubclients ( appId int PRIMARY KEY(AppId) )
	CREATE TABLE #tblFullAppId ( appId int PRIMARY KEY(AppId) )
	CREATE TABLE #tblFirstFullToBeCopied ( appId int, backupJobId int, commCellId INT, SIDBStoreId INT  PRIMARY KEY(appId, backupJobId, commcellId))
	--------------------------------------------------------------------------
	---- Dedup copy: copy the first fulls for subclients serially ----
	--------------------------------------------------------------------------
IF  (@l_copyExtendedFlags & 131072 = 131072)
	BEGIN
		INSERT INTO #tblFullJobs
		SELECT	DISTINCT T.AppId, T.BackupJobId, T.CommCellId, 101
		FROM	#tblAFC T
		WHERE	backupLevel = 1 /*FULL*/
		GROUP BY T.appId, T.BackupJobId, T.CommCellId
		SELECT	@retVal = @@ERROR
		IF	@retVal <> 0 GOTO ERR_EXIT
		IF (@l_totalJobsToProcess > 0 AND @xmlJobsList IS NOT NULL)
		BEGIN
			INSERT INTO #tblFullJobs
			SELECT	DISTINCT R.AppId, R.BackupJobId, R.CommCellId, 101
			FROM	(SELECT Distinct AppId
					FROM #tblAFC) T, archChunkToReplicate R WITH (READUNCOMMITTED), archFile AF WITH (READUNCOMMITTED)
			WHERE	R.adminJobId = @i_adminJobId
					AND R.DestCopyId = @i_destCopyId
					AND R.AppId = T.AppId
AND R.Status != 2
					AND R.archFileId = AF.id
					AND R.CommCellId = AF.CommCellId
					AND AF.backupLevel = 1 /*FULL*/
			EXCEPT
			SELECT	AppId, BackupJobId, CommCellId, 101
			FROM	#tblFullJobs
			SELECT	@retVal = @@ERROR
			IF	@retVal <> 0 GOTO ERR_EXIT
		END
		-- Only full jobs should be left in #tblFullJobs at this point
		-- Skip if no full jobs left
		IF NOT EXISTS (SELECT TOP 1 backupJobId FROM #tblFullJobs)
			GOTO FIRST_JOB_FOR_DEDUP_DONE
		DELETE	JF
		FROM	#tblFullJobs JF,
				(
				(SELECT	R.BackupJobId, R.CommCellId
				FROM	archChunkToReplicateHistory R WITH (READUNCOMMITTED), #tblFullJobs J
				WHERE	R.adminJobId = @i_adminJobId
						AND R.DestCopyId = @i_destCopyId
						AND R.BackupJobId = J.backupJobId
						AND R.commCellId = J.commCellId
				GROUP BY R.adminJobId, R.destCopyId, R.BackupJobId, R.CommCellId
HAVING (MIN(R.Status) = 2 AND MAX(R.Status) = 2)
				EXCEPT
				SELECT	R.BackupJobId, R.CommCellId
				FROM	archChunkToReplicate R WITH (READUNCOMMITTED), #tblFullJobs J
				WHERE	R.adminJobId = @i_adminJobId
						AND R.DestCopyId = @i_destCopyId
						AND R.BackupJobId = J.backupJobId
						AND R.commCellId = J.commCellId
AND R.Status != 2
				GROUP BY R.adminJobId, R.destCopyId, R.BackupJobId, R.CommCellId)
				UNION
				SELECT	DISTINCT R.BackupJobId, R.CommCellId
				FROM	archChunkToReplicate R WITH (READUNCOMMITTED), #tblFullJobs J
				WHERE	R.adminJobId = @i_adminJobId
						AND R.DestCopyId = @i_destCopyId
						AND R.BackupJobId = J.backupJobId
						AND R.commCellId = J.commCellId
AND ((R.STATUS = 3 AND (R.SkippedCount >= @MAX_FAILURE_COUNT))
OR (R.STATUS IN (4, 6, 7)))
				) T
		WHERE	JF.BackupJobId = T.BackupJobId
				AND JF.commCellId = T.commCellId
		OPTION (MERGE JOIN)
		-- Skip if no more full job to be copied
		IF NOT EXISTS (SELECT TOP 1 backupJobid FROM #tblFullJobs)
			GOTO FIRST_JOB_FOR_DEDUP_DONE
		INSERT INTO #tblFirstFullToBeCopied
		SELECT a.appId, MIN(a.backupJobId), a.commCellId, 0 --a.SIDBStoreId
		FROM #tblFullJobs a
		WHERE a.status <> 100
		GROUP BY a.appId, a.commCellId
		SELECT	@retVal = @@ERROR
		IF	@retVal <> 0 GOTO ERR_EXIT
		IF NOT EXISTS (SELECT TOP 1 backupJobId FROM #tblFirstFullToBeCopied)
			GOTO FIRST_JOB_FOR_DEDUP_DONE
		-- Only copy the first full jobs here
		-- Remaining jobs will be copied during aux copy reinitialization.
		DELETE #tblAFC
		FROM #tblAFC a LEFT OUTER JOIN #tblFirstFullToBeCopied b
				ON a.appId = b.appId
					AND a.backupJobId = b.backupJobId
					AND a.commCellId = b.commCellId
		WHERE a.appId in (select distinct appId from #tblFirstFullToBeCopied)
		AND b.backupJobId IS NULL
		SELECT	@retVal = @@ERROR
		IF	@retVal <> 0 GOTO ERR_EXIT
	END
	--------------------------------------------------------------------------
	---- Dedup copy: copy the first full for subclients if no full copied ----
	--------------------------------------------------------------------------
	ELSE
	IF @i_destStream = 0 AND @i_srcStream = 0
		AND EXISTS (select 1 from MMConfigs WHERE NAME = 'MMCONFIG_AUXCOPY_COPY_FIRST_FULL_FOR_NEW_SUBCLIENT' AND VALUE = 1)
		AND NOT EXISTS (SELECT TOP 1 JobId FROM #tempJobsInput)
	BEGIN
		-- Remove records generated by old aux copy jobs or on different store
		DELETE FROM archChunkToReplicateFirstFullOnStore
		WHERE destCopyId = @i_destCopyId
		AND (adminJobId <> @i_adminJobId OR SIDBStoreId NOT IN (SELECT SIDBStoreId FROM @tblDestCopyStoreList))
		SELECT	@retVal = @@ERROR
		IF	@retVal <> 0 GOTO ERR_EXIT
		--Remove the records if the attempted in previous attempt and there was hard error or skipped because of resource conflict or aged
		DELETE FROM archChunkToReplicateFirstFullOnStore
		WHERE	destCopyId = @i_destCopyId
				AND adminJobId = @i_adminJobId
				AND NOT EXISTS (SELECT	TOP 1 adminJobId
							FROM	archChunkToReplicate R
							WHERE	R.adminJobId = @i_adminJobId
									AND R.DestCopyId = @i_destCopyId
									AND R.BackupJobId = archChunkToReplicateFirstFullOnStore.backupJobId
									AND R.commCellId = archChunkToReplicateFirstFullOnStore.commCellId
AND ((R.STATUS IN (4, 5, 6, 7))
OR (R.STATUS = 3 AND (R.SkippedCount >= @MAX_FAILURE_COUNT))))
		SELECT	@retVal = @@ERROR
		IF	@retVal <> 0 GOTO ERR_EXIT
		INSERT INTO #tblSubclients
		SELECT DISTINCT appId
		FROM #tblAFC
		SELECT	@retVal = @@ERROR
		IF	@retVal <> 0 GOTO ERR_EXIT
		INSERT INTO #tblFullJobs
		SELECT DISTINCT a.appId, a.jobId, a.commCellId, a.status
		FROM JMJobDataStats a WITH (READUNCOMMITTED), #tblSubclients b
		WHERE archGrpCopyId = @i_destCopyId
		AND a.commCellId = @l_commCellId
		AND a.appId = b.appId
		AND a.dataType = 1
AND a.disabled & (1 + 256) = 0
		AND a.status <> 1000
		SELECT	@retVal = @@ERROR
		IF	@retVal <> 0 GOTO ERR_EXIT
		-- Remove non-full jobs
		DELETE #tblFullJobs
		FROM #tblFullJobs a, JMBkpStats b WITH (READUNCOMMITTED)
		WHERE a.backupJobId = b.jobId
		AND a.commCellId = b.commCellId
		AND b.bkpLevel not in (1, 64, 128, 1024, 32768)
		OPTION (MERGE JOIN)
		SELECT	@retVal = @@ERROR
		IF	@retVal <> 0 GOTO ERR_EXIT
		-- Remove non-full DR jobs
		DELETE #tblFullJobs
		FROM #tblFullJobs a, JMAdminJobStatsTable b WITH (READUNCOMMITTED)
		WHERE a.backupJobId = b.jobId
		AND a.commCellId = b.commCellId
		AND ER_BkpLevel <> 1
		OPTION (MERGE JOIN)
		SELECT	@retVal = @@ERROR
		IF	@retVal <> 0 GOTO ERR_EXIT
		-- Only full jobs should be left in #tblFullJobs at this point
		-- Skip if no full jobs left
		IF NOT EXISTS (SELECT TOP 1 backupJobId FROM #tblFullJobs)
			GOTO FIRST_JOB_FOR_DEDUP_DONE
		BEGIN
			;WITH tblFullAppAFs_CTE(archFileId, CommCellId, appId)
			AS
			(
				SELECT	AF.id, AF.commCellId, AF.appId
				FROM	#tblFullJobs AS J, archFile AF WITH (READUNCOMMITTED)
				WHERE	J.status = 100
						AND J.backupJobid = AF.jobId
						AND J.commCellId = AF.commCellId
			)
			INSERT INTO #tblFullAppId
			SELECT DISTINCT AF.appId
			FROM   tblFullAppAFs_CTE AS AF WITH (READUNCOMMITTED), archFileCopyDedup AS c WITH (READUNCOMMITTED), archSubclientCopyDDBMap SCD WITH (READUNCOMMITTED)
			WHERE  AF.archFileId = c.archFileId
			   AND AF.commCellId = c.commCellId
			   AND c.archCopyId = @i_destCopyId
			   AND c.sidbStoreId IN (SELECT SIDBStoreId FROM @tblDestCopyStoreList)
				AND AF.appId = SCD.appId
				AND SCD.copyId = @i_destCopyId
				AND C.SIDBStoreId = SCD.SIDBStoreId
			OPTION (FORCE ORDER)
		END
		-- Remove subclients that has full job copied
		DELETE FROM #tblSubclients
		FROM #tblSubclients a, #tblFullAppId b
		WHERE a.appId = b.appId
		-- Skip if no subclients have full to be copied
		IF NOT EXISTS (SELECT TOP 1 appId FROM #tblSubclients)
			GOTO FIRST_JOB_FOR_DEDUP_DONE
		-- Remove jobs from subclients with full copied
		DELETE FROM #tblFullJobs
		FROM #tblFullJobs
		WHERE appId NOT IN (SELECT appId FROM #tblSubclients)
		SELECT	@retVal = @@ERROR
		IF	@retVal <> 0 GOTO ERR_EXIT
		-- Remove jobs that tried previously
		DELETE FROM #tblFullJobs
		FROM #tblFullJobs a, archChunkToReplicateFirstFullOnStore b WITH (READUNCOMMITTED)
		WHERE a.appId = b.appId
		AND a.backupJobId = b.backupJobId
		AND	a.commCellId = b.commCellId
		AND	b.adminJobId = @i_adminJobId
		AND b.destCopyId = @i_destCopyId
		OPTION (MERGE JOIN)
		SELECT	@retVal = @@ERROR
		IF	@retVal <> 0 GOTO ERR_EXIT
		-- Skip if no more full job to be copied
		IF NOT EXISTS (SELECT TOP 1 backupJobid FROM #tblFullJobs)
			GOTO FIRST_JOB_FOR_DEDUP_DONE
		INSERT INTO #tblFirstFullToBeCopied
		SELECT a.appId, MIN(a.backupJobId), a.commCellId, SCD.SIDBStoreID
		FROM #tblFullJobs a
				INNER JOIN #tblAFC b ON a.backupJobId = b.backupJobId AND a.commCellId = b.commCellId
				INNER JOIN archSubclientCopyDDBMap SCD WITH (READUNCOMMITTED) ON a.appId = SCD.appId AND SCD.copyId = @i_destCopyId AND b.destSIDBStoreId = SCD.SIDBStoreId
		GROUP BY a.appId, a.commCellId, SCD.SIDBStoreID
		SELECT	@retVal = @@ERROR
		IF	@retVal <> 0 GOTO ERR_EXIT
		IF NOT EXISTS (SELECT TOP 1 backupJobId FROM #tblFirstFullToBeCopied)
			GOTO FIRST_JOB_FOR_DEDUP_DONE
		-- Only copy the first full jobs here
		-- Remaining jobs will be copied during aux copy reinitialization.
		DELETE #tblAFC
		FROM #tblAFC a LEFT OUTER JOIN #tblFirstFullToBeCopied b
		ON a.appId = b.appId
		AND a.backupJobId = b.backupJobId
		AND a.commCellId = b.commCellId
		WHERE a.appId in (select distinct appId from #tblFirstFullToBeCopied)
		AND b.backupJobId IS NULL
		SELECT	@retVal = @@ERROR
		IF	@retVal <> 0 GOTO ERR_EXIT
		INSERT INTO archChunkToReplicateFirstFullOnStore
		SELECT @i_adminJobId, @i_destCopyId, SIDBStoreId, appId, backupJobId, commCellId, dbo.GetUnixTime(GETUTCDATE())
		FROM #tblFirstFullToBeCopied
		SELECT	@retVal = @@ERROR
		IF	@retVal <> 0 GOTO ERR_EXIT
	END
END
FIRST_JOB_FOR_DEDUP_DONE:
---------------------------------------------------------------------------
IF @l_copyExtendedFlags & 32768 = 0
BEGIN
-- Remove Already populated archive Files
	DELETE	#tblAFC
	FROM	#tblAFC AFC LEFT JOIN archChunkToReplicate R WITH (READUNCOMMITTED)
		ON	R.archFileId = AFC.archFileId AND R.commCellId = AFC.commCellId
		AND R.SrcCopyId = @i_srcCopyId AND R.DestCopyId = @i_destCopyId
	WHERE	R.AdminJobID = @i_adminJobId
	SELECT	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_EXIT
END
ELSE
BEGIN
-- Remove archFIles for which previous data has not been processed yet or if it's an edge afile
	DELETE	#tblAFC
	FROM	#tblAFC AFC, archChunkToReplicate R WITH (READUNCOMMITTED)
	WHERE	R.archFileId = AFC.archFileId AND R.commCellId = AFC.commCellId
		AND R.SrcCopyId = @i_srcCopyId AND R.DestCopyId = @i_destCopyId
		AND R.AdminJobID = @i_adminJobId
AND (AFC.afFlags & (32768|2097152)  > 0 OR R.status <> 2)
	SELECT	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_EXIT
END
-- Get subclients using User Pass Phrase
IF ((@l_dedupeFlags  & 262144) > 0) OR @l_ReencryptAF <> 0
BEGIN
	INSERT	INTO #tblApp
	SELECT	A.id
	FROM	APP_Application A WITH (READUNCOMMITTED), APP_ClientProp C WITH (READUNCOMMITTED),
			(SELECT	DISTINCT appId FROM #tblAFC WHERE srcEncKeyType <> 0 AND srcEncRSA <> 0) B
	WHERE	A.id = B.appId AND C.componentNameId = A.clientId
		AND C.attrName = N'Encrypt: restoreAccess' AND C.attrVal = N'1' AND C.modified = 0
	SELECT	@retVal = @@ERROR, @l_rowCount = @@ROWCOUNT
	IF	@retVal <> 0 GOTO ERR_EXIT
END
-- If the target copy is single instanced,
-- Remove archive files from jobs which have multiplexed archive files.
-- Remove archive files from jobs encrypted with user defined pass phrase.
IF ((@l_dedupeFlags  & 262144) > 0)
BEGIN
	DECLARE	@tblSkippedJobs TABLE (backupJobId int, commCellId int, errorCode int)
	IF	@i_srcCopyId = (SELECT defaultCopy FROM archGroup WITH (READUNCOMMITTED) WHERE id = @l_archGroupId)
		AND (SELECT maxMultiplex FROM archGroupCopy WITH (READUNCOMMITTED) WHERE id = @i_srcCopyId) > 1
        	AND NOT EXISTS(SELECT TOP 1 value from MMConfigs WHERE name = 'MMS2_CONFIG_AUXCOPY_BY_ARCHIVE_FILE_ORDER' AND value > 0)
	BEGIN
		INSERT	INTO @tblSkippedJobs
SELECT	DISTINCT backupJobId, commCellId, 65
		FROM	#tblAFC
WHERE	(srcFlags & 64) <> 0
		SELECT	@retVal = @@ERROR
		IF	@retVal <> 0 GOTO ERR_EXIT
	END
	INSERT	INTO @tblSkippedJobs
SELECT	DISTINCT AFC.backupJobId, AFC.commCellId, 55
	FROM	#tblAFC AFC
		INNER JOIN #tblApp APP ON AFC.appId = APP.appId
		LEFT OUTER JOIN @tblSkippedJobs J ON AFC.backupJobId = J.backupJobId AND AFC.commCellId = J.commCellId
	WHERE	J.backupJobId IS NULL
	SELECT	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_EXIT
	DELETE	archChunkSkipped
	FROM	archChunkSkipped ACS, @tblSkippedJobs J
	WHERE	ACS.backupJobId = J.backupJobId AND ACS.commCellId = J.commCellId AND ACS.destCopyId = @i_destCopyId
	SELECT	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_EXIT
	INSERT	INTO archChunkSkipped
	SELECT	0, AFC.archFileId, AFC.commCellId, @i_srcCopyId, @i_destCopyId, @i_adminJobId,
			AFC.backupJobId, 0, 0, J.errorCode, 0, 0, 0, 0
	FROM	#tblAFC AFC, @tblSkippedJobs J
	WHERE	AFC.backupJobId = J.backupJobId AND AFC.commCellId = J.commCellId
	SELECT	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_EXIT
	DELETE	#tblAFC
	FROM	#tblAFC AFC, @tblSkippedJobs J
	WHERE	AFC.backupJobId = J.backupJobId AND AFC.commCellId = J.commCellId
	SELECT	@retVal = @@ERROR, @nSkippedAFs = @@ROWCOUNT
	IF	@retVal <> 0 GOTO ERR_EXIT
	IF	@nSkippedAFs > 0
		SET @amErrCode = (SELECT TOP 1 errorCode FROM @tblSkippedJobs)
END
IF (@isIBMcopy = 1)
BEGIN
	UPDATE	#tblAFC
SET		extraFlags |= 256
	FROM	#tblAFC AFC, JMBkpStats JBS WITH (READUNCOMMITTED)
	WHERE	JBS.OpType = 43	-- UNIX TRU64 32-bit 1-Touch Backup, opType=SYSRECOVERYBACKUP
AND JBS.AppType = 38 --38, UNIX TRU64 32-bit
			AND AFC.backupJobId = JBS.jobId
			AND AFC.commCellId = JBS.commCellId
END
IF @l_copyExtendedFlags & 32768 <> 0
BEGIN
	INSERT	INTO archChunkToReplicate (AdminJobId, BackupJobId, ArchFileId, CommCellId, ArchChunkId, ChunkCommCellId, ChunkNumber, lastChunkNumber,
			ArchGroupId, SrcCopyId, SrcStreamNum, DestCopyId, DestStreamNum,
			PhysicalStartOffset, PhysicalOffset, LogicalOffset, PhysicalSize, LogicalSize, unCompBytesSize,
			VolumeId, MediaId, MediaGroupId, MediaType,
			SrcMAId, SrcDrivePoolId,
			Status, Modified, SkippedReason, SkippedCount, SkippedForSeconds, ErrorCode,
			appId, fileType, archFileCopyFlags, encKeyType, fileMarkerNo,
			chunkCreateTime, chunkVersion, chunkPhysicalSize, chunkLogicalSize, chunkHwEncKey, archFileEncKey,
			extraFlags, segmentId, IsParallelCopy, streamReaderID, destSIDBStoreId)
	SELECT
			@i_adminJobId, a.BackupJobId, a.ArchFileId, a.CommCellId, a.ArchChunkId, a.ChunkCommCellId, a.ChunkNumber, a.lastChunkNumber,
			@l_archGroupId, a.archCopyId, (CASE WHEN @l_isSnapCopy <> 0 THEN a.DestStreamNum ELSE a.SrcStreamNum END), @i_destCopyId, a.DestStreamNum,
			a.PhysicalStartOffset /*PhysicalStartOffset*/, a.PhysicalOffset, a.LogicalOffset, a.PhysicalSize, a.LogicalSize, a.unCompSize,
			b.VolumeId, 0, 0, 10001 /*MediaType*/,
			0, 0,
			0, @now, 0, 0, 0, 0,
			a.appId, a.fileType, a.srcFlags, a.srcEncKeyType, b.fileMarkerNo,
			b.createTime, b.version, b.physicalSize, b.logicalSize, b.hwEncKey, a.srcEncKey,
			a.extraFlags, 0, @l_isParallelCopy, 0, a.destSIDBStoreId
	FROM	(SELECT AFC.destSIDBStoreId, AFC.DestStreamNum, AFC.appId, AFC.backupJobId, AFC.srcStreamNum,
					AFC.fileType, AFC.srcFlags, AFC.srcEncKeyType, AFC.srcEncKey, AFC.lastChunkNumber, AFC.extraFlags, (CASE WHEN @useLogicalSize = 0 THEN AFC.PhysicalSize ELSE AFC.LogicalSize END) PhysicalStartOffset,ACM.*
			FROM #tblAFC AFC, archChunkMapping ACM WITH (READUNCOMMITTED) LEFT OUTER JOIN archChunkToReplicate ACR WITH (READUNCOMMITTED)
				ON ACR.adminJobId = @i_adminJobId AND ACR.archFIleID = ACM.archFIleID AND ACR.archCHunkID = ACM.archChunkID
				   AND ACR.ChunkCommCellId = ACM.chunkCommCellId AND ACR.commCellId = ACM.commCellId AND ACR.destCopyId = @i_destCopyId
			WHERE	(@l_isSnapCopy = 0 OR AFC.DestStreamNum = 1)
				AND ACM.archFileId = AFC.archFileId AND ACM.commCellId = AFC.commCellId AND ACM.archCopyId = @i_srcCopyId
				AND (@useLogicalSize = 0 AND (ACM.physicalOffset + ACM.physicalSize) > AFC.physicalSize
				OR @useLogicalSize = 1 AND (ACM.logicalOffset  + ACM.logicalSize)  > AFC.logicalSize)
				AND ACR.archCHunkID IS NULL
			) a, archChunk b with (READUNCOMMITTED)
	WHERE	b.id = a.archChunkId AND b.commCellId = a.chunkCommCellId
	SELECT	@retVal = @@ERROR, @l_insertedChunksCount = @l_insertedChunksCount + @@rowCount
	IF	@retVal <> 0 GOTO ERR_EXIT
END
ELSE
BEGIN
	INSERT	INTO archChunkToReplicate (AdminJobId, BackupJobId, ArchFileId, CommCellId, ArchChunkId, ChunkCommCellId, ChunkNumber, lastChunkNumber,
			ArchGroupId, SrcCopyId, SrcStreamNum, DestCopyId, DestStreamNum,
			PhysicalStartOffset, PhysicalOffset, LogicalOffset, PhysicalSize, LogicalSize, unCompBytesSize,
			VolumeId, MediaId, MediaGroupId, MediaType,
			SrcMAId, SrcDrivePoolId,
			Status, Modified, SkippedReason, SkippedCount, SkippedForSeconds, ErrorCode,
			appId, fileType, archFileCopyFlags, encKeyType, fileMarkerNo,
			chunkCreateTime, chunkVersion, chunkPhysicalSize, chunkLogicalSize, chunkHwEncKey, archFileEncKey,
			extraFlags, segmentId, IsParallelCopy, streamReaderID, destSIDBStoreId)
	SELECT
			@i_adminJobId, a.BackupJobId, a.ArchFileId, a.CommCellId, a.ArchChunkId, a.ChunkCommCellId, a.ChunkNumber, a.lastChunkNumber,
			@l_archGroupId, a.archCopyId, (CASE WHEN @l_isSnapCopy <> 0 THEN a.DestStreamNum ELSE a.SrcStreamNum END), @i_destCopyId, a.DestStreamNum,
			a.PhysicalStartOffset /*PhysicalStartOffset*/, a.PhysicalOffset, a.LogicalOffset, a.PhysicalSize, a.LogicalSize, a.unCompSize,
			b.VolumeId, 0, 0, 10001 /*MediaType*/,
			0, 0,
			0, @now, 0, 0, 0, 0,
			a.appId, a.fileType, a.srcFlags, a.srcEncKeyType, b.fileMarkerNo,
			b.createTime, b.version, b.physicalSize, b.logicalSize, b.hwEncKey, a.srcEncKey,
			a.extraFlags, 0, @l_isParallelCopy, 0, a.destSIDBStoreId
	FROM	(SELECT AFC.destSIDBStoreId, AFC.DestStreamNum, AFC.appId, AFC.backupJobId, AFC.srcStreamNum,
					AFC.fileType, AFC.srcFlags, AFC.srcEncKeyType, AFC.srcEncKey, AFC.lastChunkNumber, AFC.extraFlags, (CASE WHEN @useLogicalSize = 0 THEN AFC.PhysicalSize ELSE AFC.LogicalSize END) PhysicalStartOffset,
					ACM.archFileId, ACM.CommCellId, ACM.archChunkId, ACM.chunkCommCellId, ACM.chunkNumber, ACM.archCopyId,
					ACM.PhysicalOffset, ACM.LogicalOffset, ACM.PhysicalSize, ACM.LogicalSize, ACM.unCompSize
			FROM #tblAFC AFC, archChunkMapping ACM WITH (READUNCOMMITTED)
			WHERE	(@l_isSnapCopy = 0 OR AFC.DestStreamNum = 1)
				AND ACM.archFileId = AFC.archFileId AND ACM.commCellId = AFC.commCellId AND ACM.archCopyId = @i_srcCopyId
				AND (@useLogicalSize = 0 AND (ACM.physicalOffset + ACM.physicalSize) > AFC.physicalSize
				OR @useLogicalSize = 1 AND (ACM.logicalOffset  + ACM.logicalSize)  > AFC.logicalSize)
			) a, archChunk b with (READUNCOMMITTED)
	WHERE	b.id = a.archChunkId AND b.commCellId = a.chunkCommCellId
	SELECT	@retVal = @@ERROR, @l_insertedChunksCount = @l_insertedChunksCount + @@rowCount
	IF	@retVal <> 0 GOTO ERR_EXIT
END
UPDATE	archChunkToReplicate SET mediaId = b.MediaId, mediaGroupId = b.MediaGroupId, MediaType = M.MediaTypeId
FROM	archChunkToReplicate a, MMVolume b WITH (READUNCOMMITTED), MMMedia M WITH (READUNCOMMITTED)
WHERE	a.adminJobId = @i_adminJobId AND a.destCopyId = @i_destCopyId AND a.volumeId = b.VolumeId AND b.MediaId = M.MediaId
AND (a.extraFlags & 4) = 0
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
-- archChunkId for DataSetId, fileMarkerNo for ControlHostId, (chunk) createTime for snap job start time,
-- mediaGroupId for NodeId and volumeId for ExtRelationId
IF	@l_isSnapCopy <> 0
BEGIN
	DELETE	#tblAFC
	FROM	#tblAFC AFC, archChunkSkipped ACS (READUNCOMMITTED), APP_Application APP (READUNCOMMITTED)
	WHERE	AFC.archFileId = ACS.archFileId
			AND ACS.destCopyId = @i_destCopyId
			AND AFC.commCellId = ACS.commCellId
			AND ACS.adminJobId = @i_adminJobId
			AND AFC.appId = APP.id AND APP.appTypeId = 13 /*NAS*/ AND AFC.fileType = 1
	-- some snap jobs might have 0 appSize in JMBkpStats
	UPDATE	tAFC
	SET		PhysicalSize = CASE WHEN S.totalUncompBytes > 0 THEN S.totalUncompBytes/(CASE WHEN afCount > 0 THEN afCount ELSE 1 END) ELSE 1 END
	FROM	#tblAFC tAFC,
			(SELECT	JBS.JobId, JBS.CommCellId, JBS.totalUncompBytes, COUNT(AF.Id) afCount
			FROM	(SELECT DISTINCT BackupJobId, CommCellId
					FROM	#tblAFC) T
					INNER JOIN JMBkpStats JBS WITH (READUNCOMMITTED) ON T.BackupJobId = JBS.JobId AND T.CommCellId = JBS.CommCellID
INNER JOIN archFile	AF WITH (READUNCOMMITTED) ON JBS.JobID = AF.JobId AND JBS.CommCellId = AF.CommCellId AND AF.isValid = 1 AND AF.fileType NOT IN (6, 7)
					INNER JOIN archFileCopy AFC WITH (READUNCOMMITTED) ON AF.id = AFC.archFileId AND AF.CommCellId = AFC.CommCellId AND AFC.archCopyId = @i_srcCopyId AND AFC.isValid = 1
			GROUP BY JBS.JobId, JBS.CommCellId, JBS.totalUncompBytes) S
	WHERE	tAFC.BackupJobId = S.JobId
			AND tAFC.CommCellId = S.CommCellId
	-- For Replica Copy
	IF ((@l_copyExtendedFlags & 512) = 512)
	BEGIN
		INSERT	INTO archChunkToReplicate (AdminJobId, BackupJobId, ArchFileId, CommCellId, ArchChunkId, ChunkCommCellId, ChunkNumber, lastChunkNumber,
				ArchGroupId, SrcCopyId, SrcStreamNum, DestCopyId, DestStreamNum,
				PhysicalStartOffset, PhysicalOffset, LogicalOffset, PhysicalSize, LogicalSize, unCompBytesSize,
				VolumeId, MediaId, MediaGroupId, MediaType,
				SrcMAId, SrcDrivePoolId,
				Status, Modified, SkippedReason, SkippedCount, SkippedForSeconds, ErrorCode,
				appId, fileType, archFileCopyFlags, encKeyType, fileMarkerNo,
				chunkCreateTime, chunkVersion, chunkPhysicalSize, chunkLogicalSize, chunkHwEncKey, archFileEncKey,
				extraFlags, segmentId, IsParallelCopy, streamReaderID, destSIDBStoreId)
		SELECT	@i_adminJobId, a.backupJobId, a.archFileId, a.commCellId, a.archFileId, a.commCellId, 1, a.lastChunkNumber,
				@l_archGroupId,@i_srcCopyId, a.DestStreamNum,  @i_destCopyId, a.DestStreamNum,
				0, 0, 0, PhysicalSize, PhysicalSize, PhysicalSize,
				0, 0, 0, 0,
				0, 0,
				0, @now, 0, 0, 0, 0,
				a.appId, a.fileType, a.srcFlags, a.srcEncKeyType, 0,
				J.servStartDate, 0, 0, 0, '', a.srcEncKey,
4 | a.extraFlags, 0, @l_isParallelCopy, 0, a.destSIDBStoreId
		FROM	#tblAFC a,
				JMBkpStats J WITH (READUNCOMMITTED)
		WHERE	a.DestStreamNum > 1
				AND J.jobId = a.backupJobId AND J.commCellId = a.commCellId
		UPDATE	R
		SET		R.VolumeId = V.SMVolumeId, R.MediaId = E.SnapShotEngineId, R.MediaGroupId = (E.SnapShotEngineId * 1024) + R.DestStreamNum,
R.extraFlags |= (CASE WHEN E.SnapShotEngineId = 27 THEN 128 ELSE 0 END) | IIF(V.VolumeFlags & CAST( 4294967296 AS BIGINT) > 0,512,0),
R.PhysicalStartOffset = IIF(V.VolumeFlags & CAST( 4294967296 AS BIGINT) > 0,V.MasterJobId,0)
		FROM	archChunkToReplicate R, SMVolume V WITH (READUNCOMMITTED), SMVolSnapMap VS WITH (READUNCOMMITTED), SMSnap S WITH (READUNCOMMITTED), SMSnapShotEngine E WITH (READUNCOMMITTED)
		WHERE	R.adminJobId = @i_adminJobId
				AND R.destCopyId = @i_destCopyId
				AND R.destStreamNum > 1
				AND V.archFileId = R.archFileId AND V.commCellId = R.commCellId AND V.CopyId = R.srcCopyId
				AND VS.SMVolumeId = V.SMVolumeId AND S.SMSnapId = VS.SMSnapId
				AND S.SnapShotEngineId = E.SnapShotEngineId
		-- File Marker No column is overloaded with destination region id value for AWS
		UPDATE	R
		SET		fileMarkerNo = DestRegionId
		FROM	archChunkToReplicate R, ArchFileCopyRegion SR WITH (READUNCOMMITTED), ArchCopyAppRegionMap ARM WITH (READUNCOMMITTED)
		WHERE	R.adminJobId = @i_adminJobId
				AND R.destCopyId = @i_destCopyId
				AND R.archFileId = SR.archFileId
				AND R.CommCellId = SR.commCellId
				AND R.srcCopyId = SR.archCopyId
				AND R.destStreamNum > 1
				AND R.destCopyId = ARM.CopyId
				AND R.AppId = ARM.AppId
				AND SR.RegionId = ARM.SrcRegionId
		UPDATE	R
		SET		fileMarkerNo = DestRegionId
		FROM	archChunkToReplicate R, ArchFileCopyRegion SR WITH (READUNCOMMITTED), ArchCopyAppRegionMap ARM WITH (READUNCOMMITTED)
		WHERE	R.adminJobId = @i_adminJobId
				AND R.destCopyId = @i_destCopyId
				AND R.archFileId = SR.archFileId
				AND R.CommCellId = SR.commCellId
				AND R.srcCopyId = SR.archCopyId
				AND R.destStreamNum > 1
				AND R.destCopyId = ARM.CopyId
				AND ARM.AppId = 0
				AND SR.RegionId = ARM.SrcRegionId
				AND R.fileMarkerNo = 0
	END
	ELSE
	BEGIN
		-- For OC6 DFM
		INSERT	INTO archChunkToReplicate (AdminJobId, BackupJobId, ArchFileId, CommCellId, ArchChunkId, ChunkCommCellId, ChunkNumber, lastChunkNumber,
				ArchGroupId, SrcCopyId, SrcStreamNum, DestCopyId, DestStreamNum,
				PhysicalStartOffset, PhysicalOffset, LogicalOffset, PhysicalSize, LogicalSize, unCompBytesSize,
				VolumeId, MediaId, MediaGroupId, MediaType,
				SrcMAId, SrcDrivePoolId,
				Status, Modified, SkippedReason, SkippedCount, SkippedForSeconds, ErrorCode,
				appId, fileType, archFileCopyFlags, encKeyType, fileMarkerNo,
				chunkCreateTime, chunkVersion, chunkPhysicalSize, chunkLogicalSize, chunkHwEncKey, archFileEncKey,
				extraFlags, segmentId, IsParallelCopy, streamReaderID, destSIDBStoreId)
		SELECT
				@i_adminJobId, a.BackupJobId, a.ArchFileId, a.CommCellId, b.SMRelationId, 0, 0, a.lastChunkNumber,
				@l_archGroupId, @i_srcCopyId, a.SrcStreamNum, @i_destCopyId, a.DestStreamNum,
				0 /*PhysicalStartOffset*/, 0, 0, PhysicalSize, PhysicalSize, PhysicalSize,
				b.SMRelationId, 0, b.ArchGroupCopyId, 0 /*MediaType*/,
				0, 0,
				0, @now, 0, 0, 0, 0,
				a.appId, a.fileType, a.srcFlags, a.srcEncKeyType, c.ControlHostId,
				J.servStartDate, 0, 0, 0, '', a.srcEncKey,
4 | a.extraFlags, 0, @l_isParallelCopy, 0, a.destSIDBStoreId
		FROM	#tblAFC a,
				(SELECT x.SMRelationId, x.ExtRelationId, SRN.ExtNodeId, y.ArchGroupCopyId
				FROM	SMRelation x WITH (READUNCOMMITTED), SMCopyToRelationMap y WITH (READUNCOMMITTED) INNER JOIN SMRelationNode SRN WITH (READUNCOMMITTED) ON y.SMRelationNodeId = SRN.SMRelationNodeId
				WHERE	y.SMRelationId = x.SMRelationId AND y.ArchGroupCopyId = @i_destCopyId) b,
				SMDataSetToSubClientMap c WITH (READUNCOMMITTED), JMBkpStats J WITH (READUNCOMMITTED),
				SMControlHost H WITH (READUNCOMMITTED)
		WHERE	a.DestStreamNum > 1
				AND c.AppId = a.appId AND c.SMRelationId = b.SMRelationId
				AND J.jobId = a.backupJobId AND J.commCellId = a.commCellId
				AND H.ControlHostId = c.ControlHostId AND H.SMHostOption = 2
AND ((C.Flags & 256) = 0)
		SELECT	@retVal = @@ERROR, @l_insertedChunksCount = @l_insertedChunksCount + @@rowCount
		IF	@retVal <> 0 GOTO ERR_EXIT
		INSERT	INTO archChunkToReplicate (AdminJobId, BackupJobId, ArchFileId, CommCellId, ArchChunkId, ChunkCommCellId, ChunkNumber, lastChunkNumber,
				ArchGroupId, SrcCopyId, SrcStreamNum, DestCopyId, DestStreamNum,
				PhysicalStartOffset, PhysicalOffset, LogicalOffset, PhysicalSize, LogicalSize, unCompBytesSize,
				VolumeId, MediaId, MediaGroupId, MediaType,
				SrcMAId, SrcDrivePoolId,
				Status, Modified, SkippedReason, SkippedCount, SkippedForSeconds, ErrorCode,
				appId, fileType, archFileCopyFlags, encKeyType, fileMarkerNo,
				chunkCreateTime, chunkVersion, chunkPhysicalSize, chunkLogicalSize, chunkHwEncKey, archFileEncKey,
				extraFlags, segmentId, IsParallelCopy, streamReaderID, destSIDBStoreId)
		SELECT
				@i_adminJobId, a.BackupJobId, a.ArchFileId, a.CommCellId, (CASE WHEN ISNUMERIC(SD.ExtDataSetId) = 1  THEN CAST(SD.ExtDataSetId AS INTEGER) END), 0, 0, a.lastChunkNumber,
				@l_archGroupId, @i_srcCopyId, a.SrcStreamNum, @i_destCopyId, a.DestStreamNum,
				0 /*PhysicalStartOffset*/, 0, 0, PhysicalSize, PhysicalSize, PhysicalSize,
				b.ExtRelationId, 0, b.ExtNodeId, 0 /*MediaType*/,
				0, 0,
				0, @now, 0, 0, 0, 0,
				a.appId, a.fileType, a.srcFlags, a.srcEncKeyType, c.ControlHostId,
				J.servStartDate, 0, 0, 0, '', a.srcEncKey,
4 | a.extraFlags, 0, @l_isParallelCopy, 0, a.destSIDBStoreId
		FROM	#tblAFC a,
				(SELECT x.SMRelationId, (CASE WHEN ISNUMERIC(x.ExtRelationId) = 1  THEN CAST(x.ExtRelationId AS INTEGER) END) AS ExtRelationId,
					(CASE WHEN ISNUMERIC(SRN.ExtNodeId) = 1  THEN CAST(SRN.ExtNodeId AS INTEGER) END) AS ExtNodeId
				FROM	SMRelation x WITH (READUNCOMMITTED), SMCopyToRelationMap y WITH (READUNCOMMITTED) INNER JOIN SMRelationNode SRN WITH (READUNCOMMITTED) ON y.SMRelationNodeId = SRN.SMRelationNodeId,
						SMControlHost H WITH (READUNCOMMITTED)
				WHERE	y.SMRelationId = x.SMRelationId AND y.ArchGroupCopyId = @i_destCopyId
						AND x.ControlHostId = H.ControlHostId AND H.SMHostOption < 2) b,
				SMDataSetToSubClientMap c WITH (READUNCOMMITTED) INNER JOIN SMDataSet SD WITH (READUNCOMMITTED) ON c.DataSetId = SD.DataSetId, JMBkpStats J WITH (READUNCOMMITTED),
				SMControlHost H WITH (READUNCOMMITTED)
		WHERE	a.DestStreamNum > 1
				AND c.AppId = a.appId AND c.SMRelationId = b.SMRelationId
				AND J.jobId = a.backupJobId AND J.commCellId = a.commCellId
				AND H.ControlHostId = c.ControlHostId AND H.SMHostOption < 2
AND ((C.Flags & 256) = 0)
		SELECT	@retVal = @@ERROR, @l_insertedChunksCount = @l_insertedChunksCount + @@rowCount
		IF	@retVal <> 0 GOTO ERR_EXIT
	END
	UPDATE	R
SET		Status = 4/*CVA_CHUNK_FAILED*/,
ErrorCode = 60210 /*E_MM_SM_SB_VOL_NOT_EXIST*/,
SkippedReason = 0x10,
			Modified = @now
	FROM	archChunkToReplicate R
	WHERE	adminJobId = @i_adminJobId
			AND	destCopyId = @i_destCopyId
			AND SrcCopyId = @i_srcCopyId
			AND R.destStreamNum > 1
			AND R.VolumeId = 0
END
IF EXISTS(SELECT TOP 1 Value from MMConfigs WHERE name = 'MMS2_CONFIG_AUXCOPY_BY_ARCHIVE_FILE_ORDER' AND value > 0)
AND ((@l_dedupeFlags  & 262144) > 0)
BEGIN
UPDATE archChunkToReplicate SET extraFlags = extraFlags | 1
	WHERE adminJobId = @i_adminJobId
	AND destCopyId = @i_destCopyId
	AND SrcCopyId = @i_srcCopyId
	AND (@i_srcStream = 0 or SrcStreamNum = @i_srcStream)
	AND (@i_destStream = 0 or DestStreamNum = @i_destStream)
	AND segmentId = 0 -- we need to set these only once, without the segmentID join this query gets executed for the same chunks again n again setting the same flag
END
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
IF @useLogicalSize = 1
BEGIN
UPDATE archChunkToReplicate SET extraFlags = extraFlags | 4
	WHERE adminJobId = @i_adminJobId
	AND destCopyId = @i_destCopyId
	AND SrcCopyId = @i_srcCopyId
	AND (@i_srcStream = 0 or SrcStreamNum = @i_srcStream)
	AND (@i_destStream = 0 or DestStreamNum = @i_destStream)
	AND segmentId = 0 -- we need to set these only once, without the segmentID join this query gets executed for the same chunks again n again setting the same flag
END
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
CREATE TABLE #tmpJobSizeInfo (
	JobId INT, CommCellId INT, totalBackupSize BIGINT, totalAppSize BIGINT, totalIndexSize BIGINT
 	PRIMARY KEY (JobId, CommCellId))
INSERT INTO #tmpJobSizeInfo
SELECT	DISTINCT backupJobId, CommCellId, 0, 0, 0
FROM archChunkToReplicate
WHERE adminJobId = @i_adminJobId
	AND destCopyId = @i_destCopyId
	AND SrcCopyId = @i_srcCopyId
	AND (@i_srcStream = 0 or SrcStreamNum = @i_srcStream)
	AND (@i_destStream = 0 or DestStreamNum = @i_destStream)
	AND unCompBytesSize = -1
EXEC  @retVal = archGetJobSizeInfo 0
UPDATE	archChunkToReplicate
SET		unCompBytesSize = (CASE WHEN totalBackupSize > 0 THEN CAST(((@oneConstReal * (totalAppSize+totalIndexSize)*physicalSize)/totalBackupSize) AS BIGINT) ELSE physicalSize END)
FROM	#tmpJobSizeInfo J
WHERE	adminJobId = @i_adminJobId
		AND destCopyId = @i_destCopyId
		AND SrcCopyId = @i_srcCopyId
		AND (@i_srcStream = 0 or SrcStreamNum = @i_srcStream)
		AND (@i_destStream = 0 or DestStreamNum = @i_destStream)
		AND archChunkToReplicate.backupJobId = J.JobId
		AND archChunkToReplicate.CommCellId = J.CommCellId
		AND archChunkToReplicate.unCompBytesSize = -1
IF ((@l_isSnapCopy = 1) AND ((@l_copyExtendedFlags & 512) = 512))
BEGIN
	DECLARE @archChunkToReplicateGetMAForReplicationReturn TABLE(errorCode INTEGER, errorString	varchar(1024))
	INSERT INTO @archChunkToReplicateGetMAForReplicationReturn
	EXEC MM_SMGetMAForReplication @i_adminJobId, @i_destCopyId, @i_isForNewData, 0, 0
	SELECT	@errorCode = @@ERROR
	IF	@errorCode <> 0
	BEGIN
SET	@amErrCode = 185
		SET @nSkippedAFs = 1
		SET	@retVal = 0
		GOTO ERR_EXIT
	END
	SELECT TOP 1 @errorCode = errorCode
	FROM	@archChunkToReplicateGetMAForReplicationReturn
	IF	@errorCode <> 0
	BEGIN
SET	@amErrCode = 185
		SET @nSkippedAFs = 1
		SET	@retVal = 0
		GOTO ERR_EXIT
	END
END
IF EXISTS(	SELECT  1
			FROM    MMConfigs WITH (READUNCOMMITTED)
			WHERE   name = 'MMCONFIG_AUXCOPY_SKIP_UNAVAILABLE_MEDIA'
					AND value = 1)
BEGIN
	INSERT INTO #tblChunksSkippedDueToMediaOutisde
	SELECT	DISTINCT R.adminJobId, R.archFileId, R.commCellId, R.destCopyId, M.BarCode
			FROM	archChunkToReplicate R WITH (READUNCOMMITTED), MMMedia M WITH (READUNCOMMITTED)
			WHERE	R.adminJobId = @i_adminJobId
					AND R.destCopyId = @i_destCopyId
					AND R.SrcCopyId = @i_srcCopyId
AND R.Status IN (0, 3)
					AND R.MediaType != 10001
					AND R.MediaId = M.MediaId
					AND M.MediaLocation NOT IN (1,2) /*LOCATION_SLOT, LOCATION_DRIVE*/
	IF @@ROWCOUNT > 0
	BEGIN
		UPDATE	R
SET		Status = 8,
				Modified = @now
		FROM	archChunkToReplicate R,
				(SELECT	DISTINCT adminJobId, archFileId, commCellId, destCopyId
						FROM	#tblChunksSkippedDueToMediaOutisde
								) T
		WHERE	R.adminJobID = T.adminJobId
				AND R.archFileId = T.archFileId
				AND R.commCellId = T.commCellId
				AND R.destCopyId = T.destCopyId
AND R.Status IN (0, 3)
		DECLARE @NextEvIDTable      TABLE (id int)
		DECLARE @paramEvMsgId INT = 0
		INSERT INTO @NextEvIDTable
		EXECUTE GetNextEventId
		 SELECT @paramEvMsgId = id FROM  @NextEvIDTable
		INSERT INTO EvMsg (id, TimeSource, TimeServer, Severity, Ack, Acked, Type,
			ParamNum, MessageId, JobId_h, JobId_l, ClientId, CommcellId,
			UserId, SubSystemId, Client, CommCell, UserName, SubSystem,
			MsgEnglish, RepeatCount, LastOccurrence, NextPost,
			mediaId, driveId, libraryId, maClientId)
			SELECT  TOP 1 @paramEvMsgId, @now, @now, 0, 0, 0, 0,
1, (2722 | (CAST(POWER(2, 24) AS BIGINT) * 62)), 0, @i_adminJobId, C.id, 2,
				0, 0, c.name, 0, 0, 'JobManager', --user ID is always admin since it's an admin job
				'', 1, @now, 1,
				0, 0, 0, 0
			FROM	APP_Platform P WITH (READUNCOMMITTED), App_Client C WITH (READUNCOMMITTED)
			WHERE	P.platformType = 1
					AND P.clientId = C.id
		DECLARE @BarCodes VARCHAR(8000)
		SELECT @BarCodes = COALESCE(@BarCodes + ', ', '') + BarCode
		FROM (SELECT DISTINCT BarCode FROM #tblChunksSkippedDueToMediaOutisde) a
		INSERT INTO EvParam(EvMsgId, EventId, Position, Type, Size, Data)
SELECT @paramEvMsgId, (2722 | (CAST(POWER(2, 24) AS BIGINT) * 62)), 1, 0, 0, @BarCodes
SET	@amErrCode = 235
		SET @nSkippedAFs = 1
		SET	@retVal = 0
	END
	UPDATE	R
SET		Status = 0,
			Modified = @now
	FROM	archChunkToReplicate R,
			(SELECT	R.adminJobId, R.archFileId, R.commCellId, R.destCopyId
			FROM	archChunkToReplicate R WITH (READUNCOMMITTED), MMMedia M WITH (READUNCOMMITTED)
			WHERE	R.adminJobId = @i_adminJobId
					AND R.destCopyId = @i_destCopyId
					AND R.SrcCopyId = @i_srcCopyId
AND R.Status  = 8
					AND R.MediaType != 10001
					AND R.MediaId = M.MediaId
			GROUP BY R.adminJobId, R.archFileId, R.commCellId, R.destCopyId
			HAVING MIN(M.MediaLocation) IN (1,2) AND MAX(MediaLocation) IN (1,2) /*LOCATION_SLOT, LOCATION_DRIVE*/
			) T
	WHERE	R.adminJobID = T.adminJobId
			AND R.archFileId = T.archFileId
			AND R.commCellId = T.commCellId
			AND R.destCopyId = T.destCopyId
AND R.Status  = 8
END
-- Adjust hwEncKey based on media
UPDATE	R
SET		chunkHwEncKey = M.hwEncKey
FROM	archChunkToReplicate R WITH (READUNCOMMITTED), MMMedia M WITH (READUNCOMMITTED), ArchChunk chunk WITH (READUNCOMMITTED)
WHERE	R.adminJobId = @i_adminJobId
		AND R.destCopyId = @i_destCopyId
		AND R.SrcCopyId = @i_srcCopyId
		AND M.MediaTypeId != 10001
		AND R.MediaId = M.MediaId
		AND R.chunkHwEncKey = ''
		AND	R.ArchChunkId = chunk.Id
		AND	R.ChunkCommCellId = chunk.CommCellId
AND chunk.flags & 1048576 > 0
--Update the store id information
UPDATE	JA
SET		JA.cloudId = ISNULL((SELECT MAX(destSIDBStoreId) FROM #tblAFC), 0)
FROM	JMAdminJobInfoTable JA
WHERE	JA.JobId = @i_adminJobId
		AND JA.archGrpCopyID = @i_destCopyId
ERR_EXIT:
IF OBJECT_ID('tempdb.dbo.#tblAFC') IS NOT NULL DROP TABLE #tblAFC
IF OBJECT_ID('tempdb.dbo.#destArchFileCopy') IS NOT NULL DROP TABLE #destArchFileCopy
IF OBJECT_ID('tempdb.dbo.#tempJobsInput') IS NOT NULL DROP TABLE #tempJobsInput
IF OBJECT_ID('tempdb.dbo.#tmpJobSizeInfo') IS NOT NULL DROP TABLE #tmpJobSizeInfo
IF OBJECT_ID('tempdb.dbo.#tblFullJobs') IS NOT NULL DROP TABLE #tblFullJobs
IF OBJECT_ID('tempdb.dbo.#tblApp') IS NOT NULL DROP TABLE #tblApp
IF OBJECT_ID('tempdb.dbo.#tblFirstFullToBeCopied') IS NOT NULL DROP TABLE #tblFirstFullToBeCopied
IF OBJECT_ID('tempdb.dbo.#tblFullAppId') IS NOT NULL DROP TABLE #tblFullAppId
IF OBJECT_ID('tempdb.dbo.#tblSubclients') IS NOT NULL DROP TABLE #tblSubclients
IF object_id('tempdb.dbo.#tempJobsToProcess') IS NOT null DROP TABLE #tempJobsToProcess
IF OBJECT_ID('tempdb.dbo.#tblChunksSkippedDueToMediaOutisde') IS NOT NULL DROP TABLE #tblChunksSkippedDueToMediaOutisde
IF	@retVal = 0 AND @nSkippedAFs <> 0
	SELECT @amErrCode, @nSkippedAFs, @l_insertedChunksCount
ELSE
	SELECT @retVal, @nSkippedAFs, @l_insertedChunksCount
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToReplicateInsert')
	delete from GxQscripts where name = 'archChunkToReplicateInsert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToReplicateInsert')
	delete from GXDBVersions where aliasname = 'archChunkToReplicateInsert'
GO

insert into GXDBVersions values(2, 'archChunkToReplicateInsert',  'v1.25.2.73.4.1', 'archChunkToReplicateInsert', 'v1.25.2.73.4.1')
GO

