

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToReplicateHandleFailedReportStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToReplicateHandleFailedReportStatus.sp,v $ $Id: archChunkToReplicateHandleFailedReportStatus.sp,v 1.8.36.22 2020/10/28 22:27:06 chandru Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archChunkToReplicateHandleFailedReportStatus')
BEGIN
	print '>>> Drop Stored Procedure: archChunkToReplicateHandleFailedReportStatus <<<'
	drop procedure archChunkToReplicateHandleFailedReportStatus
END
IF EXISTS (select * from GxQscripts where name='archChunkToReplicateHandleFailedReportStatus')
	delete from GxQscripts where name = 'archChunkToReplicateHandleFailedReportStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToReplicateHandleFailedReportStatus')
	delete from GXDBVersions where aliasname = 'archChunkToReplicateHandleFailedReportStatus'
GO
print '... Creating Procedure: archChunkToReplicateHandleFailedReportStatus'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archChunkToReplicateHandleFailedReportStatus
  @i_adminJobId int,
  @i_chunkId bigint,
  @i_chunkCommCellId int,
  @i_srcCopyId int,
  @i_srcStreamNum int,
  @i_destCopyId int,
  @i_destStreamNum int,
  @i_readerId int,
  @i_isSrcError int,
  @i_errorCode int,
  @i_mmErrorCode int,
  @i_type int,
  @i_reservedLong int
AS
  DECLARE @o_error integer;
  DECLARE @o_errorString varchar(2048);
  DECLARE @o_barcode varchar(256);
  DECLARE @o_libraryName NVARCHAR(128);
  DECLARE @o_mediaTypeId integer;
  DECLARE @o_mountPathName NVARCHAR(1024); 
  DECLARE @o_policyName NVARCHAR(144);
  DECLARE @o_copyName NVARCHAR(64);
  DECLARE @o_mediaAgentName NVARCHAR(255);
  DECLARE @o_jobIdString varchar(1024);
SET NOCOUNT ON
DECLARE @error			integer = 0
DECLARE @errorString	varchar(1024) = ''
DECLARE @barcode		varchar(256) = ''
DECLARE @libraryName	NVARCHAR(128) = ''
DECLARE @mediaTypeId	integer = 0
DECLARE @mountPathName	NVARCHAR(1024) = ''
DECLARE @policyName		NVARCHAR(144) = ''
DECLARE @copyName		NVARCHAR(64) = ''
DECLARE @mediaAgentName	NVARCHAR(255) = ''
DECLARE @jobIdString	varchar(1024) = ''
DECLARE @snapShotNamesMax	NVARCHAR(MAX) = ''
DECLARE @isSnapCopy		INTEGER = 0;
DECLARE @srcMAId		integer = 0
DECLARE @destMAId		integer = 0
DECLARE @srcDPId		integer = 0
DECLARE @destDPId		integer = 0
DECLARE @segmentId		integer = 0
DECLARE @segmentIdFromStream		integer = 0
DECLARE	@volumeId integer = 0
DECLARE	@mediaId integer = 0
DECLARE	@skipSourceMedia INTEGER = 0
DECLARE @now INTEGER = dbo.GetUnixTime(GetUTCDate())
DECLARE @SKIP_INTERVAL_ON_SOURCE_ERROR_MINS	INT = 60
SET @SKIP_INTERVAL_ON_SOURCE_ERROR_MINS = ISNULL( (SELECT Value FROM MMConfigs WHERE NAME = 'MMCONFIG_DASHCOPY_JOB_SKIP_CHUNK_ON_SOURCE_ERROR_INTERVAL_MINS'), 60)
DECLARE @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS	INT = 10
-- SET @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS = ISNULL( (SELECT Value FROM MMConfigs WHERE NAME = 'MMCONFIG_DASHCOPY_JOB_SKIP_CHUNK_ON_NONE_SOURCE_ERROR_INTERVAL_MINS'), 10)
SET @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS = ISNULL( (SELECT Value FROM MMConfigs WHERE NAME = 'MMCONFIG_AUXCOPY_RETRY_STREAM_INTERVAL_MINUTES'), 10)
DECLARE @ContinueOnReadError INTEGER = 0
SET	@ContinueOnReadError = ISNULL( (SELECT Value FROM MMConfigs WHERE NAME = 'MMS2_CONFIG_STRING_SKIP_CHUNKS'), 1)
-- Mark the processed chunks
DECLARE @archChunkToReplicateUpdateStatusReturn TABLE (errorCode INTEGER)
INSERT INTO @archChunkToReplicateUpdateStatusReturn
EXEC archChunkToReplicateUpdateStatus @i_adminJobId
SELECT	TOP 1 @segmentId = segmentId
FROM	archChunkToReplicate WITH (NOLOCK)
WHERE	adminJobId = @i_adminJobId
		AND archChunkId = @i_chunkId
		AND chunkCommCellId = @i_chunkCommCellId
		AND destCopyId = @i_destCopyId
SELECT	@srcMAId	= SrcMAId,
		@destMAId	= DestMAId,
		@srcDPId	= SrcDrivePoolId,
		@destDPId	= DestDrivePoolId,
		@segmentIdFromStream = S.SegmentId
FROM	ArchJobStreamStatus S  WITH (NOLOCK)
WHERE	S.JobId = @i_adminJobId
		AND S.SrcCopyId = @i_srcCopyId
		AND S.SrcStreamNum = @i_srcStreamNum
		AND S.DestCopyId = @i_destCopyId
		AND S.DestStreamNum = @i_destStreamNum
		AND S.StreamReaderId = @i_readerId
IF EXISTS (SELECT * FROM MMConfigs  WITH (NOLOCK) WHERE	name = 'MMCONFIG_AUXCOPY_SKIP_UNAVAILABLE_MEDIA' and Value > 0)
	SET	@skipSourceMedia = 1
SELECT	@mediaAgentName = name
FROM	APP_Client C  WITH (NOLOCK)
WHERE	C.Id = (CASE WHEN (@i_isSrcError = 1) THEN @srcMAId ELSE @destMAId END)
IF ((@i_isSrcError = 1)
	AND @skipSourceMedia = 1
AND 273 = @i_mmErrorCode
	AND	EXISTS (SELECT	1
			FROM	MMDrivePool DP WITH (NOLOCK), MMMasterPool MP WITH (NOLOCK), MMLibrary L WITH (NOLOCK)
			WHERE	DP.DrivePoolId = @srcDPId
					AND DP.MasterPoolId = MP.MasterPoolId
					AND MP.LibraryId = L.LibraryId
AND L.LibraryTypeId NOT IN (4, 5)))
SET @i_errorCode = 0x10;
IF OBJECT_ID('tempdb.dbo.#archFileToSkip') IS NOT NULL DROP TABLE #archFileToSkip
CREATE TABLE  #archFileToSkip  (archFileId integer, commCellId integer, minChunkNumber integer, backupJobId integer, segmentId integer, StreamReaderId integer PRIMARY KEY (archfileId, CommCellId, backupJobid))
IF OBJECT_ID('tempdb.dbo.#tblChunksToReset') IS NOT NULL DROP TABLE #tblChunksToReset
CREATE TABLE  #tblChunksToReset  (segmentId integer, ArchChunkId BIGINT, ChunkCommCellId integer, ArchFileId integer, CommCellId integer)
IF OBJECT_ID('tempdb.dbo.#skippedAppIds') IS NOT NULL DROP TABLE #skippedAppIds
CREATE TABLE  #skippedAppIds  (appId integer, extraFlags integer PRIMARY KEY (appId, extraFlags) WITH (IGNORE_DUP_KEY = ON))
DECLARE @tblSkipEverythingErrorCodes TABLE (ErrorCode INT PRIMARY KEY(ErrorCode))
INSERT INTO @tblSkipEverythingErrorCodes (ErrorCode) VALUES (53001)
INSERT INTO @tblSkipEverythingErrorCodes (ErrorCode) VALUES (53002)
INSERT INTO @tblSkipEverythingErrorCodes (ErrorCode) VALUES (53004)
INSERT INTO @tblSkipEverythingErrorCodes (ErrorCode) VALUES (53005)
INSERT INTO @tblSkipEverythingErrorCodes (ErrorCode) VALUES (53006)
INSERT INTO @tblSkipEverythingErrorCodes (ErrorCode) VALUES (53013)
INSERT INTO @tblSkipEverythingErrorCodes (ErrorCode) VALUES (53021)
INSERT INTO @tblSkipEverythingErrorCodes (ErrorCode) VALUES (53023)
INSERT INTO @tblSkipEverythingErrorCodes (ErrorCode) VALUES (53027)
INSERT INTO @tblSkipEverythingErrorCodes (ErrorCode) VALUES (53036)
INSERT INTO @tblSkipEverythingErrorCodes (ErrorCode) VALUES (53039)
INSERT INTO @tblSkipEverythingErrorCodes (ErrorCode) VALUES (53041)
INSERT INTO @tblSkipEverythingErrorCodes (ErrorCode) VALUES (53044)
INSERT INTO @tblSkipEverythingErrorCodes (ErrorCode) VALUES (53043)
INSERT INTO @tblSkipEverythingErrorCodes (ErrorCode) VALUES (53048)
INSERT INTO @tblSkipEverythingErrorCodes (ErrorCode) VALUES (53200)
INSERT INTO @tblSkipEverythingErrorCodes (ErrorCode) VALUES (53201)
INSERT INTO @tblSkipEverythingErrorCodes (ErrorCode) VALUES (53202)
INSERT INTO @tblSkipEverythingErrorCodes (ErrorCode) VALUES (53206)
INSERT INTO @tblSkipEverythingErrorCodes (ErrorCode) VALUES (53209)
INSERT INTO @tblSkipEverythingErrorCodes (ErrorCode) VALUES (53218)
INSERT INTO @tblSkipEverythingErrorCodes (ErrorCode) VALUES (53219)
INSERT INTO @tblSkipEverythingErrorCodes (ErrorCode) VALUES (53220)
INSERT INTO @tblSkipEverythingErrorCodes (ErrorCode) VALUES (53221)
INSERT INTO @tblSkipEverythingErrorCodes (ErrorCode) VALUES (53222)
INSERT INTO @tblSkipEverythingErrorCodes (ErrorCode) VALUES (53223)
INSERT INTO @tblSkipEverythingErrorCodes (ErrorCode) VALUES (67007)
INSERT INTO @tblSkipEverythingErrorCodes (ErrorCode) VALUES (67012)
INSERT INTO @tblSkipEverythingErrorCodes (ErrorCode) VALUES (67013)
BEGIN TRAN
BEGIN TRY
IF ((@i_reservedLong & 1) = 1)
BEGIN
	INSERT INTO #archFileToSkip
	SELECT	archFileId, CommCellId, MIN(chunkNumber), BackupJobId, MIN(SegmentId), MAX(StreamReaderId)
	FROM	archChunkToReplicate WITH (NOLOCK)
	WHERE	adminJobId = @i_adminJobId
			AND destCopyId = @i_destCopyId
			AND DestStreamNum = @i_destStreamNum
AND Status IN (1)
			AND StreamReaderId = @i_readerId
	GROUP BY archFileId, CommCellId, BackupJobId
	UPDATE	archChunkToReplicate
SET		Status = 5,
			SkippedCount += 1,
			SkippedForSeconds = (@SKIP_INTERVAL_ON_SOURCE_ERROR_MINS * 60), -- Skip for 6 hours or till next attempts, modified to 1 hour because auxcopy does not have ways to recognize errors resulting many streams skipped for longer durations
			SkippedReason = @i_errorCode,
			ErrorCode = @i_mmErrorCode,
			Modified = @now,
			StreamReaderId = S.StreamReaderId
	OUTPUT  DELETED.AppId, DELETED.extraFlags INTO #skippedAppIds
	FROM	archChunkToReplicate R, #archFileToSkip S, ArchJobStreamStatus SS WITH (NOLOCK)
	WHERE	R.adminJobId = @i_adminJobID
			AND R.archFileId = S.archFileId
			AND R.CommCellId = S.commCellId
			AND R.destCopyId = @i_destCopyId
AND R.Status IN (0, 1)
			AND R.adminJobId = SS.JobId
			AND	S.StreamReaderId = SS.StreamReaderId
	DELETE FROM #archFileToSkip
END
IF (@i_errorCode = 0x11 AND EXISTS (SELECT * FROM @tblSkipEverythingErrorCodes WHERE ErrorCode = @i_mmErrorCode))
BEGIN
	-- Current Segment and all other not active segments chunks in populated and sent should be set with skipped state
	UPDATE	archChunkToReplicate
SET		Status = 3,
			SkippedCount += 1,
			SkippedForSeconds = (@SKIP_INTERVAL_ON_SOURCE_ERROR_MINS * 60),
			SkippedReason = @i_errorCode,
			ErrorCode = @i_mmErrorCode,
			Modified = @now
	FROM	archChunkToReplicate R LEFT OUTER JOIN ArchJobStreamStatus S WITH (NOLOCK) ON R.AdminJobId = S.JobId AND (S.StreamReaderId != @i_readerId AND S.StreamReaderId = R.StreamReaderId)
	WHERE	R.adminJobId = @i_adminJobID
			AND R.srcCopyId = @i_srcCopyId
			AND R.destCopyId = @i_destCopyId
AND R.Status IN (0, 1)
			AND S.JobID IS NULL
END
ELSE IF (@i_errorCode = 0x6 OR @i_errorCode = 0x11)
BEGIN
	INSERT INTO #archFileToSkip
	SELECT	archFileId, CommCellId, MIN(chunkNumber), BackupJobId, MIN(SegmentId), MIN(StreamReaderId)
	FROM	archChunkToReplicate WITH (NOLOCK)
	WHERE	adminJobId = @i_adminJobId
			AND archChunkId = @i_chunkId
			AND chunkCommCellId = @i_chunkCommCellId
			AND destCopyId = @i_destCopyId
AND Status IN (0, 1)
	GROUP BY archFileId, CommCellId, BackupJobId
IF( (@i_mmErrorCode = 30017 OR @i_mmErrorCode = 30032 OR
@i_mmErrorCode = 30074   OR @i_mmErrorCode = 1208 OR
@i_mmErrorCode = 65103   ) )
	BEGIN
		-- Mark the chunks as failed with MMErrorCode
		-- Mark the job as bad on JMJobDataStats table based on config param
		UPDATE	archChunkToReplicate
SET		Status = 4,
				ErrorCode = @i_mmErrorCode,
				Modified = @now
		FROM	archChunkToReplicate R, #archFileToSkip S
		WHERE	R.adminJobId = @i_adminJobID
				AND R.archFileId = S.archFileId
				AND R.CommCellId = S.commCellId
				AND R.destCopyId = @i_destCopyId
AND Status IN (0, 1)
		IF EXISTS (SELECT 1 FROM MMConfigs WHERE name = 'MMS2_CONFIG_STRING_MARK_JOBS_BAD' AND Value = 1)
		BEGIN
			UPDATE	JMJobDataStats
SET		disabled |= (64 | 1)
			FROM	JMJobDataStats J, #archFileToSkip S
			WHERE	J.JobID = S.backupJobId
					AND J.CommCellId = S.CommCellId
					AND J.archGrpCopyId = @i_SrcCopyId
			UPDATE	JMJobSnapshotStats
SET		disabled |= (64 | 1)
			FROM	JMJobSnapshotStats J, #archFileToSkip S
			WHERE	J.JobID = S.backupJobId
					AND J.CommCellId = S.CommCellId
					AND materializationStatus IN (101, 102, 103)
					AND disabled = 0
					AND J.archGrpId IN (SELECT id FROM archGroup WHERE defaultSnapCopy = @i_SrcCopyId)
			DECLARE @jobId INTEGER
			DECLARE @commCellid INTEGER
			DECLARE @retCode INTEGER
			DECLARE BadJobsCursor CURSOR
				FOR SELECT	DISTINCT backupJobId, CommCellId
					FROM	#archFileToSkip
			OPEN BadJobsCursor
			FETCH NEXT FROM BadJobsCursor INTO @jobId, @commCellid
			WHILE @@FETCH_STATUS = 0
			BEGIN
				EXEC @retCode = archDisallowJobForCopy @jobId, @commCellid, @i_SrcCopyId, @now
				FETCH NEXT FROM BadJobsCursor INTO @jobId, @commCellid
			END
			CLOSE BadJobsCursor
			DEALLOCATE BadJobsCursor
		END
	END
IF (@ContinueOnReadError = 1 OR @i_errorCode = 0x6)
	BEGIN
		-- Skip the archive files here, Update the Src and Dest Stream Number for all chunks getting skipped
		UPDATE	archChunkToReplicate
SET		Status = 3,
				SkippedCount += 1,
				SkippedForSeconds = (@SKIP_INTERVAL_ON_SOURCE_ERROR_MINS * 60),
				SkippedReason = @i_errorCode,
				ErrorCode = @i_mmErrorCode,
				Modified = @now
		OUTPUT  DELETED.AppId, DELETED.extraFlags INTO #skippedAppIds
		FROM	archChunkToReplicate R, #archFileToSkip S
		WHERE	R.adminJobId = @i_adminJobID
				AND R.archFileId = S.archFileId
				AND R.CommCellId = S.commCellId
				AND R.destCopyId = @i_destCopyId
AND Status IN (0, 1)
	END
	ELSE
	BEGIN
		-- Skip all chunks on current reader
		TRUNCATE TABLE #archFileToSkip
		INSERT INTO #archFileToSkip
		SELECT	archFileId, CommCellId, MIN(chunkNumber), BackupJobId, MIN(SegmentId), MIN(StreamReaderId)
		FROM	archChunkToReplicate WITH (NOLOCK)
		WHERE	adminJobId = @i_adminJobId
				AND destCopyId = @i_destCopyId
				AND DestStreamNum = @i_destStreamNum
AND Status IN (1)
				AND StreamReaderId = @i_readerId
		GROUP BY archFileId, CommCellId, BackupJobId
		-- Skip the archive files here, Update the Src and Dest Stream Number for all chunks getting skipped
		UPDATE	archChunkToReplicate
SET		Status = 3,
				SkippedCount += 1,
				SkippedForSeconds = (@SKIP_INTERVAL_ON_SOURCE_ERROR_MINS * 60),
				SkippedReason = @i_errorCode,
				ErrorCode = @i_mmErrorCode,
				Modified = @now
		OUTPUT  DELETED.AppId, DELETED.extraFlags INTO #skippedAppIds
		FROM	archChunkToReplicate R, #archFileToSkip S
		WHERE	R.adminJobId = @i_adminJobID
				AND R.archFileId = S.archFileId
				AND R.CommCellId = S.commCellId
				AND R.destCopyId = @i_destCopyId
AND Status IN (0, 1)
	END
END
-- TODO: Skip entire volume and it's AF when you get CVA_AUXCOPY_SOURCE_MEDIA_ERROR
ELSE IF (@i_errorCode = 0x10)
BEGIN
	INSERT INTO #archFileToSkip
	SELECT	archFileId, CommCellId, MIN(chunkNumber), BackupJobId, MIN(SegmentId), MIN(StreamReaderId)
	FROM	archChunkToReplicate WITH (NOLOCK)
	WHERE	adminJobId = @i_adminJobId
			AND destCopyId = @i_destCopyId
AND Status IN (0, 1)
			AND chunkCommCellId = @i_chunkCommCellId
			AND VolumeId = (SELECT TOP 1 VolumeId FROM 	archChunkToReplicate WITH (NOLOCK)
							 WHERE	adminJobId = @i_adminJobId
									AND destCopyId = @i_destCopyId
									AND archChunkId = @i_chunkId
									AND chunkCommCellId = @i_chunkCommCellId)
	GROUP BY archFileId, CommCellId, BackupJobId
	-- Logic to update the src and dest stream numbers
	-- Volume we are skipping might belong to different segments
	--	1. Segment currently reported error - Skip the chunks and Assign the same src and dest stream number
	--  2. Segments that are assigned to other streams and active - Do not skip chunks or update the src and dest stream number
	--  3. Segments that are not assigned to other streams - Skip the chunks but do not Assign the src and dest stream number
	-- Volume we are skipping might belong to different readers
	--	1. Reader currently reported error - Skip the chunks
	--  2. Other Active Reader - Do not skip chunks
	--  3. Non Active readers or reader id is 0 - Skip the chunks
	--  2. Reader that are assigned to other streams and active - Do not skip chunks
	DELETE FROM #archFileToSkip
	WHERE	StreamReaderId IN (SELECT StreamReaderId FROM ArchJobStreamStatus WHERE JobId = @i_adminJobId AND StreamReaderId != @i_readerId)
	-- Skip the archive files here
	--	1. Reader currently reported error - Skip the chunks
	UPDATE	archChunkToReplicate
SET		Status = 3,
			SkippedCount += 1,
			SkippedForSeconds = (@SKIP_INTERVAL_ON_SOURCE_ERROR_MINS * 60),
			SkippedReason = @i_errorCode,
			ErrorCode = @i_mmErrorCode,
			Modified = @now
	OUTPUT  DELETED.AppId, DELETED.extraFlags INTO #skippedAppIds
	FROM	archChunkToReplicate R, #archFileToSkip S
	WHERE	R.adminJobId = @i_adminJobID
			AND R.archFileId = S.archFileId
			AND R.CommCellId = S.commCellId
			AND R.destCopyId = @i_destCopyId
AND Status IN (0, 1)
			AND R.StreamReaderId = @i_readerId
	--  3. Segments that are not assigned to other streams - Skip the chunks but do not Assign the src and dest stream number
	UPDATE	archChunkToReplicate
SET		Status = 3,
			SkippedCount += 1,
			SkippedForSeconds = (@SKIP_INTERVAL_ON_SOURCE_ERROR_MINS * 60),
			SkippedReason = @i_errorCode,
			ErrorCode = @i_mmErrorCode,
			Modified = @now
	OUTPUT  DELETED.AppId, DELETED.extraFlags INTO #skippedAppIds
	FROM	archChunkToReplicate R, #archFileToSkip S
	WHERE	R.adminJobId = @i_adminJobID
			AND R.archFileId = S.archFileId
			AND R.CommCellId = S.commCellId
			AND R.destCopyId = @i_destCopyId
AND Status IN (0, 1)
			AND R.StreamReaderId NOT IN (SELECT StreamReaderId FROM ArchJobStreamStatus WHERE JobId = @i_adminJobId AND StreamReaderId = @i_readerId)
END
-- WHEN REPLICATOR CONTROLLER STOPPED OBRUPTLY
ELSE IF (@i_errorCode = 0x3 AND @i_mmErrorCode IN (67001,	67007,
67012, 67013))
BEGIN
	INSERT INTO #archFileToSkip
	SELECT	archFileId, CommCellId, MIN(chunkNumber), BackupJobId, MIN(SegmentId), MIN(StreamReaderId)
	FROM	archChunkToReplicate WITH (NOLOCK)
	WHERE	adminJobId = @i_adminJobId
			AND destCopyId = @i_destCopyId
			AND (DestStreamNum = @i_destStreamNum OR segmentId = @segmentIdFromStream)
AND Status IN (0, 1)
			AND (StreamReaderId = @i_readerId OR StreamReaderId = 0)
	GROUP BY archFileId, CommCellId, BackupJobId
	-- Skip the archive files here, if the chunks are in still populated and sent state but reservation is not released.
	UPDATE	archChunkToReplicate
SET		Status = 5,
			SkippedCount += 1,
			SkippedForSeconds = (@SKIP_INTERVAL_ON_SOURCE_ERROR_MINS * 60), -- Skip for 6 hours or till next attempts, modified to 1 hour because auxcopy does not have ways to recognize errors resulting many streams skipped for longer durations
			SkippedReason = @i_errorCode,
			ErrorCode = @i_mmErrorCode,
			Modified = @now
	OUTPUT  DELETED.AppId, DELETED.extraFlags INTO #skippedAppIds
	FROM	archChunkToReplicate R, #archFileToSkip S, ArchJobStreamStatus SS WITH (NOLOCK)
	WHERE	R.adminJobId = @i_adminJobID
			-- AND R.backupJobId = S.backupJobId
			AND R.archFileId = S.archFileId
			AND R.CommCellId = S.commCellId
			AND R.destCopyId = @i_destCopyId
AND R.Status IN (0, 1)
			AND R.adminJobId = SS.JobId
			AND R.StreamReaderId = SS.StreamReaderId
	-- Skip the archive files here, Update the Src and Dest Stream Number for all chunks getting skipped
	UPDATE	archChunkToReplicate
SET		Status = 3,
			SkippedCount += 1,
			SkippedForSeconds = (@SKIP_INTERVAL_ON_SOURCE_ERROR_MINS * 60),
			SkippedReason = @i_errorCode,
			ErrorCode = @i_mmErrorCode,
			Modified = @now
	OUTPUT  DELETED.AppId, DELETED.extraFlags INTO #skippedAppIds
	FROM	archChunkToReplicate R, #archFileToSkip S
	WHERE	R.adminJobId = @i_adminJobID
			-- AND R.backupJobId = S.backupJobId
			AND R.archFileId = S.archFileId
			AND R.CommCellId = S.commCellId
			AND R.destCopyId = @i_destCopyId
AND Status IN (0, 1)
END
ELSE
BEGIN
	INSERT INTO #archFileToSkip
	SELECT	archFileId, CommCellId, MIN(chunkNumber), BackupJobId, MIN(SegmentId), MIN(StreamReaderId)
	FROM	archChunkToReplicate WITH (NOLOCK)
	WHERE	adminJobId = @i_adminJobId
			AND destCopyId = @i_destCopyId
AND Status IN (0, 1)
			AND StreamReaderId = (SELECT TOP 1 StreamReaderId FROM 	archChunkToReplicate WITH (NOLOCK)
							 WHERE	adminJobId = @i_adminJobId
									AND destCopyId = @i_destCopyId
									AND archChunkId = @i_chunkId
									AND chunkCommCellId = @i_chunkCommCellId)
	GROUP BY archFileId, CommCellId, BackupJobId
	-- Skip the archive files here, Update the Src and Dest Stream Number for all chunks getting skipped
	UPDATE	archChunkToReplicate
SET		Status = 3,
			SkippedCount += 1,
			SkippedForSeconds = (@SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS * 60) * (SkippedCount+1),
			SkippedReason = @i_errorCode,
			ErrorCode = @i_mmErrorCode,
			Modified = @now
	OUTPUT  DELETED.AppId, DELETED.extraFlags INTO #skippedAppIds
	FROM	archChunkToReplicate R, #archFileToSkip S
	WHERE	R.adminJobId = @i_adminJobID
			-- AND R.backupJobId = S.backupJobId
			AND R.archFileId = S.archFileId
			AND R.CommCellId = S.commCellId
			AND R.destCopyId = @i_destCopyId
AND Status IN (0, 1)
END
SELECT	TOP 1 @volumeId = VolumeId, @mediaId = mediaId, @mediaTypeId = MediaType
FROM	archChunkToReplicate WITH (NOLOCK)
WHERE	adminJobId = @i_adminJobId
		AND archChunkId = @i_chunkId
		AND chunkCommCellId = @i_chunkCommCellId
		AND destCopyId = @i_destCopyId
SELECT	@jobIdString = @jobIdString + (CASE WHEN (LEN(@JobIdString) > 0) THEN ', ' ELSE '' END) + CAST(backupJobId AS varchar(10))
FROM	archChunkToReplicate WITH (READUNCOMMITTED)
WHERE	adminJobId = @i_adminJobId
			AND archChunkId = @i_chunkId
			AND chunkCommCellId = @i_chunkCommCellId
			AND destCopyId = @i_destCopyId
SET	 @jobIdString = ' Backup Job [' + @jobIdString + ']'
SELECT	@barCode = barcode, @libraryName = L.AliasName
FROM	MMMedia M WITH (NOLOCK), MMLibrary L WITH (NOLOCK)
WHERE	M.MediaId = @mediaId
		AND M.LibraryId = L.LibraryId
SELECT	@policyName = AG.name, @copyName = AGC.name, @isSnapCopy = AGC.isSnapCopy
FROM	archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
WHERE	AG.id = AGC.archGroupId
		AND AGC.id = (CASE WHEN (@i_destCopyId = 0) THEN @i_srcCopyId ELSE @i_destCopyId END)
IF (@mediaTypeId = 10001)
BEGIN
	SELECT	@barCode = VolumeName
	FROM	MMVolume
	WHERE	VolumeId = @volumeId
	SELECT	@mountPathName = MountPathName
	FROM	MMS2getMountPathNameGUIView
	WHERE	MediaId = @mediaId
END
ELSE IF (@isSnapCopy = 1)
	AND (@i_destStreamNum > 1)
BEGIN
	SELECT  @snapShotNamesMax = SUBSTRING((	SELECT DISTINCT ( ', ' + H.SMArrayId + ':' + SN.UniqueIdentifier)
											FROM	archChunkToReplicate R WITH (READUNCOMMITTED)
													INNER JOIN SMVolume SMV WITH (READUNCOMMITTED) ON SMV.archFileId = R.archFileID AND SMV.CommCellId = R.commCellID AND SMV.CopyId = R.SrcCopyId
													INNER JOIN SMVolSnapMap Map WITH (READUNCOMMITTED) ON SMV.SMVolumeId = Map.SMVolumeId
													INNER JOIN SMSnap SN WITH (READUNCOMMITTED) ON Map.SMSnapId = SN.SMSnapId
													INNER JOIN SMControlHost H WITH (READUNCOMMITTED) ON SN.ControlHostId = H.ControlHostId
											WHERE	adminJobId = @i_adminJobId
													AND archChunkId = @i_chunkId
													AND chunkCommCellId = @i_chunkCommCellId
													AND destCopyId = @i_destCopyId
AND (R.extraFlags & 4) = 4
											FOR XML PATH('') ), 2, 255)
	SET @mediaTypeId = -1 /*Snap Info*/
	IF (LEN(@snapShotNamesMax) = 255)
	BEGIN
		SET	@snapShotNamesMax = REVERSE(@snapShotNamesMax)
		SET	@mountPathName = REVERSE(SUBSTRING(@snapShotNamesMax, CHARINDEX(',', @snapShotNamesMax) +1, 255))
	END
	ELSE
	BEGIN
		SET @mountPathName = @snapShotNamesMax
	END
END
IF EXISTS (SELECT 1
		FROM	#skippedAppIds
WHERE	extraFlags & 128 > 0)
BEGIN
	-- If some appIds are marked as skipped, then mark newer jobs of those appIds as skipped
	UPDATE	ACR
	SET		DestStreamNum= B.DestStreamNum,
			SrcMAId = B.SrcMAId,
			MediaGroupId = B.MediaGroupId,
			SkippedCount = B.SkippedCount,
			SkippedForSeconds = B.SkippedForSeconds,
			SkippedReason = B.SkippedReason,
			ErrorCode = B.ErrorCode,
			Modified = B.Modified,
Status = 3,
			StreamReaderId = B.StreamReaderId
	FROM	ArchChunkToReplicate ACR INNER JOIN
			(
				SELECT	DISTINCT ACR.appId,
								MAX(DestStreamNum) DestStreamNum,
								MAX(SrcMAId) SrcMAId,
								MAX(MediaGroupId) MediaGroupId,
								MAX(SkippedCount) SkippedCount,
								MAX(SkippedForSeconds) SkippedForSeconds,
								MAX(SkippedReason) SkippedReason,
								MAX(ErrorCode) ErrorCode,
								MAX(Modified) Modified,
								MAX(StreamReaderId) StreamReaderId
				FROM	#skippedAppIds T, ArchChunkToReplicate ACR
				WHERE	ACR.AdminJobId = @i_adminJobId
						AND ACR.DestCopyId = @i_destCopyId
						AND ACR.SrcMAId > 0
						AND ACR.fileType = 1
						AND	ACR.appId = T.AppId
AND	T.extraFlags & 128 > 0
AND	ACR.extraFlags & 128 > 0
AND ACR.Status IN ( 3, 5 )
				GROUP BY ACR.appId
			) B ON ACR.appId = B.appId
	WHERE	ACR.AdminJobId = @i_adminJobId
			AND ACR.DestCopyId = @i_destCopyId
			AND ACR.fileType = 1
AND ACR.Status = 0
END
-- Move the chunks in sent state back to populated state to send them again
INSERT INTO #tblChunksToReset -- fetching all the remaining clustered index columns so that SQL server doesn't over shoots the page locks for read
SELECT /*AdminJobId, DestCopyId,*/ segmentId, ArchChunkId, ChunkCommCellId, ArchFileId, CommCellId
FROM	archChunkToReplicate R WITH (READUNCOMMITTED)
WHERE	R.adminJobId = @i_adminJobId
		AND R.DestCopyId = @i_destCopyId
		AND R.DestStreamNum = @i_destStreamNum
		AND R.StreamReaderId = @i_readerId
AND R.Status = 1
UPDATE	archChunkToReplicate
SET		Status = 0
FROM	archChunkToReplicate R, #tblChunksToReset t
WHERE	R.adminJobId = @i_adminJobId
		AND R.DestCopyId = @i_destCopyId
		AND R.DestStreamNum = @i_destStreamNum
		AND R.StreamReaderId = @i_readerId
AND R.Status = 1
		AND t.segmentId = R.segmentId AND t.archCHunkId = R.archChunkId AND t.chunkCommCellId = R.ChunkCommCellId AND t.archFileId = R.archFileId AND t.commCellId = R.commCellId
END TRY
BEGIN CATCH
	ROLLBACK TRAN
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	;THROW
END CATCH
COMMIT TRAN
SELECT	@error, @errorString, @barcode, @libraryName, @mediaTypeId, @mountPathName,
		@policyName, @copyName, @mediaAgentName, @jobIdString
IF OBJECT_ID('tempdb.dbo.#archFileToSkip') IS NOT NULL DROP TABLE #archFileToSkip
IF OBJECT_ID('tempdb.dbo.#tblChunksToReset') IS NOT NULL DROP TABLE #tblChunksToReset
IF OBJECT_ID('tempdb.dbo.#skippedAppIds') IS NOT NULL DROP TABLE #skippedAppIds
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToReplicateHandleFailedReportStatus')
	delete from GxQscripts where name = 'archChunkToReplicateHandleFailedReportStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToReplicateHandleFailedReportStatus')
	delete from GXDBVersions where aliasname = 'archChunkToReplicateHandleFailedReportStatus'
GO

insert into GXDBVersions values(2, 'archChunkToReplicateHandleFailedReportStatus',  '00010008003600220000', 'archChunkToReplicateHandleFailedReportStatus', '00010008003600220000')
GO

