

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToReplicateGetJobStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToReplicateGetJobStatus.sp,v $ $Id: archChunkToReplicateGetJobStatus.sp,v 1.17.2.17 2019/10/23 13:27:19 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archChunkToReplicateGetJobStatus')
BEGIN
	print '>>> Drop Stored Procedure: archChunkToReplicateGetJobStatus <<<'
	drop procedure archChunkToReplicateGetJobStatus
END
IF EXISTS (select * from GxQscripts where name='archChunkToReplicateGetJobStatus')
	delete from GxQscripts where name = 'archChunkToReplicateGetJobStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToReplicateGetJobStatus')
	delete from GXDBVersions where aliasname = 'archChunkToReplicateGetJobStatus'
GO
print '... Creating Procedure: archChunkToReplicateGetJobStatus'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archChunkToReplicateGetJobStatus
  @i_AuxCopyJobId integer,
  @i_includeAttemptState integer
AS
  DECLARE @errorCode integer;
  DECLARE @jobStatus integer;
  DECLARE @agedChunksSkipped integer;
  DECLARE @disabledChunksSkipped integer;
  DECLARE @mediaOutSideChunksSkipped integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @archChunkToReplicateUpdateStatusReturn TABLE (errorCode INTEGER)
IF OBJECT_ID('tempdb.dbo.#tblChunksSkippedDueToMediaOutisde') IS NOT NULL DROP TABLE #tblChunksSkippedDueToMediaOutisde
CREATE TABLE #tblChunksSkippedDueToMediaOutisde (adminJobId int,archFileiD int, CommcellId int, destCopyId int, BarCode varchar(256) )
DECLARE @now INTEGER;
SET		@now = dbo.GetUnixTime(GetUTCDate())
DECLARE @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS	INT = 10
-- SET @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS = ISNULL( (SELECT Value FROM MMConfigs WHERE NAME = 'MMCONFIG_DASHCOPY_JOB_SKIP_CHUNK_ON_NONE_SOURCE_ERROR_INTERVAL_MINS'), 10)
SET @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS = ISNULL( (SELECT Value FROM MMConfigs WHERE NAME = 'MMCONFIG_AUXCOPY_RETRY_STREAM_INTERVAL_MINUTES'), 10)
DECLARE @SKIP_INTERVAL_ON_SOURCE_ERROR_MINS	INT = 60
SET @SKIP_INTERVAL_ON_SOURCE_ERROR_MINS = ISNULL( (SELECT Value FROM MMConfigs WHERE NAME = 'MMCONFIG_DASHCOPY_JOB_SKIP_CHUNK_ON_SOURCE_ERROR_INTERVAL_MINS'), 60)
DECLARE @MAX_FAILURE_COUNT INT = 3
    SELECT  TOP 1 @MAX_FAILURE_COUNT = ISNULL(value, 3)
    FROM    MMConfigs WITH (NOLOCK)
    WHERE   name = 'MMS2_CONFIG_AUXCOPY_STREAM_RETRY_COUNT'
DECLARE @RETRY_TIME_INTERVAL INT = 180 -- SECONDS
    SELECT  TOP 1 @RETRY_TIME_INTERVAL = ISNULL(value, 180)
    FROM    MMConfigs WITH (NOLOCK)
    WHERE   name = 'MMCONFIG_AUXCOPY_RETRY_STREAM_INTERVAL_MINUTES'
SET	@errorCode = 0
-- Mark the copied chunks as processed
INSERT INTO @archChunkToReplicateUpdateStatusReturn
EXEC archChunkToReplicateUpdateStatus @i_AuxCopyJobId
SELECT	@errorCode = @@ERROR
IF	@errorCode <> 0 GOTO ERR_EXIT
SELECT TOP 1 @errorCode = errorCode
FROM	@archChunkToReplicateUpdateStatusReturn
IF	@errorCode <> 0 GOTO ERR_EXIT
-- When this store procedure is invoked it is assumed that we dont have any running stream and we are not able to create new readers
-- If we have any chunks in sent state and reservation exist on dest copy then mark the rest of the chunks of that archive file as sent
DECLARE	@archFileToSkip TABLE (archFileId integer, commCellId integer, DestCopyId integer, minChunkNumber integer, backupJobId integer, segmentId integer, SrcStreamNum int, DestStreamNum int, StreamReaderId int)
INSERT INTO @archFileToSkip
SELECT	archFileId, CommCellId, DestCopyId, MIN(chunkNumber), BackupJobId, MIN(SegmentId), MAX(SrcStreamNum), MAX(DestStreamNum), MAX(StreamReaderId)
FROM	archChunkToReplicate AR
WHERE	AR.adminJobId = @i_AuxCopyJobId
AND AR.Status = (1)
		AND EXISTS (SELECT * FROM ArchJobStreamStatus WITH (NOLOCK) WHERE jobId = AR.AdminJobId AND StreamReaderId = AR.StreamReaderId)
GROUP BY archFileId, CommCellId, BackupJobId, DestCopyId
UPDATE	archChunkToReplicate
SET		Status = 5,
 		SkippedCount += 1,
 		SkippedForSeconds = (@SKIP_INTERVAL_ON_SOURCE_ERROR_MINS * 60), -- Skip for 6 hours or till next attempts, modified to 1 hour because auxcopy does not have ways to recognize errors resulting many streams skipped for longer durations
SkippedReason = 0x12,
ErrorCode = 67000,
		Modified = @now,
		SrcStreamNum = S.SrcStreamNum,
		DestStreamNum = S.DestStreamNum,
		StreamReaderId = S.StreamReaderId
FROM	archChunkToReplicate R, @archFileToSkip S
WHERE	R.adminJobId = @i_AuxCopyJobId
		--AND R.backupJobId = S.backupJobId
		AND R.archFileId = S.archFileId
		AND R.CommCellId = S.commCellId
		AND R.destCopyId = S.DestCopyId
AND Status IN (0, 1)
UPDATE	AR
SET		Status = 0
FROM	archChunkToReplicate AR LEFT OUTER JOIN ArchJobStreamStatus S WITH (NOLOCK) ON S.jobId = AR.AdminJobId AND S.StreamReaderId = AR.StreamReaderId
WHERE	AR.adminJobId = @i_AuxCopyJobId
AND AR.Status IN (1, 5)
		AND S.JobId IS NULL
		AND (
				AR.SkippedForSeconds = 0 AND (AR.Modified + @RETRY_TIME_INTERVAL) < @NOW
				OR
				(AR.Modified + AR.SkippedForSeconds) < @NOW
			)
AND (AR.SkippedCount < @MAX_FAILURE_COUNT OR AR.ExtraFlags & 64 > 0)
UPDATE	archChunkToReplicate
SET		Status = 0
WHERE	adminJobId = @i_AuxCopyJobId
AND	Status = 3
AND (SkippedCount < @MAX_FAILURE_COUNT OR ExtraFlags & 64 > 0)
		AND (
				SkippedForSeconds = 0 AND (Modified + @RETRY_TIME_INTERVAL) < @NOW
				OR
				(Modified + SkippedForSeconds) < @NOW
			)
UPDATE ArchChunkToReplicate
SET		Status = 0, SkippedReason = 0, SkippedForSeconds = 0, ErrorCode = 0, Modified = @now
WHERE	adminJobId = @i_AuxCopyJobId
AND		Status = 3
AND		SkippedReason = 0X13
UPDATE	ArchChunkToReplicate
SET		Status = (CASE WHEN JDS.disabled & (8192 | 256) > 0 THEN 6 ELSE 7 END)
FROM	ArchChunkToReplicate R, JMJobDataStats JDS WITH (NOLOCK)
WHERE	R.AdminJobId = @i_AuxCopyJobId
ANd		R.Status IN ( 3, 5, 0)
		AND		R.BackupJobId = JDS.JobID
		AND		R.destCopyId = JDS.archGrpCopyId
		AND		R.fileType = JDS.dataType
		AND		R.CommCellid = JDS.CommCellId
AND		(JDS.disabled & (1 | 256)) > 0
UPDATE	ArchChunkToReplicate
SET		Status = 6
FROM	ArchChunkToReplicate R, JMJobDataStats JDS WITH (NOLOCK)
WHERE	R.AdminJobId = @i_AuxCopyJobId
ANd		R.Status IN ( 3, 5, 0)
		AND		R.BackupJobId = JDS.JobID
		AND		R.SrcCopyId = JDS.archGrpCopyId
		AND		R.fileType = JDS.dataType
		AND		R.CommCellid = JDS.CommCellId
AND		(JDS.disabled & 256) > 0
IF EXISTS(	SELECT  1
			FROM    MMConfigs WITH (NOLOCK)
			WHERE   name = 'MMCONFIG_AUXCOPY_SKIP_UNAVAILABLE_MEDIA'
					AND value = 1)
BEGIN
	INSERT INTO #tblChunksSkippedDueToMediaOutisde
	SELECT	DISTINCT R.adminJobId, R.archFileId, R.commCellId, R.destCopyId, M.BarCode
	FROM	archChunkToReplicate R WITH (READUNCOMMITTED), MMMedia M WITH (READUNCOMMITTED)
	WHERE	R.adminJobId = @i_AuxCopyJobId
AND R.Status IN (0, 3)
			AND R.MediaType != 10001
			AND R.MediaId = M.MediaId
			AND M.MediaLocation NOT IN (1,2) /*LOCATION_SLOT, LOCATION_DRIVE*/
	IF @@ROWCOUNT > 0
	BEGIN
		UPDATE	R
SET		Status = 8,
				Modified = @now
		FROM	archChunkToReplicate R,
				(SELECT	DISTINCT adminJobId, archFileId, commCellId, destCopyId
					FROM	#tblChunksSkippedDueToMediaOutisde
							) T
		WHERE	R.adminJobID = T.adminJobId
				AND R.archFileId = T.archFileId
				AND R.commCellId = T.commCellId
				AND R.destCopyId = T.destCopyId
AND R.Status IN (0, 3)
		DECLARE @NextEvIDTable      TABLE (id int)
		DECLARE @paramEvMsgId INT = 0
		INSERT INTO @NextEvIDTable
			EXECUTE GetNextEventId
		SELECT @paramEvMsgId = id FROM  @NextEvIDTable
		INSERT INTO EvMsg (id, TimeSource, TimeServer, Severity, Ack, Acked, Type,
			ParamNum, MessageId, JobId_h, JobId_l, ClientId, CommcellId,
			UserId, SubSystemId, Client, CommCell, UserName, SubSystem,
			MsgEnglish, RepeatCount, LastOccurrence, NextPost,
			mediaId, driveId, libraryId, maClientId)
			SELECT  @paramEvMsgId, @now, @now, 0, 0, 0, 0,
1, (2722 | (CAST(POWER(2, 24) AS BIGINT) * 62)), 0, @i_AuxCopyJobId, 0, 2,
				1, 0, '', 0, 0, 'JobManager', --user ID is always admin since it's an admin job
				'', 1, @now, 1,
				0, 0, 0, 0
		DECLARE @BarCodes VARCHAR(8000)
		SELECT @BarCodes = COALESCE(@BarCodes + ', ', '') + BarCode
		FROM (SELECT DISTINCT BarCode FROM #tblChunksSkippedDueToMediaOutisde) a
		INSERT INTO EvParam(EvMsgId, EventId, Position, Type, Size, Data)
SELECT @paramEvMsgId, (2722 | (CAST(POWER(2, 24) AS BIGINT) * 62)), 1, 0, 0, @BarCodes
	END
	UPDATE	R
SET		Status = 0,
			Modified = @now
	FROM	archChunkToReplicate R,
			(SELECT	R.adminJobId, R.archFileId, R.commCellId, R.destCopyId
			FROM	archChunkToReplicate R WITH (READUNCOMMITTED), MMMedia M WITH (READUNCOMMITTED)
			WHERE	R.adminJobId = @i_AuxCopyJobId
AND R.Status = 8
					AND R.MediaType != 10001
					AND R.MediaId = M.MediaId
			GROUP BY R.adminJobId, R.archFileId, R.commCellId, R.destCopyId
			HAVING MIN(M.MediaLocation) IN (1,2) AND MAX(MediaLocation) IN (1,2) /*LOCATION_SLOT, LOCATION_DRIVE*/
					) T
	WHERE	R.adminJobID = T.adminJobId
			AND R.archFileId = T.archFileId
			AND R.commCellId = T.commCellId
			AND R.destCopyId = T.destCopyId
AND R.Status  = 8
END
DECLARE	@totalChunks INTEGER = 0
DECLARE	@totalProcessedChunks INTEGER = 0
DECLARE	@totalSentChunks INTEGER = 0
DECLARE	@totalSkippedChunks INTEGER = 0
DECLARE	@totalSkippedAgedChunks INTEGER = 0
DECLARE	@totalSkippedDisabledChunks INTEGER = 0
DECLARE	@totalSkippedMediaOutsideChunks INTEGER = 0
DECLARE	@totalFailedChunks INTEGER = 0
DECLARE	@totalPopulatedChunks INTEGER = 0
SELECT	@totalChunks = COUNT(*),
@totalPopulatedChunks = ISNULL(SUM(CASE WHEN archChunkToReplicate.Status = 0 THEN  1 ELSE 0 END), 0),
@totalSentChunks = ISNULL(SUM(CASE WHEN archChunkToReplicate.Status = 1 THEN  1 ELSE 0 END), 0),
@totalProcessedChunks = ISNULL(SUM(CASE WHEN archChunkToReplicate.Status = 2 THEN  1 WHEN archChunkToReplicate.Status = 9 THEN  1 ELSE 0 END), 0),
@totalSkippedChunks = ISNULL(SUM(CASE WHEN (archChunkToReplicate.Status = 3 AND  (archChunkToReplicate.SkippedCount < @MAX_FAILURE_COUNT OR archChunkToReplicate.ExtraFlags & 64 > 0)
OR archChunkToReplicate.Status = 5 AND  (archChunkToReplicate.SkippedCount < @MAX_FAILURE_COUNT OR archChunkToReplicate.ExtraFlags & 64 > 0)) THEN  1 ELSE 0 END), 0),
@totalSkippedAgedChunks = ISNULL(SUM(CASE WHEN archChunkToReplicate.Status = 6 THEN  1 ELSE 0 END), 0),
@totalSkippedDisabledChunks = ISNULL(SUM(CASE WHEN archChunkToReplicate.Status = 7 THEN  1 ELSE 0 END), 0),
@totalSkippedMediaOutsideChunks = ISNULL(SUM(CASE WHEN archChunkToReplicate.Status = 8 THEN  1 ELSE 0 END), 0),
@totalFailedChunks = ISNULL(SUM(CASE WHEN (archChunkToReplicate.Status = 4
OR archChunkToReplicate.Status = 5 AND archChunkToReplicate.SkippedCount >= @MAX_FAILURE_COUNT AND archChunkToReplicate.ExtraFlags & 64 = 0
OR archChunkToReplicate.Status = 8
OR archChunkToReplicate.Status = 3 AND archChunkToReplicate.SkippedCount >= @MAX_FAILURE_COUNT AND archChunkToReplicate.ExtraFlags & 64 = 0) THEN  1 ELSE 0 END), 0)
FROM	archChunkToReplicate
WHERE	adminJobId = @i_AuxCopyJobId
SELECT	@errorCode = @@ERROR
IF	@errorCode <> 0 GOTO ERR_EXIT
SELECT	@totalChunks = @totalChunks + COUNT(*),
@totalProcessedChunks = @totalProcessedChunks + ISNULL(SUM(CASE WHEN H.Status = 2 THEN  1 WHEN H.Status = 9 THEN  1 ELSE 0 END), 0)
FROM	archChunkToReplicateHistory H WITH (READUNCOMMITTED)
WHERE	adminJobId = @i_AuxCopyJobId
SELECT	@errorCode = @@ERROR
IF	@errorCode <> 0 GOTO ERR_EXIT
-- This function returns following four values
--	DASHCOPY_ARCHMGR_MORE_TO_COPY : We still have some chunks to be copied either in populated state or skipped state with skipped count < 3
--	DASHCOPY_ARCHMGR_JOB_SUCCESS: All chunks are processed
--	DASHCOPY_ARCHMGR_JOB_FAIL: All chunks are failed
--	DASHCOPY_ARCHMGR_JOB_CWE: All chunks are either processed, failed or skipped with skipped count >= 3
DECLARE @attempStartTime INTEGER = 0
DECLARE @dataProcessedInCurrentAttempt INTEGER = 0
DECLARE @totalFailedChunksCurrentAttempt INTEGER = 0
DECLARE @totalSkippedAgedChunksCurrentAttempt INTEGER = 0
SELECT	@attempStartTime = ISNULL(attemptStartTime, 0)
FROM	JMJobInfo
WHERE	JobId = @i_AuxCopyJobId
IF  (@attempStartTime != 0) AND (@i_includeAttemptState = 1)
BEGIN
	IF EXISTS ( SELECT  TOP 1 AC.id
			FROM	ArchChunk AC WITH (READUNCOMMITTED), archChunkMapping ACM WITH (READUNCOMMITTED), JMDataCopiedStatsTable JC WITH (READUNCOMMITTED)
			WHERE	JC.jobId = @i_AuxCopyJobId
				AND JC.archGrpCopyID = ACM.archCopyId
					AND ACM.archChunkId = AC.id
					AND ACM.chunkCommCellId = AC.commCellId
					AND ACM.chunkNumber > 0
					AND AC.createTime >= @attempStartTime)
		SET @dataProcessedInCurrentAttempt = 1
SELECT  @totalSkippedAgedChunksCurrentAttempt = ISNULL( SUM(CASE WHEN archChunkToReplicate.Status = 6 THEN  1 ELSE 0 END), 0),
@totalFailedChunksCurrentAttempt = ISNULL( SUM(CASE WHEN (archChunkToReplicate.Status = 4
OR archChunkToReplicate.Status = 5 AND archChunkToReplicate.SkippedCount >= @MAX_FAILURE_COUNT AND archChunkToReplicate.ExtraFlags & 64 = 0
OR archChunkToReplicate.Status = 8
OR archChunkToReplicate.Status = 3 AND archChunkToReplicate.SkippedCount >= @MAX_FAILURE_COUNT AND archChunkToReplicate.ExtraFlags & 64 = 0 ) THEN  1 ELSE 0 END), 0)
	FROM	archChunkToReplicate
	WHERE	adminJobId = @i_AuxCopyJobId
			AND Modified  >= @attempStartTime
	IF (@totalPopulatedChunks > 0 OR @totalSkippedChunks > 0 OR @totalSentChunks > 0)
	BEGIN
		IF (@totalPopulatedChunks = 0 AND @totalSentChunks = 0)
		BEGIN
			IF  (@dataProcessedInCurrentAttempt = 1)
				SET @jobStatus = 11 --DASHCOPY_ARCHMGR_MORE_TO_COPY_PARTIAL_SUCCESS -- More to process
			ELSE
				SET @jobStatus = 12 --DASHCOPY_ARCHMGR_MORE_TO_COPY_FAILED -- More to process
		END
		ELSE
			SET @jobStatus = 3 --DASHCOPY_ARCHMGR_MORE_TO_COPY -- More to process
	END
	ELSE IF (@totalChunks = @totalProcessedChunks) OR (@dataProcessedInCurrentAttempt = 1 AND @totalSkippedAgedChunksCurrentAttempt = 0 AND @totalFailedChunksCurrentAttempt = 0)
		SET @jobStatus = 4 --DASHCOPY_ARCHMGR_JOB_SUCCESS -- SUCCESS
	ELSE IF (@totalChunks = @totalFailedChunks) OR (@dataProcessedInCurrentAttempt = 0 AND @totalSkippedAgedChunksCurrentAttempt = 0 AND @totalFailedChunksCurrentAttempt > 0)
		SET @jobStatus = 5 --DASHCOPY_ARCHMGR_JOB_FAIL -- FAILED
	ELSE IF (@dataProcessedInCurrentAttempt = 0 AND @totalSkippedAgedChunksCurrentAttempt > 0 AND @totalFailedChunksCurrentAttempt = 0)
		SET @jobStatus = 9 --DASHCOPY_ARCHMGR_JOB_CWW -- CWW
	ELSE IF ( @dataProcessedInCurrentAttempt = 0)
			SET @jobStatus = 5 --DASHCOPY_ARCHMGR_JOB_FAIL -- FAILED
	ELSE
		SET @jobStatus = 6 --DASHCOPY_ARCHMGR_JOB_CWE -- PARTIALSUCCESS
END
ELSE
BEGIN
	IF (@totalPopulatedChunks > 0 OR @totalSkippedChunks > 0 OR @totalSentChunks > 0)
	BEGIN
		IF (@i_includeAttemptState = 0 AND @totalPopulatedChunks = 0 AND @totalSentChunks = 0)
			SET @jobStatus = 10 --DASHCOPY_ARCHMGR_MORE_TO_COPY_ALL_SKIPPED
		ELSE
			SET @jobStatus = 3 --DASHCOPY_ARCHMGR_MORE_TO_COPY -- More to process
	END
	ELSE IF (@totalChunks = @totalProcessedChunks)
		SET @jobStatus = 4 --DASHCOPY_ARCHMGR_JOB_SUCCESS -- SUCCESS
	ELSE IF (@totalChunks = @totalFailedChunks)
		SET @jobStatus = 5 --DASHCOPY_ARCHMGR_JOB_FAIL -- FAILED
	ELSE IF (@totalFailedChunks = 0 AND @totalSkippedChunks = 0 AND (@totalSkippedAgedChunks > 0 OR @totalSkippedDisabledChunks > 0))
		SET @jobStatus = 9 --DASHCOPY_ARCHMGR_JOB_CWW -- CWW
	ELSE
		SET @jobStatus = 6 --DASHCOPY_ARCHMGR_JOB_CWE -- PARTIALSUCCESS
END
ERR_EXIT:
IF object_id('tempdb.dbo.#archChunkToReplicateGetJobStatusResultTable') IS NOT null
BEGIN
	INSERT INTO #archChunkToReplicateGetJobStatusResultTable
	SELECT @errorCode, @jobStatus, @totalSkippedAgedChunks, @totalSkippedDisabledChunks, @totalSkippedMediaOutsideChunks
END
ELSE
BEGIN
	SELECT @errorCode, @jobStatus, @totalSkippedAgedChunks, @totalSkippedDisabledChunks, @totalSkippedMediaOutsideChunks
END
IF OBJECT_ID('tempdb.dbo.#tblChunksSkippedDueToMediaOutisde') IS NOT NULL DROP TABLE #tblChunksSkippedDueToMediaOutisde
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToReplicateGetJobStatus')
	delete from GxQscripts where name = 'archChunkToReplicateGetJobStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToReplicateGetJobStatus')
	delete from GXDBVersions where aliasname = 'archChunkToReplicateGetJobStatus'
GO

insert into GXDBVersions values(2, 'archChunkToReplicateGetJobStatus',  '00010017000200170000', 'archChunkToReplicateGetJobStatus', '00010017000200170000')
GO

