

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToReplicateGetJobProgress.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToReplicateGetJobProgress.sp,v $ $Id: archChunkToReplicateGetJobProgress.sp,v 1.5.2.7 2019/05/09 20:17:24 chandru Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archChunkToReplicateGetJobProgress')
BEGIN
	print '>>> Drop Stored Procedure: archChunkToReplicateGetJobProgress <<<'
	drop procedure archChunkToReplicateGetJobProgress
END
IF EXISTS (select * from GxQscripts where name='archChunkToReplicateGetJobProgress')
	delete from GxQscripts where name = 'archChunkToReplicateGetJobProgress'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToReplicateGetJobProgress')
	delete from GXDBVersions where aliasname = 'archChunkToReplicateGetJobProgress'
GO
print '... Creating Procedure: archChunkToReplicateGetJobProgress'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archChunkToReplicateGetJobProgress
  @i_adminJobId int,
  @i_archCopyId int
AS
  DECLARE @outputXml XML
/*:DECLARE DestCopyId INT
  DECLARE @DestCopyName NVARCHAR(MAX_DEFAULT_REC_SIZE)
  DECLARE @CombinedStreamCount INT
  DECLARE @MaxMultiplexingFactor INT
  DECLARE @SrcCopyId INT
  DECLARE @SrcCopyName NVARCHAR(MAX_DEFAULT_REC_SIZE)
  DECLARE @TotalData bigint
  DECLARE @TotalDataProcessed bigint
  DECLARE @TotalDataTobeProcessed bigint
*/
-- Chunk status
/*
--Values for Status column in archChunkToReplicate table
*/
IF OBJECT_ID('tempdb.dbo.#tmpJobSizeInfo') IS NOT NULL DROP TABLE #tmpJobSizeInfo
IF OBJECT_ID('tempdb.dbo.#tmpChunkInfo') IS NOT NULL DROP TABLE #tmpChunkInfo
DECLARE	@oneConstReal REAL = 1.0
DECLARE @retVal integer
DECLARE @CopyTable TABLE (SrcCopyId INT, DestCopyId INT, TotalData bigint, TotalDataProcessed bigint, TotalDataTobeProcessed bigint)
INSERT INTO @CopyTable
SELECT	T.SrcCopyId, T.DestCopyId, SUM(T.TotalData), SUM(T.TotalDataProcessed), SUM(T.TotalDataTobeProcessed)
FROM
	(SELECT	R.SrcCopyId, R.DestCopyId,
			SUM(
CASE WHEN (R.extraFlags & 4) > 0 THEN
				(CASE WHEN (R.PhysicalStartOffset > R.LogicalOffSet) THEN (R.LogicalOffSet + R.LogicalSize - R.PhysicalStartOffset) ELSE R.LogicalSize END)*@oneConstReal*unCompBytesSize/(CASE WHEN R.LogicalSize > 0 THEN R.LogicalSize ELSE 1 END)
			ELSE
				(CASE WHEN (R.PhysicalStartOffset > R.PhysicalOffset) THEN (R.PhysicalOffset + R.PhysicalSize - R.PhysicalStartOffset) ELSE R.PhysicalSize END)*@oneConstReal*unCompBytesSize/(CASE WHEN R.PhysicalSize > 0 THEN R.PhysicalSize ELSE 1 END)
			END
			) TotalData,
SUM(CASE WHEN ((R.extraFlags & 4) > 0 AND Status = 2) THEN unCompBytesSize ELSE 0 END) TotalDataProcessed,
			0 TotalDataTobeProcessed
	FROM	ArchChunkToReplicate R WITH (READUNCOMMITTED)
	WHERE	R.AdminJobId = @i_adminJobId
			AND (@i_archCopyId = 0 OR R.destCopyId = @i_archCopyId)
	GROUP BY R.SrcCopyId, R.DestCopyId
	UNION ALL
	SELECT	R.SrcCopyId, R.DestCopyId,
			SUM(
CASE WHEN (R.extraFlags & 4) > 0 THEN
				(CASE WHEN (R.PhysicalStartOffset > R.LogicalOffSet) THEN (R.LogicalOffSet + R.LogicalSize - R.PhysicalStartOffset) ELSE R.LogicalSize END)*@oneConstReal*unCompBytesSize/(CASE WHEN R.LogicalSize > 0 THEN R.LogicalSize ELSE 1 END)
			ELSE
				(CASE WHEN (R.PhysicalStartOffset > R.PhysicalOffset) THEN (R.PhysicalOffset + R.PhysicalSize - R.PhysicalStartOffset) ELSE R.PhysicalSize END)*@oneConstReal*unCompBytesSize/(CASE WHEN R.PhysicalSize > 0 THEN R.PhysicalSize ELSE 1 END)
			END
			) TotalData,
SUM(CASE WHEN ((R.extraFlags & 4) > 0 AND Status = 2) THEN unCompBytesSize ELSE 0 END) TotalDataProcessed,
			0 TotalDataTobeProcessed
	FROM	ArchChunkToReplicateHistory R WITH (READUNCOMMITTED)
	WHERE	R.AdminJobId = @i_adminJobId
			AND (@i_archCopyId = 0 OR R.destCopyId = @i_archCopyId)
	GROUP BY R.SrcCopyId, R.DestCopyId) T
GROUP BY T.SrcCopyId, T.DestCopyId
CREATE TABLE #tmpChunkInfo (
		archFileId integer, commCellId integer, destCopyId integer, jobId integer, archChunkId bigint, chunkCommCellId integer, physicalSize bigint, logicalSize bigint, unCompBytesSize bigint)
CREATE TABLE #tmpJobSizeInfo (
	JobId INT, CommCellId INT, totalBackupSize BIGINT, totalAppSize BIGINT, totalIndexSize BIGINT
 	PRIMARY KEY (JobId, CommCellId))
INSERT INTO #tmpChunkInfo
SELECT	ACM.archFileId, ACM.commCellId, ACM.archCopyId, ACM.jobId, ACM.archChunkId, ACM.chunkCommCellId, ACM.physicalSize, ACM.logicalSize, ACM.unCompSize
FROM	archChunkMapping ACM WITH (READUNCOMMITTED), archChunk AC WITH (READUNCOMMITTED),
		(SELECT DISTINCT adminJobId, archFileId, CommCellId, destCopyId
		FROM archChunkToReplicate WITH (READUNCOMMITTED)
		WHERE	adminJobId = @i_adminJobId
		UNION
		SELECT DISTINCT adminJobId, archFileId, CommCellId, destCopyId
		FROM archChunkToReplicateHistory WITH (READUNCOMMITTED)
		WHERE	adminJobId = @i_adminJobId) H
WHERE	H.archFileId = ACM.archFileId
		AND H.commCellId = ACM.commCellId
		AND H.destCopyId = ACM.archCopyId
		AND ACM.archChunkId = AC.id
		AND ACM.chunkCommCellId = AC.commCellId
		AND AC.createTime > (	SELECT	jobStartTime FROM	JMJobInfo WITH (READUNCOMMITTED) WHERE	jobId = @i_adminJobId)
INSERT INTO #tmpJobSizeInfo
SELECT	DISTINCT JobId, CommCellId, 0, 0, 0
FROM #tmpChunkInfo
WHERE	unCompBytesSize = -1
EXEC  @retVal = archGetJobSizeInfo 0
UPDATE	#tmpChunkInfo
SET		unCompBytesSize = (CASE WHEN totalBackupSize > 0 THEN CAST(((@oneConstReal * (totalAppSize+totalIndexSize)*physicalSize)/totalBackupSize) AS BIGINT) ELSE physicalSize END)
FROM	#tmpJobSizeInfo J
WHERE	#tmpChunkInfo.JobId = J.JobId
		AND #tmpChunkInfo.CommCellId = J.CommCellId
		AND #tmpChunkInfo.unCompBytesSize = -1
UPDATE	C
SET		TotalDataProcessed += (	SELECT ISNULL(SUM(unCompBytesSize), 0)
								FROM	#tmpChunkInfo T
								WHERE	T.destCopyId = C.destCopyId)
FROM	@CopyTable C
SET @outputXml =
(
	SELECT
	dataCopied		'@dataCopied',
	totalToCopy		'@dataToBeCopied',
	muxFactor		'@muxFactor',
	destinationNum	'@destinationNum',
	(SELECT
	destCopyId		'@copyId',
	destCopyName	'@copyName'
	FOR XML PATH('destinationCopy'), TYPE),
	(SELECT
	srcCopyId		'@copyId',
	(select name From archGroupCopy(READUNCOMMITTED) where id = srcCopyId) '@copyName'
	FOR XML PATH('sourceCopy'),TYPE)
	FROM
	(
	SELECT	C.DestCopyId 'destCopyId',
			AGCD.name 'destCopyName',
			C.TotalDataProcessed 'dataCopied',
			C.SrcCopyId 'srcCopyId',
			AGCS.name 'srcCopyName',
			C.TotalData 'totalToCopy',
			AGCD.maxStreamNum 'destinationNum',
			ISNULL(GACP.maxMultiplex, AGCD.maxMultiplex) 'muxFactor'
	FROM	@CopyTable C,
			archGroupCopy AGCS,
			archGroupCopy AGCD LEFT OUTER JOIN archGroupCopy GACP
				ON AGCD.destMediaCopyId = GACP.id
AND AGCD.extendedFlags & 2 > 0
AND GACP.extendedFlags & 1 > 0
	WHERE	C.DestCopyId = AGCD.id
			AND C.SrcCopyId = AGCS.id
	UNION
	SELECT	0 'destCopyId',
			'Total' 'destCopyName',
			SUM(C.TotalDataProcessed) 'dataCopied',
			0 'srcCopyId',
			'Total' 'srcCopyName',
			SUM(C.TotalData) 'totalToCopy',
			0 'destinationNum',
			0 'muxFactor'
	FROM	@CopyTable C
	WHERE	@i_archCopyId = 0
	)T
	FOR XML PATH('copyInfo'), ROOT('JobManager_ArchDataInfo')
)
IF @outputXml IS NULL
SET @outputXml = '<JobManager_ArchDataInfo/>'
SELECT @outputXml
IF OBJECT_ID('tempdb.dbo.#tmpJobSizeInfo') IS NOT NULL DROP TABLE #tmpJobSizeInfo
IF OBJECT_ID('tempdb.dbo.#tmpChunkInfo') IS NOT NULL DROP TABLE #tmpChunkInfo
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToReplicateGetJobProgress')
	delete from GxQscripts where name = 'archChunkToReplicateGetJobProgress'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToReplicateGetJobProgress')
	delete from GXDBVersions where aliasname = 'archChunkToReplicateGetJobProgress'
GO

insert into GXDBVersions values(2, 'archChunkToReplicateGetJobProgress',  '00010005000200070000', 'archChunkToReplicateGetJobProgress', '00010005000200070000')
GO

