

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToRefreshInsert.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToRefreshInsert.sp,v $ $Id: archChunkToRefreshInsert.sp,v 1.22.14.4 2020/05/11 15:13:59 cliu Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archChunkToRefreshInsert')
BEGIN
	print '>>> Drop Stored Procedure: archChunkToRefreshInsert <<<'
	drop procedure archChunkToRefreshInsert
END
IF EXISTS (select * from GxQscripts where name='archChunkToRefreshInsert')
	delete from GxQscripts where name = 'archChunkToRefreshInsert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToRefreshInsert')
	delete from GXDBVersions where aliasname = 'archChunkToRefreshInsert'
GO
print '... Creating Procedure: archChunkToRefreshInsert'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archChunkToRefreshInsert
  @i_adminJobId int,
  @i_destCopyId int,
  @i_destStream int,
  @i_srcCopyId int, 
  @i_srcStream int,
  @i_whichCommCell int
AS
  DECLARE @retVal int;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @tblPickedAF TABLE(archFileId INT, commCellId INT)
--DECLARE @tblRequiredMedia TABLE(VolId INT)
DECLARE @tblAFChunk TABLE(
		srcChunkId bigint, archFileId int, commCellId int, srcChunkNumber int,
		physicalOffset bigint, logicalOffset bigint, physicalSize bigint, logicalSize bigint,
		fileMarkerNo int, chunkCreateTime int, chunkVersion int, chunkPhysicalSize bigint, chunkLogicalSize bigint, hwEncKey varchar(114),
		srcVolumeId int, srcMediaId int, srcMediaGroupId int,
		dstStreamNum int, dstFlags int, dstPhysicalSize bigint, dstLogicalSize bigint, dstLastChunkNumber int,
		unCompSize	bigint)
DECLARE @tblAFCopy TABLE(
		archFileId INT, commCellId INT, minPhysicalOffset BIGINT, minLogicalOffset BIGINT, minChunkNumber INT)
DECLARE @tblVol TABLE(
		srcVolumeId int, commCellId int,archFileId int, MaxChunkNumber int, MinChunkNumber int, chunkCount int)
DECLARE	@oneConstReal REAL = 1.0
DECLARE @isGACPCopy INT = 0
-- On SILO enabled copy fail the media refresh job
IF EXISTS (SELECT * FROM archGroupCopy WHERE id = @i_srcCopyId AND siloAppId > 0)
BEGIN
	SELECT	@retVal = -2
	IF	@retVal <> 0 GOTO ERR_EXIT
END
SELECT  @isGACPCopy = 1
FROM archGroupCopy AGC WITH (NOLOCK), archGroup AG WITH (NOLOCK)
WHERE AGC.id = @i_srcCopyId AND AGC.archGroupId = AG.id
AND AG.flags & 16384 = 16384
--Media Which are picked.
--INSERT @tblRequiredMedia
--SELECT	DISTINCT V.VolumeId
--FROM	archFileCopy AFC WITH (NOLOCK), archChunkMapping ACM WITH (NOLOCK), archChunk AC WITH (NOLOCK), MMVolume V WITH (NOLOCK) , archFileCopy AFCSource WITH (NOLOCK)
--WHERE	AFC.archFileId = ACM.archFileId AND AFC.commCellId = ACM.commCellId AND AFC.archCopyId = @i_destCopyId
--	--AND ACM.archCopyId = @i_srcCopyId
--	AND ((@isGACPCopy = 0 AND ACM.archCopyId = @i_srcCopyId)
--		   OR (ACM.archCopyId IN ( SELECT id FROM archGroupCopy WITH (NOLOCK) WHERE destMediaCopyId  = @i_srcCopyId))
--		)
--	AND ACM.archCopyId = AFCSource.archCopyId AND ACM.commCellId = AFCSource.commCellId
--	-- AND ACM.chunkNumber >= AFC.lastChunkNumber
--	AND AFCSource.physicalSize > AFC.physicalSize
--	AND AFC.streamNum > 0 AND (@i_destStream = 0 OR AFC.streamNum = @i_destStream)
--	AND ACM.archChunkId = AC.id AND ACM.chunkCommCellId = AC.commCellId
--	AND (AC.flags & 256) = 0 AND (ACM.flags & 256) = 0
--	AND AC.volumeId = V.VolumeId AND (V.Attributes & 8) <> 0
--	AND (@i_srcStream = 0 OR V.MediaGroupId IN (SELECT mediaGroupId FROM archStream WITH (NOLOCK) WHERE archGroupCopyId = @i_srcCopyId))
---- Added condition "AND AFCSource.physicalSize > AFC.physicalSize"
---- When we susepnd or killed the job entries are already created we just checked that , data is not copied fully for those archfiles
---- Earlier it was in ACM but here we also have condition picked media
---- beacuse of that we do not get complete source archfile size
INSERT @tblPickedAF
SELECT DISTINCT	ACM.archFileId, ACM.commCellId
FROM	archFileCopy AFC WITH (NOLOCK), archChunkMapping ACM WITH (NOLOCK), archChunk AC WITH (NOLOCK), MMVolume V WITH (NOLOCK), archFileCopy AFCSource WITH (NOLOCK)
WHERE	AFC.archFileId = ACM.archFileId AND AFC.commCellId = ACM.commCellId AND AFC.archCopyId = @i_destCopyId
	--AND ACM.archCopyId = @i_srcCopyId
	AND ((@isGACPCopy = 0 AND ACM.archCopyId = @i_srcCopyId)
		   OR (ACM.archCopyId IN ( SELECT id FROM archGroupCopy WITH (NOLOCK) WHERE destMediaCopyId  = @i_srcCopyId))
		)
	AND ACM.archCopyId = AFCSource.archCopyId AND ACM.commCellId = AFCSource.commCellId AND AFCSource.archFileId = AFC.archFileId
	AND ( @i_srcStream = 0 OR AFCSource.streamNum = @i_srcStream)
	-- AND ACM.chunkNumber >= AFC.lastChunkNumber
	AND AFCSource.physicalSize > AFC.physicalSize
	AND AFC.streamNum > 0 AND (@i_destStream = 0 OR AFC.streamNum = @i_destStream)
	AND ACM.archChunkId = AC.id AND ACM.chunkCommCellId = AC.commCellId
	AND (AC.flags & 256) = 0 AND (ACM.flags & 256) = 0
	AND AC.volumeId = V.VolumeId AND (V.Attributes & 8) <> 0
	AND (@i_srcStream = 0 OR V.MediaGroupId IN (SELECT mediaGroupId FROM archStream WITH (NOLOCK) WHERE archGroupCopyId = @i_srcCopyId))
-- Validation query for checking some statistics which should match with archfilecopy table data
IF EXISTS (	SELECT *
		FROM archFileCopy AFC WITH (NOLOCK),
		(SELECT ACM.archCopyId, ACM.archFileId, ACM.commCellId,
				SUM(ACM.physicalSize) TotalACMPhysicalSize , SUM(ACM.logicalSize) TotalACMLogicalSize,
				MAX(ACM.chunkNumber) MaxChunkNumber, COUNT(ACM.archChunkId) ChunkCount
			FROM archChunkMapping ACM WITH (NOLOCK),   @tblPickedAF PAF
		WHERE ACM.archFileId = PAF.archFileId AND ACM.commCellId = PAF.commCellId
		AND ACM.archCopyId = @i_srcCopyId
	GROUP BY  ACM.archcopyId, ACM.archFileId , ACM.commCellId) T
		WHERE AFC.archCopyId = T.archCopyId
			AND AFC.archFileId = T.archFileId
			AND AFC.commCellId = T.commCellId
			AND (AFC.physicalSize <> T.TotalACMPhysicalSize
				OR AFC.logicalSize <> T.TotalACMLogicalSize
				OR AFC.lastChunkNumber <> T.MaxChunkNumber
				OR AFC.lastChunkNumber <> T.ChunkCount )
			)
BEGIN
	SELECT	@retVal = -10
	IF	@retVal <> 0 GOTO ERR_EXIT
END
-- Here we are only validating physicalOffset and PhysicalSize of chunk.
IF EXISTS (	SELECT  *
				FROM ( SELECT ROW_NUMBER() OVER(PARTITION BY ACM.archfileId ORDER BY ACM.archfileid, ACM.physicaloffset) RNP , ACM.*
					FROM archChunkMapping ACM, @tblPickedAF PAF
					WHERE ACM.archCopyId = @i_srcCopyId
						AND ACM.archfileid = PAF.archFileId
						AND ACM.commCellId = PAF.commCellId ) T
				WHERE T.RNP - chunkNumber <> 0)
BEGIN
	SELECT	@retVal = -10
	IF	@retVal <> 0 GOTO ERR_EXIT
END
IF EXISTS (	SELECT T.archCopyId, T.archFileId
				FROM ( SELECT  (AFC.lastChunkNumber - ACM.chunkNumber)*ACM.physicalSize product,  ACM.archCopyId, ACM.archFileId, ACM.physicalOffset
						FROM archChunkMapping ACM , archFileCopy AFC, @tblPickedAF PAF
						WHERE ACM.archCopyId = @i_srcCopyId
							AND ACM.archfileid = PAF.archFileId
							AND ACM.commCellId = PAF.commCellId
							AND ACM.archCopyId = AFC.archCopyId
							AND ACM.archFileId = AFC.archFileId
							AND ACM.commcellId = AFC.commCellId ) T
				GROUP BY T.archCopyId, T.archFileId
				HAVING SUM(T.physicalOffset) <> SUM(T.product)
			)
BEGIN
	SELECT	@retVal = -10
	IF	@retVal <> 0 GOTO ERR_EXIT
END
---- Okay, we will run media dependency here again. We should not attempting to refresh chunks from partial media list.
---- Example:
---- 1. Say the user picked media M1,M2 & M3 for refresh. These media are dependent (common afiles between them). M1,M2 & M3 afiles were
----    picked during the first attempt of refresh - entries in AFC table.
---- 2. Now, this refresh job was either stopped or went into pending. Then media M2 was either exported or marked bad.
---- 3. When a new run refresh is run we will skip adding archive files from these media since they fail dependency check. Also there is no
----    need to add up Afiles from these volumes, since they are already present in AFC table.
---- 4. Here where we pick chunks from volumes that satisfy the dependency criteria.
-- We are calling dependency check SP at many places. Optimize this.
--IF  object_id('tempdb.dbo.#TmpMRDepMediaUI') IS  NOT null DROP TABLE #TmpMRDepMediaUI
--IF object_id('tempdb.dbo.#TmpMRDepMediaResultSet') IS  NOT null DROP TABLE #TmpMRDepMediaResultSet
--CREATE TABLE #TmpMRDepMediaUI(VolumeId INT)
--CREATE TABLE #TmpMRDepMediaResultSet(BucketId INT, VolumeId INT, VolumeFlags INT,VolumeAttributes INT,
--		MediaId INT, MediaLocation INT, MediaFlags INT)
--DECLARE	@depMediaOp		INT
--INSERT INTO #TmpMRDepMediaUI
--SELECT	DISTINCT VolId
--FROM @tblRequiredMedia
-- Get dependent media list for input media.
--EXEC @depMediaOp = archMediaRefreshGetDependentMedia
--IF @depMediaOp <> 0
--BEGIN
--	SET @retVal  = @depMediaOp
--	GOTO ERR_EXIT
--END
--ELSE
--BEGIN
--    INSERT @tblRequiredMedia
--	SELECT T.VolumeId
--		FROM #TmpMRDepMediaResultSet T
--		LEFT OUTER JOIN
--	@tblRequiredMedia R
--	ON T.VolumeId = R.VolId
--	WHERE R.VolId IS NULL
-- Delete AFiles from volumes that are either bad or exported or not picked.
--  DELETE FROM @tblAFChunk
--  WHERE	srcVolumeId IN ( SELECT DISTINCT V.srcVolumeId
--						  FROM	#TmpMRDepMediaResultSet	RS1
--						  JOIN	#TmpMRDepMediaResultSet	RS2
--							ON	RS1.BucketId = RS2.BucketId
--						  JOIN	@tblVol	V
--							ON	V.srcVolumeId = RS2.VolumeId
--						  WHERE	RS1.MediaFlags = 2 -- Bad media
--								--Not required below conditions
--								--OR RS1.MediaLocation  = 3 -- Exported
--								--OR (RS1.VolumeAttributes & (MMS2_VOLUME_PICKED_FOR_REFRESHING | MMS2_VOLUME_PREVENT_FOR_REFRESHING)) <> --MMS2_VOLUME_PICKED_FOR_REFRESHING
--								--OR RS1.VolumeFlags <> 2
--						)
--
--END
--DROP TABLE #TmpMRDepMediaUI
--DROP TABLE #TmpMRDepMediaResultSet
INSERT INTO @tblAFChunk
SELECT	ACM.archChunkId, ACM.archFileId, ACM.commCellId, ACM.chunkNumber, ACM.physicalOffset, ACM.logicalOffset, ACM.physicalSize, ACM.logicalSize,
		AC.fileMarkerNo, AC.createTime, AC.version, AC.physicalSize, AC.logicalSize, AC.hwEncKey,
		V.VolumeId, V.MediaId, V.MediaGroupId,
		AFC.streamNum, AFC.flags, AFC.physicalSize, AFC.logicalSize, AFC.lastChunkNumber, ACM.unCompSize
FROM	archFileCopy AFC WITH (NOLOCK), archChunkMapping ACM WITH (NOLOCK), archChunk AC WITH (NOLOCK), MMVolume V WITH (NOLOCK), archFileCopy AFCS
WHERE	AFC.archFileId = ACM.archFileId AND AFC.commCellId = ACM.commCellId AND AFC.archCopyId = @i_destCopyId AND AFC.archFileId = AFCS.archFileId AND AFC.commCellId = AFCS.commCellId
	 AND AFCS.archCopyId = ACM.archCopyId AND ( @i_srcStream = 0 OR AFCS.streamNum = @i_srcStream)
	--AND ACM.archCopyId = @i_srcCopyId
	AND ((@isGACPCopy = 0 AND ACM.archCopyId = @i_srcCopyId)
		   OR (ACM.archCopyId IN ( SELECT id FROM archGroupCopy WITH (NOLOCK) WHERE destMediaCopyId  = @i_srcCopyId))
		)
	-- AND ACM.chunkNumber >= AFC.lastChunkNumber
	AND (ACM.physicalOffSet + ACM.physicalSize) > AFC.physicalSize
	AND AFC.streamNum > 0 AND (@i_destStream = 0 OR AFC.streamNum = @i_destStream)
	AND ACM.archChunkId = AC.id AND ACM.chunkCommCellId = AC.commCellId
	AND (AC.flags & 256) = 0 AND (ACM.flags & 256) = 0
	AND AC.volumeId = V.VolumeId -- AND (V.Attributes & 8) <> 0
	AND (@i_srcStream = 0 OR V.MediaGroupId IN (SELECT mediaGroupId FROM archStream WITH (NOLOCK) WHERE archGroupCopyId = @i_srcCopyId))
--	AND RM.VolId = V.VolumeId
--	AND PAF.archFileId = AFC.archFileId AND PAF.commCellId = AFC.commCellId
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
INSERT INTO @tblVol
SELECT	srcVolumeId, commCellId, archFileId, MAX(srcChunkNumber), MIN(srcChunkNumber), COUNT(*)
FROM	@tblAFChunk
GROUP BY srcVolumeId, commCellId, archFileId
--Delete all the volumes where archive files with holes in chunk sequence exist
-- This change is not required
--DELETE FROM @tblAFChunk
--WHERE	srcVolumeId IN (
--				SELECT	srcVolumeId
--				FROM	@tblVol
--				WHERE (MaxChunkNumber - MinChunkNumber - chunkCount + 1) <> 0
--			)
-- If there is hole in chunk sequence for given file across volumes selected then media refresh job
-- can do one volume at a time
--IF EXISTS (SELECT	commCellId, archFileId
--			FROM	@tblVol
--			GROUP BY commCellId, archFileId
--			HAVING  (MAX(MaxChunkNumber)-MIN(MinChunkNumber)-SUM(chunkCount)+1) <> 0)
--BEGIN
--	DELETE FROM @tblAFChunk
--	WHERE	srcVolumeId > (SELECT	MIN(srcVolumeId)
--					FROM	@tblVol
--					WHERE (MaxChunkNumber - MinChunkNumber - chunkCount + 1) = 0)
--END
-- For Now commenting the code which handles the holes in archfile in an volume
-- But later we will revisit this code and we already have MR 122198 for this issue.
---- We can get holes in archfiles which belongs to one volume ( ex: v1( chunk1 ... chunk3 , chunk7....chunk10), v2(chunk4....chunk6))
---- In this case we are inserting only the first set of chunk from that ordered volume for the archfile
---- Below logic is basically we are comparing the chunknumbers  for each volume, if we get the next chunknumber greater than previous with difference > 1
---- then we delete all the chunk for that volume as well ass other volume
---- which end up having the chunks (v1chunk1 ... chunk3) for the archfile
--IF EXISTS (	SELECT	srcVolumeId
--				FROM	@tblVol
--				WHERE (MaxChunkNumber - MinChunkNumber - chunkCount + 1) <> 0)
--BEGIN
--
--			 DELETE @tblAFChunk
--			 FROM @tblAFChunk  AFC, (
--				SELECT	archFileId, MIN(srcVolumeId) volid
--				FROM	@tblVol
--				WHERE (MaxChunkNumber - MinChunkNumber - chunkCount + 1) <> 0
--				GROUP BY archFileId) Vol
--				WHERE AFC.archFileId = Vol.archFileId AND AFC.srcVolumeId > volid
--
--			DELETE @tblVol
--			 FROM @tblVol  AFC, (
--				SELECT	archFileId, MIN(srcVolumeId) volid
--				FROM	@tblVol
--				WHERE (MaxChunkNumber - MinChunkNumber - chunkCount + 1) <> 0
--				GROUP BY archFileId) Vol
--				WHERE AFC.archFileId = Vol.archFileId AND AFC.srcVolumeId > volid
--
--			;WITH Volume_Holes(archfileId,  chunkNumber, volumeid, commcellid, sn) AS
--			(
--				SELECT AFC.archFileId, AFC.srcChunkNumber,  AFC.srcVolumeId, AFC.commCellId , ROW_NUMBER() OVER (ORDER BY AFC.archfileid, AFC.srcChunkNumber ) AS sn
--				FROM @tblAFChunk AFC ,( SELECT *
--				FROM @tblVol
--				WHERE (MaxChunkNumber - MinChunkNumber - chunkCount + 1) <> 0) H
--				WHERE AFC.archFileId = H.archFileId AND AFC.srcVolumeId = H.srcVolumeId
--			)
--
--			DELETE @tblAFChunk
--			FROM @tblAFChunk AFC , (
--			SELECT V.commcellid,  V.archfileId, V.volumeid , MIN(V.chunkNumber) ChunkNumber
--			FROM (
--			SELECT VLead.commcellid, VLead.archfileId , V.chunkNumber, V.volumeid
--			FROM Volume_Holes VLead JOIN  Volume_Holes V
--			ON VLead.archfileId = V.archfileId AND  VLead.commcellid = V.commcellid AND  V.volumeid = VLead.volumeid AND VLead.sn = V.sn + 1
--			WHERE VLead.chunkNumber - V.chunkNumber <> 1 ) V
--			GROUP BY V.commcellid,  V.archfileId, V.volumeid) T
--			WHERE AFC.archFileId = T.archfileId AND AFC.commCellId = T.commcellId AND AFC.srcVolumeId = T.volumeid AND AFC.srcChunkId > T.ChunkNumber
--END
--
----If we have only volumes with archfiles containing chunk holes then exit
--IF EXISTS (
--			SELECT	srcVolumeId, commCellId, archFileId
--			FROM	@tblVol
--			WHERE (MaxChunkNumber - MinChunkNumber - chunkCount + 1) <> 0
--		)
--	AND NOT EXISTS (SELECT * FROM @tblAFChunk)
--BEGIN
--	SELECT	@retVal = -1
--	IF	@retVal <> 0 GOTO ERR_EXIT
--END
-- Adjust the size and lastChunkNumber of archFileCopy entries.
INSERT	INTO @tblAFCopy
SELECT	archFileId, commCellId, MIN(physicalOffset), MIN(logicalOffset), MIN(srcChunkNumber)
FROM	@tblAFChunk
GROUP BY archFileId, commCellId
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
DELETE	@tblAFCopy
FROM	@tblAFCopy T, archFileCopy AFC WITH (NOLOCK)
WHERE	AFC.archFileId = T.archFileId AND AFC.commCellId = T.commCellId AND AFC.archCopyId = @i_destCopyId
	AND AFC.physicalSize = T.minPhysicalOffset AND AFC.logicalSize = T.minLogicalOffset AND AFC.lastChunkNumber = T.minChunkNumber
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
-- This part of code not required as what ever the size updation is not a part of archchunktorefreshinsert
-- and if somehow we get some incomplete set of chunks then we end up updating the archfile with size which leads to copy only some data or partial data
--IF EXISTS (SELECT archFileId FROM @tblAFChunk)
--BEGIN
--	UPDATE	archFileCopy
--	SET		physicalSize = T.minPhysicalOffset, logicalSize = T.minLogicalOffset, lastChunkNumber = (T.minChunkNumber - 1)
--	FROM	@tblAFCopy T, archFileCopy AFC WITH (NOLOCK)
--	WHERE	AFC.archFileId = T.archFileId AND AFC.commCellId = T.commCellId AND AFC.archCopyId = @i_destCopyId
--			AND NOT EXISTS (SELECT	*
--							FROM	archChunkMapping ACM
--							WHERE	ACM.archFileId = AFC.archFileId AND ACM.CommCellId = AFC.CommCellId
--									AND ACM.archCopyId = @i_destCopyId)
--	SELECT	@retVal = @@ERROR
--	IF	@retVal <> 0 GOTO ERR_EXIT
--	UPDATE	@tblAFChunk
--	SET		dstPhysicalSize = T.minPhysicalOffset, dstLogicalSize = T.minLogicalOffset, dstLastChunkNumber = T.minChunkNumber
--	FROM	@tblAFCopy T, @tblAFChunk AFC
--	WHERE	AFC.archFileId = T.archFileId AND AFC.commCellId = T.commCellId
--			AND NOT EXISTS (SELECT	*
--							FROM	archChunkMapping ACM
--							WHERE	ACM.archFileId = AFC.archFileId AND ACM.CommCellId = AFC.CommCellId
--									AND ACM.archCopyId = @i_destCopyId)
--	SELECT	@retVal = @@ERROR
--	IF	@retVal <> 0 GOTO ERR_EXIT
--END
---- Remove chunks after holes in the refreshing archive files. These removed chunks will be repopulated after the chunks before the holes
---- have been copied and the size and lastChunkNumber of archFileCopy entries are adjusted.
---- This is critical to ensure that chunks are copied in correct order.
--DELETE	@tblAFChunk
--FROM	@tblAFChunk A,
--		(SELECT	ACM.archFileId, ACM.commCellId, MIN(ACM.chunkNumber) AS chunkNumber
--		FROM	archChunkMapping ACM WITH (NOLOCK) LEFT OUTER JOIN @tblAFChunk T
--			ON  ACM.archFileId = T.archFileId AND ACM.commCellId = T.commCellId AND ACM.archCopyId = @i_srcCopyId
--		WHERE	T.archFileId IS null
--		GROUP BY ACM.archFileId, ACM.commCellId) B
--WHERE	A.archFileId = B.archFileId AND A.commCellId = B.commCellId AND A.srcChunkNumber > B.chunkNumber
--SELECT	@retVal = @@ERROR
--IF	@retVal <> 0 GOTO ERR_EXIT
DECLARE @l_commCellId	int
IF @i_whichCommCell = 1
	SET @l_commCellId = (SELECT ISNULL(MIN(commCellId), 2) FROM @tblAFChunk)
ELSE
IF @i_whichCommCell = 2
	SET @l_commCellId = (SELECT ISNULL(MAX(commCellId), 2) FROM @tblAFChunk)
ELSE
	SET @l_commCellId = 2
DELETE FROM @tblAFChunk WHERE commCellId <> @l_commCellId
-- Re-populate archChunkToCopy table for @i_destCopyId
--DELETE FROM archChunkToCopy
--WHERE	destCopyId = @i_destCopyId
--	AND (@i_destStream = 0 OR destStream = @i_destStream)
--	AND (@i_srcStream = 0 OR streamNum = @i_srcStream)
IF @i_srcStream = 0 AND @i_destStream = 0
BEGIN
    WHILE 1 = 1
	BEGIN
		DELETE TOP (10000) FROM archChunkToCopy
		WHERE   destCopyId = @i_destCopyId
		IF @@ROWCOUNT = 0
			BREAK
	END
END
ELSE
BEGIN
    DELETE archChunkToCopy
    FROM archChunkToCopy A,
    (SELECT archFileId, commCellId
     FROM  @tblAFChunk) B
    WHERE A.archFileId = B.archFileId
    AND A.commCellId = B.commCellId
    AND A.destCopyId = @i_destCopyId
END
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
INSERT	INTO archChunkToCopy
SELECT	@i_destCopyId, a.dstStreamNum, @i_adminJobId, 0, 0, a.srcChunkId, a.archFileId, a.commCellId,
		@i_srcCopyId, b.streamNum, 0, b.flags, b.encKeyType, b.lastChunkNumber,
		a.srcChunkNumber, a.physicalOffset, a.logicalOffset, a.physicalSize, a.logicalSize,
		a.srcVolumeId, a.srcMediaId, a.srcMediaGroupId,
		a.fileMarkerNo,	a.chunkCreateTime, a.chunkVersion, a.chunkPhysicalSize, a.chunkLogicalSize, a.hwEncKey,	b.encKey, 0, 0, a.unCompSize
FROM	@tblAFChunk a, archFileCopy b WITH (NOLOCK)
WHERE	b.archFileId = a.archFileId AND b.commCellId = a.commCellId
  --AND b.archCopyId = @i_srcCopyId
  AND ((@isGACPCopy = 0 AND b.archCopyId = @i_srcCopyId)
		   OR (b.archCopyId IN ( SELECT id FROM archGroupCopy WITH (NOLOCK) WHERE destMediaCopyId  = @i_srcCopyId))
		)
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
UPDATE	archChunkToCopy
SET		fileType = b.fileType, appId = b.appId, backupJobId = b.jobId
FROM	archChunkToCopy a, archFile b WITH (NOLOCK)
WHERE	b.id = a.archFileId AND b.commCellId = a.commCellId
CREATE TABLE #tmpJobSizeInfo (
	JobId INT, CommCellId INT, totalBackupSize BIGINT, totalAppSize BIGINT, totalIndexSize BIGINT
 	PRIMARY KEY (JobId, CommCellId))
INSERT INTO #tmpJobSizeInfo
SELECT	DISTINCT backupJobId, CommCellId, 0, 0, 0
FROM archChunkToCopy
WHERE adminJobId = @i_adminJobId
	AND destCopyId = @i_destCopyId
	AND archCopyId = @i_srcCopyId
	AND (@i_srcStream = 0 or streamNum = @i_srcStream)
	AND (@i_destStream = 0 or destStream = @i_destStream)
	AND unCompBytesSize = -1
EXEC  @retVal = archGetJobSizeInfo 0
UPDATE	archChunkToCopy
SET		unCompBytesSize = (CASE WHEN totalBackupSize > 0 THEN CAST(((@oneConstReal * (totalAppSize+totalIndexSize)*physicalSize)/totalBackupSize) AS BIGINT) ELSE physicalSize END)
FROM	#tmpJobSizeInfo J
WHERE	adminJobId = @i_adminJobId
		AND destCopyId = @i_destCopyId
		AND archCopyId = @i_srcCopyId
		AND (@i_srcStream = 0 or streamNum = @i_srcStream)
		AND (@i_destStream = 0 or destStream = @i_destStream)
		AND archChunkToCopy.backupJobId = J.JobId
		AND archChunkToCopy.CommCellId = J.CommCellId
		AND archChunkToCopy.unCompBytesSize = -1
-- Adjust hwEncKey based on media
UPDATE	R
SET		chunkHwEncKey = M.hwEncKey
FROM	archChunkToCopy R WITH (READUNCOMMITTED), MMMedia M WITH (READUNCOMMITTED), ArchChunk chunk WITH (READUNCOMMITTED)
WHERE	R.adminJobId = @i_adminJobId
		AND R.destCopyId = @i_destCopyId
		AND R.archCopyId = @i_srcCopyId
		AND (@i_srcStream = 0 or R.streamNum = @i_srcStream)
		AND (@i_destStream = 0 or R.destStream = @i_destStream)
		AND R.MediaId = M.MediaId
		AND M.MediaTypeId != 10001
		AND R.chunkHwEncKey = ''
		AND	R.ArchChunkId = chunk.Id
		AND	R.CommCellId = chunk.CommCellId
AND chunk.flags & 1048576 > 0
SELECT	@retVal = @@ERROR
ERR_EXIT:
SELECT @retVal
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToRefreshInsert')
	delete from GxQscripts where name = 'archChunkToRefreshInsert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToRefreshInsert')
	delete from GXDBVersions where aliasname = 'archChunkToRefreshInsert'
GO

insert into GXDBVersions values(2, 'archChunkToRefreshInsert',  '00010022001400040000', 'archChunkToRefreshInsert', '00010022001400040000')
GO

