

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToRecoverDDBSegment.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchChunkToRecoverDDBSegment.sp,v $ $Id: ArchChunkToRecoverDDBSegment.sp,v 1.1.2.3 2018/03/30 00:51:22 chandru Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ArchChunkToRecoverDDBSegment')
BEGIN
	print '>>> Drop Stored Procedure: ArchChunkToRecoverDDBSegment <<<'
	drop procedure ArchChunkToRecoverDDBSegment
END
IF EXISTS (select * from GxQscripts where name='ArchChunkToRecoverDDBSegment')
	delete from GxQscripts where name = 'ArchChunkToRecoverDDBSegment'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchChunkToRecoverDDBSegment')
	delete from GXDBVersions where aliasname = 'ArchChunkToRecoverDDBSegment'
GO
print '... Creating Procedure: ArchChunkToRecoverDDBSegment'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ArchChunkToRecoverDDBSegment
  @i_adminJobId int,
  @i_archCopyId int,
  @i_minSegmentSize int
AS
  DECLARE @o_error integer;
  DECLARE @o_errorString varchar(1024);
  DECLARE @o_lastSegmentId integer;
SET NOCOUNT ON
BEGIN TRAN ArchChunkToRecoverDDBSeg_tran
	IF object_id('tempdb.dbo.#tblChunkToRecoverDDB') IS NOT NULL DROP TABLE #tblChunkToRecoverDDB
	IF object_id('tempdb.dbo.#tblChunkInSegment') IS NOT NULL DROP TABLE #tblChunkInSegment
	DECLARE	@cursor	INTEGER
	DECLARE	@errVal	INTEGER
	DECLARE	@errStr	VARCHAR(1024)
	DECLARE @segmentId	INTEGER
	SET @segmentId = 0
	SET @errVal = 0
	SET @errStr = 'NO ERROR'
	SET @cursor = 0
	create table #tblChunkToRecoverDDB (
		id					integer IDENTITY (1,1),
		SrcCopyId			integer,
		volumeId			integer,
		mediaGroupId		integer,
		srcStreamNum		integer,
		chunkCount			integer,
		segmentID			integer,
		primary key (id)
	)
	create index tblChunkToRecoverDDB_volumeId_Idx on #tblChunkToRecoverDDB (volumeId)
	create table #tblChunkInSegment (
		id					integer,
		SrcCopyId			integer,
		volumeId			integer,
		mediaGroupId		integer,
		srcStreamNum		integer,
		chunkCount			integer,
		segmentID			integer,
		primary key (id)
	)
	create index tblChunkInSegment_volumeId_Idx on #tblChunkInSegment (volumeId)
	-- If DSA flag is not set on the copy, set segment as the source copy archstream
	IF EXISTS (SELECT * FROM ArchGroup sp WITH (NOLOCK), ArchGroupCopy copy WITH (NOLOCK)
				WHERE copy.Id = @i_archCopyId
				AND		copy.ArchGroupId = sp.Id
AND		(sp.flags & 131072/*CVA_SP_DYNAMIC_STREAM_ALLOCATION_FLAG*/) = 0)
	BEGIN
		INSERT INTO ArchChunkToRecoverDDBSegmentTable (ArchCopyId, MediaGroupId)
		SELECT	T.SrcCopyId, T.MediaGroupId
		FROM	(SELECT DISTINCT A.SrcCopyId, A.MediaGroupId
				FROM ArchChunkToRecoverDDB a WITH (NOLOCK)
				WHERE a.adminJobId = @i_adminJobId
				AND a.srcCopyId = @i_archCopyId
				AND a.segmentId = 0) T LEFT OUTER JOIN ArchChunkToRecoverDDBSegmentTable S
					ON	T.SrcCopyId = S.ArchCopyId
						AND T.MediaGroupId = S.MediaGroupId
		WHERE	S.ArchCopyId IS NULL
		UPDATE ArchChunkToRecoverDDB
		SET	segmentId = S.SegmentId
		FROM ArchChunkToRecoverDDB a, ArchChunkToRecoverDDBSegmentTable S
		WHERE a.adminJobId = @i_adminJobId
		AND a.SrcCopyId = @i_archCopyId
		AND a.segmentId = 0
		AND S.ArchCopyId = A.SrcCopyId
		AND S.MediaGroupId = A.MediaGroupId
		SELECT	@segmentId = MAX(segmentId)
		FROM	ArchChunkToRecoverDDB a
		WHERE	a.adminJobId = @i_adminJobId
				AND a.srcCopyId = @i_archCopyId
		GOTO CX_EXIT
	END
	IF @i_minSegmentSize = 0
		SET @i_minSegmentSize = 1000
	INSERT INTO #tblChunkToRecoverDDB
	SELECT a.SrcCopyId, a.volumeId, a.mediaGroupId, a.srcStreamNum, a.chunksCount, 0
	FROM ArchChunkToRecoverDDB a WITH (NOLOCK)
	WHERE a.adminJobId = @i_adminJobId
	AND a.srcCopyId = @i_archCopyId
	AND a.segmentId = 0
	IF @@ROWCOUNT = 0
		GOTO CX_EXIT
	-- Clear source stream and media group info
	UPDATE ArchChunkToRecoverDDB
	SET SrcStreamNum = 0
	FROM ArchChunkToRecoverDDB a, #tblChunkToRecoverDDB b
	WHERE  a.adminJobId = @i_adminJobId
	AND a.volumeId = b.volumeId
	AND a.SrcCopyId = @i_archCopyId
	AND a.SrcCopyId = b.SrcCopyId
	SELECT @errVal = @@ERROR
	IF @errVal <> 0
	BEGIN
			SET @errStr = 'Failed to clear streams for ArchChunkToRecoverDDB: DB error!'
			GOTO CX_EXIT_ERROR
	END
	DECLARE @volumeId		INTEGER
	DECLARE @SrcCopyId		INTEGER
	DECLARE @mediaGroupId	INTEGER
	DECLARE @srcStreamNum		INTEGER
	DECLARE @mediaGroupId_prev INTEGER
	SET @mediaGroupId_prev = -1
	DECLARE @srcStream_prev INTEGER
	SET @srcStream_prev = -1
	DECLARE AFCursor CURSOR LOCAL FOR
			SELECT DISTINCT SrcCopyId, volumeId, mediaGroupId, srcStreamNum
			FROM #tblChunkToRecoverDDB
			ORDER BY SrcCopyId, mediaGroupId, volumeId
	OPEN AFCursor
	SET @cursor = 1
	FETCH NEXT from AFCursor INTO @SrcCopyId, @volumeId, @mediaGroupId, @srcStreamNum
	WHILE (1 = 1)
	BEGIN
		DECLARE @fetchNext INTEGER
		SET @fetchNext = 1
		IF @@FETCH_STATUS <> 0
			GOTO CREATE_SEGMENT
		IF EXISTS (select * from #tblChunkToRecoverDDB WITH (NOLOCK)
					where  volumeId = @volumeId
					and SrcCopyId = @SrcCopyId
					and segmentId > 0
					)
			GOTO FETCH_NEXT
		IF @mediaGroupId_prev < 0
			SET @mediaGroupId_prev = @mediaGroupId
		IF @srcStream_prev < 0
			SET @srcStream_prev = @srcStreamNum
		IF @mediaGroupId_prev <> @mediaGroupId
		BEGIN
			-- MediaGroupId changed, needs to group previous chunks
			-- This archive file will be processed again
			SET @mediaGroupId_prev = @mediaGroupId
			SET @fetchNext = 0
			GOTO CREATE_SEGMENT
		END
		IF @srcStream_prev <> @srcStreamNum
		BEGIN
			-- destStreamNum changed, needs to group previous chunks
			-- This archive file will be processed again
			SET @srcStream_prev = @srcStreamNum
			SET @fetchNext = 0
			GOTO CREATE_SEGMENT
		END
		-- Set flag for all chunks of given archive file
		INSERT INTO #tblChunkInSegment
		SELECT a.*
		FROM #tblChunkToRecoverDDB a LEFT OUTER JOIN #tblChunkInSegment b ON a.id = b.id
		WHERE a.volumeId = @volumeId
		AND b.id IS NULL
		-- No new chunks of this archive file found
		IF @@ROWCOUNT = 0
			GOTO FETCH_NEXT
		WHILE (1 = 1)
		BEGIN
			DECLARE @sumSegmentSize bigint = 0
			SET @sumSegmentSize = (SELECT SUM(chunkCount) FROM #tblChunkInSegment)
			IF @sumSegmentSize < @i_minSegmentSize
			BEGIN
				GOTO FETCH_NEXT
			END
			ELSE
				BREAK;
		END
CREATE_SEGMENT:
		IF EXISTS (SELECT * FROM #tblChunkInSegment)
		BEGIN
			INSERT INTO ArchChunkToRecoverDDBSegmentTable (ArchCopyId, MediaGroupId)
			SELECT @i_archCopyId, 0
			SELECT @errVal = @@ERROR, @segmentId = @@IDENTITY
			IF @errVal <> 0 OR @segmentId = 0
			BEGIN
					SET @errStr = 'Failed to create new segment for data verification: DB error!'
					GOTO CX_EXIT_ERROR
			END
            DELETE FROM ArchChunkToRecoverDDBSegmentTable WITH (ROWLOCK)
            WHERE segmentId = @segmentId
            SELECT @errVal = @@ERROR
            IF @errVal <> 0
            BEGIN
                SET @errStr = 'Failed to delete segment ID for data verification: DB error!'
                GOTO CX_EXIT_ERROR
            END
			UPDATE #tblChunkToRecoverDDB
			SET segmentId = @segmentId
			FROM #tblChunkToRecoverDDB a, #tblChunkInSegment b
			WHERE  a.volumeId = b.volumeId
			AND a.SrcCopyId = b.SrcCopyId
			SELECT @errVal = @@ERROR
			IF @errVal <> 0
			BEGIN
					SET @errStr = 'Failed to update segmentId for ArchChunkToRecoverDDB: DB error!'
					GOTO CX_EXIT_ERROR
			END
			-- Clear temp table
			DELETE FROM #tblChunkInSegment
		END
		IF @@FETCH_STATUS <> 0
			GOTO CX_EXIT
FETCH_NEXT:
		IF @fetchNext = 1
			FETCH NEXT from AFCursor INTO @SrcCopyId, @volumeId, @mediaGroupId, @srcStreamNum
	END
CX_EXIT:
	UPDATE ArchChunkToRecoverDDB
	SET segmentId = b.segmentId
	FROM ArchChunkToRecoverDDB a, #tblChunkToRecoverDDB b
	WHERE  a.adminJobId = @i_adminJobId
	AND a.volumeId = b.volumeId
	AND a.SrcCopyId = b.SrcCopyId
	IF object_id('tempdb.dbo.#tblChunkToRecoverDDB') IS NOT NULL DROP TABLE #tblChunkToRecoverDDB
	IF object_id('tempdb.dbo.#tblChunkInSegment') IS NOT NULL DROP TABLE #tblChunkInSegment
	IF @cursor = 1
	BEGIN
		CLOSE AFCursor
		DEALLOCATE AFCursor
	END
	-- for parallel copy i might have reused segment id from other parallel copy
	IF (@segmentId = 0)
	BEGIN
		SELECT	@segmentId = MAX(segmentId)
		FROM	ArchChunkToRecoverDDB a
		WHERE	a.adminJobId = @i_adminJobId
				AND a.srcCopyId = @i_archCopyId
	END
	COMMIT TRAN ArchChunkToRecoverDDBSeg_tran
	SELECT 0, '', @segmentId
	RETURN
CX_EXIT_ERROR:
	IF object_id('tempdb.dbo.#tblChunkToRecoverDDB') IS NOT NULL DROP TABLE #tblChunkToRecoverDDB
	IF object_id('tempdb.dbo.#tblChunkInSegment') IS NOT NULL DROP TABLE #tblChunkInSegment
	IF @cursor = 1
	BEGIN
		CLOSE AFCursor
		DEALLOCATE AFCursor
	END
	ROLLBACK TRAN ArchChunkToRecoverDDBSeg_tran
	SELECT @errVal, @errStr, @segmentId
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToRecoverDDBSegment')
	delete from GxQscripts where name = 'archChunkToRecoverDDBSegment'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToRecoverDDBSegment')
	delete from GXDBVersions where aliasname = 'archChunkToRecoverDDBSegment'
GO

insert into GXDBVersions values(2, 'archChunkToRecoverDDBSegment',  '00010001000200030000', 'archChunkToRecoverDDBSegment', '00010001000200030000')
GO

