

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToRecoverDDBInsert.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToRecoverDDBInsert.sp,v $ $Id: archChunkToRecoverDDBInsert.sp,v 1.1.2.14 2020/07/21 22:27:06 chandru Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archChunkToRecoverDDBInsert')
BEGIN
	print '>>> Drop Stored Procedure: archChunkToRecoverDDBInsert <<<'
	drop procedure archChunkToRecoverDDBInsert
END
IF EXISTS (select * from GxQscripts where name='archChunkToRecoverDDBInsert')
	delete from GxQscripts where name = 'archChunkToRecoverDDBInsert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToRecoverDDBInsert')
	delete from GXDBVersions where aliasname = 'archChunkToRecoverDDBInsert'
GO
print '... Creating Procedure: archChunkToRecoverDDBInsert'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archChunkToRecoverDDBInsert
  @i_adminJobId int,
  @i_archCopyId int,
  @i_SIDBStoreId int,	
  @i_isNewAttempt int,
  @i_AttemptNum int
AS
  DECLARE @retVal integer;
  DECLARE @hasMoreBatchesToRun integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @maxVolumeId INTEGER = 0
DECLARE @now INTEGER = dbo.GetUnixTime(GetUTCDate())
DECLARE @maxVolumes INT = 1000
DECLARE @hasCompletedJobs INT = 0
DECLARE @l_hasMoreBatchesToRun INT = 0
DECLARE @firstExecutionForJob INT = 0
SELECT @l_hasMoreBatchesToRun = R.hasMoreBatchesToRun,  @maxVolumeId = R.maxVolumeId
FROM archChunkToRecoverDDBBatchDetails R WHERE  R.adminJobId = @i_adminJobId
IF @@ROWCOUNT = 0 -- batchDetails not available for this job, that means this proc is called first time for this job
BEGIN
	INSERT INTO archChunkToRecoverDDBBatchDetails(adminJobId, commcellId, maxVolumeId, hasMoreBatchesToRun)
	SELECT	@i_adminJobId, 2, 0, 1
	SET @l_hasMoreBatchesToRun = 1
	SET @firstExecutionForJob = 1
END
IF (@i_isNewAttempt = 1 AND @i_AttemptNum > 0)
BEGIN
	-- On new attempt move all chunks from SENT status to POPULATE Status
	UPDATE ArchChunkToRecoverDDB
SET		Status = 0,
			Modified = @now
	WHERE	ArchChunkToRecoverDDB.adminjobId = @i_adminJobId
AND ((Status = 1) OR (Status = 3) OR (Status = 5))
	SELECT	@retVal = @@ERROR
	IF  @retVal <> 0 GOTO FINISH
	UPDATE ArchChunkToRecoverDDB
	SET		SegmentId = 0,
			Modified = @now
	WHERE	ArchChunkToRecoverDDB.adminjobId = @i_adminJobId
AND Status = 0
	SELECT	@retVal = @@ERROR
	IF  @retVal <> 0 GOTO FINISH
	GOTO FINISH
END
ELSE IF (EXISTS (SELECT 1 FROM ArchChunkToRecoverDDB R WITH (READUNCOMMITTED) WHERE R.adminjobId = @i_adminJobId)
		AND (@l_hasMoreBatchesToRun = 0))
BEGIN
	GOTO FINISH
END
--For capturing return value of stored procedure
IF OBJECT_ID('tempdb..#retValTemp') IS NOT NULL  DROP TABLE #retValTemp
IF OBJECT_ID('tempdb..#volumesRecoverDDBTemp') IS NOT NULL  DROP TABLE #volumesRecoverDDBTemp
CREATE TABLE #retValTemp ( rVal INT)
CREATE TABLE #volumesRecoverDDBTemp ( volumeId INT, MediaId INT, MediaGroupId INT, RecordingFormatId INT, MountPathId INT PRIMARY KEY (VolumeId))
IF (@firstExecutionForJob = 1)
BEGIN
	-- Call the following store procedures to clean chunks for this store
	EXEC	archDeleteInvalidChunks 0, @i_SIDBStoreId
	SELECT	@retVal = @@ERROR
	IF  @retVal <> 0 GOTO FINISH
	SELECT @retVal = rVal FROM #retValTemp
	IF  @retVal <> 0 GOTO FINISH
	DELETE #retValTemp
	EXEC	cleanPrunedMagneticChunks 0
	SELECT	@retVal = @@ERROR
	IF  @retVal <> 0 GOTO FINISH
	SELECT @retVal = rVal FROM #retValTemp
	IF  @retVal <> 0 GOTO FINISH
	INSERT INTO #retValTemp
	EXEC	MMCleanArchFileSubStore @i_SIDBStoreId
	SELECT	@retVal = @@ERROR
	IF  @retVal <> 0 GOTO FINISH
	SELECT @retVal = rVal FROM #retValTemp
	IF  @retVal <> 0 GOTO FINISH
END
DECLARE	@l_NumOfRows	INT
DECLARE	@oneConstReal REAL = 1.0
DECLARE @reconFlags INT = 0
SET @reconFlags = dbo.GetOptionInt(93390483, @i_adminJobId, 0, 0)
DECLARE	@l_LastSnapTime	INT = 0
DECLARE	@l_minLastSnapTime	INT = 0
DECLARE	@l_minSubStoreCreateTime	INT = 0
DECLARE @l_corruptionTime INT = 0
DECLARE @retReconInfo TABLE ( CommCellId INT, SIDBStoreId INT, ReconLevel INT, MemDbTimeStamp INT, CorruptionTime INT)
DECLARE @memDbRecon INT = 0
DECLARE @l_jobStartTime INT = 0
DECLARE @l_chunkCreateTime INT = 0
INSERT INTO @retReconInfo
exec MMGetDDBReconInfo 2, @i_SIDBStoreId, @i_adminJobId, 0
SELECT @l_corruptionTime = CorruptionTime FROM @retReconInfo
IF @l_corruptionTime <= 0
	OR EXISTS (SELECT 1 FROM IdxSIDBStore WITH (READUNCOMMITTED) WHERE SIDBStoreId = @i_SIDBStoreId AND SealedTime > 0)
BEGIN
	SELECT	@l_jobStartTime = jobStartTime
	FROM	JMJobInfo WITH (READUNCOMMITTED)
	WHERE	JobId = @i_adminJobId
	SET @l_corruptionTime = @l_jobStartTime
END
SELECT	@l_minLastSnapTime = MIN(LastSnapTime), @l_minSubStoreCreateTime = MIN(CreatedTime)
FROM IdxSIDBSubStore,
		(
			SELECT sb.value('@val', 'INT') AS t_substoreId
			FROM
			(
				select CAST(value AS XML) AS xmlstr
				from dbo.GetAllJobOptions(@i_adminJobId)
				where optionId=34449693 -- DEDUPDBSYNCOPTION__SUB_STORE_ID_LIST
			) AS O
			CROSS APPLY O.xmlstr.nodes ('SubStoreIdList') R(sb)
		) T
WHERE SIDBStoreId = @i_SIDBStoreId AND Status = 1
		AND T.t_substoreId = SubStoreId
IF @reconFlags <> 1
BEGIN
	IF (1 = (SELECT ReconLevel FROM @retReconInfo))
	BEGIN
		SELECT @l_LastSnapTime = MemDbTimeStamp FROM @retReconInfo
		SET @memDbRecon = 1
	END
	ELSE
	BEGIN
		SET	@l_LastSnapTime = @l_minLastSnapTime
	END
END
DECLARE	@additionalChunksForReconstrunctionPeriodInMin int = 0
IF @memDbRecon = 0
BEGIN
	SET		@additionalChunksForReconstrunctionPeriodInMin = ISNULL((SELECT TOP 1 value FROM MMConfigs WHERE name = 'MMS2_MMCONFIG_ADDITIONAL_MINUTES_FROM_LASTSNAPTIME_FOR_DDB_RECOVER'), 30)
	IF (@additionalChunksForReconstrunctionPeriodInMin < 0)
		SET	@additionalChunksForReconstrunctionPeriodInMin = 30
END
ELSE IF @memDbRecon = 1
BEGIN
	-- for delta recon add 5 mins of buffer and read more chunks.
	SET @additionalChunksForReconstrunctionPeriodInMin = 5
END
-- No need to consider additionalChunksForReconstrunctionPeriodInMin as we considering chunk write time now
-- SET @l_LastSnapTime = @l_LastSnapTime - (@additionalChunksForReconstrunctionPeriodInMin * 60)
SET	@l_chunkCreateTime = (CASE WHEN @l_LastSnapTime > 0 AND @l_LastSnapTime > @l_minSubStoreCreateTime THEN @l_LastSnapTime ELSE @l_minSubStoreCreateTime END)
WHILE (@l_hasMoreBatchesToRun = 1)
BEGIN
	DECLARE @insertedVolumeCount INT = 0
	IF (@maxVolumeId = 0)
	BEGIN
		SELECT @maxVolumeId = MIN(V.VolumeId) - 1
		FROM	MMVolume V INNER JOIN archChunk AC ON V.VolumeId = AC.VolumeId
		WHERE	V.SIDBStoreId = @i_SIDBStoreId
AND (AC.flags & 256) = 0
				AND AC.createTime > @l_chunkCreateTime
AND ((AC.createTime - AC.writeTime) < @l_corruptionTime OR ((AC.flags & 524288) = 524288))
	END
	DELETE #volumesRecoverDDBTemp
	INSERT INTO #volumesRecoverDDBTemp
	SELECT	DISTINCT TOP (@maxVolumes) MV.VolumeId, MV.MediaId, MV.MediaGroupId, MV.RecordingFormatId, MP.MountPathId
	--SELECT	MV.VolumeId, MV.MediaId, MV.MediaGroupId, MV.RecordingFormatId, MP.MountPathId
	FROM	MMVolume MV WITH (READUNCOMMITTED) INNER JOIN MMMountPath MP WITH (READUNCOMMITTED) ON MV.MediaSideId = MP.MediaSideId
	WHERE	MV.SIDBStoreId = @i_SIDBStoreId
			AND MV.VolumeId > @maxVolumeId
	ORDER BY VolumeId
	IF (EXISTS (SELECT * FROM IdxSIDBStore WHERE SIDBStoreId = @i_SIDBStoreId AND Version > 2))
	BEGIN
		IF OBJECT_ID('tempdb..#chunksRecoverDDBTemp') IS NOT NULL  DROP TABLE #chunksRecoverDDBTemp
		CREATE TABLE #chunksRecoverDDBTemp (VolumeId		INT,
											archChunkId		BIGINT,
											chunkCommCellId INT,
											archFileId		INT,
											commCellId		INT,
											archCopyId		INT,
											chunkNumber		INT,
											physicalSize	BIGINT,
											logicalSize		BIGINT,
											unCompSize		BIGINT,
											RecordingFormatId INT,
											MountPathId		INT,
											MediaId			INT,
											MediaGroupId	INT
											PRIMARY KEY (VolumeId, archChunkId, chunkCommCellId))
		CREATE INDEX chunksRecoverDDBTemp_archFileId_CommCellId_archCopyId_INDEX ON #chunksRecoverDDBTemp(archFileId,commCellId,archCopyId)
		INSERT INTO	#chunksRecoverDDBTemp
		SELECT	V.VolumeId, ACM.archCHunkId, ACM.chunkCommCellId, ACM.archFileId, ACM.commCellId, ACM.archCopyId, ACM.chunkNumber, ACM.physicalSize, ACM.logicalSize,
				(CASE WHEN ACM.unCompSize > 0 THEN ACM.unCompSize
					 WHEN ACM.logicalSize > 0 THEN ACM.logicalSize
					 WHEN ACM.physicalSize > 0 THEN ACM.physicalSize
					 ELSE 1
				END), V.RecordingFormatId, V.MountPathId, V.MediaId, V.MediaGroupId
		FROM	#volumesRecoverDDBTemp V INNER JOIN archChunk AC ON V.VolumeId = AC.VolumeId
										 INNER JOIN archChunkMapping ACM ON AC.id = ACM.archChunkId AND AC.CommCellId = ACM.chunkCommCellId
WHERE	(AC.flags & 256) = 0
				AND AC.createTime > @l_chunkCreateTime
AND ((AC.createTime - AC.writeTime) < @l_corruptionTime OR ((AC.flags & 524288) = 524288))
				-- AND ACM.chunkNumber > 0
		DELETE	#chunksRecoverDDBTemp
		FROM	#chunksRecoverDDBTemp S,
				archFileCopyDedup D LEFT OUTER JOIN archFileSubStore AFSS
					ON	AFSS.archFileId	= D.archFileId
						AND	AFSS.CommCellId	= D.CommCellId
						AND AFSS.SIDBStoreId	= D.SIDBStoreId
		WHERE	S.archFileId	= D.archFileId
				AND S.CommCellId	= D.CommCellId
				AND S.archCopyId	= D.archCopyId
				AND D.primaryObjects = 0
				AND D.secondaryObjects = 0
				AND ISNULL(AFSS.primaryObjects, 0) = 0
				AND ISNULL(AFSS.secondaryObjects, 0) = 0
				AND S.chunkNumber > 0
		INSERT INTO ArchChunkToRecoverDDB (AdminJobId, VolumeId, MinChunkId, MaxChunkId, CurrChunkId, ChunkCommCellId,
										ArchGroupId, SrcCopyId, SrcStreamNum,
										PhysicalSize, LogicalSize, unCompBytesSize,	chunksCount,
										RecordingFormatId, MountPathId, MediaId, MediaGroupId,
										SrcMAId, SrcDrivePoolId,
										Status, Modified, SkippedReason, SkippedCount, SkippedForSeconds, ErrorCode,
										extraFlags, segmentId, streamReaderID, processedChunksCount, processedUnCompBytesSize)
		SELECT	@i_adminJobId, C.VolumeId, MIN(C.archChunkId), MAX(C.archChunkId), MIN(C.archChunkId), MAX(C.ChunkCommCellId),
				0, 0, 0,
				SUM(C.physicalSize), SUM(C.logicalSize), SUM(C.unCompSize), COUNT(DISTINCT C.archChunkId),
				C.RecordingFormatId, C.MountPathId, C.MediaId, C.MediaGroupId,
				0, 0,
				0, @now, 0, 0, 0, 0,
				0, 0, 0, 0, 0
		FROM	#chunksRecoverDDBTemp	C
		GROUP BY C.VolumeId, C.MountPathId, C.MediaId, C.MediaGroupId, C.RecordingFormatId
	END
	ELSE
	BEGIN
		INSERT INTO ArchChunkToRecoverDDB (AdminJobId, VolumeId, MinChunkId, MaxChunkId, CurrChunkId, ChunkCommCellId,
										ArchGroupId, SrcCopyId, SrcStreamNum,
										PhysicalSize, LogicalSize, unCompBytesSize,	chunksCount,
										RecordingFormatId, MountPathId, MediaId, MediaGroupId,
										SrcMAId, SrcDrivePoolId,
										Status, Modified, SkippedReason, SkippedCount, SkippedForSeconds, ErrorCode,
										extraFlags, segmentId, streamReaderID, processedChunksCount, processedUnCompBytesSize)
		SELECT	@i_adminJobId, V.VolumeId, MIN(AC.id), MAX(AC.id), MIN(AC.id), MAX(AC.CommCellId),
				0, 0, 0,
				SUM(ACM.physicalSize), SUM(ACM.physicalSize), SUM(ACM.unCompSize), COUNT(*),
				V.RecordingFormatId, V.MountPathId, V.MediaId, V.MediaGroupId,
				0, 0,
				0, @now, 0, 0, 0, 0,
				0, 0, 0, 0, 0
		FROM	#volumesRecoverDDBTemp V, archChunk AC, archChunkMapping ACM
		WHERE	V.VolumeId = AC.VolumeId
				AND AC.id = ACM.archChunkId
				AND AC.CommCellId = ACM.chunkCommCellId
AND (AC.flags & 256) = 0
				AND AC.createTime > @l_chunkCreateTime
AND ((AC.createTime - AC.writeTime) < @l_corruptionTime OR ((AC.flags & 524288) = 524288))
		GROUP BY V.VolumeId, V.MountPathId, V.MediaId, V.MediaGroupId, V.RecordingFormatId
	END
	SELECT	@retVal = @@ERROR, @insertedVolumeCount = @@ROWCOUNT
	IF  @retVal <> 0 GOTO FINISH
	SELECT	@maxVolumeId = MAX(VolumeId), @l_hasMoreBatchesToRun = (CASE WHEN COUNT(*) < @maxVolumes THEN 0 ELSE 1 END)
	FROM	#volumesRecoverDDBTemp V
	UPDATE	R
	SET		maxVolumeID = ISNULL(@maxVolumeId, maxVolumeID), hasMoreBatchesToRun = @l_hasMoreBatchesToRun
	FROM archChunkToRecoverDDBBatchDetails R
	WHERE  R.adminJobId = @i_adminJobId
	IF (@insertedVolumeCount != 0 OR @l_hasMoreBatchesToRun = 0)
	BEGIN
		BREAK
	END
END
	IF (@l_hasMoreBatchesToRun = 0 AND
		NOT EXISTS (SELECT 1 FROM ArchChunkToRecoverDDB WHERE adminJobId = @i_adminJobId))
	BEGIN
		INSERT INTO ArchChunkToRecoverDDB (AdminJobId, VolumeId, MinChunkId, MaxChunkId, CurrChunkId, ChunkCommCellId,
										ArchGroupId, SrcCopyId, SrcStreamNum,
									PhysicalSize, LogicalSize, unCompBytesSize,	chunksCount,
										RecordingFormatId, MountPathId, MediaId, MediaGroupId,
										SrcMAId, SrcDrivePoolId,
										Status, Modified, SkippedReason, SkippedCount, SkippedForSeconds, ErrorCode,
										extraFlags, segmentId, streamReaderID, processedChunksCount, processedUnCompBytesSize)
		SELECT	TOP 1 @i_adminJobId, V.VolumeId, 0, 0, 0, 0,
				S.archGroupId, S.archGroupCopyId, S.stream,
				1, 1, 1, 0,
				V.RecordingFormatId, MP.MountPathId, V.MediaId, V.MediaGroupId,
				0, 0,
				0, @now, 0, 0, 0, 0,
				0, 0, 0, 0, 0
		FROM	MMVolume V WITH (READUNCOMMITTED) INNER JOIN MMMountPath MP WITH (READUNCOMMITTED) ON V.MediaSideId = MP.MediaSideId, archStream S WITH (READUNCOMMITTED)
		WHERE	S.mediaGroupId = V.MediaGroupId AND V.SIDBStoreId = @i_SIDBStoreId AND S.MediagroupId > 0
		ORDER BY V.VolumeId DESC
	END
	ELSE
	BEGIN
		UPDATE	R
		SET		R.archGroupId = S.archGroupId,
				R.SrcCopyId = S.archGroupCopyId,
				R.SrcStreamNum = S.stream
		FROM	ArchChunkToRecoverDDB R WITH (READUNCOMMITTED),  #volumesRecoverDDBTemp V, archStream S WITH (READUNCOMMITTED)
		WHERE	R.adminJobId = @i_adminJobId
				AND R.VolumeId = V.VolumeId
				AND S.mediaGroupId = V.MediaGroupId AND S.MediagroupId > 0
	END
SELECT	@retVal = @@ERROR
IF  @retVal <> 0 GOTO FINISH
FINISH:
IF OBJECT_ID('tempdb..#retValTemp') IS NOT NULL  DROP TABLE #retValTemp
IF OBJECT_ID('tempdb..#volumesRecoverDDBTemp') IS NOT NULL  DROP TABLE #volumesRecoverDDBTemp
SELECT @retVal, @l_hasMoreBatchesToRun
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToRecoverDDBInsert')
	delete from GxQscripts where name = 'archChunkToRecoverDDBInsert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToRecoverDDBInsert')
	delete from GXDBVersions where aliasname = 'archChunkToRecoverDDBInsert'
GO

insert into GXDBVersions values(2, 'archChunkToRecoverDDBInsert',  '00010001000200140000', 'archChunkToRecoverDDBInsert', '00010001000200140000')
GO

