

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToRecoverDDBHandleReportStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToRecoverDDBHandleReportStatus.sp,v $ $Id: archChunkToRecoverDDBHandleReportStatus.sp,v 1.1.2.13 2019/11/13 22:43:04 chandru Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archChunkToRecoverDDBHandleReportStatus')
BEGIN
	print '>>> Drop Stored Procedure: archChunkToRecoverDDBHandleReportStatus <<<'
	drop procedure archChunkToRecoverDDBHandleReportStatus
END
IF EXISTS (select * from GxQscripts where name='archChunkToRecoverDDBHandleReportStatus')
	delete from GxQscripts where name = 'archChunkToRecoverDDBHandleReportStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToRecoverDDBHandleReportStatus')
	delete from GXDBVersions where aliasname = 'archChunkToRecoverDDBHandleReportStatus'
GO
print '... Creating Procedure: archChunkToRecoverDDBHandleReportStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archChunkToRecoverDDBHandleReportStatus
  @i_adminJobId int,
  @i_srcCopyId int,
  @i_srcStreamNum int,
  @i_readerId int,
  @i_errorCode int,
  @i_mmErrorCode int,
  @i_type int,
  @i_chunksXML XML
AS
  DECLARE @o_error integer;
  DECLARE @o_errorString varchar(2048);
  DECLARE @o_barcode varchar(256);
  DECLARE @o_libraryName NVARCHAR(128);
  DECLARE @o_mediaTypeId integer;
  DECLARE @o_mountPathName NVARCHAR(1024); 
  DECLARE @o_policyName NVARCHAR(144);
  DECLARE @o_copyName NVARCHAR(64);
  DECLARE @o_mediaAgentName NVARCHAR(255);
  DECLARE @o_jobIdString varchar(1024);
  DECLARE @o_chunkId BIGINT;
SET NOCOUNT ON
DECLARE @error			integer = 0
DECLARE @errorString	varchar(2048) = ''
DECLARE @barcode		varchar(256) = ''
DECLARE @libraryName	NVARCHAR(128) = ''
DECLARE @mediaTypeId	integer = 0
DECLARE @mountPathName	NVARCHAR(1024) = ''
DECLARE @policyName		NVARCHAR(144) = ''
DECLARE @copyName		NVARCHAR(64) = ''
DECLARE @mediaAgentName	NVARCHAR(255) = ''
DECLARE @jobIdString	varchar(1024) = ''
DECLARE @srcMAId		integer = 0
DECLARE @srcDPId		integer = 0
DECLARE	@volumeId integer = 0
DECLARE	@mediaId integer = 0
DECLARE	@skipSourceMedia INTEGER = 0
DECLARE @jobId INTEGER = 0
DECLARE @commCellid INTEGER = 0
DECLARE @retCode INTEGER = 0
DECLARE @l_SIDBStoreId INTEGER = dbo.GetOptionInt(1777365717, @i_adminJobId, 0, 0)
DECLARE @now INTEGER = dbo.GetUnixTime(GetUTCDate())
DECLARE @SKIP_INTERVAL_ON_SOURCE_ERROR_MINS	INT = 60
SET @SKIP_INTERVAL_ON_SOURCE_ERROR_MINS = ISNULL( (SELECT Value FROM MMConfigs WHERE NAME = 'MMCONFIG_DASHCOPY_JOB_SKIP_CHUNK_ON_SOURCE_ERROR_INTERVAL_MINS'), 10)
DECLARE @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS	INT = 10
SET @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS = ISNULL( (SELECT Value FROM MMConfigs WHERE NAME = 'MMCONFIG_DASHCOPY_JOB_SKIP_CHUNK_ON_NONE_SOURCE_ERROR_INTERVAL_MINS'), 10)
SELECT	@srcMAId	= SrcMAId,
		@srcDPId	= SrcDrivePoolId
FROM	ArchJobStreamStatus S  WITH (NOLOCK)
WHERE	S.JobId = @i_adminJobId
		AND S.SrcCopyId = @i_srcCopyId
		AND S.SrcStreamNum = @i_srcStreamNum
		AND S.StreamReaderId = @i_readerId
IF EXISTS (SELECT * FROM MMConfigs  WITH (NOLOCK) WHERE	name = 'MMCONFIG_AUXCOPY_SKIP_UNAVAILABLE_MEDIA' and Value > 0)
	SET	@skipSourceMedia = 1
SELECT	@mediaAgentName = name
FROM	APP_Client C  WITH (NOLOCK)
WHERE	C.Id = @srcMAId
IF OBJECT_ID('tempdb..#volumesRecoverDDBTemp') IS NOT NULL  DROP TABLE #volumesRecoverDDBTemp
IF OBJECT_ID('tempdb..#chunksRecoverDDBTemp') IS NOT NULL  DROP TABLE #chunksRecoverDDBTemp
CREATE TABLE #volumesRecoverDDBTemp (
			VolumeId		INT,
			MinChunkId		BIGINT,
			MaxChunkId		BIGINT,
			chunkCommCellId INT,
			srcCopyId		INT,
			currentChunkId	BIGINT,
			Status				INTEGER,
			SkippedReason		INTEGER,
			SkippedForSeconds	INTEGER,
			ErrorCode			INTEGER,
			processedChunksCount		INTEGER,
			processedUnCompBytesSize	BIGINT,
			primary key (VolumeId, MinChunkId, MaxChunkId, ChunkCommCellId, currentChunkId)
			)
CREATE TABLE #chunksRecoverDDBTemp (
			VolumeId		INT,
			MinChunkId		BIGINT,
			MaxChunkId		BIGINT,
			chunkId			BIGINT,
			chunkCommCellId		INTEGER,
			UnCompBytesSize		BIGINT,
			Status				INTEGER,
			SkippedReason		INTEGER,
			ErrorCode			INTEGER,
			ErrorString			VARCHAR(2048),
			primary key (VolumeId, MinChunkId, MaxChunkId, ChunkCommCellId, chunkId)
			)
INSERT INTO #chunksRecoverDDBTemp
SELECT	VolMsg.value('@VolumeId', 'INTEGER'),
		VolMsg.value('@minChunkId', 'BIGINT'),
		VolMsg.value('@maxChunkId', 'BIGINT'),
		ChunkMsg.value('@chunkId', 'BIGINT'),
		VolMsg.value('@chunkCommCellId', 'INTEGER'),
		ChunkMsg.value('@UnCompBytesSize', 'BIGINT'),
		0,
		ChunkMsg.value('@SkippedReason', 'BIGINT'),
		ChunkMsg.value('@ErrorCode', 'BIGINT'),
		ChunkMsg.value('@ErrorString', 'VARCHAR(2048)')
FROM	@i_chunksXML.nodes('VolMsg') AS VolMsg(VolMsg)
			CROSS APPLY  VolMsg.nodes('chunkMsg') AS ChunkMsg(ChunkMsg)
UPDATE	#chunksRecoverDDBTemp
SET		Status = (CASE	WHEN (SkippedReason = 0x6 OR SkippedReason = 0x11) THEN 4
WHEN ( SkippedReason = 0x10 AND ErrorCode = 801 )THEN 3
WHEN ( SkippedReason = 0x10 AND ErrorCode = 312 )THEN 3
ELSE 3
						END)
WHERE	SkippedReason != 0
INSERT INTO #volumesRecoverDDBTemp
SELECT	VolumeId, minChunkId, maxChunkId, chunkCommCellId,
		@i_srcCopyId,
		MAX(chunkId) currentChunkId,
MAX (CASE WHEN Status = 3 THEN 3 ELSE 0 END) Status,
		0 SkippedReason,
		0 SkippedForSeconds,
		0 ErrorCode,
SUM (CASE WHEN Status = 3 THEN 0 ELSE 1 END),
		SUM(CASE WHEN Status = 0 THEN UnCompBytesSize ELSE 0 END)
FROM	#chunksRecoverDDBTemp
GROUP BY	VolumeId, minChunkId, maxChunkId, chunkCommCellId
UPDATE	V
SET		SkippedReason = C.SkippedReason,
		SkippedForSeconds = @SKIP_INTERVAL_ON_SOURCE_ERROR_MINS * 60,
		ErrorCode = C.ErrorCode
FROM	#volumesRecoverDDBTemp V, #chunksRecoverDDBTemp C
WHERE	V.VolumeId = C.VolumeId
		AND V.minChunkId = C.minChunkId
		AND V.maxChunkId = C.maxChunkId
		AND V.chunkCommCellId = C.chunkCommCellId
		AND V.currentChunkId = C.chunkId
AND V.Status = 3
UPDATE	ARD
SET		CurrChunkId = V.currentChunkId,
Status = (CASE WHEN (V.Status = 3) THEN 3 WHEN V.currentChunkId = V.maxChunkId THEN 2 ELSE ARD.Status END),
		Modified = @now,
		SkippedReason = V.SkippedReason,
SkippedCount += (CASE WHEN (V.Status = 3) THEN 1 ELSE 0 END),
		SkippedForSeconds = V.SkippedForSeconds,
		ErrorCode = V.ErrorCode,
		processedChunksCount += V.processedChunksCount,
		processedUnCompBytesSize += V.processedUnCompBytesSize
FROM	archChunkToRecoverDDB ARD, #volumesRecoverDDBTemp V
WHERE	ARD.adminJobId = @i_adminJobId
		AND ARD.VolumeId = V.VolumeId
		AND ARD.minChunkId = V.minChunkId
		AND ARD.maxChunkId = V.maxChunkId
		AND ARD.chunkCommCellId = V.chunkCommCellId
		AND ARD.srcCopyId = V.srcCopyId
--Skip all volumes for which mountPath is marked offline permanently by user
UPDATE	ARD
SET		Status = V.Status,
		Modified = @now,
		SkippedReason = V.SkippedReason,
SkippedCount += (CASE WHEN (V.Status = 3) THEN 1 ELSE 0 END),
		SkippedForSeconds = V.SkippedForSeconds,
		ErrorCode = V.ErrorCode
FROM	archChunkToRecoverDDB ARD LEFT OUTER JOIN ArchJobStreamStatus S WITH (NOLOCK) ON ARD.AdminJobId = S.JobId AND (S.StreamReaderId != @i_readerId AND S.StreamReaderId = ARD.StreamReaderId),
		MMMountPath MP, #volumesRecoverDDBTemp V
WHERE	ARD.adminJobId = @i_adminJobId
		AND ARD.VolumeId = V.VolumeId
		AND ARD.minChunkId = V.minChunkId
		AND ARD.maxChunkId = V.maxChunkId
		AND ARD.chunkCommCellId = V.chunkCommCellId
		AND ARD.srcCopyId = V.srcCopyId
AND V.Status = 3
AND V.SkippedReason = 0x10
AND V.ErrorCode = 312
		AND ARD.MountPathId = MP.MountPathId
		AND MP.OfflineReason = 6 /*MOUNTPATH_MARKED_PERMANENTLY_OFFLINE_BY_USER*/
AND ARD.Status IN (0, 1, 3)
		AND S.JobID IS NULL
SELECT	TOP 1 @volumeId = MV.VolumeId, @mediaId = mediaId, @mediaTypeId = 10001, @barCode = VolumeName
FROM	(SELECT TOP 1 VolumeId FROM #chunksRecoverDDBTemp WHERE Status != 0) C, MMVolume MV
WHERE	C.VolumeId = MV.VolumeId
SET @jobIdString =  SUBSTRING((  SELECT DISTINCT TOP 1000 ( ', ' + CAST(ACM.jobId AS VARCHAR(10)))
FROM    archChunkMapping ACM, #chunksRecoverDDBTemp C
WHERE	ACM.archChunkId = C.chunkId
		AND ACM.chunkCommCellId = C.chunkCommCellId
		AND C.Status != 0
FOR XML PATH('') ), 2, 99999999)
SET	 @jobIdString = ' Backup Job [' + @jobIdString + ']'
SELECT	@libraryName = L.AliasName
FROM	MMMedia M WITH (NOLOCK), MMLibrary L WITH (NOLOCK)
WHERE	M.MediaId = @mediaId
		AND M.LibraryId = L.LibraryId
SELECT	@policyName = AG.name, @copyName = AGC.name
FROM	archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
WHERE	AG.id = AGC.archGroupId
		AND AGC.id = @i_srcCopyId
SELECT	@mountPathName = MountPathName
FROM	MMS2getMountPathNameGUIView
WHERE	MediaId = @mediaId
DELETE	C
FROM	#chunksRecoverDDBTemp C, ArchChunkToRecoverDDBFailedChunks F
WHERE	F.adminJobId = @i_adminJobId
		AND C.VolumeId = F.VolumeId
		AND C.chunkId = F.ChunkId
		AND C.chunkCommCellId = F.chunkCommCellId
-- Move the volumes in sent state back to populated state to send them again
IF EXISTS (SELECT * FROM #volumesRecoverDDBTemp WHERE Status = 3)
BEGIN
	UPDATE	archChunkToRecoverDDB
SET		Status = 0
	FROM	archChunkToRecoverDDB R
	WHERE	R.adminJobId = @i_adminJobId
			AND R.SrcCopyId = @i_srcCopyId
			AND R.SrcStreamNum = @i_srcStreamNum
			AND R.StreamReaderId = @i_readerId
AND R.Status = 1
END
INSERT INTO ArchChunkToRecoverDDBFailedChunks (AdminJobId, VolumeId, ChunkId, ChunkCommCellId, SrcMAId, Status, Modified, SkippedReason, ErrorCode)
SELECT	@i_adminJobId, C.VolumeId, C.chunkId, C.chunkCommCellId, @srcMAId, C.Status, @now, C.SkippedReason, C.ErrorCode
FROM	#chunksRecoverDDBTemp C
WHERE	C.Status IN (4, 6)
DECLARE @failedChunksInserted INT = @@ROWCOUNT
DECLARE @badChunkList XML = N''
WHILE ( @failedChunksInserted > 0 AND @badChunkList IS NOT NULL)
BEGIN
	if object_id('tempdb.dbo.#tempBadChunkInfoListC') is not null DROP TABLE #tempBadChunkInfoListC
	CREATE TABLE #tempBadChunkInfoListC (jobId int, archFileCCId int, copyId int)
	if object_id('tempdb.dbo.#MMProcessBadChunkInfoList_Output') is not null DROP TABLE #MMProcessBadChunkInfoList_Output
	CREATE TABLE #MMProcessBadChunkInfoList_Output (jobId int, archFileCCId int, copyId int)
	SET @badChunkList = (
						SELECT TOP(100) R.chunkId as '@chunk', R.ChunkCommCellId as '@chunkCCId', 0 as '@mpId', @l_SIDBStoreId as '@StoreId', R.volumeId as '@volId', 0 as '@afId', 0 as '@copyId', 0 as '@flags'
						FROM ArchChunkToRecoverDDBFailedChunks R
							LEFT OUTER JOIN archChunkDDBDrop ACDDB WITH (READUNCOMMITTED) ON
								R.chunkId = ACDDB.archChunkId
								AND R.ChunkCommCellId = ACDDB.chunkCommCellId
								AND @l_SIDBStoreId= ACDDB.SIDBStoreId
						WHERE
								R.adminJobId = @i_adminJobId
-- AND R.ErrorCode != 1005
								AND ACDDB.archChunkId IS NULL
						ORDER BY R.chunkId ASC
						FOR XML PATH ('h'), root('r')
						)
    INSERT INTO #tempBadChunkInfoListC
	EXEC MMProcessBadChunkInfoList @badChunkList, @i_adminJobId, @srcMAId
	SELECT @error = @@ERROR
	if object_id('tempdb.dbo.#tempBadChunkInfoListC') is not null DROP TABLE #tempBadChunkInfoListC
	if object_id('tempdb.dbo.#MMProcessBadChunkInfoList_Output') is not null DROP TABLE #MMProcessBadChunkInfoList_Output
    IF @error <> 0
        BREAK
END
SELECT	C.ErrorCode, C.ErrorString, MV.VolumeName, L.AliasName, MV.RecordingFormatId , MP.MountPathName, @policyName, @copyName, @mediaAgentName, CAST(ACM.jobId AS VARCHAR(10)), C.chunkId
FROM	#chunksRecoverDDBTemp C, MMVolume MV, MMS2getMountPathNameGUIView MP, MMLibrary L, archChunkMapping ACM
WHERE	C.Status IN (4, 6, 3)
		AND C.VolumeId = MV.VolumeId
		AND MV.MediaSideId = MP.MediaSideId
		AND MP.LibraryId = L.LibraryId
		AND C.chunkId = ACM.archChunkId
		AND C.chunkCommCellId = ACM.chunkCommCellId
ORDER BY (CASE WHEN C.Status = 3 THEN 1 ELSE 0 END), C.VolumeId, c.ChunkId
IF (@@ROWCOUNT = 0)
BEGIN
SELECT	@error, @errorString, @barcode, @libraryName, @mediaTypeId, @mountPathName,
		@policyName, @copyName, @mediaAgentName, @jobIdString, 0
END
IF OBJECT_ID('tempdb..#volumesRecoverDDBTemp') IS NOT NULL  DROP TABLE #volumesRecoverDDBTemp
IF OBJECT_ID('tempdb..#chunksRecoverDDBTemp') IS NOT NULL  DROP TABLE #chunksRecoverDDBTemp
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToRecoverDDBHandleReportStatus')
	delete from GxQscripts where name = 'archChunkToRecoverDDBHandleReportStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToRecoverDDBHandleReportStatus')
	delete from GXDBVersions where aliasname = 'archChunkToRecoverDDBHandleReportStatus'
GO

insert into GXDBVersions values(2, 'archChunkToRecoverDDBHandleReportStatus',  '00010001000200130000', 'archChunkToRecoverDDBHandleReportStatus', '00010001000200130000')
GO

