

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToMediaRefreshMoveRefreshedChunks.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- -----------------------------------------------------------------------------------------------------------------------
--	The basic assumptions:
-- 1. Commit the new chunk when an old volume has been copied to the transitive copy. So chunks in the old volume can be
--    deleted and the new chunks can be moved to the original copy.
-- 2. If not all volumes are to be refreshed, an archive file may have holes of chunks among the to be refreshed volumes.
--    The chunks after the first hole will not be read until the stream has been re-initialized. At that time, the size
--    and the lastChunkNumber in the transitive copy will be re-adjusted to fill the hole.
-- 3. No combining streams during Media Refreshing so a portion of new chunks of an archive file can be moved back to
--    the original copy. The refreshed and not refreshed chunks of an archive file have the same stream number.
-- -----------------------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archChunkToMediaRefreshMoveRefreshedChunks')
BEGIN
	print '>>> Drop Stored Procedure: archChunkToMediaRefreshMoveRefreshedChunks <<<'
	drop procedure archChunkToMediaRefreshMoveRefreshedChunks
END
IF EXISTS (select * from GxQscripts where name='archChunkToMediaRefreshMoveRefreshedChunks')
	delete from GxQscripts where name = 'archChunkToMediaRefreshMoveRefreshedChunks'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToMediaRefreshMoveRefreshedChunks')
	delete from GXDBVersions where aliasname = 'archChunkToMediaRefreshMoveRefreshedChunks'
GO
print '... Creating Procedure: archChunkToMediaRefreshMoveRefreshedChunks'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archChunkToMediaRefreshMoveRefreshedChunks
  @i_adminJobId INTEGER,
  @i_destCopyId INTEGER,
  @i_srcCopyId INTEGER
AS
  DECLARE @retVal INTEGER;
  DECLARE @barCode VARCHAR(1024);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE	@now	INTEGER
SET		@now	= dbo.GetUnixTime(GETUTCDATE())
SET		@retVal = 0
CREATE TABLE #tblOldAFChunk (
		volumeId int, acCommCellId int, archChunkId bigint, afCommCellId int, archFileId int,
		chunkNumber int, endPhysicalOffset bigint, endLogicalOffset bigint, newAFCPhysicalSize bigint, newAFCLogicalSize bigint, PhysicalOffset bigint)
CREATE TABLE #tblNewAFChunk (
		acCommCellId int, archChunkId bigint, afCommCellId int, archFileId int, chunkNumber int, maxDeletedChunkNumber int)
CREATE TABLE #tblOldChunk (
		archChunkId bigint, commCellId int, volumeId int)
DECLARE	@tblOldVol TABLE (volumeId int)
DECLARE	@tblRefreshedVol TABLE (volumeId int)
CREATE TABLE #tblPickedAF (archFileId INT, commCellId INT, physicalSize BIGINT)
DECLARE @tblPickedMedia TABLE(VolId INT)
DECLARE @isGACPCopy INT = 0
DECLARE @dedupeFlags INT = 0
DECLARE @tblRefreshedMedia TABLE(VolumeId INT, BarCode NVARCHAR(MAX))
DECLARE @archChunkToReplicateUpdateStatusReturn TABLE(errorCode INTEGER)
DECLARE @errorCode	int
-- Mark the copied chunks as processed
INSERT INTO @archChunkToReplicateUpdateStatusReturn
EXEC archChunkToReplicateUpdateStatus @i_adminJobId
SELECT	@errorCode = @@ERROR
IF	@errorCode <> 0
BEGIN
	SET	@retVal = @errorCode
	GOTO SCR_EXIT
END
SELECT TOP 1 @errorCode = errorCode
FROM	@archChunkToReplicateUpdateStatusReturn
SELECT	@errorCode = @@ERROR
IF	@errorCode <> 0
BEGIN
	SET	@retVal = @errorCode
	GOTO SCR_EXIT
END
SELECT  @isGACPCopy = 1
FROM archGroupCopy AGC WITH (NOLOCK), archGroup AG WITH (NOLOCK)
WHERE AGC.id = @i_srcCopyId AND AGC.archGroupId = AG.id
AND AG.flags & 16384 = 16384
SELECT  @dedupeFlags = dedupeFlags
FROM archGroupCopy AGC WITH (NOLOCK)
WHERE AGC.id = @i_srcCopyId
INSERT	#tblPickedAF
SELECT	DISTINCT archFileId, commCellId,physicalSize
FROM	archFileCopy WITH (NOLOCK)
WHERE	archCopyId = @i_destCopyId
INSERT @tblPickedMedia
SELECT	DISTINCT V.VolumeId
FROM	archFileCopy AFC WITH (NOLOCK), archChunkMapping ACM WITH (NOLOCK), archChunk AC WITH (NOLOCK), MMVolume V WITH (NOLOCK)
WHERE	AFC.archFileId = ACM.archFileId AND AFC.commCellId = ACM.commCellId AND AFC.archCopyId = ACM.archCopyId
	AND ACM.archChunkId = AC.id AND ACM.chunkCommCellId = AC.commCellId
	AND ((@isGACPCopy = 0 AND ACM.archCopyId = @i_srcCopyId)
		   OR (ACM.archCopyId IN ( SELECT id FROM archGroupCopy WITH (NOLOCK) WHERE destMediaCopyId  = @i_srcCopyId))
		)
AND (AC.flags & 256) = 0 AND (ACM.flags & 256) = 0
AND AC.volumeId = V.VolumeId AND (V.Attributes & 8) <> 0
-- Get not fully refreshed archFile from transitive copy and
-- if it is not copied fully then deleted the archfile from picked archfile itself
-- so that it do not come in picture for logical application and checks.
DELETE #tblPickedAF
FROM #tblPickedAF PAF, archFileCopy AFCOld WITH (NOLOCK)
WHERE AFCOld.archFileId = PAF.archFileId AND AFCOld.commCellId = PAF.commCellId
	AND ((@isGACPCopy = 0 AND AFCOld.archCopyId = @i_srcCopyId)
		   OR (AFCOld.archCopyId IN ( SELECT id FROM archGroupCopy WITH (NOLOCK) WHERE destMediaCopyId  = @i_srcCopyId))
		)
	AND AFCOld.physicalSize > PAF.physicalSize
-- Get all refreshed old chunks
INSERT	INTO #tblOldAFChunk
SELECT	AC.volumeId, ACM.chunkCommCellId, ACM.archChunkId, ACM.commCellId, ACM.archFileId,  ACM.chunkNumber,
		(ACM.physicalOffset + ACM.physicalSize), (ACM.logicalOffset + ACM.logicalSize), AFC.physicalSize, AFC.logicalSize, ACM.physicalOffSet
FROM	archFileCopy AFC WITH (NOLOCK), archChunkMapping ACM WITH (NOLOCK), archChunk AC WITH (NOLOCK), #tblPickedAF PAF
WHERE	AFC.archFileId = ACM.archFileId AND AFC.commCellId = ACM.commCellId AND AFC.archCopyId = @i_destCopyId
	AND AFC.streamNum > 0
	AND ACM.archChunkId = AC.id AND ACM.chunkCommCellId = AC.commCellId
	AND ((@isGACPCopy = 0 AND ACM.archCopyId = @i_srcCopyId)
		   OR (ACM.archCopyId IN ( SELECT id FROM archGroupCopy WITH (NOLOCK) WHERE destMediaCopyId  = @i_srcCopyId))
		)
AND (AC.flags & 256) = 0 AND (ACM.flags & 256) = 0
	AND ACM.archFileId = PAF.archFileId AND ACM.commCellId = PAF.commCellId
INSERT	INTO @tblRefreshedVol
SELECT	DISTINCT volumeId
FROM	#tblOldAFChunk
-- Get all new chunks for fully refreshed volumes
INSERT	INTO #tblNewAFChunk
SELECT	D.chunkCommCellId, D.archChunkId, D.commCellId, D.archFileId, D.chunkNumber, S.chunkNumber
FROM	archChunkMapping D WITH (NOLOCK),
		(SELECT archFileId, afCommCellId, MAX(chunkNumber) AS chunkNumber,
		MAX(endPhysicalOffset) AS endPhysicalOffset, MAX(endLogicalOffset) AS endLogicalOffset
		FROM #tblOldAFChunk GROUP BY archFileId, afCommCellId) S
WHERE	D.archFileId = S.archFileId AND D.commCellId = S.afCommCellId AND D.archCopyId = @i_destCopyId
	AND (D.physicalOffset + D.physicalSize) <= S.endPhysicalOffset
BEGIN TRANSACTION
BEGIN TRY
	-- Delete refreshed old chunks and move the new chunks from the transitive copy to the original copy
	UPDATE	archChunkMapping
SET		flags = (ACM.flags | 256), modifiedTime = @now, agedBy = (agedBy | 134217728)
	FROM	archChunkMapping ACM, #tblOldAFChunk T
	WHERE	ACM.chunkCommCellId = T.acCommCellId  AND ACM.archChunkId = T.archChunkId
	AND ACM.commCellId = T.afCommCellId AND ACM.archFileId = T.archFileId
	DELETE	archChunkMapping
	FROM	archChunkMapping ACM, #tblOldAFChunk T
	WHERE	ACM.chunkCommCellId = T.acCommCellId  AND ACM.archChunkId = T.archChunkId
	AND ACM.commCellId = T.afCommCellId AND ACM.archFileId = T.archFileId
	IF @isGACPCopy = 0
	BEGIN
		UPDATE	archChunkMapping
		SET		archCopyId = @i_srcCopyId
		FROM	archChunkMapping ACM, #tblNewAFChunk T
		WHERE	ACM.chunkCommCellId = T.acCommCellId AND ACM.archChunkId = T.archChunkId
		AND ACM.commCellId = T.afCommCellId AND ACM.archFileId = T.archFileId
	END
	ELSE
	BEGIN
		UPDATE	archChunkMapping
		SET		archCopyId = AFC.archCopyId
		FROM	archChunkMapping ACM, #tblNewAFChunk T, archGroupCopy AGC , archFileCopy AFC
		WHERE	ACM.chunkCommCellId = T.acCommCellId AND ACM.archChunkId = T.archChunkId
		AND ACM.commCellId = T.afCommCellId AND ACM.archFileId = T.archFileId
		AND AGC.destMediaCopyId = @i_srcCopyId AND AGC.id = AFC.archCopyId
		AND AFC.archFileId = T.archFileId AND AFC.commCellId = T.afCommCellId
	END
	DECLARE @l_EnableReEnc INT = ISNULL((SELECT value FROM MMConfigs WITH(READUNCOMMITTED)
											WHERE name = 'MM_CONFIG_ENABLE_RE_ENCRYPTION_FOR_MEDIA_REFRESH'), 0)
	IF @l_EnableReEnc > 0
	BEGIN
		UPDATE AFCSource
		SET AFCSource.streamNum = AFCDest.streamNum , AFCSource.flags = AFCDest.flags,
			encRSA = AFCDest.encRSA, encKeyType = AFCDest.encKeyType, encKey = AFCDest.encKey
		FROM archFileCopy AFCSource, archFileCopy AFCDest,  (SELECT DISTINCT archFileId, afCommCellId FROM #tblNewAFChunk) AF
		WHERE AFCSource.archFileId = AFCDest.archFileId AND AFCSource.commCellId = AFCDest.commCellId
		AND AFCDest.archFileId = AF.archFileId AND AF.afCommCellId = AFCDest.commCellId
		AND ((@isGACPCopy = 0 AND AFCSource.archCopyId = @i_srcCopyId)
			   OR (AFCSource.archCopyId IN ( SELECT id FROM archGroupCopy WITH (NOLOCK) WHERE destMediaCopyId  = @i_srcCopyId))
			)
		AND AFCDest.archCopyId = @i_destCopyId
	END
	ELSE
	BEGIN
		UPDATE AFCSource
		SET AFCSource.streamNum = AFCDest.streamNum , AFCSource.flags = AFCDest.flags
		FROM archFileCopy AFCSource, archFileCopy AFCDest,  (SELECT DISTINCT archFileId, afCommCellId FROM #tblNewAFChunk) AF
		WHERE AFCSource.archFileId = AFCDest.archFileId AND AFCSource.commCellId = AFCDest.commCellId
		AND AFCDest.archFileId = AF.archFileId AND AF.afCommCellId = AFCDest.commCellId
		AND ((@isGACPCopy = 0 AND AFCSource.archCopyId = @i_srcCopyId)
			   OR (AFCSource.archCopyId IN ( SELECT id FROM archGroupCopy WITH (NOLOCK) WHERE destMediaCopyId  = @i_srcCopyId))
			)
		AND AFCDest.archCopyId = @i_destCopyId
IF ((@dedupeFlags  & 262144) > 0)
	BEGIN
		INSERT INTO archFileSIDBKeys
		SELECT DISTINCT AFCD1.archFileId,AFCD1.commCellId,@i_srcCopyId,
				case when AFCD1.encKeyId > 0 then 0 else AFCD1.encKeyType end,
				case when AFCD1.encKeyId > 0 then '' else AFCD1.encKey end,
				AFCD1.SIDBStoreId,
				AFCD1.encRSA,
				AFCD1.encKeyId
		FROM archFileSIDBKeys AFCD1,#tblNewAFChunk T
		WHERE	AFCD1.archFileId = T.archFileId AND AFCD1.commCellId = T.afCommCellId AND AFCD1.archCopyId = @i_destCopyId
		DELETE SK
		FROM  archFileSIDBKeys SK
		INNER JOIN  #tblNewAFChunk T
		ON T.archFileId = Sk.archFileId
		AND T.afCommCellId = SK.commCellId
		AND SK.archCopyId = @i_destCopyId
	END
	END
	UPDATE	AFC
SET 	AFC.flags = (AFC.flags | 256), AFC.modifiedTime = @now, AFC.agedBy = (AFC.agedBy | 134217728)
	FROM	archFileCopy AFC
		INNER JOIN (SELECT DISTINCT archFileId, afCommCellId FROM #tblNewAFChunk) T
		ON	AFC.archFileId = T.archFileId AND AFC.commCellId = T.afCommCellId AND AFC.archCopyId = @i_destCopyId
		LEFT OUTER JOIN archChunkMapping ACM
		ON	ACM.archFileId = T.archFileId AND ACM.commCellId = T.afCommCellId AND ACM.archCopyId = @i_destCopyId
	WHERE	ACM.archFileId IS NULL
IF ((@dedupeFlags  & 262144) > 0)
	BEGIN
	UPDATE	AFCD
SET 	AFCD.SIDBStoreId = AFCD1.SIDBStoreId, AFCD.primaryObjects = AFCD1.primaryObjects, AFCD.secondaryObjects = AFCD1.secondaryObjects,
AFCD.primaryObjSize = AFCD1.primaryObjSize, AFCD.secondaryObjSize = AFCD1.secondaryObjSize, AFCD.secondaryMetaDataSize =AFCD1.secondaryMetaDataSize, AFCD.transDataSize = AFCD1.transDataSize, AFCD.savedDataSize =AFCD1.savedDataSize
	FROM archFileCopyDedup AFCD, archFileCopyDedup AFCD1,#tblNewAFChunk T
		WHERE	AFCD1.archFileId = T.archFileId AND AFCD1.commCellId = T.afCommCellId AND AFCD1.archCopyId = @i_destCopyId
		AND AFCD1.archFileId = AFCD.archFileId AND  AFCD1.commCellId = AFCD.commCellId AND AFCD.archCopyId = @i_srcCopyId
	END
	DELETE	archFileCopy
	FROM	archFileCopy AFC
		INNER JOIN (SELECT DISTINCT archFileId, afCommCellId FROM #tblNewAFChunk) T
		ON	AFC.archFileId = T.archFileId AND AFC.commCellId = T.afCommCellId AND AFC.archCopyId = @i_destCopyId
		LEFT OUTER JOIN archChunkMapping ACM
		ON	ACM.archFileId = T.archFileId AND ACM.commCellId = T.afCommCellId AND ACM.archCopyId = @i_destCopyId
	WHERE	ACM.archFileId IS NULL
	UPDATE	archFileCopy
	SET		lastChunkNumber = MaxChunkNumber
	FROM	archFileCopy AFC
		INNER JOIN (SELECT ACM.archFileId, ACM.commCellId, ACM.archCopyId, MAX(ACM.chunkNumber) as MaxChunkNumber
					FROM (SELECT DISTINCT archFileId, afCommCellId FROM #tblNewAFChunk) NewACM, archChunkMapping ACM
					WHERE	NewACM.archFileId = ACM.archFileId
							AND NewACM.afCommCellId = ACM.commCellId
							AND   -- ACM.archCopyId = @i_srcCopyId
							 ((@isGACPCopy = 0 AND ACM.archCopyId  = @i_srcCopyId)
		   OR (ACM.archCopyId  IN ( SELECT id FROM archGroupCopy WHERE destMediaCopyId  = @i_srcCopyId))
		)
					GROUP BY ACM.archFileId, ACM.commCellId, ACM.archCopyId) T
		ON	AFC.archFileId = T.archFileId AND AFC.commCellId = T.commCellId AND AFC.archCopyId = T.archCopyId
	INSERT	INTO #tblOldChunk
	SELECT	DISTINCT archChunkId, acCommCellId, volumeId
	FROM	#tblOldAFChunk
	DELETE	#tblOldChunk
	FROM	#tblOldChunk A, archChunkMapping ACM
	WHERE	A.archChunkId = ACM.archChunkId AND A.commCellId = ACM.chunkCommCellId
AND (ACM.flags & 256) = 0
	UPDATE	archChunk
SET		flags = (AC.flags | 256), modifiedTime = @now, agedBy = (agedBy | 134217728)
	FROM	archChunk AC, #tblOldChunk T
	WHERE	AC.id = T.archChunkId AND AC.commCellId = T.commCellId
	DELETE	#tblOldChunk
	FROM	#tblOldChunk A, archChunkMapping ACM
	WHERE	A.archChunkId = ACM.archChunkId AND A.commCellId = ACM.chunkCommCellId
	-- Let RecycleVolumesInDeletedAF stored procedure handle media recycling
	INSERT	INTO MMDeletedAF
	SELECT	0, AC.volumeId, 0, 0, @i_srcCopyId, '', AC.physicalSize, AC.id, 0, V.SIDBStoreId, 0, @now, 0, 0, 0, 0, 0, AC.commCellId
	FROM	archChunk AC WITH(READUNCOMMITTED), #tblOldChunk T,MMVolume V WITH(READUNCOMMITTED)
	WHERE	AC.id = T.archChunkId AND AC.commCellId = T.commCellId
			AND AC.volumeId = V.VolumeId AND V.origCCcommCellID = AC.commCellId
	DELETE	archChunk
	FROM	archChunk AC, #tblOldChunk T
	WHERE	AC.id = T.archChunkId AND AC.commCellId = T.commCellId
    -- The logic we have to make sure is that if there is no valid data on media, then only we have to mark media prevented
	-- otherwise we end up having data fragmented.
	-- The below query is checking that there is no chunk in archchunk table  which is valid.
	-- this query also covers the case when we consolidated the media basically deleting all the chunks from archchunk table.
	INSERT @tblRefreshedMedia
	SELECT	DISTINCT V.VolumeId, ''
	FROM	MMVolume V
		INNER JOIN
		@tblRefreshedVol T
			ON V.VolumeId = T.volumeId
		INNER JOIN
		@tblPickedMedia PM
			ON V.VolumeId = PM.VolId
		LEFT OUTER JOIN
		archChunk AC
ON  V.VolumeId = AC.volumeId AND AC.flags & 256 = 0
		WHERE
		AC.id IS NULL
	UPDATE	MMVolume
SET		Attributes = (V.Attributes & ~8) | 16
	FROM	MMVolume V
		INNER JOIN
		@tblRefreshedVol T
			ON V.VolumeId = T.volumeId
		INNER JOIN
		@tblPickedMedia PM
			ON V.VolumeId = PM.VolId
		LEFT OUTER JOIN
		archChunk AC
ON  V.VolumeId = AC.volumeId  AND AC.flags & 256 = 0
		WHERE
		AC.id IS NULL
	-- Move full volumes from the transitive copy to the original copy
	UPDATE	MMVolume
	SET		MediaGroupId = S1.MediaGroupId, VolumeFullJobId = @i_adminJobId
	FROM	MMVolume V, archStream S1,
			(SELECT	stream, mediaGroupId FROM archStream
			WHERE	archGroupCopyId = @i_destCopyId
			) S2
	WHERE	V.MediaGroupId = S2.MediaGroupId AND V.VolumeFlags = 2 /*VOL_FULL*/
		AND S2.stream = S1.stream
		AND S1.archGroupCopyId = @i_srcCopyId
	UPDATE R
SET status = 9
	FROM ArchChunkToReplicate R , archChunkMapping ACM WITH (NOLOCK), #tblPickedAF AF
	WHERE ACM.archChunkId <> R.ArchChunkId
	AND ACM.archCopyId = @i_srcCopyId
	AND R.SrcCopyId = ACM.archCopyId
	AND ACM.archFileId = R.ArchFileId
	AND AF.archFileId = R.ArchFileId
	AND ACM.commCellId = R.CommCellId
	AND ACM.commCellId = AF.commCellId
AND status = 2
	UPDATE R
SET status = 9
	FROM ArchChunkToReplicateHistory R , archChunkMapping ACM WITH (NOLOCK), #tblPickedAF AF
	WHERE ACM.archChunkId <> R.ArchChunkId
	AND ACM.archCopyId = @i_srcCopyId
	AND R.SrcCopyId = ACM.archCopyId
	AND ACM.archFileId = R.ArchFileId
	AND AF.archFileId = R.ArchFileId
	AND ACM.commCellId = R.CommCellId
	AND ACM.commCellId = AF.commCellId
AND status = 2
	UPDATE 	TBM
	SET TBM.BarCode = MM.BarCode
	FROM @tblRefreshedMedia TBM, MMVolume V, MMMedia MM
	WHERE TBM.VolumeId = V.volumeId AND V.MediaId = MM.MediaId
	-- Insert into this table to allow recompute of retention for the medias that got written to for this copy by MR job
	INSERT INTO JMJobDataStatsTracking (commCellId, jobId, archGrpCopyId, dataType)
	VALUES (0, 0, @i_srcCopyId, 0)
	COMMIT TRANSACTION
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @retVal = (SELECT ERROR_NUMBER())
	ROLLBACK TRANSACTION
END CATCH
SCR_EXIT:
IF object_id('tempdb.dbo.#TmpMRDepMediaUI') IS  NOT null DROP TABLE #TmpMRDepMediaUI
IF object_id('tempdb.dbo.#TmpMRDepMediaResultSet') IS  NOT null DROP TABLE #TmpMRDepMediaResultSet
IF @retVal = 0
	SELECT  DISTINCT @retVal , BarCode
	FROM @tblRefreshedMedia
ELSE
	SELECT @retVal, ''
RETURN	@retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToMediaRefreshMoveRefreshedChunks')
	delete from GxQscripts where name = 'archChunkToMediaRefreshMoveRefreshedChunks'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToMediaRefreshMoveRefreshedChunks')
	delete from GXDBVersions where aliasname = 'archChunkToMediaRefreshMoveRefreshedChunks'
GO

insert into GXDBVersions values(2, 'archChunkToMediaRefreshMoveRefreshedChunks',  '00000000000000000000', 'archChunkToMediaRefreshMoveRefreshedChunks', '00000000000000000000')
GO

