

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToMediaRefreshInsert.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archChunkToMediaRefreshInsert')
BEGIN
	print '>>> Drop Stored Procedure: archChunkToMediaRefreshInsert <<<'
	drop procedure archChunkToMediaRefreshInsert
END
IF EXISTS (select * from GxQscripts where name='archChunkToMediaRefreshInsert')
	delete from GxQscripts where name = 'archChunkToMediaRefreshInsert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToMediaRefreshInsert')
	delete from GXDBVersions where aliasname = 'archChunkToMediaRefreshInsert'
GO
print '... Creating Procedure: archChunkToMediaRefreshInsert'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archChunkToMediaRefreshInsert
  @i_adminJobId int,
  @i_destCopyId int,
  @i_destStream int,
  @i_srcCopyId int, 
  @i_srcStream int,
  @i_whichCommCell int,
  @i_AuxCopyMgr int,
  @i_isNewAttempt int,
  @i_isForNewData int
AS
  DECLARE @retVal int;
  DECLARE @nSkippedAFs int;
  DECLARE @nInsertedChunks int;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#tblAFC') IS NOT NULL DROP TABLE #tblAFC
IF OBJECT_ID('tempdb.dbo.#destArchFileCopy') IS NOT NULL DROP TABLE #destArchFileCopy
IF OBJECT_ID('tempdb.dbo.#tmpJobSizeInfo') IS NOT NULL DROP TABLE #tmpJobSizeInfo
CREATE TABLE #tblAFC (
		archFileId int, commCellId int, fileType int, appId int, backupJobId int,
		DestStreamNum int, flags int, physicalSize bigint, logicalSize bigint,
		srcStreamNum int, srcFlags int, srcPhysicalSize bigint, srcLogicalSize bigint,
		srcEncKeyType int, srcEncRSA int, srcEncKey varchar(1024), lastChunkNumber int, isJobRunning int, extraFlags int,afFlags int,
		destSIDBStoreId int,
		primary key (archFileId, commCellId) )
DECLARE @archChunkToReplicateUpdateStatusReturn TABLE(errorCode INTEGER)
DECLARE @l_dsaEnabled	int
DECLARE @l_commCellId	int
DECLARE @l_archGroupId	int
DECLARE @l_isSnapCopy	int
DECLARE @l_dedupeFlags	int
DECLARE @useLogicalSize	int
DECLARE @amErrCode		int
DECLARE	@oneConstReal REAL = 1.0
DECLARE	@l_isParallelCopy	int
DECLARE @errorCode	int
DECLARE	@l_insertedChunksCount int = 0
DECLARE @l_copyExtendedFlags INTEGER = 0
DECLARE @l_rowCount	int = 0
DECLARE @isGACPCopy INT = 0
DECLARE @l_ignoreDVFailedJobs INTEGER = ISNULL(dbo.GetOptionInt(2064661278, @i_adminJobId, 0, 0), 0)
SET		@useLogicalSize	= 0
SET		@amErrCode		= 0
SET		@nSkippedAFs	= 0
SET		@l_dsaEnabled	= 0
DECLARE @now INTEGER;
SET		@now = dbo.GetUnixTime(GetUTCDate())
-- Mark the copied chunks as processed
INSERT INTO @archChunkToReplicateUpdateStatusReturn
EXEC archChunkToReplicateUpdateStatus @i_adminJobId
SELECT	@errorCode = @@ERROR
IF	@errorCode <> 0
BEGIN
SET	@amErrCode = 132
	SET @nSkippedAFs = 1
	SET	@retVal = 0
	GOTO ERR_EXIT
END
SELECT TOP 1 @errorCode = errorCode
FROM	@archChunkToReplicateUpdateStatusReturn
SELECT	@errorCode = @@ERROR
IF	@errorCode <> 0
BEGIN
SET	@amErrCode = 132
	SET @nSkippedAFs = 1
	SET	@retVal = 0
	GOTO ERR_EXIT
END
DECLARE @MAX_FAILURE_COUNT INT = 3
    SELECT  TOP 1 @MAX_FAILURE_COUNT = ISNULL(value, 3)
    FROM    MMConfigs WITH (NOLOCK)
    WHERE   name = 'MMS2_CONFIG_AUXCOPY_STREAM_RETRY_COUNT'
SELECT  @isGACPCopy = 1
 FROM archGroupCopy AGC WITH (NOLOCK), archGroup AG WITH (NOLOCK)
 WHERE AGC.id = @i_srcCopyId AND AGC.archGroupId = AG.id
AND AG.flags & 16384 = 16384
IF (@i_destStream = 0 AND @i_srcStream = 0 AND @i_isNewAttempt = 1)
BEGIN
	-- On new attempt move all chunks from SENT status to POPULATE Status
	UPDATE archChunkToReplicate
SET		Status = 0,
			Modified = @now
	WHERE	archChunkToReplicate.adminjobId = @i_adminJobId
			AND archChunkToReplicate.destCopyId = @i_destCopyId
AND (Status = 1
OR (archChunkToReplicate.Status = 3 AND archChunkToReplicate.SkippedCount < @MAX_FAILURE_COUNT)
OR (archChunkToReplicate.Status = 5 AND archChunkToReplicate.SkippedCount < @MAX_FAILURE_COUNT))
				--  AND archChunkToReplicate.SkippedReason IN (CVA_READ_SOURCE_DATA_ERROR, CVA_AUXCOPY_SOURCE_MEDIA_ERROR))
				--  OR (archChunkToReplicate.Status = CVA_CHUNK_SKIPPED AND archChunkToReplicate.SkippedCount < 12 AND archChunkToReplicate.SkippedReason NOT IN (CVA_READ_SOURCE_DATA_ERROR, CVA_AUXCOPY_SOURCE_MEDIA_ERROR)))
	UPDATE archChunkToReplicate
	SET		SegmentId = 0,
			Modified = @now
	WHERE	archChunkToReplicate.adminjobId = @i_adminJobId
			AND archChunkToReplicate.destCopyId = @i_destCopyId
AND Status = 0
END
ELSE IF @i_isForNewData = 0
BEGIN
	-- When this store procedure is invoked it is assumed that we dont have any running stream and we are not able to create new readers
	-- If we have any chunks in sent state and reservation exist on dest copy then mark the rest of the chunks of that archive file as sent
	DECLARE	@archFileToSkip TABLE (archFileId integer, commCellId integer, DestCopyId integer, minChunkNumber integer, backupJobId integer, segmentId integer, SrcStreamNum int, DestStreamNum int, StreamReaderId int)
	INSERT INTO @archFileToSkip
	SELECT	archFileId, CommCellId, DestCopyId, MIN(chunkNumber), BackupJobId, MIN(SegmentId), MAX(SrcStreamNum), MAX(DestStreamNum), MAX(StreamReaderId)
	FROM	archChunkToReplicate AR
	WHERE	AR.adminJobId = @i_adminJobId
			AND AR.destCopyId = @i_destCopyId
AND AR.Status = (1)
			AND EXISTS (SELECT * FROM ArchJobStreamStatus WITH (NOLOCK) WHERE jobId = AR.AdminJobId AND StreamReaderId = AR.StreamReaderId)
	GROUP BY archFileId, CommCellId, BackupJobId, DestCopyId
	UPDATE	archChunkToReplicate
SET		Status = 5,
			SkippedCount += 1,
 			SkippedForSeconds = (60 * 60), -- Skip for 1 hour or till next attempts
SkippedReason = 0x12,
ErrorCode = 67000,
			Modified = @now,
			SrcStreamNum = S.SrcStreamNum,
			DestStreamNum = S.DestStreamNum,
			StreamReaderId = S.StreamReaderId
	FROM	archChunkToReplicate R, @archFileToSkip S
	WHERE	R.adminJobId = @i_adminJobId
			--AND R.backupJobId = S.backupJobId
			AND R.archFileId = S.archFileId
			AND R.CommCellId = S.commCellId
			AND R.destCopyId = S.DestCopyId
AND Status IN (0, 1)
	-- Move all chunks from SENT status to POPULATE Status if we dont have any reservations
	UPDATE	AR
SET		Status = 0
	FROM	archChunkToReplicate AR LEFT OUTER JOIN ArchJobStreamStatus S WITH (NOLOCK) ON S.jobId = AR.AdminJobId AND S.StreamReaderId = AR.StreamReaderId
	WHERE	AR.adminJobId = @i_adminJobId
AND AR.Status IN (1, 5)
			AND S.JobId IS NULL
			AND	(Modified + SkippedForSeconds) < @NOW
END
IF	(SELECT	COUNT(DISTINCT PT.CopyId)
	FROM	MMDrivePool PL WITH (NOLOCK), MMDataPath PT WITH (NOLOCK)
	WHERE	PL.DrivePoolId = PT.DrivePoolId AND PT.CopyId IN (@i_srcCopyId, @i_destCopyId) AND PL.DrivePoolType = 3) = 1
BEGIN
		SET	@useLogicalSize = 1
END
SELECT	@l_archGroupId = archGroupId,
		@l_isSnapCopy  = isSnapCopy,
		@l_dedupeFlags = dedupeFlags,
@l_isParallelCopy = case when (flags & 2048) > 0 then 1 else 0 end,
		@l_copyExtendedFlags = extendedFlags
FROM	archGroupCopy WITH (NOLOCK) WHERE id = @i_destCopyId
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
SELECT	@l_dsaEnabled = case when (flags & 131072) = 131072 then 1 else 0 end
FROM	archGroup WITH (NOLOCK) WHERE id = @l_archGroupId
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
IF @i_srcStream = 0 AND @i_destStream = 0
BEGIN
	SELECT * INTO #destArchFileCopy
	FROM archFileCopy WITH (NOLOCK)
		WHERE	archCopyId = @i_destCopyId AND streamNum > 0
			AND (@i_destStream = 0 OR streamNum = @i_destStream)
AND (isValid = 0) AND (flags & 256) = 0
	INSERT #tblAFC
	SELECT	A.archFileId, A.commCellId, 0, 0, 0,
			A.streamNum, A.flags, A.physicalSize, A.logicalSize,
			B.streamNum, B.flags, B.physicalSize, B.logicalSize,
			B.encKeyType, B.encRSA, B.encKey, B.lastChunkNumber, 0,
			0,0,0
	FROM   #destArchFileCopy A,
			archFileCopy B WITH (NOLOCK)
	WHERE	A.archFileId = B.archFileId AND A.commCellId = B.commCellId
		AND ((@isGACPCopy = 0 AND B.archCopyId = @i_srcCopyId)
            OR (b.archCopyId IN ( SELECT id FROM archGroupCopy WITH (NOLOCK) WHERE destMediaCopyId  = @i_srcCopyId))
         )
		AND (@l_isSnapCopy > 0 OR B.streamNum > 0)
	DELETE #tblAFC
	WHERE  (srcPhysicalSize <> 0 AND srclogicalSize <> 0
			AND ( @useLogicalSize = 0 AND physicalSize > srcphysicalSize
			OR @useLogicalSize = 1 AND logicalSize > srclogicalSize))
OR (srcFlags & 256) <> 0
END
 IF @i_srcStream > 0 AND @i_destStream > 0
 BEGIN
 	IF object_id('dbo.archChunkToReplicateDSA') IS NOT NULL
 		and @l_dsaEnabled > 0
 	BEGIN
 		-- Remove non-DSA archive files which use different source stream.
 		DELETE #tblAFC
 		FROM #tblAFC A LEFT OUTER JOIN archChunkToReplicateDSA B
 		ON		A.archFileId = B.archFileId
 			AND A.commCellId = B.commCellId
 			AND B.adminJobId = @i_adminJobId
 			AND B.destCopyId = @i_destCopyId
 			AND B.archCopyId = @i_srcCopyId
 		WHERE B.archFileId IS NULL AND A.srcStreamNum <> @i_srcStream
 		-- Remove DSA archive files which use different source streams
 		DELETE #tblAFC
 		FROM #tblAFC A, archChunkToReplicateDSA B
 		WHERE	A.archFileId = B.archFileId
 			AND A.commCellId = B.commCellId
 			AND B.adminJobId = @i_adminJobId
 			AND B.destCopyId = @i_destCopyId
 			AND B.archCopyId = @i_srcCopyId
 			AND (B.streamNum <> @i_srcStream OR B.destStream <> @i_destStream)
 	END
 	ELSE
 	BEGIN
 		DELETE #tblAFC
 		WHERE srcStreamNum <> @i_srcStream
 	END
 END
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
UPDATE	#tblAFC
SET		fileType = b.fileType, appId = b.appId, backupJobId = b.jobId, afFlags = b.flags
FROM	#tblAFC a, archFile b WITH (NOLOCK)
WHERE	b.id = a.archFileId AND b.commCellId = a.commCellId
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
-- Need to remove the archFiles if they are multiplexed in source and the job is still running i.e for fast copy on deduplicated copy.
/* commenting this out as we will support dedupe copy for this later
if ((@l_dedupeFlags  & 262144) > 0)
BEGIN
END
*/
-- Remove Already populated archive Files
    DELETE  #tblAFC
    FROM    #tblAFC AFC LEFT JOIN archChunkToReplicate R WITH (READUNCOMMITTED)
      ON  R.archFileId = AFC.archFileId AND R.commCellId = AFC.commCellId
        AND R.SrcCopyId = @i_srcCopyId AND R.DestCopyId = @i_destCopyId
  WHERE   R.AdminJobID = @i_adminJobId
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
/*
UPDATE	ArchChunkToReplicate
SET		Status = (CASE WHEN JDS.disabled & (8192 | 256) > 0 THEN 6 ELSE 7 END)
FROM	ArchChunkToReplicate R, JMJobDataStats JDS WITH (NOLOCK)
WHERE	R.AdminJobId = @i_adminJobId
		AND		R.DestCopyId = @i_destCopyId
ANd		R.Status IN ( 3, 5, 0)
		AND		R.BackupJobId = JDS.JobID
		AND		R.destCopyId = JDS.archGrpCopyId
		AND		R.fileType = JDS.dataType
		AND		R.CommCellid = JDS.CommCellId
AND		(JDS.disabled & 256) > 0
*/
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
UPDATE	ArchChunkToReplicate
SET		Status = 6
FROM	ArchChunkToReplicate R, JMJobDataStats JDS WITH (NOLOCK)
WHERE	R.AdminJobId = @i_adminJobId
		AND		R.DestCopyId = @i_destCopyId
ANd		R.Status IN ( 3, 5, 0)
		AND		R.BackupJobId = JDS.JobID
		AND		R.SrcCopyId = JDS.archGrpCopyId
		AND		R.fileType = JDS.dataType
		AND		R.CommCellid = JDS.CommCellId
AND		(JDS.disabled & 256) > 0
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
/*
UPDATE	ArchChunkToReplicate
SET		Status = (CASE WHEN JDS.disabled & 8192 = 8192 THEN 6 ELSE 7 END)
FROM	ArchChunkToReplicate R LEFT OUTER JOIN archFileCopy AFC
			ON	R.archFileId = AFC.archFileId
				AND R.CommCellId = AFC.CommCellId
				AND R.DestCopyid = AFC.archCopyId
		, JMJobDataStats JDS WITH (NOLOCK)
WHERE	R.AdminJobId = @i_adminJobId
		AND		R.DestCopyId = @i_destCopyId
ANd		R.Status IN ( 3, 5, 1)
		AND		R.BackupJobId = JDS.JobID
		AND		R.destCopyId = JDS.archGrpCopyId
		AND		R.fileType = JDS.dataType
		AND		R.CommCellid = JDS.CommCellId
--AND		(JDS.disabled & 1) = 1
		AND		AFC.archFileId IS NULL
*/
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
IF @i_whichCommCell = 1
	SET @l_commCellId = (SELECT ISNULL(MIN(commCellId), 2) FROM #tblAFC)
ELSE
IF @i_whichCommCell = 2
	SET @l_commCellId = (SELECT ISNULL(MAX(commCellId), 2) FROM #tblAFC)
ELSE
	SET @l_commCellId = 2
DELETE FROM #tblAFC WHERE commCellId <> @l_commCellId
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
-- If the target copy is single instanced,
-- Remove archive files from jobs which have multiplexed archive files.
-- Remove archive files from jobs encrypted with user defined pass phrase.
-- Validation query for checking some statistics which should match with archfilecopy table data
IF EXISTS (	SELECT *
		FROM archFileCopy AFC WITH (NOLOCK),
		(SELECT ACM.archCopyId, ACM.archFileId, ACM.commCellId,
				SUM(ACM.physicalSize) TotalACMPhysicalSize , SUM(ACM.logicalSize) TotalACMLogicalSize,
				MAX(ACM.chunkNumber) MaxChunkNumber, COUNT(ACM.archChunkId) ChunkCount
			FROM archChunkMapping ACM WITH (NOLOCK),   #tblAFC PAF
		WHERE ACM.archFileId = PAF.archFileId AND ACM.commCellId = PAF.commCellId
		AND ACM.archCopyId = @i_srcCopyId
	GROUP BY  ACM.archcopyId, ACM.archFileId , ACM.commCellId) T
		WHERE AFC.archCopyId = T.archCopyId
			AND AFC.archFileId = T.archFileId
			AND AFC.commCellId = T.commCellId
			AND (AFC.physicalSize <> T.TotalACMPhysicalSize
				OR AFC.logicalSize <> T.TotalACMLogicalSize
				OR AFC.lastChunkNumber <> T.MaxChunkNumber
				OR AFC.lastChunkNumber <> T.ChunkCount )
			)
BEGIN
	SELECT	@retVal = -10
	IF	@retVal <> 0 GOTO ERR_EXIT
END
-- Here we are only validating physicalOffset and PhysicalSize of chunk.
IF EXISTS (	SELECT  *
				FROM ( SELECT ROW_NUMBER() OVER(PARTITION BY ACM.archfileId ORDER BY ACM.archfileid, ACM.physicaloffset) RNP , ACM.*
					FROM archChunkMapping ACM, #tblAFC PAF
					WHERE ACM.archCopyId = @i_srcCopyId
						AND ACM.archfileid = PAF.archFileId
						AND ACM.commCellId = PAF.commCellId ) T
				WHERE T.RNP - chunkNumber <> 0)
BEGIN
	SELECT	@retVal = -10
	IF	@retVal <> 0 GOTO ERR_EXIT
END
IF EXISTS (	SELECT T.archCopyId, T.archFileId
				FROM ( SELECT  (AFC.lastChunkNumber - ACM.chunkNumber)*ACM.physicalSize product,  ACM.archCopyId, ACM.archFileId, ACM.physicalOffset
						FROM archChunkMapping ACM , archFileCopy AFC, #tblAFC PAF
						WHERE ACM.archCopyId = @i_srcCopyId
							AND ACM.archfileid = PAF.archFileId
							AND ACM.commCellId = PAF.commCellId
							AND ACM.archCopyId = AFC.archCopyId
							AND ACM.archFileId = AFC.archFileId
							AND ACM.commcellId = AFC.commCellId ) T
				GROUP BY T.archCopyId, T.archFileId
				HAVING SUM(T.physicalOffset) <> SUM(T.product)
			)
BEGIN
	SELECT	@retVal = -10
	IF	@retVal <> 0 GOTO ERR_EXIT
END
UPDATE	AFC
SET		destSIDBStoreId = SCD.SIDBStoreId
FROM	#tblAFC AFC,  archSubclientCopyDDBMap SCD WITH (READUNCOMMITTED)
WHERE	SCD.appId = AFC.appId AND SCD.copyId = @i_srcCopyId
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
INSERT INTO archChunkToReplicate (AdminJobId, BackupJobId, ArchFileId, CommCellId, ArchChunkId, ChunkCommCellId, ChunkNumber, lastChunkNumber,
		ArchGroupId, SrcCopyId, SrcStreamNum, DestCopyId, DestStreamNum,
		PhysicalStartOffset, PhysicalOffset, LogicalOffset, PhysicalSize, LogicalSize, unCompBytesSize,
		VolumeId, MediaId, MediaGroupId, MediaType,
		SrcMAId, SrcDrivePoolId,
		Status, Modified, SkippedReason, SkippedCount, SkippedForSeconds, ErrorCode,
		appId, fileType, archFileCopyFlags, encKeyType, fileMarkerNo,
		chunkCreateTime, chunkVersion, chunkPhysicalSize, chunkLogicalSize, chunkHwEncKey, archFileEncKey,
		extraFlags, segmentId, IsParallelCopy, streamReaderID, DestSIDBStoreId)
SELECT
		@i_adminJobId, a.BackupJobId, a.ArchFileId, a.CommCellId, a.ArchChunkId, a.ChunkCommCellId, a.ChunkNumber, a.lastChunkNumber,
		@l_archGroupId, a.archCopyId, (CASE WHEN @l_isSnapCopy <> 0 THEN a.DestStreamNum ELSE a.SrcStreamNum END), @i_destCopyId, a.DestStreamNum,
		a.PhysicalStartOffset /*PhysicalStartOffset*/, a.PhysicalOffset, a.LogicalOffset, a.PhysicalSize, a.LogicalSize, a.unCompSize,
		b.VolumeId, 0, 0, 10001 /*MediaType*/,
		0, 0,
		0, @now, 0, 0, 0, 0,
		a.appId, a.fileType, a.srcFlags, a.srcEncKeyType, b.fileMarkerNo,
		b.createTime, b.version, b.physicalSize, b.logicalSize, b.hwEncKey, a.srcEncKey,
		a.extraFlags, 0, @l_isParallelCopy, 0, a.destSIDBStoreId
FROM	(SELECT AFC.destSIDBStoreId, AFC.DestStreamNum, AFC.appId, AFC.backupJobId, AFC.srcStreamNum,
				AFC.fileType, AFC.srcFlags, AFC.srcEncKeyType, AFC.srcEncKey, AFC.lastChunkNumber, AFC.extraFlags, (CASE WHEN @useLogicalSize = 0 THEN AFC.PhysicalSize ELSE AFC.LogicalSize END) PhysicalStartOffset,ACM.*
		FROM #tblAFC AFC, archChunkMapping ACM WITH (NOLOCK)
		WHERE	(@l_isSnapCopy = 0 OR AFC.DestStreamNum = 1)
			AND ACM.archFileId = AFC.archFileId AND ACM.commCellId = AFC.commCellId
			AND ((@isGACPCopy = 0 AND ACM.archCopyId = @i_srcCopyId)
            OR (ACM.archCopyId IN ( SELECT id FROM archGroupCopy WITH (NOLOCK) WHERE destMediaCopyId  = @i_srcCopyId)))
			AND (@useLogicalSize = 0 AND (ACM.physicalOffset + ACM.physicalSize) > AFC.physicalSize
			OR @useLogicalSize = 1 AND (ACM.logicalOffset  + ACM.logicalSize)  > AFC.logicalSize)
		) a, archChunk b with (NOLOCK)
WHERE	b.id = a.archChunkId AND b.commCellId = a.chunkCommCellId
SELECT	@retVal = @@ERROR, @l_insertedChunksCount = @l_insertedChunksCount + @@rowCount
IF	@retVal <> 0 GOTO ERR_EXIT
UPDATE	archChunkToReplicate SET mediaId = b.MediaId, mediaGroupId = b.MediaGroupId, MediaType = M.MediaTypeId
FROM	archChunkToReplicate a, MMVolume b WITH (NOLOCK), MMMedia M WITH (NOLOCK)
WHERE	a.adminJobId = @i_adminJobId AND a.destCopyId = @i_destCopyId AND a.volumeId = b.VolumeId AND b.MediaId = M.MediaId
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
-- archChunkId for DataSetId, fileMarkerNo for ControlHostId, (chunk) createTime for snap job start time,
-- mediaGroupId for NodeId and volumeId for ExtRelationId
IF EXISTS(SELECT * from MMConfigs WHERE name = 'MMS2_CONFIG_AUXCOPY_BY_ARCHIVE_FILE_ORDER' AND value > 0)
AND ((@l_dedupeFlags & 262144) > 0)
BEGIN
UPDATE archChunkToReplicate SET extraFlags = extraFlags | 1
	WHERE adminJobId = @i_adminJobId
	AND destCopyId = @i_destCopyId
	AND SrcCopyId = @i_srcCopyId
	AND (@i_srcStream = 0 or SrcStreamNum = @i_srcStream)
	AND (@i_destStream = 0 or DestStreamNum = @i_destStream)
END
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
IF @useLogicalSize = 1
BEGIN
UPDATE archChunkToReplicate SET extraFlags = extraFlags | 4
	WHERE adminJobId = @i_adminJobId
	AND destCopyId = @i_destCopyId
	AND SrcCopyId = @i_srcCopyId
	AND (@i_srcStream = 0 or SrcStreamNum = @i_srcStream)
	AND (@i_destStream = 0 or DestStreamNum = @i_destStream)
END
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
CREATE TABLE #tmpJobSizeInfo (
	JobId INT, CommCellId INT, totalBackupSize BIGINT, totalAppSize BIGINT, totalIndexSize BIGINT
 	PRIMARY KEY (JobId, CommCellId))
INSERT INTO #tmpJobSizeInfo
SELECT	DISTINCT backupJobId, CommCellId, 0, 0, 0
FROM archChunkToReplicate
WHERE adminJobId = @i_adminJobId
	AND destCopyId = @i_destCopyId
	AND SrcCopyId = @i_srcCopyId
	AND (@i_srcStream = 0 or SrcStreamNum = @i_srcStream)
	AND (@i_destStream = 0 or DestStreamNum = @i_destStream)
	AND unCompBytesSize = -1
EXEC  @retVal = archGetJobSizeInfo 0
UPDATE	archChunkToReplicate
SET		unCompBytesSize = (CASE WHEN totalBackupSize > 0 THEN CAST(((@oneConstReal * (totalAppSize+totalIndexSize)*physicalSize)/totalBackupSize) AS BIGINT) ELSE physicalSize END)
FROM	#tmpJobSizeInfo J
WHERE	adminJobId = @i_adminJobId
		AND destCopyId = @i_destCopyId
		AND SrcCopyId = @i_srcCopyId
		AND (@i_srcStream = 0 or SrcStreamNum = @i_srcStream)
		AND (@i_destStream = 0 or DestStreamNum = @i_destStream)
		AND archChunkToReplicate.backupJobId = J.JobId
		AND archChunkToReplicate.CommCellId = J.CommCellId
		AND archChunkToReplicate.unCompBytesSize = -1
IF EXISTS(	SELECT  1
			FROM    MMConfigs WITH (NOLOCK)
			WHERE   name = 'MMCONFIG_AUXCOPY_SKIP_UNAVAILABLE_MEDIA'
					AND value = 1)
BEGIN
	UPDATE	R
SET		Status = 8,
			Modified = @now
	FROM	archChunkToReplicate R,
			(SELECT	DISTINCT R.adminJobId, R.archFileId, R.commCellId, R.destCopyId
			FROM	archChunkToReplicate R WITH (READUNCOMMITTED), MMMedia M WITH (READUNCOMMITTED)
			WHERE	R.adminJobId = @i_adminJobId
					AND R.destCopyId = @i_destCopyId
					AND R.SrcCopyId = @i_srcCopyId
AND R.Status IN (0, 3)
					AND R.MediaType != 10001
					AND R.MediaId = M.MediaId
					AND M.MediaLocation NOT IN (1,2) /*LOCATION_SLOT, LOCATION_DRIVE*/
					) T
	WHERE	R.adminJobID = T.adminJobId
			AND R.archFileId = T.archFileId
			AND R.commCellId = T.commCellId
			AND R.destCopyId = T.destCopyId
AND R.Status IN (0, 3)
	UPDATE	R
SET		Status = 0,
			Modified = @now
	FROM	archChunkToReplicate R,
			(SELECT	R.adminJobId, R.archFileId, R.commCellId, R.destCopyId
			FROM	archChunkToReplicate R WITH (READUNCOMMITTED), MMMedia M WITH (READUNCOMMITTED)
			WHERE	R.adminJobId = @i_adminJobId
					AND R.destCopyId = @i_destCopyId
					AND R.SrcCopyId = @i_srcCopyId
AND R.Status  = 8
					AND R.MediaType != 10001
					AND R.MediaId = M.MediaId
			GROUP BY R.adminJobId, R.archFileId, R.commCellId, R.destCopyId
			HAVING MIN(M.MediaLocation) IN (1,2) AND MAX(MediaLocation) IN (1,2) /*LOCATION_SLOT, LOCATION_DRIVE*/
			) T
	WHERE	R.adminJobID = T.adminJobId
			AND R.archFileId = T.archFileId
			AND R.commCellId = T.commCellId
			AND R.destCopyId = T.destCopyId
AND R.Status  = 8
END
-- Adjust hwEncKey based on media
UPDATE	R
SET		chunkHwEncKey = M.hwEncKey
FROM	archChunkToReplicate R WITH (READUNCOMMITTED), MMMedia M WITH (READUNCOMMITTED), ArchChunk chunk WITH (READUNCOMMITTED)
WHERE	R.adminJobId = @i_adminJobId
		AND R.destCopyId = @i_destCopyId
		AND R.SrcCopyId = @i_srcCopyId
		AND R.MediaType != 10001
		AND R.MediaId = M.MediaId
		AND R.chunkHwEncKey = ''
		AND	R.ArchChunkId = chunk.Id
		AND	R.ChunkCommCellId = chunk.CommCellId
AND chunk.flags & 1048576 > 0
ERR_EXIT:
IF OBJECT_ID('tempdb.dbo.#tblAFC') IS NOT NULL DROP TABLE #tblAFC
IF OBJECT_ID('tempdb.dbo.#destArchFileCopy') IS NOT NULL DROP TABLE #destArchFileCopy
IF OBJECT_ID('tempdb.dbo.#tmpJobSizeInfo') IS NOT NULL DROP TABLE #tmpJobSizeInfo
IF	@retVal = 0 AND @nSkippedAFs <> 0
	SELECT @amErrCode, @nSkippedAFs, @l_insertedChunksCount
ELSE
	SELECT @retVal, @nSkippedAFs, @l_insertedChunksCount
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToMediaRefreshInsert')
	delete from GxQscripts where name = 'archChunkToMediaRefreshInsert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToMediaRefreshInsert')
	delete from GXDBVersions where aliasname = 'archChunkToMediaRefreshInsert'
GO

insert into GXDBVersions values(2, 'archChunkToMediaRefreshInsert',  '00000000000000000000', 'archChunkToMediaRefreshInsert', '00000000000000000000')
GO

