

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToMediaRefreshAllowed.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToMediaRefreshAllowed.sp,v $ $Id: archChunkToMediaRefreshAllowed.sp,v 1.1.2.4 2020/08/24 15:16:12 sjohnson Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archChunkToMediaRefreshAllowed')
BEGIN
	print '>>> Drop Stored Procedure: archChunkToMediaRefreshAllowed <<<'
	drop procedure archChunkToMediaRefreshAllowed
END
IF EXISTS (select * from GxQscripts where name='archChunkToMediaRefreshAllowed')
	delete from GxQscripts where name = 'archChunkToMediaRefreshAllowed'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToMediaRefreshAllowed')
	delete from GXDBVersions where aliasname = 'archChunkToMediaRefreshAllowed'
GO
print '... Creating Procedure: archChunkToMediaRefreshAllowed'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archChunkToMediaRefreshAllowed
  @i_adminJobId integer
AS
  DECLARE @errorCode integer;	-- newly added for error code.
  DECLARE @returnValue integer; -- -- copy id
-- DECLARE	@i_adminJobId INTEGER = 56599
IF EXISTS (SELECT * FROM GxGlobalParam WITH (READUNCOMMITTED) WHERE NAME = 'CheckUseScalableResourceOptionAllowed' AND Value = '0')
BEGIN
	SET @returnValue = 1
	SET @errorCode = 0
	GOTO CX_EXIT
END
DECLARE @l_SIDBStoreId INTEGER = 0 -- ISNULL(dbo.GetOptionInt(SIDBSTORE_SIDB_STORE_ID /*SIDBSTORE_SIDB_STORE_ID*/, @i_adminJobId, 0, 0), 0)
DECLARE @l_archGroupId INTEGER = 0 -- ISNULL(dbo.GetOptionInt(COM_POLICY_ID /*COM_POLICY_ID*/, @i_adminJobId, 0, 0), 0)
DECLARE @l_archGroupCopyId INTEGER = 0 -- ISNULL(dbo.GetOptionInt(COM_COPY_ID /*COM_COPY_ID*/, @i_adminJobId, 0, 0), 0)
DECLARE @l_srcMediaAgentId INTEGER = 0 -- dbo.GetOptionInt(AUXCOPYJOBOPTION_MEDIAAGENT_MEDIA_AGENT_ID /*AUXCOPYJOBOPTION_MEDIAAGENT_MEDIA_AGENT_ID*/, @i_adminJobId, 0, 0)
DECLARE @JobOptions TABLE (optionId INTEGER, value INTEGER)
INSERT INTO @JobOptions
SELECT	optionId, (CASE WHEN ISNUMERIC(VALUE) = 1 THEN CAST(Value AS INTEGER) ELSE 0 END)
FROm	dbo.GetAllJobOptions(@i_adminJobId)
WHERE	OptionId IN (229570007, 140008, 140009, 1564054677)
SELECT
@l_SIDBStoreId = ISNULL([229570007], 0),
@l_archGroupId = ISNULL([140008], 0),
@l_archGroupCopyId =  ISNULL([140009], 0),
@l_srcMediaAgentId =  ISNULL([1564054677], 0)
FROM
(SELECT *
    FROM @JobOptions) AS SourceTable
PIVOT
(
MAX(Value)
FOR OptionId IN ([229570007], [140008], [140009], [1564054677])
) AS PivotTable
DECLARE @l_srcMediaAgentVersion INTEGER = 0
SELECT	@l_srcMediaAgentVersion = CL.releaseId
FROM	APP_Client CL WITH (NOLOCK)
WHERE	CL.id = @l_srcMediaAgentId
		AND @l_srcMediaAgentId > 0
-- if srcMediaAgent is selected and version is less than V11 then use old auxcopy
IF (@l_srcMediaAgentId > 0 AND @l_srcMediaAgentVersion < 16)
BEGIN
	SET @returnValue = 0
	GOTO CX_EXIT
END
DECLARE @srcCopyIds TABLE (CopyId INT)
INSERT INTO @srcCopyIds
SELECT	(CASE WHEN C.sourceCopyId > 0 THEN C.sourceCopyId WHEN C.isSnapCopy = 0 THEN AG.defaultCopy ELSE AG.defaultSnapCopy END)
FROM	archGroupCopy C WITH (READUNCOMMITTED), archGroup AG WITH (READUNCOMMITTED)
WHERE	C.id = @l_archGroupCopyId
		AND @l_archGroupCopyId > 0
		AND C.archGroupId = AG.ID
IF NOT EXISTS( SELECT * FROM @srcCopyIds)
BEGIN
	INSERT INTO @srcCopyIds
	SELECT	defaultCopy
	FROM	archGroup AG WITH (READUNCOMMITTED)
	WHERE	AG.id = @l_archGroupId
	INSERT INTO @srcCopyIds
	SELECT	defaultSnapCopy
	FROM	archGroup AG WITH (READUNCOMMITTED)
	WHERE	AG.id = @l_archGroupId
END
SET @returnValue = 1
SET @errorCode = 0
 --Return false If any of the selected copy is Snap Copy
  DECLARE @returnTable TABLE (
	errorCode integer,	-- newly added for error code.
	id		  integer, -- -- copy id
    policyName VARCHAR(1024),
    copyName VARCHAR(1024),
    archGroupId integer,
	srcCopyId integer,
    copyStartTime integer,
    copyType integer,
    spFlags integer,
    copyFlags integer,
    copyFlagsExt integer,
    copyLevel integer,
   deferredDays integer,
----  startReadTime integer,
   markCopiedTime integer,
    maxMultiplex integer,
    SIDBStoreId integer,
    dedupeFlags integer,
    encType integer,
    encKeyLen integer,
    isSnapCopy integer,
    isMirrorCopy integer,
    isNasCopy integer,
    isActive integer,
	hasOlderMediaAgent integer Default 0)
INSERT INTO @returnTable (	errorCode, id, policyName, copyName,
							archGroupId, srcCopyId, copyStartTime, copyType, spFlags, copyFlags, copyFlagsExt,
							copyLevel, deferredDays, markCopiedTime, maxMultiplex,
							SIDBStoreId, dedupeFlags, encType, encKeyLen, isSnapCopy, isMirrorCopy, isNasCopy, isActive)
EXEC archGetMediaRefreshCopyProperties @l_archGroupCopyId, @l_archGroupId
SELECT @errorCode = @@ERROR
IF (@errorCode != 0) GOTO CX_EXIT
IF EXISTS (SELECT	*
			FROM	@returnTable R, archGroupControlHost H WITH (READUNCOMMITTED)
			WHERE	R.isSnapCopy = 1
					AND R.archGroupId = H.ArchGroupId)
BEGIN
	SET @returnValue = 0
	GOTO CX_EXIT
END
IF (EXISTS (SELECT	*
			FROM	@returnTable R, MMDataPath DPath WITH (NOLOCK), MMDrivepool DPool WITH (NOLOCK), APP_Client CL WITH (NOLOCK)
			WHERE	R.id IN (SELECT CopyId FROM @srcCopyIds)
					AND DPath.copyId = R.id
					AND DPath.DrivePoolId = DPool.DrivePoolId
					AND DPool.ClientId = CL.id
					AND CL.releaseId < 16
					AND (@l_srcMediaAgentId = 0 OR @l_srcMediaAgentId = CL.id)))
BEGIN
	SET @returnValue = 0
	GOTO CX_EXIT
END
IF (@l_srcMediaAgentId > 0)
BEGIN
	IF NOT EXISTS (SELECT	*
					FROM	@returnTable R, MMDataPath DPath WITH (NOLOCK), MMDrivepool DPool WITH (NOLOCK), APP_Client CL WITH (NOLOCK)
					WHERE	R.id NOT IN (SELECT CopyId FROM @srcCopyIds)
							AND DPath.copyId = R.id
							AND DPath.DrivePoolId = DPool.DrivePoolId
							AND DPool.ClientId = CL.id
							AND CL.releaseId >= 16)
	BEGIN
		SET @returnValue = 0
		GOTO CX_EXIT
	END
END
ELSE
BEGIN
	IF EXISTS (SELECT	*
					FROM	@returnTable R, MMDataPath DPath WITH (NOLOCK), MMDrivepool DPool WITH (NOLOCK), APP_Client CL WITH (NOLOCK)
					WHERE	R.id NOT IN (SELECT CopyId FROM @srcCopyIds)
							AND DPath.copyId = R.id
							AND DPath.DrivePoolId = DPool.DrivePoolId
							AND DPool.ClientId = CL.id
							AND CL.releaseId < 16)
	BEGIN
	SET	@returnValue = 0
		GOTO CX_EXIT
	END
END
SELECT @errorCode = @@ERROR
IF (@errorCode != 0) GOTO CX_EXIT
CX_EXIT:
SELECT @errorCode, @returnValue
GO
-- End code

IF EXISTS (select * from GxQscripts where name = 'archChunkToMediaRefreshAllowed')
	delete from GxQscripts where name = 'archChunkToMediaRefreshAllowed'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToMediaRefreshAllowed')
	delete from GXDBVersions where aliasname = 'archChunkToMediaRefreshAllowed'
GO

insert into GXDBVersions values(2, 'archChunkToMediaRefreshAllowed',  '00010001000200040000', 'archChunkToMediaRefreshAllowed', '00010001000200040000')
GO

