

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToCopyTotalDataSize.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToCopyTotalDataSize.sp,v $ $Id: archChunkToCopyTotalDataSize.sp,v 1.11.14.3 2018/03/22 00:58:34 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archChunkToCopyTotalDataSize <<<'

IF EXISTS (select * from sysobjects where name='archChunkToCopyTotalDataSize')
	drop procedure archChunkToCopyTotalDataSize
IF EXISTS (select * from GxQscripts where name='archChunkToCopyTotalDataSize')
	delete from GxQscripts where name = 'archChunkToCopyTotalDataSize'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToCopyTotalDataSize')
	delete from GXDBVersions where aliasname = 'archChunkToCopyTotalDataSize'
GO
print '... Creating Procedure: archChunkToCopyTotalDataSize'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archChunkToCopyTotalDataSize
  @i_destCopyId int,
  @i_adminJobId int
AS
  DECLARE @o_totalDataSize bigint;
  DECLARE @o_totalUnCompBytesDataSize bigint;
  DECLARE @o_copiedDataSizeByJob bigint;
  DECLARE @o_copiedUnCompBytesDataSizeByJob bigint;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @copiedBytes bigint
DECLARE @totalSize bigint
DECLARE @copiedUnCompBytes bigint
DECLARE @totalUnCompBytesSize bigint
DECLARE	@oneConstReal REAL = 1.0
DECLARE @copiedBytesByJob bigint
DECLARE @copiedUnCompBytesByJob bigint
SET @copiedBytes = 0;
SET @totalSize = 0;
SELECT	@copiedBytes = ISNULL((SUM(b.physicalSize - a.physicalOffset)), 0),
		--@copiedUnCompBytes = CAST((ISNULL(SUM(((b.physicalSize - a.physicalOffset)*@oneConstReal*a.unCompBytesSize)/(CASE WHEN a.physicalSize <> 0 THEN a.physicalSize ELSE 1 END)), 0)) AS BIGINT)
		@copiedUnCompBytes = CAST((SUM( CASE WHEN a.physicalSize = 0 THEN (b.physicalSize - a.physicalOffset) ELSE (((b.physicalSize - a.physicalOffset)*@oneConstReal*a.unCompBytesSize)/ a.physicalSize)  END)) AS BIGINT)
FROM	archChunkToCopy a WITH (nolock), archFileCopy b WITH (nolock)
WHERE	a.destCopyId = @i_destCopyId
AND		a.archFileId = b.archFileId
AND		a.commCellId = b.commCellId
AND		b.archCopyId = @i_destCopyId
AND		b.physicalSize >= a.physicalOffset
-- To Calculate the copied size by this auxcopy job or media refresh jobs
-- To calculate this
--     1. Find the all the new chunks created on the destination copy for archive files to be copied by this job
--     2. For these chunks find the corresponding application size by calling archGetJobSizeInfo store procedure
-- For Media Refresh in addition to destination copy we should also get the chunks from source copy as some of the media might have been moved back to source copy
DECLARE @retVal integer
CREATE TABLE #tmpChunkInfo (
		archFileId integer, commCellId integer, jobId integer, archChunkId bigint, chunkCommCellId integer, physicalSize bigint, logicalSize bigint, unCompBytesSize bigint)
CREATE TABLE #tmpJobSizeInfo (
	JobId INT, CommCellId INT, totalBackupSize BIGINT, totalAppSize BIGINT, totalIndexSize BIGINT
 	PRIMARY KEY (JobId, CommCellId))
DECLARE		@opType integer = 0
DECLARE		@mediaRefreshSrcCopy integer = -1
DECLARE		@archGroupFlags int
SELECT  @opType = opType
FROM	JMJobInfo  WITH (nolock)
WHERE	jobID = @i_adminJobId
SELECT @archGroupFlags = AG.flags
FROM archGroup AG, archGroupCopy AGC
WHERE AG.id = AGC.archGroupId
	AND AGC.id = @i_destCopyId
IF (@opType = 74) --MEDIAREFRESHINGJOB
BEGIN
	SELECT	TOP 1 @mediaRefreshSrcCopy = copyId
	FROM	archCopyMediaRefreshProp  WITH (nolock)
	WHERE	targetCopyId = @i_destCopyId
END
INSERT INTO #tmpChunkInfo
SELECT	ACM.archFileId, ACM.commCellId, ACM.jobId, ACM.archChunkId, ACM.chunkCommCellId, ACM.physicalSize, ACM.logicalSize, ACM.unCompSize
FROM	archChunkMapping ACM WITH (nolock), archChunk AC WITH (nolock),
		(SELECT DISTINCT archFileId, CommCellId
		FROM archChunkToCopyHistory WITH (nolock)
		WHERE	adminJobId = @i_adminJobId
				AND destCopyId = @i_destCopyId) H
WHERE	H.archFileId = ACM.archFileId
		AND H.commCellId = ACM.commCellId
		AND (@i_destCopyId = ACM.archCopyId
OR ( ((@archGroupFlags & 16384 = 0) AND  @mediaRefreshSrcCopy = ACM.archCopyId)
				OR ( ACM.archCopyId IN ( SELECT id FROM archGroupCopy WHERE destMediaCopyId = @mediaRefreshSrcCopy )) ) )
		AND ACM.archChunkId = AC.id
		AND ACM.chunkCommCellId = AC.commCellId
		AND AC.createTime > (	SELECT	jobStartTime FROM	JMJobInfo WITH (NOLOCK) WHERE	jobId = @i_adminJobId)
INSERT INTO #tmpJobSizeInfo
SELECT	DISTINCT JobId, CommCellId, 0, 0, 0
FROM #tmpChunkInfo
WHERE	unCompBytesSize = -1
EXEC  @retVal = archGetJobSizeInfo 0
UPDATE	#tmpChunkInfo
SET		unCompBytesSize = (CASE WHEN totalBackupSize > 0 THEN CAST(((@oneConstReal * (totalAppSize+totalIndexSize)*physicalSize)/totalBackupSize) AS BIGINT) ELSE physicalSize END)
FROM	#tmpJobSizeInfo J
WHERE	#tmpChunkInfo.JobId = J.JobId
		AND #tmpChunkInfo.CommCellId = J.CommCellId
		AND #tmpChunkInfo.unCompBytesSize = -1
SELECT	@copiedBytesByJob = SUM(physicalSize), @copiedUnCompBytesByJob = SUM(unCompBytesSize)
FROM	#tmpChunkInfo
SELECT @totalSize = ISNULL(SUM(physicalSize), 0), @totalUnCompBytesSize = ISNULL(SUM(unCompBytesSize), 0)
from archChunkToCopy
where destCopyId = @i_destCopyId
SELECT @totalSize - @copiedBytes, @totalUnCompBytesSize - @copiedUnCompBytes, @copiedBytesByJob, @copiedUnCompBytesByJob
DROP TABLE #tmpJobSizeInfo
DROP TABLE #tmpChunkInfo
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToCopyTotalDataSize')
	delete from GxQscripts where name = 'archChunkToCopyTotalDataSize'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToCopyTotalDataSize')
	delete from GXDBVersions where aliasname = 'archChunkToCopyTotalDataSize'
GO

insert into GXDBVersions values(2, 'archChunkToCopyTotalDataSize',  '00010011001400030000', 'archChunkToCopyTotalDataSize', '00010011001400030000')
GO

