

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToCopySetStream.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToCopySetStream.sp,v $ $Id: archChunkToCopySetStream.sp,v 1.14.86.8 2018/07/11 07:31:09 kjaiswal Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archChunkToCopySetStream <<<'

IF EXISTS (select * from sysobjects where name='archChunkToCopySetStream')
	drop procedure archChunkToCopySetStream
IF EXISTS (select * from GxQscripts where name='archChunkToCopySetStream')
	delete from GxQscripts where name = 'archChunkToCopySetStream'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToCopySetStream')
	delete from GXDBVersions where aliasname = 'archChunkToCopySetStream'
GO
print '... Creating Procedure: archChunkToCopySetStream'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archChunkToCopySetStream
  @i_destCopyId int,
  @i_destStream int,
  @i_srcStream int
AS
  DECLARE @o_error integer;
  DECLARE @o_errorString varchar(1024);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE	@errVal	INTEGER
	DECLARE	@errStr	VARCHAR(1024)
	SET @errVal = 0
	SET @errStr = 'NO ERROR'
	IF	@i_destStream > 0 AND @i_srcStream > 0
			AND EXISTS (SELECT 1 FROM ArchChunkToCopy WITH (NOLOCK)
						WHERE destCopyId = @i_destCopyId
						AND streamNum = @i_srcStream
						AND destStream = @i_destStream)
		GOTO CX_EXIT
	IF OBJECT_ID('tempdb.dbo.#tblSegmentStream') IS NOT NULL DROP TABLE #tblSegmentStream
	CREATE TABLE #tblSegmentStream (
		streamNum			integer,
		destStream			integer,
		segmentId			integer,
		backupJobId			integer,
		isSet				integer
	)
	CREATE INDEX tblSegmentStream_idx ON #tblSegmentStream(segmentId)
	-- Do not support dynamic stream allocation for snap copy
	IF EXISTS (SELECT 1 FROM ArchGroupCopy WITH (NOLOCK) WHERE id = @i_destCopyId AND isSnapCopy = 1)
		GOTO CX_EXIT
	DECLARE @max_destStream	INTEGER
	DECLARE @max_multiplex	INTEGER
	DECLARE @max_streamNum	INTEGER
	DECLARE @archGroupId	INTEGER
	DECLARE @sourceCopyId	INTEGER
	DECLARE @primaryCopyId	INTEGER
	DECLARE @isGacpCopy		INTEGER
	DECLARE @destMediaCopyId	INTEGER
	SELECT	@archGroupId = archGroupId,
			@max_destStream	= maxStreamNum,
			@max_multiplex = maxMultiplex,
			@sourceCopyId = sourceCopyId,
@isGacpCopy = extendedFlags & 2,
			@destMediaCopyId = destMediaCopyId
	FROM	archGroupCopy WITH (NOLOCK)
	WHERE	id = @i_destCopyId
	SELECT	@max_streamNum = maxStreams,
			@primaryCopyId = defaultCopy
	FROM	archGroup WITH (NOLOCK)
	WHERE	id = @archGroupId
	IF @max_multiplex = 0 AND @isGacpCopy > 0 AND @destMediaCopyId <> 0
			SELECT @max_multiplex = maxMultiplex
			FROM archGroupCopy WITH (NOLOCK)
			WHERE id = @destMediaCopyId
	ELSE IF @max_multiplex = 0
		SET @max_multiplex = 1
	-- Use max stream of storage policy if it is not set from destination copy.
	IF @max_destStream = 0
		SELECT	@max_destStream = maxStreams
		FROM	archGroup WITH (NOLOCK)
		WHERE	id = @archGroupId
	DECLARE @max_destDriveCount INTEGER
	-- When round robin is enabled, we should return the total drive count from all the data paths.
IF EXISTS( SELECT 1 FROM archGroupCopy WHERE flags &  512 > 0 AND id = @i_destCopyId)
		SET @max_destDriveCount = ISNULL((
				select COUNT(DISTINCT c.driveId) as driveCount
				from MMDataPath a WITH (NOLOCK)
				INNER JOIN  MMDriveController b WITH (NOLOCK) ON a.DrivePoolId = b.DrivePoolId
				INNER JOIN  MMDrive c WITH (NOLOCK) ON b.DriveId = c.DriveId
				AND b.DriveControllerEnabled = 1
				AND a.CopyId = @i_destCopyId) , 0)
	ELSE
		SET @max_destDriveCount = ISNULL((
			select MAX(driveCount) from (
				select a.DrivePoolId, COUNT(DISTINCT c.driveId) as driveCount
				from MMDataPath a WITH (NOLOCK)
				INNER JOIN  MMDriveController b WITH (NOLOCK) ON a.DrivePoolId = b.DrivePoolId
				INNER JOIN  MMDrive c WITH (NOLOCK) ON b.DriveId = c.DriveId
				and b.DriveControllerEnabled = 1
				and a.CopyId = @i_destCopyId
				group by a.DrivePoolId
			) as copyDrive), 0)
	IF @max_destStream > @max_destDriveCount AND @max_destDriveCount > 0
		SET @max_destStream = @max_destDriveCount
	DECLARE @tblMinJob TABLE (backupJobId int, segmentId int)
	DECLARE @destStream	INTEGER
	DECLARE @streamNum		INTEGER
	DECLARE @nextStream		INTEGER
	SET @nextStream = 0
	SET @destStream = 1
	SET @streamNum = 1
	IF	@i_destStream > 0 AND @i_srcStream > 0
	BEGIN
		SET @streamNum = @i_srcStream
		SET @destStream = @i_destStream
	END
	INSERT INTO #tblSegmentStream
	SELECT streamNum, destStream, segmentId, min(backupJobId), 0
	FROM ArchChunkToCopy WITH (NOLOCK)
	WHERE destCopyId = @i_destCopyId
	AND segmentId > 0
	GROUP BY streamNum, destStream, segmentId
	WHILE 1 = 1
	BEGIN
		IF NOT EXISTS (SELECT 1 FROM #tblSegmentStream WHERE streamNum = 0 or destStream = 0)
			BREAK
		IF EXISTS (SELECT 1 FROM #tblSegmentStream WHERE streamNum = @streamNum AND destStream = @destStream)
			SET @nextStream = 1
		IF @nextStream > 0
		BEGIN
			IF	@i_destStream > 0 AND @i_srcStream > 0
				BREAK
			SET @streamNum = @streamNum + 1
			SET @destStream = @destStream + 1
			IF @streamNum > @max_multiplex * @max_destStream
				BREAK
			IF @streamNum > @max_streamNum
				BREAK
			IF @destStream > @max_destStream
				SET @destStream = 1
			SET @streamNum = @streamNum
			SET @destStream = @destStream
			SET @nextStream = 0
			CONTINUE
		END
		DECLARE @t_segmentId INTEGER
        DELETE FROM @tblMinJob
		INSERT INTO @tblMinJob
		SELECT top 1 backupJobId, segmentId
		FROM #tblSegmentStream
		WHERE streamNum = 0
		AND destStream = @destStream
		ORDER BY backupJobId, segmentId
		IF @@ROWCOUNT = 1
		BEGIN
				SET @t_segmentId = (SELECT segmentId FROM @tblMinJob)
				UPDATE #tblSegmentStream
				SET StreamNum = @streamNum, isSet = 1
				WHERE segmentId = @t_segmentId
				CONTINUE
		END
        DELETE FROM @tblMinJob
		INSERT INTO @tblMinJob
		SELECT top 1 backupJobId, segmentId
		FROM #tblSegmentStream
		WHERE streamNum = 0
		AND destStream = 0
		ORDER BY backupJobId, segmentId
		IF @@ROWCOUNT = 1
		BEGIN
				SET @t_segmentId = (SELECT segmentId FROM @tblMinJob)
				UPDATE #tblSegmentStream
				SET streamNum = @streamNum, destStream = @destStream, isSet = 1
				WHERE segmentId = @t_segmentId
				CONTINUE
		END
		SET @nextStream = 1
	END
	--
	-- Source stream for chunks from previous attemps
	-- which have higher destinamtion stream number
	-- than current setting won't be set be above logic.
	-- We need to set them the same as destStream.
	--
	IF @i_destStream = 0 AND @i_srcStream = 0
	BEGIN
		UPDATE #tblSegmentStream
		SET streamNum = destStream, isSet = 1
		FROM #tblSegmentStream
		WHERE streamNum = 0
		AND destStream > @max_destStream
	END
	BEGIN TRAN archChunkToCopySetStream_tran
	UPDATE ArchChunkToCopy
	SET streamNum = b.streamNum, destStream = b.destStream
	FROM ArchChunkToCopy a
	INNER JOIN #tblSegmentStream b ON a.segmentId = b.segmentId
	AND a.destCopyId = @i_destCopyId
	AND b.isSet = 1
	SELECT @errVal = @@ERROR
	IF @errVal <> 0
	BEGIN
			SET @errStr = 'Failed to update StreamNum in ArchChunkToCopy: DB error!'
			GOTO CX_EXIT_ERROR
	END
	UPDATE ArchFileCopy
SET streamNum = c.destStream, flags = flags | 2048
	FROM ArchFileCopy a
	INNER JOIN ArchChunkToCopy b ON a.archFileId = b.archFileId
									AND a.commCellId = b.commCellId
									AND a.archCopyId = b.destCopyId
	INNER JOIN #tblSegmentStream c ON b.segmentId = c.segmentId
	AND b.destCopyId = @i_destCopyId
	AND c.isSet = 1
	SELECT @errVal = @@ERROR
	IF @errVal <> 0
	BEGIN
			SET @errStr = 'Failed to update StreamNum in ArchFileCopy: DB error!'
			GOTO CX_EXIT_ERROR
	END
	DELETE ArchChunkToCopyDSA
	FROM ArchChunkToCopyDSA a
	INNER JOIN ArchChunkToCopy b ON a.archFileId = b.archFileId
									AND a.commCellId = b.commCellId
									AND a.destCopyId = b.destCopyId
	INNER JOIN #tblSegmentStream c ON b.segmentId = c.segmentId
	AND b.destCopyId = @i_destCopyId
	AND c.isSet = 1
	SELECT @errVal = @@ERROR
	IF @errVal <> 0
	BEGIN
			SET @errStr = 'Failed to delete from ArchChunkToCopyDSA: DB error!'
			GOTO CX_EXIT_ERROR
	END
	INSERT INTO ArchChunkToCopyDSA
	SELECT DISTINCT a.adminJobId, a.archCopyId, a.destCopyId,
					a.archFileId, a.commCellId,
					a.streamNum, a.destStream, a.segmentId,
					GETUTCDATE()
	FROM ArchChunkToCopy a
	INNER JOIN #tblSegmentStream b ON a.segmentId = b.segmentId
	AND a.destCopyId = @i_destCopyId
	AND b.isSet = 1
	SELECT @errVal = @@ERROR
	IF @errVal <> 0
	BEGIN
			SET @errStr = 'Failed to insert into ArchChunkToCopyDSA: DB error!'
			GOTO CX_EXIT_ERROR
	END
	SET @errStr = 'All streams are assigned for copy with multiplex factor: [' + convert(varchar(10), @max_multiplex) + '] and max stream: [' + convert(varchar(10), @max_destStream) + ']'
	COMMIT TRAN archChunkToCopySetStream_tran
CX_EXIT:
	SELECT 0, ''
	RETURN
CX_EXIT_ERROR:
	ROLLBACK TRAN archChunkToCopySetStream_tran
	SELECT @errVal, @errStr
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToCopySetStream')
	delete from GxQscripts where name = 'archChunkToCopySetStream'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToCopySetStream')
	delete from GXDBVersions where aliasname = 'archChunkToCopySetStream'
GO

insert into GXDBVersions values(2, 'archChunkToCopySetStream',  '00010014008600080000', 'archChunkToCopySetStream', '00010014008600080000')
GO

