

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToCopySegment.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToCopySegment.sp,v $ $Id: archChunkToCopySegment.sp,v 1.14.88.5 2018/03/22 01:05:59 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archChunkToCopySegment <<<'

IF EXISTS (select * from sysobjects where name='archChunkToCopySegment')
	drop procedure archChunkToCopySegment
IF EXISTS (select * from GxQscripts where name='archChunkToCopySegment')
	delete from GxQscripts where name = 'archChunkToCopySegment'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToCopySegment')
	delete from GXDBVersions where aliasname = 'archChunkToCopySegment'
GO
print '... Creating Procedure: archChunkToCopySegment'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archChunkToCopySegment
  @i_destCopyId int,
  @i_minSegmentGB bigint
AS
  DECLARE @o_error integer;
  DECLARE @o_errorString varchar(1024);
  DECLARE @o_lastSegmentId integer;
SET NOCOUNT ON
BEGIN TRAN archChunkToCopySegment_tran
	IF object_id('tempdb.dbo.#tblChunkToCopy') IS NOT NULL DROP TABLE #tblChunkToCopy
	IF object_id('tempdb.dbo.#tblChunkInSegment') IS NOT NULL DROP TABLE #tblChunkInSegment
	DECLARE	@cursor	INTEGER
	DECLARE	@errVal	INTEGER
	DECLARE	@errStr	VARCHAR(1024)
	DECLARE @segmentId	INTEGER
	SET @segmentId = 0
	SET @errVal = 0
	SET @errStr = 'NO ERROR'
	SET @cursor = 0
	IF @i_minSegmentGB = 0
		SET @i_minSegmentGB = 2
	create table #tblChunkToCopy (
		id					integer IDENTITY (1,1),
		archCopyId			integer,
		archChunkId			bigint,
		archFileId			integer,
		commCellId			integer,
		mediaGroupId		integer,
		destStream			integer,
		physicalSize		bigint,
		segmentID			int,
		primary key (id)
	)
	create index ChunkToCopy_temp_idx_1 on #tblChunkToCopy (archFileId, commCellId)
	create index ChunkToCopy_temp_idx_2 on #tblChunkToCopy (archChunkId, commCellId)
	create index ChunkToCopy_temp_idx_3 on #tblChunkToCopy (archCopyId, mediaGroupId, commCellId, archFileId)
	create table #tblChunkInSegment (
		id					integer,
		archCopyId			integer,
		archChunkId			bigint,
		archFileId			integer,
		commCellId			integer,
		mediaGroupId		integer,
		destStream			integer,
		physicalSize		bigint,
		segmentID			int,
		primary key (id)
	)
	create index ChunkInSegment_temp_idx_1 on #tblChunkInSegment (archFileId, commCellId)
	create index ChunkInSegment_temp_idx_2 on #tblChunkInSegment (archChunkId, commCellId)
	-- Do not support dynamic stream allocation for snap copy
	IF EXISTS (SELECT * FROM ArchGroupCopy WITH (NOLOCK) WHERE id = @i_destCopyId AND isSnapCopy = 1)
		GOTO CX_EXIT
	DECLARE @multiplex         INTEGER = 0
    if exists (
            select destCopyId, archchunkid
            from ArchChunkToCopy with (NOLock)
            where destCopyId = @i_destCopyId
            group by destCopyId, archchunkid having count(archfileid) > 1
            )
    SET @multiplex = 1
	INSERT INTO #tblChunkToCopy
	SELECT a.archCopyId, a.archChunkId, a.archFileId, a.commCellId, a.mediaGroupId, a.destStream, a.physicalSize, 0
	FROM ArchChunkToCopy a WITH (NOLOCK), MMVolume b WITH (NOLOCK), MMMedia c WITH (NOLOCK)
	WHERE a.destCopyId = @i_destCopyId
	AND a.volumeId = b.volumeId
	AND b.mediaId = c.mediaId
	AND c.mediaTypeId = 10001
	AND a.segmentId = 0
	IF @@ROWCOUNT = 0
		GOTO CX_EXIT
	UPDATE #tblChunkToCopy
	SET destStream = 0
	FROM #tblChunkToCopy a, ArchFileCopy b WITH (NOLOCK)
	WHERE a.archFileId = b.archFileId
	AND a.commCellId = b.commCellId
	AND b.archCopyId = @i_destCopyId
AND b.flags & 2048 = 0
	and b.lastChunkNumber = 0 AND b.physicalSize = 0
	-- Clear source stream and media group info
	UPDATE ArchChunkToCopy
	SET streamNum = 0, destStream = b.destStream
	FROM ArchChunkToCopy a, #tblChunkToCopy b
	WHERE a.archChunkId = b.archChunkId
	AND a.archFileId = b.archFileId
	AND a.commCellId = b.commCellId
	AND a.destCopyId = @i_destCopyId
	AND a.archCopyId = b.archCopyId
	SELECT @errVal = @@ERROR
	IF @errVal <> 0
	BEGIN
			SET @errStr = 'Failed to clear streams for ArchChunkToCopy: DB error!'
			GOTO CX_EXIT_ERROR
	END
	DECLARE @archFileId		INTEGER
	DECLARE @commCellId		INTEGER
	DECLARE @archCopyId		INTEGER
	DECLARE @mediaGroupId	INTEGER
	DECLARE @destStream		INTEGER
	DECLARE @mediaGroupId_prev INTEGER
	SET @mediaGroupId_prev = -1
	DECLARE @destStream_prev INTEGER
	SET @destStream_prev = -1
	DECLARE AFCursor CURSOR FOR
			SELECT DISTINCT archCopyId, archFileId, commCellId, mediaGroupId, destStream
			FROM #tblChunkToCopy
			ORDER BY archCopyId, mediaGroupId, commCellId, archFileId
	OPEN AFCursor
	SET @cursor = 1
	FETCH NEXT from AFCursor INTO @archCopyId, @archFileId, @commCellId, @mediaGroupId, @destStream
	WHILE (1 = 1)
	BEGIN
		DECLARE @fetchNext INTEGER
		SET @fetchNext = 1
		IF @@FETCH_STATUS <> 0
			GOTO CREATE_SEGMENT
		IF EXISTS (select * from #tblChunkToCopy WITH (NOLOCK)
					where archFileId = @archFileId
					and commCellId = @commCellId
					and archCopyId = @archCopyId
					and segmentId > 0
					)
			GOTO FETCH_NEXT
		IF @mediaGroupId_prev < 0
			SET @mediaGroupId_prev = @mediaGroupId
		IF @destStream_prev < 0
			SET @destStream_prev = @destStream
		IF @mediaGroupId_prev <> @mediaGroupId
		BEGIN
			-- MediaGroupId changed, needs to group previous chunks
			-- This archive file will be processed again
			SET @mediaGroupId_prev = @mediaGroupId
			SET @fetchNext = 0
			GOTO CREATE_SEGMENT
		END
		IF @destStream_prev <> @destStream
		BEGIN
			-- destStream changed, needs to group previous chunks
			-- This archive file will be processed again
			SET @destStream_prev = @destStream
			SET @fetchNext = 0
			GOTO CREATE_SEGMENT
		END
		-- Set flag for all chunks of given archive file
		INSERT INTO #tblChunkInSegment
		SELECT a.*
		FROM #tblChunkToCopy a LEFT OUTER JOIN #tblChunkInSegment b ON a.id = b.id
		WHERE a.archFileId = @archFileId
		AND a.commCellId = @commCellId
		AND b.id IS NULL
		-- No new chunks of this archive file found
		IF @@ROWCOUNT = 0
			GOTO FETCH_NEXT
		WHILE (1 = 1)
		BEGIN
			DECLARE @sumSegmentSize bigint = 0
			DECLARE @numChunks integer = 0
			IF @multiplex > 0
            BEGIN
				-- Get linked chunks through multiplexing
				INSERT INTO #tblChunkInSegment
				SELECT DISTINCT b.*
				FROM #tblChunkInSegment a right outer join #tblChunkToCopy b on a.id = b.id INNER JOIN #tblChunkInSegment c ON c.archChunkId = b.archChunkId AND c.commCellId = b.commCellId
				WHERE a.id is null
				SET @numChunks = @@ROWCOUNT
				IF @numChunks > 0
				BEGIN
					-- Add linked archive files.
					INSERT INTO #tblChunkInSegment
					SELECT DISTINCT b.*
					FROM #tblChunkInSegment a right outer join #tblChunkToCopy b on a.id = b.id INNER JOIN #tblChunkInSegment c ON c.archFileId = b.archFileId AND c.commCellId = b.commCellId
					WHERE a.id is null
					SET @numChunks = @@ROWCOUNT
				END
			END
			SET @sumSegmentSize = (SELECT SUM(physicalSize) FROM #tblChunkInSegment)
			IF @sumSegmentSize < @i_minSegmentGB * 1024 * 1024 * 1024
			BEGIN
				IF @numChunks = 0
					GOTO FETCH_NEXT
				ELSE
					CONTINUE
			END
			IF @numChunks = 0
				BREAK;
		END
CREATE_SEGMENT:
		IF EXISTS (SELECT * FROM #tblChunkInSegment)
		BEGIN
			INSERT INTO archChunkSegment
			SELECT @i_destCopyId, @archCopyId, 0
			SELECT @errVal = @@ERROR, @segmentId = @@IDENTITY
			IF @errVal <> 0 OR @segmentId = 0
			BEGIN
					SET @errStr = 'Failed to create new segment for aux copy: DB error!'
					GOTO CX_EXIT_ERROR
			END
			DELETE FROM archChunkSegment WITH (ROWLOCK)
			WHERE segmentId = @segmentId
			SELECT @errVal = @@ERROR
			IF @errVal <> 0
			BEGIN
					SET @errStr = 'Failed to delete segment ID for aux copy: DB error!'
					GOTO CX_EXIT_ERROR
			END
			UPDATE #tblChunkToCopy
			SET segmentId = @segmentId
			FROM #tblChunkToCopy a, #tblChunkInSegment b
			WHERE a.archChunkId = b.archChunkId
			AND a.archFileId = b.archFileId
			AND a.commCellId = b.commCellId
			AND a.archCopyId = b.archCopyId
			SELECT @errVal = @@ERROR
			IF @errVal <> 0
			BEGIN
					SET @errStr = 'Failed to update segmentId for ArchChunkToCopy: DB error!'
					GOTO CX_EXIT_ERROR
			END
			-- Clear temp table
			DELETE FROM #tblChunkInSegment
		END
		IF @@FETCH_STATUS <> 0
			GOTO CX_EXIT
FETCH_NEXT:
		IF @fetchNext = 1
			FETCH NEXT from AFCursor INTO @archCopyId, @archFileId, @commCellId, @mediaGroupId, @destStream
	END
CX_EXIT:
	UPDATE ArchChunkToCopy
	SET segmentId = b.segmentID
	FROM ArchChunkToCopy a, #tblChunkToCopy b
	WHERE a.archChunkId = b.archChunkId
	AND a.archFileId = b.archFileId
	AND a.commCellId = b.commCellId
	AND a.destCopyId = @i_destCopyId
	AND a.archCopyId = b.archCopyId
	IF object_id('tempdb.dbo.#tblChunkToCopy') IS NOT NULL DROP TABLE #tblChunkToCopy
	IF object_id('tempdb.dbo.#tblChunkInSegment') IS NOT NULL DROP TABLE #tblChunkInSegment
	IF @cursor = 1
	BEGIN
		CLOSE AFCursor
		DEALLOCATE AFCursor
	END
	COMMIT TRAN archChunkToCopySegment_tran
	SELECT 0, '', @segmentId
	RETURN
CX_EXIT_ERROR:
	IF object_id('tempdb.dbo.#tblChunkToCopy') IS NOT NULL DROP TABLE #tblChunkToCopy
	IF object_id('tempdb.dbo.#tblChunkInSegment') IS NOT NULL DROP TABLE #tblChunkInSegment
	IF @cursor = 1
	BEGIN
		CLOSE AFCursor
		DEALLOCATE AFCursor
	END
	ROLLBACK TRAN archChunkToCopySegment_tran
	SELECT @errVal, @errStr, @segmentId
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToCopySegment')
	delete from GxQscripts where name = 'archChunkToCopySegment'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToCopySegment')
	delete from GXDBVersions where aliasname = 'archChunkToCopySegment'
GO

insert into GXDBVersions values(2, 'archChunkToCopySegment',  '00010014008800050000', 'archChunkToCopySegment', '00010014008800050000')
GO

