

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToCopyListMedia.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToCopyListMedia.sp,v $ $Id: archChunkToCopyListMedia.sp,v 1.17.200.2 2018/03/22 00:56:08 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archChunkToCopyListMedia <<<'

IF EXISTS (select * from sysobjects where name='archChunkToCopyListMedia')
	drop procedure archChunkToCopyListMedia
IF EXISTS (select * from GxQscripts where name='archChunkToCopyListMedia')
	delete from GxQscripts where name = 'archChunkToCopyListMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToCopyListMedia')
	delete from GXDBVersions where aliasname = 'archChunkToCopyListMedia'
GO
print '... Creating Procedure: archChunkToCopyListMedia'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archChunkToCopyListMedia
  @i_destCopyId int,
  @i_destStream int,
  @i_srcStream int
AS
  DECLARE @o_dstStream int;
  DECLARE @o_srcCopyId int;
  DECLARE @o_srcStream int;
  DECLARE @o_volumeId int;
  DECLARE @o_mediaId int;
  DECLARE @o_mediaGroupId int;
  DECLARE @o_archFileId int;
  DECLARE @o_commCellId int;
  DECLARE @o_barcode varchar(256);
  DECLARE @o_firstChunkId bigint;
  DECLARE @o_lastChunkId bigint;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE	@tblMediaInfo	TABLE (
	destStream int, srcCopyId int, srcStream int,
	volumeId int, mediaId int, mediaGroupId int,
	archFileId int, commCellId int, fileMarkerNo int, archChunkId bigint)
DECLARE	@tblMedia	TABLE (
	destStream int, srcCopyId int, srcStream int,
	volumeId int, mediaId int, mediaGroupId int,
archFileId int, commCellId int, barcode varchar(256),
	firstChunkId bigint, lastChunkId bigint)
DECLARE @isSnapCopy integer
IF EXISTS (SELECT * FROM ArchGroupCopy WITH (NOLOCK) WHERE id = @i_destCopyId AND isSnapCopy = 1)
    SET @isSnapCopy = 1
ELSE
    SET @isSnapCopy = 0
INSERT	INTO @tblMediaInfo
SELECT	destStream, archCopyId, streamNum, volumeId, mediaId, mediaGroupId,
		CASE WHEN extraFlags & 1 > 0 THEN archFileId ELSE 0 END,
		CASE WHEN extraFlags & 1 > 0 THEN commCellId ELSE 0 END,
		fileMarkerNo, archChunkId
FROM	archChunkToCopy WITH (NOLOCK)
WHERE	destCopyId = @i_destCopyId
	AND (@isSnapCopy = 1 or @isSnapCopy = 0 and destStream > 0 and streamNum > 0)
	AND (@i_destStream = 0 OR destStream = @i_destStream)
	AND (@i_srcStream = 0 OR streamNum = @i_srcStream)
DECLARE	@tblMediaName TABLE ( mediaId int, barcode varchar(256))
INSERT INTO @tblMediaName
select mediaId, MountPathName
from MMS2getMountPathNameGUIView WITH (NOLOCK)
where mediaId in (SELECT DISTINCT mediaId from @tblMediaInfo)
INSERT INTO @tblMediaName
select mediaId, Barcode
from MMMedia WITH (NOLOCK)
where mediaId in (SELECT DISTINCT mediaId from @tblMediaInfo)
and mediaId not in (SELECT DISTINCT mediaId from @tblMediaName)
INSERT	INTO @tblMedia
SELECT	a.destStream, a.srcCopyId, a.srcStream,
		a.volumeId, a.mediaId, a.mediaGroupId,
		a.archFileId, a.commCellId, b.barcode,
		MIN(a.archChunkId), MAX(a.archChunkId)
FROM	@tblMediaInfo a, @tblMediaName b
WHERE	A.mediaId = B.mediaId AND B.mediaId > 0
GROUP BY a.destStream, a.srcCopyId, a.srcStream,
		a.volumeId, a.mediaId, a.mediaGroupId,
		a.archFileId, a.commCellId, b.barcode
INSERT	INTO @tblMedia
SELECT	a.destStream, a.srcCopyId, a.srcStream,
		a.volumeId, MIN(a.fileMarkerNo), a.mediaGroupId,
		0, 0, '',
		MIN(a.archChunkId), MAX(a.archChunkId)
FROM	@tblMediaInfo a
WHERE	A.mediaId = 0
GROUP BY a.destStream, a.srcCopyId, a.srcStream,
		a.volumeId, a.mediaGroupId
select destStream, srcCopyId, srcStream, volumeId, mediaId, mediaGroupId, archFileId, commCellId, barcode, firstChunkId, lastChunkId
from @tblMedia
ORDER BY destStream, srcStream, archFileId, commCellId, firstChunkId
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToCopyListMedia')
	delete from GxQscripts where name = 'archChunkToCopyListMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToCopyListMedia')
	delete from GXDBVersions where aliasname = 'archChunkToCopyListMedia'
GO

insert into GXDBVersions values(2, 'archChunkToCopyListMedia',  '00010017020000020000', 'archChunkToCopyListMedia', '00010017020000020000')
GO

