

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToCopyInsert.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToCopyInsert.sp,v $ $Id: archChunkToCopyInsert.sp,v 1.84.2.18 2020/09/30 21:56:54 chandru Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archChunkToCopyInsert')
BEGIN
	print '>>> Drop Stored Procedure: archChunkToCopyInsert <<<'
	drop procedure archChunkToCopyInsert
END
IF EXISTS (select * from GxQscripts where name='archChunkToCopyInsert')
	delete from GxQscripts where name = 'archChunkToCopyInsert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToCopyInsert')
	delete from GXDBVersions where aliasname = 'archChunkToCopyInsert'
GO
print '... Creating Procedure: archChunkToCopyInsert'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archChunkToCopyInsert
  @i_adminJobId int,
  @i_destCopyId int,
  @i_destStream int,
  @i_srcCopyId int, 
  @i_srcStream int,
  @i_whichCommCell int,
  @i_AuxCopyMgr int
AS
  DECLARE @retVal int;
  DECLARE @nSkippedAFs int;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#tblAFC') IS NOT NULL DROP TABLE #tblAFC
IF OBJECT_ID('tempdb.dbo.#destArchFileCopy') IS NOT NULL DROP TABLE #destArchFileCopy
IF OBJECT_ID('tempdb.dbo.#tempJobsInput') IS NOT NULL DROP TABLE #tempJobsInput
IF OBJECT_ID('tempdb.dbo.#tmpJobSizeInfo') IS NOT NULL DROP TABLE #tmpJobSizeInfo
IF OBJECT_ID('tempdb.dbo.#tblFullJobs') IS NOT NULL DROP TABLE #tblFullJobs
IF OBJECT_ID('tempdb.dbo.#tblApp') IS NOT NULL DROP TABLE #tblApp
IF OBJECT_ID('tempdb.dbo.#tblFirstFullToBeCopied') IS NOT NULL DROP TABLE #tblFirstFullToBeCopied
IF OBJECT_ID('tempdb.dbo.#tblFullAppId') IS NOT NULL DROP TABLE #tblFullAppId
IF OBJECT_ID('tempdb.dbo.#tblSubclients') IS NOT NULL DROP TABLE #tblSubclients
CREATE TABLE #tblFullJobs ( appId int, backupJobId int, commCellId int, status int PRIMARY KEY (backupJobId, CommCellId, AppId))
CREATE TABLE #tempJobsInput
(
	jobId		integer,
	commcellId	integer
)
CREATE TABLE #tblAFC (
		archFileId int, commCellId int, fileType int, appId int, backupJobId int,
		streamNum int, flags int, physicalSize bigint, logicalSize bigint,
		srcStreamNum int, srcFlags int, srcPhysicalSize bigint, srcLogicalSize bigint,
		srcEncKeyType int, srcEncRSA int, srcEncKey varchar(1024), lastChunkNumber int,
		primary key (archFileId, commCellId) )
CREATE TABLE #tblApp(appId int PRIMARY KEY(appId))
DECLARE @l_dsaEnabled	int
DECLARE @l_commCellId	int
DECLARE @l_archGroupId	int
DECLARE @l_isSnapCopy	int
DECLARE @l_SIDBStoreId	int
DECLARE @l_ReencryptAF	int
DECLARE @useLogicalSize	int
DECLARE @amErrCode		int
DECLARE	@oneConstReal REAL = 1.0
DECLARE @l_ignoreDVFailedJobs INTEGER = ISNULL(dbo.GetOptionInt(2064661278, @i_adminJobId, 0, 0), 0)
SET		@useLogicalSize	= 0
SET		@amErrCode		= 0
SET		@nSkippedAFs	= 0
SET		@l_dsaEnabled	= 0
IF @i_destStream = 0 AND @i_srcStream = 0 AND @i_AuxCopyMgr = 0 AND EXISTS ( SELECT	*
				FROM	MMResource R WITH (NOLOCK), MMResourceToJob RJ WITH (NOLOCK),
					JMAdminJobInfoTable J WITH (NOLOCK), APP_Client AC WITH (NOLOCK)
				WHERE	R.CopyId = @i_destCopyId
						AND R.ReservationId = RJ.ReservationId
						AND R.ClientId = AC.id
						AND RJ.ReservationType = 2
						AND (RJ.InUse = 1 OR RJ.ReserveBitMask <> 0)
						AND J.jobId = RJ.JobId_l
						AND J.commCellId = 2
						AND AC.releaseId < 15 )
BEGIN
	-- Clean up the chunks for partially copied archive files
	DELETE FROM archChunkToCopy
	FROM	archFileCopy
	WHERE	archChunkToCopy.destCopyId = @i_destCopyId
			AND archChunkToCopy.archFileId = archFileCopy.archFileId
			AND archChunkToCopy.commcellId = archFileCopy.commcellId
			AND archChunkToCopy.destCopyId = archFileCopy.archCopyId
			AND archFileCopy.isValid = 0
	IF object_id('dbo.archChunkToCopyDSA') IS NOT NULL
	BEGIN
		DELETE archChunkToCopyDSA
		FROM	archFileCopy
		WHERE destCopyId = @i_destCopyId
			AND archChunkToCopyDSA.archFileId = archFileCopy.archFileId
			AND archChunkToCopyDSA.commcellId = archFileCopy.commcellId
			AND archChunkToCopyDSA.destCopyId = archFileCopy.archCopyId
			AND archFileCopy.isValid = 0
	END
SET	@amErrCode = 126
	SET @nSkippedAFs = 1
	SET	@retVal = 0
	GOTO ERR_EXIT
END
IF	(SELECT	COUNT(DISTINCT PT.CopyId)
	FROM	MMDrivePool PL WITH (NOLOCK), MMDataPath PT WITH (NOLOCK)
	WHERE	PL.DrivePoolId = PT.DrivePoolId AND PT.CopyId IN (@i_srcCopyId, @i_destCopyId) AND PL.DrivePoolType = 3) = 1
BEGIN
		SET	@useLogicalSize = 1
END
SELECT	@l_archGroupId = archGroupId,
		@l_isSnapCopy  = isSnapCopy,
@l_ReencryptAF = case when encType > 0 then (flags & 8388608) else 0 end
FROM	archGroupCopy WITH (NOLOCK) WHERE id = @i_destCopyId
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
SELECT	@l_SIDBStoreId = SIDBStoreId
FROM	archCopySIDBStore WITH (NOLOCK)
WHERE	copyId = @i_destCopyId
AND ((Flags & (2|4)) = (2|4))
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
SELECT	@l_dsaEnabled = case when (flags & 131072) = 131072 then 1 else 0 end
FROM	archGroup WITH (NOLOCK) WHERE id = @l_archGroupId
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
IF EXISTS(SELECT	*
	FROM	JMAdminJobInfoTable
	WHERE	jobId = @i_adminJobId
		AND (TotalObjects = 0 OR EXISTS(	SELECT *
											FROM	MMConfigs
											WHERE	name = 'MMS2_CONFIG_AUXCOPY_SHOULD_COPY_PREFERRED_JOBS_EVEN_AFTER_INTERRUPTIONS'
													AND Value = 1)))
BEGIN
	DECLARE @filename NVARCHAR(MAX)
	DECLARE @filename2 NVARCHAR(MAX)
	SELECT	@filename = (SELECT	TOP 1 install_dir FROM	APP_Platform WHERE	platformType = 1) + '\Base\' + AG.name + '_' + AGC.name + '_Jobs.txt',
			@filename2 = (SELECT	TOP 1 install_dir FROM	APP_Platform WHERE	platformType = 1) + '\Base\SP_'  + CAST(AG.id AS VARCHAR(10)) + '_SPC_' + CAST(AGC.id AS VARCHAR(10)) + '_Jobs.txt'
	FROM	archGroup AG, archGroupCopy AGC
	WHERE	AG.id = AGC.archGroupId
			AND AGC.id = @i_destCopyId
	BEGIN TRY
	    -- load data into temporary table
		DECLARE @SQLQuery NVARCHAR(MAX) = '
		BULK
		INSERT  #tempJobsInput
		FROM    ''' + @filename + '''
		WITH    (ROWTERMINATOR=''\n'', FIELDTERMINATOR='','', KEEPNULLS)'
		EXEC SQLAdminUtilExecQuery @SQLQuery, 1
	END TRY
	BEGIN CATCH
	/*
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	*/
		BEGIN TRY
			-- load data into temporary table
			DECLARE @SQLQuery2 NVARCHAR(MAX) = '
			BULK
			INSERT  #tempJobsInput
			FROM    ''' + @filename2 + '''
			WITH    (ROWTERMINATOR=''\n'', FIELDTERMINATOR='','', KEEPNULLS)'
			EXEC SQLAdminUtilExecQuery @SQLQuery2, 1
		END TRY
		BEGIN CATCH
		/*
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		*/
		END CATCH
	END CATCH
	UPDATE	JDS
SET		flags |= 1
	FROM	JMJobDataStats JDS WITH (NOLOCK), #tempJobsInput TJ
	WHERE	JDS.JobId = TJ.JobId
		AND JDS.CommCellId = TJ.CommCellId
		AND archGrpCopyId = @i_destCopyId
		AND status IN (101, 102, 103)
AND (disabled & (1 + 256)) = 0
	DELETE FROM #tempJobsInput
END
INSERT INTO #tempJobsInput
SELECT DISTINCT J.JobId, J.CommCellId
FROM   JMJobDataStats J WITH (READUNCOMMITTED)
WHERE	J.archGrpCopyId = @i_destCopyId
		AND J.Status IN (101, 102, 103)
AND (J.disabled & (1 + 256) = 0)
AND (J.flags & 1) > 0
SELECT AFC.*
INTO #destArchFileCopy
FROM JMJobDataStats J, archFile AF WITH (READUNCOMMITTED), archFileCopy AFC WITH (READUNCOMMITTED)
	WHERE	J.JobId = AF.JobId
			AND J.CommCellId = AF.commCellId
			AND J.archGrpCopyId = @i_destCopyId
			AND J.dataType = AF.fileType
			AND J.Status IN (101, 102, 103)
AND J.disabled & (1 + 256) = 0
			AND AF.id = AFC.archFileId
			AND AF.CommCellId = AFC.commCellId
			AND AFC.archCopyId = @i_destCopyId
			AND AFC.streamNum > 0
			AND (@i_destStream = 0 OR AFC.streamNum = @i_destStream)
			--AND (AFC.isValid = 0)
AND (AFC.flags & 256) = 0
INSERT #tblAFC
SELECT	A.archFileId, A.commCellId, 0, 0, 0,
		A.streamNum, A.flags, A.physicalSize, A.logicalSize,
		B.streamNum, B.flags, B.physicalSize, B.logicalSize,
		B.encKeyType, B.encRSA, B.encKey, B.lastChunkNumber
FROM   #destArchFileCopy A,
		archFileCopy B WITH (NOLOCK)
WHERE	A.archFileId = B.archFileId AND A.commCellId = B.commCellId
	AND B.archCopyId = @i_srcCopyId AND (@l_isSnapCopy > 0 OR B.streamNum > 0)
DELETE #tblAFC
WHERE  (srcPhysicalSize <> 0 AND srclogicalSize <> 0
		AND ( @useLogicalSize = 0 AND physicalSize > srcphysicalSize
		OR @useLogicalSize = 1 AND logicalSize > srclogicalSize))
OR (srcFlags & 256) <> 0
IF @i_srcStream > 0 AND @i_destStream > 0
BEGIN
	IF object_id('dbo.archChunkToCopyDSA') IS NOT NULL
		and @l_dsaEnabled > 0
	BEGIN
		-- Remove non-DSA archive files which use different source stream.
		DELETE #tblAFC
		FROM #tblAFC A LEFT OUTER JOIN archChunkToCopyDSA B
		ON		A.archFileId = B.archFileId
			AND A.commCellId = B.commCellId
			AND B.adminJobId = @i_adminJobId
			AND B.destCopyId = @i_destCopyId
			AND B.archCopyId = @i_srcCopyId
		WHERE B.archFileId IS NULL AND A.srcStreamNum <> @i_srcStream
		-- Remove DSA archive files which use different source streams
		DELETE #tblAFC
		FROM #tblAFC A, archChunkToCopyDSA B
		WHERE	A.archFileId = B.archFileId
			AND A.commCellId = B.commCellId
			AND B.adminJobId = @i_adminJobId
			AND B.destCopyId = @i_destCopyId
			AND B.archCopyId = @i_srcCopyId
			AND (B.streamNum <> @i_srcStream OR B.destStream <> @i_destStream)
	END
	ELSE
	BEGIN
		DELETE #tblAFC
		WHERE srcStreamNum <> @i_srcStream
	END
END
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
UPDATE	#tblAFC
SET		fileType = b.fileType, appId = b.appId, backupJobId = b.jobId
FROM	#tblAFC a, archFile b WITH (NOLOCK)
WHERE	b.id = a.archFileId AND b.commCellId = a.commCellId
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
DELETE	#tblAFC
FROM	#tblAFC AFC LEFT JOIN JMJobDataStats J WITH (NOLOCK)
	ON	J.jobId = AFC.backupJobId AND J.commCellId = AFC.commCellId
	AND J.archGrpCopyId = @i_destCopyId AND J.dataType = AFC.fileType
AND J.status IN (101, 102, 103) AND J.disabled & (1 + 256) = 0
WHERE	J.jobId IS NULL
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
DELETE	#tblAFC
FROM	#tblAFC AFC LEFT JOIN JMJobDataStats J WITH (NOLOCK)
	ON	J.jobId = AFC.backupJobId AND J.commCellId = AFC.commCellId
	AND J.archGrpCopyId = @i_srcCopyId AND J.dataType = AFC.fileType
AND J.status = 100 AND J.disabled & (1 + 256) = 0
	AND (@l_ignoreDVFailedJobs = 0 OR J.archCheckStatus != 6/*ACS_FAILED */)
WHERE	J.jobId IS NULL
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
IF @i_whichCommCell = 1
	SET @l_commCellId = (SELECT ISNULL(MIN(commCellId), 2) FROM #tblAFC)
ELSE
IF @i_whichCommCell = 2
	SET @l_commCellId = (SELECT ISNULL(MAX(commCellId), 2) FROM #tblAFC)
ELSE
	SET @l_commCellId = 2
DELETE FROM #tblAFC WHERE commCellId <> @l_commCellId
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
-- Delete the jobs which does not have archFileCopy entries for copying, this can happen if the job is already copied or arch file entries are in MMDeletedAF table
DELETE	#tempJobsInput
FROM	#tempJobsInput J LEFT JOIN #tblAFC AFC
	ON	J.jobId = AFC.backupJobId AND J.commCellId = AFC.commCellId
WHERE	AFC.backupJobId IS NULL
IF EXISTS (SELECT * FROM #tempJobsInput)
BEGIN
	DELETE	#tblAFC
	FROM	#tblAFC AFC LEFT JOIN #tempJobsInput J
		ON	J.jobId = AFC.backupJobId AND J.commCellId = AFC.commCellId
	WHERE	J.JobId IS NULL
END
-- Do not send VSA appaware child job data archfiles/chunks
DELETE	AFC
FROM	#tblAFC AFC, JMVSAAppJobLink J (READUNCOMMITTED)
WHERE	AFC.backupJobId = J.childJobId
		AND AFC.CommCellId = J.CommCellId
		AND AFC.fileType = 1
--------------------------------------------------------------------------
---- Dedup copy: copy the first full for subclients if no full copied ----
--------------------------------------------------------------------------
IF @l_SIDBStoreId <> 0 AND @i_destStream = 0 AND @i_srcStream = 0
	AND EXISTS (select 1 from MMConfigs WHERE NAME = 'MMCONFIG_AUXCOPY_COPY_FIRST_FULL_FOR_NEW_SUBCLIENT' AND VALUE = 1)
	AND NOT EXISTS (SELECT TOP 1 * FROM #tempJobsInput)
BEGIN
	-- Remove records generated by old aux copy jobs or by previous attempt before job went to pending
	DELETE FROM archChunkToCopyFirstFullOnStore
	WHERE destCopyId = @i_destCopyId
	AND (adminJobId <> @i_adminJobId OR @i_AuxCopyMgr = 0 OR SIDBStoreId != @l_SIDBStoreId)
	SELECT	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_EXIT
	CREATE TABLE #tblSubclients( appId int PRIMARY KEY(AppId))
	CREATE TABLE #tblFullAppId ( appId int PRIMARY KEY(AppId))
	INSERT INTO #tblSubclients
	SELECT DISTINCT appId
	FROM #tblAFC
	SELECT	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_EXIT
	INSERT INTO #tblFullJobs
	SELECT a.appId, a.jobId, a.commCellId, a.status
	FROM JMJobDataStats a WITH (NOLOCK), #tblSubclients b
	WHERE archGrpCopyId = @i_destCopyId
	AND a.commCellId = @l_commCellId
	AND a.appId = b.appId
	AND a.dataType = 1
AND a.disabled & (1 + 256) = 0
	AND a.status <> 1000
	SELECT	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_EXIT
	-- Remove non-full jobs
	DELETE #tblFullJobs
	FROM #tblFullJobs a, JMBkpStats b WITH (NOLOCK)
	WHERE a.backupJobId = b.jobId
	AND a.commCellId = b.commCellId
	AND b.bkpLevel not in (1, 64, 128, 1024, 32768)
	SELECT	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_EXIT
	-- Remove non-full DR jobs
	DELETE #tblFullJobs
	FROM #tblFullJobs a, JMAdminJobStatsTable b WITH (NOLOCK)
	WHERE a.backupJobId = b.jobId
	AND a.commCellId = b.commCellId
	AND ER_BkpLevel <> 1
	SELECT	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_EXIT
	-- Only full jobs should be left in #tblFullJobs at this point
	-- Skip if no full jobs left
	IF NOT EXISTS (SELECT * FROM #tblFullJobs)
		GOTO FIRST_JOB_FOR_DEDUP_DONE
	BEGIN
		WITH tblFullAppAFs_CTE(archFileId, CommCellId, appId)
		AS
		(
			SELECT	AF.id, AF.commCellId, AF.appId
			FROM	#tblFullJobs AS J, archFile AF
			WHERE	J.status = 100
					AND J.backupJobid = AF.jobId
					AND J.commCellId = AF.commCellId
		)
		INSERT INTO #tblFullAppId
		SELECT DISTINCT AF.appId
		FROM   tblFullAppAFs_CTE AS AF WITH (NOLOCK), archFileCopyDedup AS c WITH (NOLOCK)
		WHERE  AF.archFileId = c.archFileId
		   AND AF.commCellId = c.commCellId
		   AND c.archCopyId = @i_destCopyId
		   AND c.sidbStoreId = @l_SIDBStoreId
	END
	-- Remove subclients that has full job copied
	DELETE FROM #tblSubclients
	FROM #tblSubclients a, #tblFullAppId b
	WHERE a.appId = b.appId
	-- Skip if no subclients have full to be copied
	IF NOT EXISTS (SELECT * FROM #tblSubclients)
		GOTO FIRST_JOB_FOR_DEDUP_DONE
	-- Remove jobs from subclients with full copied
	DELETE FROM #tblFullJobs
	FROM #tblFullJobs
	WHERE appId NOT IN (SELECT appId FROM #tblSubclients)
	SELECT	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_EXIT
	-- Remove jobs that tried previously
	DELETE FROM #tblFullJobs
	FROM #tblFullJobs a, archChunkToCopyFirstFullOnStore b WITH (NOLOCK)
	WHERE a.appId = b.appId
	AND a.backupJobId = b.backupJobId
	AND	a.commCellId = b.commCellId
	AND	b.adminJobId = @i_adminJobId
	AND b.destCopyId = @i_destCopyId
	SELECT	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_EXIT
	-- Skip if no more full job to be copied
	IF NOT EXISTS (SELECT * FROM #tblFullJobs)
		GOTO FIRST_JOB_FOR_DEDUP_DONE
	CREATE TABLE #tblFirstFullToBeCopied ( appId int, backupJobId int, commCellId int PRIMARY KEY(appId, backupJobId, commcellId))
	INSERT INTO #tblFirstFullToBeCopied
	SELECT a.appId, MIN(a.backupJobId), a.commCellId
	FROM #tblFullJobs a, #tblAFC b
	WHERE a.backupJobId = b.backupJobId
	AND a.commCellId = b.commCellId
	GROUP BY a.appId, a.commCellId
	SELECT	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_EXIT
	IF NOT EXISTS (SELECT * FROM #tblFirstFullToBeCopied)
		GOTO FIRST_JOB_FOR_DEDUP_DONE
	-- Only copy the first full jobs here
	-- Remaining jobs will be copied during aux copy reinitialization.
	DELETE #tblAFC
	FROM #tblAFC a LEFT OUTER JOIN #tblFirstFullToBeCopied b
	ON a.appId = b.appId
	AND a.backupJobId = b.backupJobId
	AND a.commCellId = b.commCellId
	WHERE a.appId in (select distinct appId from #tblFirstFullToBeCopied)
	AND b.backupJobId IS NULL
	SELECT	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_EXIT
	INSERT INTO archChunkToCopyFirstFullOnStore
	SELECT @i_adminJobId, @i_destCopyId, @l_SIDBStoreId, appId, backupJobId, commCellId, dbo.GetUnixTime(GETUTCDATE())
	FROM #tblFirstFullToBeCopied
	SELECT	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_EXIT
END
FIRST_JOB_FOR_DEDUP_DONE:
---------------------------------------------------------------------------
-- Get subclients using User Pass Phrase
IF @l_SIDBStoreId <> 0 OR @l_ReencryptAF <> 0
BEGIN
	INSERT	INTO #tblApp
	SELECT	A.id
	FROM	APP_Application A WITH (NOLOCK), APP_ClientProp C WITH (NOLOCK),
			(SELECT	DISTINCT appId FROM #tblAFC WHERE srcEncKeyType <> 0 AND srcEncRSA <> 0) B
	WHERE	A.id = B.appId AND C.componentNameId = A.clientId
		AND C.attrName = N'Encrypt: restoreAccess' AND C.attrVal = N'1' AND C.modified = 0
END
-- If the target copy is single instanced,
-- Remove archive files from jobs which have multiplexed archive files.
-- Remove archive files from jobs encrypted with user defined pass phrase.
IF @l_SIDBStoreId <> 0
BEGIN
	DECLARE	@tblSkippedJobs TABLE (backupJobId int, commCellId int, errorCode int)
	IF	@i_srcCopyId = (SELECT defaultCopy FROM archGroup WITH (NOLOCK) WHERE id = @l_archGroupId)
		AND (SELECT maxMultiplex FROM archGroupCopy WITH (NOLOCK) WHERE id = @i_srcCopyId) > 1
        	AND NOT EXISTS(SELECT * from MMConfigs WHERE name = 'MMS2_CONFIG_AUXCOPY_BY_ARCHIVE_FILE_ORDER' AND value > 0)
	BEGIN
		INSERT	INTO @tblSkippedJobs
SELECT	DISTINCT backupJobId, commCellId, 65
		FROM	#tblAFC
WHERE	(srcFlags & 64) <> 0
		SELECT	@retVal = @@ERROR
		IF	@retVal <> 0 GOTO ERR_EXIT
	END
	INSERT	INTO @tblSkippedJobs
SELECT	DISTINCT AFC.backupJobId, AFC.commCellId, 55
	FROM	#tblAFC AFC
		INNER JOIN #tblApp APP ON AFC.appId = APP.appId
		LEFT OUTER JOIN @tblSkippedJobs J ON AFC.backupJobId = J.backupJobId AND AFC.commCellId = J.commCellId
	WHERE	J.backupJobId IS NULL
	SELECT	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_EXIT
	DELETE	archChunkSkipped
	FROM	archChunkSkipped ACS, @tblSkippedJobs J
	WHERE	ACS.backupJobId = J.backupJobId AND ACS.commCellId = J.commCellId AND ACS.destCopyId = @i_destCopyId
	SELECT	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_EXIT
	INSERT	INTO archChunkSkipped
	SELECT	0, AFC.archFileId, AFC.commCellId, @i_srcCopyId, @i_destCopyId, @i_adminJobId,
			AFC.backupJobId, 0, 0, J.errorCode, 0, 0, 0, 0
	FROM	#tblAFC AFC, @tblSkippedJobs J
	WHERE	AFC.backupJobId = J.backupJobId AND AFC.commCellId = J.commCellId
	SELECT	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_EXIT
	DELETE	#tblAFC
	FROM	#tblAFC AFC, @tblSkippedJobs J
	WHERE	AFC.backupJobId = J.backupJobId AND AFC.commCellId = J.commCellId
	SELECT	@retVal = @@ERROR, @nSkippedAFs = @@ROWCOUNT
	IF	@retVal <> 0 GOTO ERR_EXIT
	IF	@nSkippedAFs > 0
		SET @amErrCode = (SELECT TOP 1 errorCode FROM @tblSkippedJobs)
END
IF @i_srcStream = 0 AND @i_destStream = 0
BEGIN
    WHILE 1 = 1
	BEGIN
		DELETE TOP (10000) FROM archChunkToCopy
		WHERE	destCopyId = @i_destCopyId
		IF @@ROWCOUNT = 0
			BREAK
	END
END
ELSE
BEGIN
	DELETE archChunkToCopy
	FROM archChunkToCopy A, #tblAFC B
	WHERE A.archFileId = B.archFileId
	AND A.commCellId = B.commCellId
	AND A.destCopyId = @i_destCopyId
END
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
INSERT	INTO archChunkToCopy
SELECT	@i_destCopyId, a.streamNum, @i_adminJobId, a.appId,
		a.backupJobId, a.archChunkId, a.archFileId, a.commCellId, a.archCopyId,
		a.srcStreamNum, a.fileType, a.srcFlags, a.srcEncKeyType, a.lastChunkNumber,
		a.chunkNumber, a.physicalOffset, a.logicalOffset, a.physicalSize, a.logicalSize, b.volumeId, 0, 0,
		b.fileMarkerNo,	b.createTime, b.version, b.physicalSize, b.logicalSize, b.hwEncKey,	a.srcEncKey, 0, 0, a.unCompSize
FROM	(SELECT AFC.streamNum, AFC.appId, AFC.backupJobId, AFC.srcStreamNum,
				AFC.fileType, AFC.srcFlags, AFC.srcEncKeyType, AFC.srcEncKey, AFC.lastChunkNumber, ACM.*
		FROM #tblAFC AFC, archChunkMapping ACM WITH (NOLOCK)
		WHERE	(@l_isSnapCopy = 0 OR AFC.streamNum = 1)
			AND ACM.archFileId = AFC.archFileId AND ACM.commCellId = AFC.commCellId AND ACM.archCopyId = @i_srcCopyId
			AND (@useLogicalSize = 0 AND (ACM.physicalOffset + ACM.physicalSize) > AFC.physicalSize
			  OR @useLogicalSize = 1 AND (ACM.logicalOffset  + ACM.logicalSize)  > AFC.logicalSize)
		) a, archChunk b with (NOLOCK)
WHERE	b.id = a.archChunkId AND b.commCellId = a.chunkCommCellId
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
UPDATE	archChunkToCopy SET mediaId = b.MediaId, mediaGroupId = b.MediaGroupId
FROM	archChunkToCopy a, MMVolume b WITH (NOLOCK)
WHERE	a.destCopyId = @i_destCopyId AND a.volumeId = b.VolumeId
AND (a.extraFlags & 4) = 0
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
-- archChunkId for DataSetId, fileMarkerNo for ControlHostId, (chunk) createTime for snap job start time,
-- mediaGroupId for NodeId and volumeId for ExtRelationId
IF	@l_isSnapCopy <> 0
BEGIN
	DELETE	#tblAFC
	FROM	#tblAFC AFC, archChunkSkipped ACS (NOLOCK), APP_Application APP (NOLOCK)
	WHERE	AFC.archFileId = ACS.archFileId
			AND ACS.destCopyId = @i_destCopyId
			AND AFC.commCellId = ACS.commCellId
			AND ACS.adminJobId = @i_adminJobId
			AND AFC.appId = APP.id AND APP.appTypeId = 13 /*NAS*/ AND AFC.fileType = 1
	-- For OC6 DFM
	INSERT	INTO archChunkToCopy
	SELECT	@i_destCopyId, a.streamNum, @i_adminJobId, a.appId,
			a.backupJobId, a.appId, a.archFileId, a.commCellId, @i_srcCopyId,
			a.srcStreamNum, a.fileType, a.srcFlags, a.srcEncKeyType, a.lastChunkNumber,
			0, 0, 0, 0, 0, b.SMRelationId, 0, b.ArchGroupCopyId,
c.ControlHostId, J.servStartDate, 0, 0, 0, '', a.srcEncKey, 4, 0, 0
	FROM	#tblAFC a,
			(SELECT x.SMRelationId, x.ExtRelationId, SRN.ExtNodeId, y.ArchGroupCopyId
			FROM	SMRelation x WITH (NOLOCK), SMCopyToRelationMap y WITH (NOLOCK) INNER JOIN SMRelationNode SRN WITH (NOLOCK) ON y.SMRelationNodeId = SRN.SMRelationNodeId
			WHERE	y.SMRelationId = x.SMRelationId AND y.ArchGroupCopyId = @i_destCopyId) b,
			SMDataSetToSubClientMap c WITH (NOLOCK), JMBkpStats J WITH (NOLOCK),
			SMControlHost H WITH (NOLOCK)
	WHERE	a.streamNum > 1
			AND c.AppId = a.appId AND c.SMRelationId = b.SMRelationId
			AND J.jobId = a.backupJobId AND J.commCellId = a.commCellId
			AND H.ControlHostId = c.ControlHostId AND H.SMHostOption = 2
AND ((C.Flags & 256) = 0)
	-- For OC5 DFM
	INSERT	INTO archChunkToCopy
	SELECT	@i_destCopyId, a.streamNum, @i_adminJobId, a.appId,
			a.backupJobId, (CASE WHEN ISNUMERIC(SD.ExtDataSetId) = 1  THEN CAST(SD.ExtDataSetId AS INTEGER) END), a.archFileId, a.commCellId, @i_srcCopyId,
			a.srcStreamNum, a.fileType, a.srcFlags, a.srcEncKeyType, a.lastChunkNumber,
			0, 0, 0, 0, 0, b.ExtRelationId, 0, b.ExtNodeId,
c.ControlHostId, J.servStartDate, 0, 0, 0, '', a.srcEncKey, 4, 0, 0
	FROM	#tblAFC a,
			(SELECT x.SMRelationId, (CASE WHEN ISNUMERIC(x.ExtRelationId) = 1  THEN CAST(x.ExtRelationId AS INTEGER) END) AS ExtRelationId,
				(CASE WHEN ISNUMERIC(SRN.ExtNodeId) = 1  THEN CAST(SRN.ExtNodeId AS INTEGER) END) AS ExtNodeId
			FROM	SMRelation x WITH (NOLOCK), SMCopyToRelationMap y WITH (NOLOCK) INNER JOIN SMRelationNode SRN WITH (NOLOCK) ON y.SMRelationNodeId = SRN.SMRelationNodeId,
					SMControlHost H WITH (NOLOCK)
			WHERE	y.SMRelationId = x.SMRelationId AND y.ArchGroupCopyId = @i_destCopyId
					AND x.ControlHostId = H.ControlHostId AND H.SMHostOption < 2) b,
			SMDataSetToSubClientMap c WITH (NOLOCK) INNER JOIN SMDataSet SD WITH (NOLOCK) ON c.DataSetId = SD.DataSetId, JMBkpStats J WITH (NOLOCK),
			SMControlHost H WITH (NOLOCK)
	WHERE	a.streamNum > 1
			AND c.AppId = a.appId AND c.SMRelationId = b.SMRelationId
			AND J.jobId = a.backupJobId AND J.commCellId = a.commCellId
			AND H.ControlHostId = c.ControlHostId AND H.SMHostOption < 2
AND ((C.Flags & 256) = 0)
END
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_EXIT
IF EXISTS(SELECT * from MMConfigs WHERE name = 'MMS2_CONFIG_AUXCOPY_BY_ARCHIVE_FILE_ORDER' AND value > 0)
AND @l_SIDBStoreId <> 0
BEGIN
UPDATE archChunkToCopy SET extraFlags = extraFlags | 1
	WHERE adminJobId = @i_adminJobId
	AND destCopyId = @i_destCopyId
	AND archCopyId = @i_srcCopyId
	AND (@i_srcStream = 0 or streamNum = @i_srcStream)
	AND (@i_destStream = 0 or destStream = @i_destStream)
END
CREATE TABLE #tmpJobSizeInfo (
	JobId INT, CommCellId INT, totalBackupSize BIGINT, totalAppSize BIGINT, totalIndexSize BIGINT
 	PRIMARY KEY (JobId, CommCellId))
INSERT INTO #tmpJobSizeInfo
SELECT	DISTINCT backupJobId, CommCellId, 0, 0, 0
FROM archChunkToCopy
WHERE adminJobId = @i_adminJobId
	AND destCopyId = @i_destCopyId
	AND archCopyId = @i_srcCopyId
	AND (@i_srcStream = 0 or streamNum = @i_srcStream)
	AND (@i_destStream = 0 or destStream = @i_destStream)
	AND unCompBytesSize = -1
EXEC  @retVal = archGetJobSizeInfo 0
UPDATE	archChunkToCopy
SET		unCompBytesSize = (CASE WHEN totalBackupSize > 0 THEN CAST(((@oneConstReal * (totalAppSize+totalIndexSize)*physicalSize)/totalBackupSize) AS BIGINT) ELSE physicalSize END)
FROM	#tmpJobSizeInfo J
WHERE	adminJobId = @i_adminJobId
		AND destCopyId = @i_destCopyId
		AND archCopyId = @i_srcCopyId
		AND (@i_srcStream = 0 or streamNum = @i_srcStream)
		AND (@i_destStream = 0 or destStream = @i_destStream)
		AND archChunkToCopy.backupJobId = J.JobId
		AND archChunkToCopy.CommCellId = J.CommCellId
		AND archChunkToCopy.unCompBytesSize = -1
IF @i_srcStream = 0 AND @i_destStream = 0
BEGIN
	DELETE archChunkToCopyDSA
	WHERE destCopyId = @i_destCopyId
	SELECT	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_EXIT
END
ELSE
BEGIN
	DELETE archChunkToCopyDSA
	FROM archChunkToCopyDSA A, #tblAFC B
	WHERE A.archFileId = B.archFileId
	AND A.commCellId = B.commCellId
	AND A.destCopyId = @i_destCopyId
	SELECT	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_EXIT
END
ERR_EXIT:
IF OBJECT_ID('tempdb.dbo.#tblAFC') IS NOT NULL DROP TABLE #tblAFC
IF OBJECT_ID('tempdb.dbo.#destArchFileCopy') IS NOT NULL DROP TABLE #destArchFileCopy
IF OBJECT_ID('tempdb.dbo.#tempJobsInput') IS NOT NULL DROP TABLE #tempJobsInput
IF OBJECT_ID('tempdb.dbo.#tmpJobSizeInfo') IS NOT NULL DROP TABLE #tmpJobSizeInfo
IF OBJECT_ID('tempdb.dbo.#tblFullJobs') IS NOT NULL DROP TABLE #tblFullJobs
IF OBJECT_ID('tempdb.dbo.#tblApp') IS NOT NULL DROP TABLE #tblApp
IF OBJECT_ID('tempdb.dbo.#tblFirstFullToBeCopied') IS NOT NULL DROP TABLE #tblFirstFullToBeCopied
IF OBJECT_ID('tempdb.dbo.#tblFullAppId') IS NOT NULL DROP TABLE #tblFullAppId
IF OBJECT_ID('tempdb.dbo.#tblSubclients') IS NOT NULL DROP TABLE #tblSubclients
IF	@retVal = 0 AND @nSkippedAFs <> 0
	SELECT @amErrCode, @nSkippedAFs
ELSE
	SELECT @retVal, @nSkippedAFs
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToCopyInsert')
	delete from GxQscripts where name = 'archChunkToCopyInsert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToCopyInsert')
	delete from GXDBVersions where aliasname = 'archChunkToCopyInsert'
GO

insert into GXDBVersions values(2, 'archChunkToCopyInsert',  '00010084000200180000', 'archChunkToCopyInsert', '00010084000200180000')
GO

