

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToCopyGetNext.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToCopyGetNext.sp,v $ $Id: archChunkToCopyGetNext.sp,v 1.58.2.4 2018/03/24 14:27:53 pnara Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archChunkToCopyGetNext <<<'

IF EXISTS (select * from sysobjects where name='archChunkToCopyGetNext')
	drop procedure archChunkToCopyGetNext
IF EXISTS (select * from GxQscripts where name='archChunkToCopyGetNext')
	delete from GxQscripts where name = 'archChunkToCopyGetNext'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToCopyGetNext')
	delete from GXDBVersions where aliasname = 'archChunkToCopyGetNext'
GO
print '... Creating Procedure: archChunkToCopyGetNext'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archChunkToCopyGetNext
  @i_adminJobId int,
  @i_archGroupId int,
  @i_destCopyId int,
  @i_destStream int,
  @i_srcStream int,
  @i_srcVolumeId int,
  @i_archFileId int,
  @i_commCellId int,
  @i_numOfChunks int,
  @i_multiCopies int,
  @i_copyIds xml
AS
  DECLARE @o_appId integer;
  DECLARE @o_appType integer;
  DECLARE @o_clientId integer;
  DECLARE @o_fullCycleNum integer;
  DECLARE @o_backupJobId integer;
  DECLARE @o_backupStartTime integer;
  DECLARE @o_backupEndTime integer;
  DECLARE @o_archChunkId bigint;
  DECLARE @o_archFileId integer;				
  DECLARE @o_commCellId integer;
  DECLARE @o_archCopyId integer;
  DECLARE @o_streamNum integer;
  DECLARE @o_fileType integer;
  DECLARE @o_archFileCopyFlags integer;
  DECLARE @o_srcEncKeyType integer;
  DECLARE @o_lastChunkNumber integer;
  DECLARE @o_chunkNumber integer;
  DECLARE @o_physicalOffset bigint;
  DECLARE @o_logicalOffset bigint;
  DECLARE @o_physicalSize bigint;
  DECLARE @o_logicalSize bigint;
  DECLARE @o_volumeId integer;
  DECLARE @o_mediaId integer;
  DECLARE @o_mediaGroupId integer;
  DECLARE @o_fileMarkerNo integer;
  DECLARE @o_chunkCreateTime integer;
  DECLARE @o_chunkVersion integer;
  DECLARE @o_chunkPhysicalSize bigint;
  DECLARE @o_chunkLogicalSize bigint;
  DECLARE @o_chunkHwEncKey varchar(2048);
  DECLARE @o_extraFlags integer;
  DECLARE @o_destPhysicalSize bigint;
  DECLARE @o_destLogicalSize bigint;
  DECLARE @o_destDrivePoolId integer;
  DECLARE @o_destAFCopyFlags integer;
  DECLARE @o_destEncKeyType integer;
  DECLARE @o_encKeyCreated integer;
  DECLARE @o_unCompBytesSize bigint;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @tblAFChunk TABLE
(
	destCopyId			integer,
	destStream			integer,
	adminJobId			integer,
	appId				integer,
	backupJobId			integer,
	archChunkId			bigint,
	archFileId			integer,
	commCellId			integer,
	archCopyId			integer,
	streamNum			integer,
	fileType			integer,
	archFileCopyFlags	integer,
	encKeyType			integer,
	lastChunkNumber		integer,
	chunkNumber			integer,
	physicalOffset		bigint,
	logicalOffset		bigint,
	physicalSize		bigint,
	logicalSize			bigint,
	volumeId			integer,
	mediaId				integer,
	mediaGroupId		integer,
	fileMarkerNo		integer,
	chunkCreateTime		integer,
	chunkVersion		integer,
	chunkPhysicalSize	bigint,
	chunkLogicalSize	bigint,
chunkHwEncKey		varchar(2048),
archFileEncKey		varchar(1024),
	extraFlags			integer,
	segmentId			integer,
	unCompBytesSize		bigint,
	backupStartTime		integer,
	backupEndTime		integer,
	ChunkNoRowNumber	integer,
	ChunkIdRowNumber	integer,
	primary key (archChunkId, archFileId, commCellId, destCopyId)
)
DECLARE	@l_error	INT
DECLARE	@l_rowcount	INT
DECLARE	@l_nAFChunk	INT
DECLARE	@l_destAFCopyFlags INT
SET @l_destAFCopyFlags = -1
UPDATE	archChunkToCopy
SET		extraFlags = extraFlags | 2
FROM	archChunkToCopy A, JMJobDataStats JDS WITH (NOLOCK)
WHERE	A.BackupJobId = JDS.JobId
		AND A.destCopyId = JDS.archGrpCopyId
		AND A.fileType = JDS.dataType
		AND A.CommCellid = JDS.CommCellId
		AND A.adminJobID = @i_adminJobId
AND (JDS.disabled & (8192 | 1)) = (8192 | 1)
IF @@ROWCOUNT > 0
BEGIN
	DELETE	archChunkToCopy
	WHERE	adminJobID = @i_adminJobId
AND (extraFlags & 2) > 0
END
IF @i_multiCopies = 0
	INSERT	INTO @tblAFChunk
	SELECT	a.*, 0, 0,
		ROW_NUMBER() OVER (PARTITION BY a.VolumeId, a.archCopyId, a.archFileId, a.commCellId ORDER BY a.chunkNumber) AS ChunkNoRowNumber,
		ROW_NUMBER() OVER (PARTITION BY a.VolumeId, a.archCopyId, a.archFileId, a.commCellId ORDER BY a.archChunkId) AS ChunkIdRowNumber
	FROM	archChunkToCopy a WITH (NOLOCK)
	WHERE	a.volumeId = @i_srcVolumeId
		AND (@i_archFileId = 0 or a.archFileId = @i_archFileId)
		AND (@i_commCellId = 0 or a.commCellId = @i_commCellId)
		AND a.adminJobId = @i_adminJobId
		AND a.destCopyId = @i_destCopyId
		AND a.destStream = @i_destStream
		AND a.streamNum = @i_srcStream
ELSE
BEGIN
	CREATE TABLE #tempCopyIds (copyId int, stream int)
	INSERT	INTO #tempCopyIds
	SELECT	T.c.value('@copyId', 'int'), T.c.value('@stream', 'int')
	FROM	@i_copyIds.nodes('/r/h') T(c)
	INSERT	INTO @tblAFChunk
	SELECT	a.*, 0, 0,
		ROW_NUMBER() OVER (PARTITION BY a.VolumeId, a.archCopyId, a.archFileId, a.commCellId ORDER BY a.chunkNumber) AS ChunkNoRowNumber,
		ROW_NUMBER() OVER (PARTITION BY a.VolumeId, a.archCopyId, a.archFileId, a.commCellId ORDER BY a.archChunkId) AS ChunkIdRowNumber
	FROM	archChunkToCopy a WITH (NOLOCK), #tempCopyIds b
	WHERE	a.volumeId = @i_srcVolumeId
		AND (@i_archFileId = 0 or a.archFileId = @i_archFileId)
		AND (@i_commCellId = 0 or a.commCellId = @i_commCellId)
		AND a.adminJobId = @i_adminJobId
		AND a.destCopyId = b.copyId
		AND a.destStream = b.stream
		AND a.streamNum = @i_srcStream
	DROP TABLE #tempCopyIds
END
IF @i_archFileId > 0 AND NOT EXISTS (SELECT * FROM @tblAFChunk)
BEGIN
	-- Return the first un-copied chunk of given archive file in another volume with @l_destAFCopyFlags = -2
    -- Current volume for given archive file is fully copied.
    -- If not data is returned, aux copy will go to next volume/archive file in volume list.
    -- If a row is returned, aux copy will set currVolumeId to the returned volumeId and copy from there.
	SET @l_destAFCopyFlags = -2
	SELECT	TOP 1 appId, 0, 0, 0, backupJobId, 0, 0,
			archChunkId, archFileId, commCellId, destCopyId,
			destStream, fileType, archFileCopyFlags, encKeyType, lastChunkNumber,
			chunkNumber, physicalOffset, logicalOffset, physicalSize, logicalSize,
			volumeId, mediaId, mediaGroupId, fileMarkerNo,
			chunkCreateTime, chunkVersion, chunkPhysicalSize, chunkLogicalSize, chunkHwEncKey, 0,
			-1, -1, -1, @l_destAFCopyFlags, -1, -1, unCompBytesSize
	FROM	archChunkToCopy WITH (NOLOCK)
	WHERE	destCopyId = @i_destCopyId AND destStream = @i_destStream
	AND (@i_archFileId = 0 or archFileId = @i_archFileId)
	AND (@i_commCellId = 0 or commCellId = @i_commCellId)
	AND		streamNum = @i_srcStream
	AND		adminJobID = @i_adminJobId
	ORDER BY archChunkId ASC
	RETURN
END
IF	EXISTS (SELECT * FROM @tblAFChunk T, archGroupCopy AGC WITH (NOLOCK)
			WHERE AGC.id = T.destCopyId AND AGC.isSnapCopy = 1 AND T.destStream > 1)
BEGIN
	DECLARE @tblNextJobs	TABLE (backupJobId int)
	INSERT	INTO @tblNextJobs
	SELECT	DISTINCT TOP(@i_numOfChunks) backupJobId
	FROM	@tblAFChunk
	ORDER BY backupJobId
	DELETE	@tblAFChunk
	WHERE  backupJobId NOT IN
		  (SELECT backupJobId from @tblNextJobs)
END
ELSE
BEGIN
	DECLARE @tblNextChunks	TABLE (archChunkId bigint)
	DECLARE @tblOrderChunks	TABLE (VolumeId integer, archCopyId integer, archFileId integer, commCellId integer, chunkNumber integer)
	/*
	-- Delete the chunks if there exist chunks with lower chunk number in other volumes for this archive file
	DELETE	@tblAFChunk
	FROM	@tblAFChunk a, archChunkToCopy b WITH (NOLOCK)
	WHERE	a.archFileId = b.archFileId AND a.commCellId = b.commCellId AND a.archCopyId = b.archCopyId
		AND a.destCopyId = b.destCopyId AND a.volumeId <> b.volumeId AND a.chunkNumber > b.chunkNumber
	*/
	IF OBJECT_ID('tempdb.dbo.#tblOtherVolumeChunksToCopy') is not null
		DROP TABLE #tblOtherVolumeChunksToCopy
	CREATE TABLE #tblOtherVolumeChunksToCopy (archFileId int, commcellId int, archCopyId int, destCopyId int, chunkNumber int)
	INSERT #tblOtherVolumeChunksToCopy
	SELECT a.archFileId, a.commCellId, a.archCopyId, a.destCopyId, MIN(a.chunkNumber) from
	archChunkToCopy a WITH (NOLOCK)
	WHERE a.volumeId <> @i_srcVolumeId AND a.adminJobId = @i_adminJobId
	group by a.archFileId, a.commCellId, a.archCopyId, a.destCopyId
	-- Delete the chunks if there exist chunks with lower chunk number in other volumes for this archive file
	DELETE	@tblAFChunk
	FROM	@tblAFChunk a, #tblOtherVolumeChunksToCopy b
	WHERE	a.archFileId = b.archFileId AND a.commCellId = b.commCellId AND a.archCopyId = b.archCopyId
	AND a.destCopyId = b.destCopyId AND a.chunkNumber > b.chunkNumber
	-- Delete the chunks if the chunkid is not in sequence for given archive file
	INSERT INTO @tblOrderChunks
	SELECT	VolumeId, archCopyId, archFileId, commCellId, Min(chunkNumber)
	FROM	@tblAFChunk
	WHERE	ChunkNoRowNumber > ChunkIdRowNumber
	GROUP BY VolumeId, archCopyId, archFileId, commCellId
	DELETE	@tblAFChunk
	FROM	@tblAFChunk AFC, @tblOrderChunks OC
	WHERE	AFC.VolumeId = OC.VolumeId
			AND AFC.archCopyId = OC.archCopyId
			AND AFC.archFileId = OC.archFileId
			AND AFC.commCellId = OC.commCellId
			AND AFC.chunkNumber >= OC.chunkNumber
	INSERT	INTO @tblNextChunks
	SELECT	DISTINCT TOP(@i_numOfChunks) archChunkId
				FROM	@tblAFChunk
	ORDER BY archChunkId
		DELETE	@tblAFChunk
		WHERE	archChunkId NOT IN
		  (SELECT archChunkId from @tblNextChunks)
END
SET	@l_nAFChunk = (SELECT COUNT(*) FROM @tblAFChunk)
UPDATE	@tblAFChunk
SET		backupStartTime = b.servStartDate,
		backupEndTime	= b.servEndDate
FROM	@tblAFChunk a, JMBkpStats b WITH (NOLOCK)
WHERE	b.jobId = a.backupJobId AND b.commCellId = a.commCellId
-- Update DFM Ids
-- Set DFMIds in chunkHwEncKey field in the format 'RelationID|DataSetID|NodeID'
-- only for AuxCopy Snap Data
UPDATE	@tblAFChunk
SET		chunkHwEncKey = a.ExtRelationId + '|' + SD.ExtDataSetId + '|' + SRN.ExtNodeId
FROM	SMRelation a WITH (NOLOCK), SMCopyToRelationMap b WITH (NOLOCK) INNER JOIN SMRelationNode SRN WITH (NOLOCK) ON b.SMRelationNodeId = SRN.SMRelationNodeId,
		SMDataSetToSubClientMap c WITH (NOLOCK) INNER JOIN SMDataSet SD WITH (NOLOCK) ON c.DataSetId = SD.DataSetId, @tblAFChunk d
WHERE	a.SMRelationId = b.SMRelationId
		AND a.SMRelationId = c.SMRelationId
		AND b.ArchGroupCopyId = d.destCopyId
		AND c.AppId = d.appId
AND ((b.Flags & 256) = 0)
AND (d.extraFlags & 4) = 4
IF @l_nAFChunk > 0
BEGIN
	DELETE	archChunkToCopy
	FROM	archChunkToCopy a, @tblAFChunk b
	WHERE	a.archChunkId = b.archChunkId AND a.archFileId = b.archFileId AND a.commCellId = b.commCellId
		AND a.archCopyId = b.archCopyId AND a.destCopyId = b.destCopyId AND a.volumeId =  b.volumeId --fix: join volumeIds too, to be safe
		AND a.adminJobID = @i_adminJobId
	SELECT	@l_error = @@ERROR, @l_rowcount = @@ROWCOUNT
	IF @l_error <> 0 OR @l_rowcount <> @l_nAFChunk
	-- 1. Make (o_destPhysicalSize > o_physicalOffset + o_physicalSize) so AuxCopyMgr will fail this stream.
	-- 2. Return @l_nAFChunk, @l_error and @l_rowcount via o_archFileId, o_archCopyId and o_streamNum
	--    so these values will be printed in AuxCopyMgr.log.
	SELECT	0, 0, 0, 0, 0, 0, 0,
			0, @l_nAFChunk, 0, @l_error,
			@l_rowcount, 0, 0, 0, 0,
			0, 0, 0, 0, 0,
			@i_srcVolumeId, 0, 0, 0,
			0, 0, 0, 0, '', 0,
			1, 0, 0, 0, 0, 0, 0
	ELSE
		SELECT	a.appId, ISNULL(S.appTypeId, 0), ISNULL(S.ClientId, 0), 0, a.backupJobId, a.backupStartTime, a.backupEndTime,
				a.archChunkId, a.archFileId, a.commCellId, a.destCopyId,
				a.destStream, a.fileType, a.archFileCopyFlags, a.encKeyType, a.lastChunkNumber,
				a.chunkNumber, a.physicalOffset, a.logicalOffset, a.physicalSize, a.logicalSize,
				a.volumeId, a.mediaId, a.mediaGroupId, a.fileMarkerNo,
				a.chunkCreateTime, a.chunkVersion, a.chunkPhysicalSize, a.chunkLogicalSize, a.chunkHwEncKey,
(CASE WHEN a.extraFlags & 4 = 4 THEN 4 ELSE 0 END),
				b.physicalSize, b.logicalSize, b.drivePoolId, b.flags, b.encKeyType,
				(case when b.physicalSize = 0 and b.encKey = '' then 0 else 1 end),
				a.unCompBytesSize
		FROM	@tblAFChunk a LEFT OUTER JOIN APP_Application S WITH (NOLOCK) ON a.AppId = S.id, archFileCopy b WITH (NOLOCK)
		WHERE	b.archFileId = a.archFileId AND b.commCellId = a.commCellId AND b.archCopyId = a.destCopyId
		ORDER BY a.archCopyId, a.archChunkId, a.archFileId
END
ELSE IF @i_archFileId > 0
BEGIN
	-- Return the first un-copied chunk of given archive file in another volume with @l_destAFCopyFlags = -3
    -- Current volume will be skipped and copied later.
	SET @l_destAFCopyFlags = -3
	SELECT	TOP 1 appId, 0, 0, 0, backupJobId, 0, 0,
			archChunkId, archFileId, commCellId, destCopyId,
			destStream, fileType, archFileCopyFlags, encKeyType, lastChunkNumber,
			chunkNumber, physicalOffset, logicalOffset, physicalSize, logicalSize,
			volumeId, mediaId, mediaGroupId, fileMarkerNo,
			chunkCreateTime, chunkVersion, chunkPhysicalSize, chunkLogicalSize, chunkHwEncKey, 0,
			-1, -1, -1, @l_destAFCopyFlags, -1, -1, unCompBytesSize
	FROM	archChunkToCopy WITH (NOLOCK)
	WHERE	destCopyId = @i_destCopyId AND destStream = @i_destStream
	AND (@i_archFileId = 0 or archFileId = @i_archFileId)
	AND (@i_commCellId = 0 or commCellId = @i_commCellId)
	AND		streamNum = @i_srcStream
	AND		adminJobID = @i_adminJobId
	ORDER BY archChunkId ASC
END
ELSE
BEGIN
	-- Either all archive files in this volume have been copied or remaining archive files are out of order of chunk number.
	-- Return the first to-be-copied chunk ID in the same volume with @l_destAFCopyFlags = -1 if there is any.
	-- So AuxCopyMgr knows some archive files have been skipped and should be copied later.
	SET @l_destAFCopyFlags = -1
	SELECT	TOP 1 appId, 0, 0, 0, backupJobId, 0, 0,
			archChunkId, archFileId, commCellId, destCopyId,
			destStream, fileType, archFileCopyFlags, encKeyType, lastChunkNumber,
			chunkNumber, physicalOffset, logicalOffset, physicalSize, logicalSize,
			volumeId, mediaId, mediaGroupId, fileMarkerNo,
			chunkCreateTime, chunkVersion, chunkPhysicalSize, chunkLogicalSize, chunkHwEncKey, 0,
			-1, -1, -1, @l_destAFCopyFlags, -1, -1, unCompBytesSize
	FROM	archChunkToCopy WITH (NOLOCK)
	WHERE	destCopyId = @i_destCopyId AND destStream = @i_destStream AND volumeId = @i_srcVolumeId
	AND		streamNum = @i_srcStream
	AND		adminJobID = @i_adminJobId
	ORDER BY archChunkId ASC
END
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToCopyGetNext')
	delete from GxQscripts where name = 'archChunkToCopyGetNext'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToCopyGetNext')
	delete from GXDBVersions where aliasname = 'archChunkToCopyGetNext'
GO

insert into GXDBVersions values(2, 'archChunkToCopyGetNext',  '00010058000200040000', 'archChunkToCopyGetNext', '00010058000200040000')
GO

