

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToCopyGetFirst.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToCopyGetFirst.sp,v $ $Id: archChunkToCopyGetFirst.sp,v 1.15.54.2 2018/03/22 01:02:23 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archChunkToCopyGetFirst <<<'

IF EXISTS (select * from sysobjects where name='archChunkToCopyGetFirst')
	drop procedure archChunkToCopyGetFirst
IF EXISTS (select * from GxQscripts where name='archChunkToCopyGetFirst')
	delete from GxQscripts where name = 'archChunkToCopyGetFirst'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToCopyGetFirst')
	delete from GXDBVersions where aliasname = 'archChunkToCopyGetFirst'
GO
print '... Creating Procedure: archChunkToCopyGetFirst'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archChunkToCopyGetFirst
  @i_destCopyId int,
  @i_destStream int,
  @i_srcStream int
AS
  DECLARE @o_srcCopyId integer;
  DECLARE @o_srcStream integer;
  DECLARE @o_srcMediaGroupId integer;
  DECLARE @o_dstStream integer;
  DECLARE @o_dstMediaGroupId integer;
  DECLARE @o_commCellId integer;
  DECLARE @o_archChunkId bigint;
  DECLARE @o_totalPhysicalSize bigint;
  DECLARE @o_totalUnCompByteSize bigint;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE	@useLogicalSize INT
DECLARE	@i_srcCopyId INT
SET		@useLogicalSize  = 0
SELECT  @i_srcCopyId = (CASE WHEN AGC.sourceCopyId <> 0 THEN sourceCopyId ELSE AG.defaultCopy END)
FROM	archGroup AG, archGroupCopy AGC
WHERE	AG.id = AGC.archGroupId AND AGC.id = @i_destCopyId
IF(@i_srcCopyId > 0 )
BEGIN
	IF	(SELECT	COUNT(DISTINCT PT.CopyId)
		FROM	MMDrivePool PL WITH (NOLOCK), MMDataPath PT WITH (NOLOCK)
		WHERE	PL.DrivePoolId = PT.DrivePoolId AND PT.CopyId IN (@i_srcCopyId, @i_destCopyId) AND PL.DrivePoolType = 3) = 1
	BEGIN
			SET	@useLogicalSize = 1
	END
END
DECLARE	@oneConstReal REAL = 1.0
DECLARE @isSnapCopy integer
IF EXISTS (SELECT * FROM ArchGroupCopy WITH (NOLOCK) WHERE id = @i_destCopyId AND isSnapCopy = 1)
    SET @isSnapCopy = 1
ELSE
    SET @isSnapCopy = 0
IF object_id('tempdb.dbo.#tblPartiallyCopiedChunk') IS NOT NULL DROP TABLE #tblPartiallyCopiedChunk
CREATE TABLE #tblPartiallyCopiedChunk(
		archCopyId int, streamNum int not null, mediaGroupId int, destStream int not null, archChunkId bigint not null, commCellId int not null, copiedBytes bigint, copiedUnCompBytes bigint)
IF @isSnapCopy = 1
BEGIN
	ALTER TABLE #tblPartiallyCopiedChunk
		ADD	primary key (destStream, streamNum, archChunkId, commCellId)
END
ELSE
BEGIN
	ALTER TABLE #tblPartiallyCopiedChunk
		ADD primary key (destStream, archChunkId, commCellId)
END
INSERT INTO #tblPartiallyCopiedChunk
SELECT	a.archCopyId, a.streamNum, a.mediaGroupId, a.destStream, a.archChunkId, a.commCellId,
		SUM(b.physicalSize - a.physicalOffset) AS copiedBytes,
		--CAST((SUM(((b.physicalSize - a.physicalOffset)*@oneConstReal*a.unCompBytesSize)/(CASE WHEN a.physicalSize <> 0 THEN a.physicalSize ELSE 1 END))) AS BIGINT) AS copiedUnCompBytes
		CAST((SUM( CASE WHEN a.physicalSize = 0 THEN (b.physicalSize - a.physicalOffset) ELSE (((b.physicalSize - a.physicalOffset)*@oneConstReal*a.unCompBytesSize)/ a.physicalSize)  END)) AS BIGINT) AS copiedUnCompBytes
FROM	archChunkToCopy a WITH (nolock), archFileCopy b WITH (nolock)
WHERE	a.destCopyId = @i_destCopyId AND a.archFileId = b.archFileId AND a.commCellId = b.commCellId
	AND b.archCopyId = @i_destCopyId
	AND ( (@useLogicalSize = 0 AND b.physicalSize >= a.physicalOffset) OR (@useLogicalSize = 1 AND b.logicalSize >= a.logicalOffset) )
	AND (@i_destStream = 0 OR a.destStream = @i_destStream)
	AND (@i_srcStream  = 0 OR a.streamNum  = @i_srcStream)
    AND (@isSnapCopy = 1 OR @isSnapCopy = 0 AND a.destStream > 0 AND a.streamNum > 0)
GROUP BY a.archCopyId, a.streamNum, a.mediaGroupId, a.destStream, a.archChunkId, a.commCellId
SELECT a.archCopyId, a.streamNum, a.mediaGroupId, a.destStream,
	ISNULL((SELECT mediaGroupId FROM archStream WITH (nolock) WHERE archGroupCopyId = @i_destCopyId AND stream = a.destStream), 0),
	a.commCellId,
	(case a.copiedBytes when 0
	then (SELECT MIN(archChunkId) FROM #tblPartiallyCopiedChunk
			WHERE streamNum = a.streamNum AND destStream = a.destStream AND commCellId = a.commCellId)
	else (SELECT TOP 1 archChunkId FROM #tblPartiallyCopiedChunk
			WHERE streamNum = a.streamNum AND destStream = a.destStream AND commCellId = a.commCellId ORDER BY copiedBytes DESC)
	end) AS firstChunkId,
	(SELECT (SUM(physicalSize) - a.copiedBytes) FROM archChunkToCopy WITH (nolock)
			WHERE destCopyId = @i_destCopyId AND destStream = a.destStream AND streamNum = a.streamNum),
	(SELECT (SUM(unCompBytesSize) - a.copiedUnCompBytes) FROM archChunkToCopy WITH (nolock)
			WHERE destCopyId = @i_destCopyId AND destStream = a.destStream AND streamNum = a.streamNum)
FROM	(SELECT	archCopyId, streamNum, mediaGroupId, destStream, commCellId, SUM(copiedBytes) AS copiedBytes, SUM(copiedUnCompBytes) AS copiedUnCompBytes
		FROM	#tblPartiallyCopiedChunk
		GROUP BY archCopyId, streamNum, mediaGroupId, destStream, commCellId) a
ORDER BY a.destStream, a.streamNum, firstChunkId, a.commCellId
IF object_id('tempdb.dbo.#tblPartiallyCopiedChunk') IS NOT NULL DROP TABLE #tblPartiallyCopiedChunk
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToCopyGetFirst')
	delete from GxQscripts where name = 'archChunkToCopyGetFirst'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToCopyGetFirst')
	delete from GXDBVersions where aliasname = 'archChunkToCopyGetFirst'
GO

insert into GXDBVersions values(2, 'archChunkToCopyGetFirst',  '00010015005400020000', 'archChunkToCopyGetFirst', '00010015005400020000')
GO

