

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkCloseInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkCloseInfo.sp,v $ $Id: archChunkCloseInfo.sp,v 1.1.4.11 2018/11/08 22:36:33 chandru Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 	Cursor: "archChunkCloseInfo"						|
--	|												|
--    |	Initial Version: 	02/03/2004 by Jun Lu					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archChunkCloseInfo')
BEGIN
	print '>>> Drop Stored Procedure: archChunkCloseInfo <<<'
	drop procedure archChunkCloseInfo
END
IF EXISTS (select * from GxQscripts where name='archChunkCloseInfo')
	delete from GxQscripts where name = 'archChunkCloseInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkCloseInfo')
	delete from GXDBVersions where aliasname = 'archChunkCloseInfo'
GO
print '... Creating Procedure: archChunkCloseInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archChunkCloseInfo
  @i_archCopyId int,
  @i_commCellId int,
  @i_archChunkId bigint,
  @i_archFileIds VARCHAR(MAX)
AS
  DECLARE @archFileId integer
  DECLARE @commCellId integer
  DECLARE @archCopyId integer
  DECLARE @flags integer
  DECLARE @isValid integer
  DECLARE @lastChunkNumber integer
  DECLARE @physicalSize bigint
  DECLARE @logicalSize bigint
  DECLARE @isSourceCopy integer
  DECLARE @physicalSizeOnChunkReuse bigint
  DECLARE @logicalSizeOnChunkReuse bigint
  DECLARE @isChunkReused integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
-- DECLARE @i_archCopyId int
-- DECLARE @i_commCellId int
-- SET @i_archCopyId = %d
-- SET @i_commCellId = %d
DECLARE @AFIds TABLE (afId int, afFlags INT)
DECLARE @AFCopyInfo TABLE (ArchFileId INT, CommCellId INT, archCopyId INT, flags INT, isValid INT, lastChunkNumber INT, PhysicalSize BIGINT, LogicalSize BIGINT, isSourceCopy INT,
		physicalSizeOnChunkReuse BIGINT, logicalSizeOnChunkReuse BIGINT, isChunkReused INT)
INSERT INTO @AFIds
SELECT DISTINCT AFC.archFileId, AF.flags
FROM archFileCopy AFC WITH (NOLOCK), archFile AF WITH (NOLOCK)
WHERE archFileId in (SELECT	*
					FROm	dbo.SplitIDs(@i_archFileIds))
		AND AFC.commCellId = @i_commCellId
		AND AFC.archFileID = AF.id
		AND AFC.commCellId = AF.commCellId
DECLARE @t_archGroupId int
DECLARE @t_srcCopyId int
DECLARE @t_isSnapCopy int
DECLARE @t_extendedFlags bigint = 0
DECLARE @t_destMediaCopyId int = 0
DECLARE @t_archGroupFlags int
DECLARE @t_copyType int
DECLARE @CopyIds  TABLE (copyId int, sourceCopyId int)
DECLARE @t_opType INT
DECLARE @t_jobId INT
DECLARE @t_hasEdgeAFs INT = 0
DECLARE @t_dedupeFlags INT = 0
SELECT @t_archGroupId = archGroupId, @t_srcCopyId = sourceCopyId, @t_isSnapCopy = isSnapCopy, @t_extendedFlags = extendedFlags, @t_destMediaCopyId = destMediaCopyId, @t_copyType = type, @t_dedupeFlags = dedupeFlags
FROM archGroupCopy WHERE id = @i_archCopyId
SELECT @t_archGroupFlags = flags
FROM archGroup WHERE id = @t_archGroupId
SELECT	@t_opType = JA.opType, @t_jobId = JA.jobId
FROM	JMAdminJobInfoTable JA WITH (READUNCOMMITTED), JMJobInfo J WITH (READUNCOMMITTED)
WHERE	archGrpID = @t_archGroupId
		AND (archGrpCopyID = @i_archCopyId OR archGrpCopyID = 0)
		AND JA.opType IN (13, 104, 74) /*AUXCOPY, AUXCOPY2, MEDIAREFRESHING*/
		AND JA.jobId = J.jobId
		AND JA.commCellId = J.commCellId
		AND J.state IN (1, 2, 3) /*RUNNING, PENDING, WAITING*/
IF EXISTS(SELECT * FROM @AFIds WHERE (afFlags & (32768|2097152)) > 0)
	SET @t_hasEdgeAFs = 1
IF @t_extendedFlags & 2 > 0
BEGIN
	INSERT INTO @CopyIds
	SELECT distinct archCopyId, AGC.sourceCopyId
	FROM archFileCopy AFC WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
	WHERE AFC.archFileId IN (SELECT afId FROM @AFIds) AND commCellId = @i_commCellId
	AND AFC.archCopyId = AGC.id
	AND AGC.destMediaCopyId = @t_destMediaCopyId
	UPDATE @CopyIds
	SET sourceCopyId = AG.defaultCopy
	FROM @CopyIds T, archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
	WHERE T.copyId = AGC.id
	AND AGC.archGroupId = AG.id
	AND T.sourceCopyId = 0
	INSERT INTO @AFCopyInfo
	SELECT AFC.archFileId, AFC.commCellId, AFC.archCopyId, AFC.flags, AFC.isValid, AFC.lastChunkNumber, AFC.physicalSize, AFC.logicalSize, (case when AFC.archCopyId = T.sourceCopyId then 1 else 0 end), 0, 0, 0
	FROM archFileCopy AFC, @CopyIds T
	WHERE AFC.archFileId IN (SELECT afId FROM @AFIds) AND commCellId = @i_commCellId
	AND (AFC.archCopyId = T.copyId OR AFC.archCopyId = T.sourceCopyId)
	ORDER BY AFC.archFileId, AFC.archCopyId
END
ELSE IF  @t_archGroupFlags & 16384 > 0 AND @t_copyType = 5
BEGIN
	INSERT INTO @CopyIds
	SELECT distinct @i_archCopyId, AGC.id
	FROM archFileCopy AFC WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
	WHERE AFC.archFileId IN (SELECT afId FROM @AFIds) AND commCellId = @i_commCellId
	AND AFC.archCopyId = AGC.id
	AND AGC.destMediaCopyId = @t_srcCopyId
	INSERT INTO @AFCopyInfo
	SELECT DISTINCT AFC.archFileId, AFC.commCellId, AFC.archCopyId, AFC.flags, AFC.isValid, AFC.lastChunkNumber, AFC.physicalSize, AFC.logicalSize, (case when AFC.archCopyId = T.sourceCopyId then 1 else 0 end), 0, 0, 0
	FROM archFileCopy AFC, @CopyIds T
	WHERE AFC.archFileId IN (SELECT afId FROM @AFIds) AND commCellId = @i_commCellId
	AND (AFC.archCopyId = T.copyId OR AFC.archCopyId = T.sourceCopyId)
	ORDER BY AFC.archFileId, AFC.archCopyId
END
ELSE
BEGIN
	IF @t_srcCopyId = 0
		IF @t_isSnapCopy = 0
			SELECT @t_srcCopyId = defaultCopy FROM archGroup WHERE id = @t_archGroupId
		ELSE
			SELECT @t_srcCopyId = defaultSnapCopy FROM archGroup WHERE id = @t_archGroupId
	INSERT INTO @AFCopyInfo
	SELECT AFC.archFileId, AFC.commCellId, AFC.archCopyId, AFC.flags, AFC.isValid, AFC.lastChunkNumber, AFC.physicalSize, AFC.logicalSize, (case when AFC.archCopyId = @t_srcCopyId then 1 else 0 end), 0, 0, 0
	FROM archFileCopy AFC, @AFIds T
	WHERE AFC.archFileId = T.afId AND AFC.commCellId = @i_commCellId
AND (T.afFlags & (32768|2097152) = 0 OR ((@t_dedupeFlags & 262144) = 0))
		AND (AFC.archCopyId = @t_srcCopyId OR AFC.archCopyId = @i_archCopyId)
	ORDER BY AFC.archFileId, AFC.archCopyId
IF (@t_hasEdgeAFs = 1 AND ((@t_dedupeFlags & 262144) > 0))
	BEGIN
		IF (@t_opType = 104 /*AUXCOPY2*/)
		BEGIN
			WITH R AS (
				SELECT	C.archFileId, C.commCellId, C.SrcCopyId, C.chunkNumber, C.physicalOffset, C.physicalSize, C.logicalOffset, C.logicalSize,
						ROW_NUMBER() OVER (PARTITION BY C.archFileId, C.commCellId ORDER BY C.ChunkNumber DESC) RowNum
				FROM	ArchChunkToReplicate C WITH (READUNCOMMITTED), @AFIds AF
				WHERE	AdminJobId = @t_jobId
						AND C.archFileId = AF.afId
						AND C.CommCellId = @i_commCellId
						AND C.DestCopyId = @i_archCopyId
AND AF.afFlags & (32768|2097152) > 0)
			INSERT INTO @AFCopyInfo
			SELECT	AFC.ArchFileId, AFC.CommCellId, AFC.archCopyId, AFC.flags, AFC.isValid, R.ChunkNumber, (R.PhysicalOffset + R.PhysicalSize), (R.LogicalOffset + R.LogicalSize), 1, 0, 0, 0
			FROM	R, archFileCopy AFC
			WHERE	R.archFileId = AFC.archFileID
					AND R.CommCellId = AFC.CommCellId
					AND R.SrcCopyId = AFC.archCopyId
					AND R.RowNum = 1
		END
		ELSE IF (@t_opType = 13 /*AUXCOPY*/)
		BEGIN
			WITH R AS (
				SELECT	T.archFileId, T.commCellId, T.SrcCopyId, T.chunkNumber, T.physicalOffset, T.physicalSize, T.logicalOffset, T.logicalSize,
						ROW_NUMBER() OVER (PARTITION BY T.archFileId, T.commCellId ORDER BY T.ChunkNumber DESC) RowNum
				FROM (
						SELECT	C.archFileId, C.commCellId, C.archCopyId AS SrcCopyId, C.chunkNumber, C.physicalOffset, C.physicalSize, C.logicalOffset, C.logicalSize
						FROM	archChunkToCopy C WITH (READUNCOMMITTED), @AFIds AF
						WHERE	AdminJobId = @t_jobId
								AND C.archFileId = AF.afId
								AND C.CommCellId = @i_commCellId
								AND C.DestCopyId = @i_archCopyId
AND AF.afFlags & (32768|2097152) > 0
						UNION
						SELECT	C.archFileId, C.commCellId, C.archCopyId AS SrcCopyId, C.chunkNumber, C.physicalOffset, C.physicalSize, C.logicalOffset, C.logicalSize
						FROM	archChunkToCopyHistory C WITH (READUNCOMMITTED), @AFIds AF
						WHERE	AdminJobId = @t_jobId
								AND C.archFileId = AF.afId
								AND C.CommCellId = @i_commCellId
								AND C.DestCopyId = @i_archCopyId
AND AF.afFlags & (32768|2097152) > 0) T)
			INSERT INTO @AFCopyInfo
			SELECT	AFC.ArchFileId, AFC.CommCellId, AFC.archCopyId, AFC.flags, AFC.isValid, R.ChunkNumber, (R.PhysicalOffset + R.PhysicalSize), (R.LogicalOffset + R.LogicalSize), 1, 0, 0, 0
			FROM	R, archFileCopy AFC
			WHERE	R.archFileId = AFC.archFileID
					AND R.CommCellId = AFC.CommCellId
					AND R.SrcCopyId = AFC.archCopyId
					AND R.RowNum = 1
		END
		BEGIN
			WITH R AS (
				SELECT	T.archFileId, T.commCellId, T.DestCopyId, T.chunkNumber, T.physicalOffset, T.physicalSize, T.logicalOffset, T.logicalSize,
						ROW_NUMBER() OVER (PARTITION BY T.archFileId, T.commCellId ORDER BY T.ChunkNumber DESC) RowNum
				FROM (
						SELECT	AF.afId AS archFileId, @i_commCellId AS CommCellId, @i_archCopyId AS DestCopyId, ISNULL(C.chunkNumber, 0) AS ChunkNumber, C.physicalOffset, C.physicalSize, C.logicalOffset, C.logicalSize
						FROM	@AFIds AF LEFT OUTER JOIN archChunkMapping C WITH (READUNCOMMITTED) ON
								C.archFileId = AF.afId
								AND C.CommCellId = @i_commCellId
								AND C.archCopyId = @i_archCopyId
								AND C.archChunkId = @i_archChunkId
								AND C.chunkCommCellId = 2
AND AF.afFlags & (32768|2097152) > 0) T)
			INSERT INTO @AFCopyInfo
			SELECT	AFC.ArchFileId, AFC.CommCellId, AFC.archCopyId, AFC.flags, AFC.isValid, AFC.lastChunkNumber,
					AFC.physicalSize, AFC.LogicalSize, 0,
					R.physicalOffSet, R.LogicalOffset, (CASE WHEN R.chunkNumber > 0 THEN 1 ELSE 0 END)
			FROM	R, archFileCopy AFC
			WHERE	R.archFileId = AFC.archFileID
					AND R.CommCellId = AFC.CommCellId
					AND R.DestCopyId = AFC.archCopyId
					AND R.RowNum = 1
		END
	END
END
SELECT	*
FROM	@AFCopyInfo
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkCloseInfo')
	delete from GxQscripts where name = 'archChunkCloseInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkCloseInfo')
	delete from GXDBVersions where aliasname = 'archChunkCloseInfo'
GO

insert into GXDBVersions values(2, 'archChunkCloseInfo',  '00010001000400110000', 'archChunkCloseInfo', '00010001000400110000')
GO

