

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkClose.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkClose.sp,v $ $Id: archChunkClose.sp,v 1.31.2.12 2020/12/09 23:57:19 chandru Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archChunkClose')
BEGIN
	print '>>> Drop Stored Procedure: archChunkClose <<<'
	drop procedure archChunkClose
END
IF EXISTS (select * from GxQscripts where name='archChunkClose')
	delete from GxQscripts where name = 'archChunkClose'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkClose')
	delete from GXDBVersions where aliasname = 'archChunkClose'
GO
print '... Creating Procedure: archChunkClose'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archChunkClose
  @i_archChunkId bigint,
  @i_commCellId int,
  @i_volumeId int,
  @i_fileMarkerNo int,
  @i_createTime int,
  @i_version int,
  @i_physicalSize bigint,
  @i_logicalSize bigint,
  @i_writeTime int,
  @i_flags int,
  @i_chunkHwEncKey varchar(114),
  @i_archCopyId int,
  @i_drivePoolId int
AS
  DECLARE @retVal integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
/* This temp table must be created and populated by caller before calling this stored procedure
CREATE TABLE #ArchFileInChunk (
	archFileId int,	physicalOffset bigint, logicalOffset bigint, physicalSize bigint, logicalSize bigint, flags int,
	primaryObjects int, secondaryObjects int,
	primaryObjSize bigint, secondaryObjSize bigint,
	primaryMetaDataSize bigint, secondaryMetaDataSize bigint,
	chunkNumber int, isLastChunk int, afc_flags int, unCompSize bigint)
*/
DECLARE	@updatedArchFileChunkSizes TABLE (archFileId int, physicalSize bigint, logicalSize bigint, unCompSize bigint)
DECLARE @l_AddChunkMapping int
SET		@l_AddChunkMapping = 1
DECLARE @l_defCopyId	int
DECLARE @l_streamNum	int
DECLARE @l_mediaId		int
DECLARE @l_mediaType	int
DECLARE @l_SIDBStoreId	int
DECLARE @l_physicalSize	bigint
DECLARE @l_logicalSize	bigint
DECLARE @l_IsOpenChunk	int = 0
DECLARE @l_extendedFlags bigint = 0
DECLARE @l_destMediaCopyId int = 0
DECLARE @l_agedByChunkClose bigint = CAST(274877906944 AS BIGINT)
DECLARE @CopyIds  TABLE (copyId int, extendedFlags bigint)
SELECT @l_extendedFlags = extendedFlags, @l_destMediaCopyId = destMediaCopyId
FROM archGroupCopy WITH (NOLOCK) WHERE id = @i_archCopyId
IF @l_extendedFlags & 2 > 0
BEGIN
	INSERT INTO @CopyIds
	SELECT distinct archCopyId, AGC.extendedFlags
	FROM #ArchFileInChunk T, archFileCopy AFC WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
	WHERE T.archFileId = AFC.archFileId AND AFC.commCellId = @i_commCellId
	AND AFC.archCopyId = AGC.id
	AND AGC.destMediaCopyId = @l_destMediaCopyId
END
ELSE
BEGIN
    INSERT INTO @CopyIds
    SELECT @i_archCopyId,@l_extendedFlags
END
SELECT	@l_streamNum = a.stream, @l_SIDBStoreId = b.SIDBStoreId,
		@l_mediaId = b.MediaId,
		@l_mediaType = (SELECT MediaTypeId FROM MMMedia WITH (NOLOCK) WHERE MediaId = b.MediaId),
		@l_defCopyId = (SELECT defaultCopy FROM archGroup WITH (NOLOCK) WHERE id = a.archGroupId)
FROM	archStream a WITH (NOLOCK), MMVolume b WITH (NOLOCK)
WHERE	a.mediaGroupId = b.MediaGroupId AND b.VolumeId = @i_volumeId
SELECT	@retVal = @@ERROR
IF	@l_streamNum IS NULL
	SET @retVal = -1
IF	@retVal <> 0 GOTO FINISH
SELECT @l_physicalSize = physicalSize, @l_logicalSize = logicalSize, @l_IsOpenChunk = (CASE WHEN (flags & 2048) > 0 THEN 1 ELSE 0 END)
FROM	archChunk WITH (NOLOCK)
WHERE	id = @i_archChunkId AND commCellId = 2--@i_commCellId
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
UPDATE	#ArchFileInChunk
SET		chunkNumber = (CASE WHEN @l_IsOpenChunk = 1 THEN AFC.lastChunkNumber ELSE (AFC.lastChunkNumber + 1) END),
		afc_flags = (case @l_mediaType when 10001 then (T.afc_flags | 2) else T.afc_flags end),
        copyId = AFC.archCopyId,
flags = T.flags | (AFC.Flags & 256)
FROM	#ArchFileInChunk T, archFileCopy AFC WITH (NOLOCK), @CopyIds C
WHERE	AFC.archFileId = T.archFileId AND AFC.commCellId = @i_commCellId AND AFC.archCopyId = C.copyId
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
SELECT @i_flags = @i_flags | (SELECT MIN(flags & 256) FROM #ArchFileInChunk)
-- If chunk flag for sharing encryption key on media is set, ignore the update for enckey
IF (@i_flags & 1048576) > 0
AND @l_mediaType <> 10001
AND EXISTS (SELECT 1 FROM MMMedia WITH (NOLOCK) WHERE mediaId = @l_mediaId AND LEN(hwEncKey)>0)
BEGIN
	SET @i_chunkHwEncKey = ''
END
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
if EXISTS (SELECT 1 FROM @CopyIds WHERE extendedFlags & 32768 > 0)
BEGIN
	UPDATE	#ArchFileInChunk
	SET		isLastChunk = 0
	FROM	#ArchFileInChunk T, archFile AF WITH (NOLOCK), JMJobInfo J WITH (NOLOCK), @CopyIds c
WHERE	extendedFlags & 32768 > 0
			AND T.copyId = c.copyId
			AND AF.id = T.archFileId AND AF.commCellId = @i_commCellId AND AF.jobId = J.jobId AND AF.commCellId = J.commCellId
			AND J.state not in (4,9,10,11)
			AND T.isLastChunk <> 0
END
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
IF @l_physicalSize IS NULL
BEGIN
	IF @l_mediaType <> 10001
		INSERT INTO archChunk
		VALUES (@i_archChunkId, 2/*@i_commCellId*/, @i_volumeId , @i_fileMarkerNo, @i_createTime , @i_version, '',
@i_physicalSize, @i_logicalSize, @i_writeTime, @i_flags, 0, @i_chunkHwEncKey, (CASE WHEN (@i_flags & 256) > 0 THEN @l_agedByChunkClose ELSE 0 END), 2)
	ELSE
	BEGIN
		SET	@retVal = -2
		GOTO FINISH
	END
END
ELSE
IF (@l_physicalSize = 0 AND @l_logicalSize = 0) OR (@l_IsOpenChunk = 1)
BEGIN
	-- To avoid a deadlock scenario, first update archChunkMapping then update archChunk.
	IF EXISTS (SELECT archChunkId FROM archChunkMapping WITH (NOLOCK) WHERE archChunkId = @i_archChunkId AND chunkCommCellId = 2 and commCellId = @i_commCellId)
	BEGIN
		UPDATE	archChunkMapping
		SET		chunkNumber = T.chunkNumber,
				physicalOffset = (CASE WHEN (@l_IsOpenChunk = 1) THEN ACM.physicalOffSet ELSE T.physicalOffset END),
				logicalOffset = (CASE WHEN (@l_IsOpenChunk = 1) THEN ACM.logicalOffset ELSE T.logicalOffset END),
				physicalSize = T.physicalSize, logicalSize = T.logicalSize, flags = T.flags, modifiedTime = @i_createTime,
				dedupedSize = (T.physicalSize - T.secondaryObjSize + T.secondaryMetaDataSize + T.primaryMetaDataSize),
				unCompSize = T.unCompSize,
				jobId = AF.jobId,
agedBy = agedBy | (CASE WHEN (T.flags & 256) > 0 THEN @l_agedByChunkClose ELSE 0 END)
		OUTPUT	DELETED.archFileId, DELETED.physicalSize, DELETED.logicalSize, (CASE WHEN DELETED.unCompSize = -1 THEN 0 ELSE DELETED.unCompSize END)
		INTO	@updatedArchFileChunkSizes
		FROM	archChunkMapping ACM, #ArchFileInChunk T, archFile AF WITH (READUNCOMMITTED)
		WHERE	ACM.archChunkId = @i_archChunkId AND ACM.archFileId = T.archFileId AND ACM.commCellId = @i_commCellId AND ACM.archCopyId = T.copyId
				AND	ACM.chunkCommCellId = 2
				AND	AF.id = T.archFileId AND AF.commCellId = @i_commCellId
		IF @@ROWCOUNT != 1
		BEGIN
			SET @retVal = -3
			GOTO FINISH
		END
		SET	@l_AddChunkMapping = 0
	END
	--When zero byte chunk is committed for cloup laptop scenario, keep the chunk in open state otherwise reset the chunk open state
	UPDATE	archChunk
	SET		volumeId = @i_volumeId, fileMarkerNo = @i_fileMarkerNo, createTime = @i_createTime, version = @i_version,
physicalSize = @i_physicalSize, logicalSize = @i_logicalSize, writeTime = @i_writeTime, flags = (CASE WHEN @i_physicalSize = 0 THEN (@i_flags | 2048) ELSE (@i_flags | (flags & ~2048)) END), hwEncKey = @i_chunkHwEncKey,
agedBy = agedBy | (CASE WHEN (@i_flags & 256) > 0 THEN @l_agedByChunkClose ELSE 0 END)
	WHERE	id = @i_archChunkId AND commCellId = 2/*@i_commCellId*/
END
ELSE
IF @l_physicalSize = @i_physicalSize AND @l_logicalSize = @i_logicalSize
BEGIN
	-- This chunk has been committed already.
	GOTO FINISH
END
ELSE
BEGIN
	-- This should never happen
	SET	@retVal = -4
	GOTO FINISH
END
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
IF @l_AddChunkMapping <> 0
	INSERT INTO archChunkMapping (archChunkId, archFileId, commCellId, archCopyId, chunkNumber,
									physicalOffset, logicalOffset, physicalSize, logicalSize,
									flags, modifiedTime, dedupedSize, agedBy, chunkCommCellId,
									jobId, unCompSize)
	SELECT	@i_archChunkId, T.archFileId, @i_commCellId, T.copyId, T.chunkNumber,
			T.physicalOffset, T.logicalOffset, T.physicalSize, T.logicalSize,
T.flags, @i_createTime, (T.physicalSize - T.secondaryObjSize + T.secondaryMetaDataSize + T.primaryMetaDataSize), (CASE WHEN (T.flags & 256) > 0 THEN @l_agedByChunkClose ELSE 0 END), 2,
			AF.jobId, T.unCompSize
	FROM	#ArchFileInChunk T, archFile AF
	WHERE	AF.id = T.archFileId AND AF.commCellId = @i_commCellId
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
IF (@l_IsOpenChunk = 1)
BEGIN
	UPDATE	archFileCopy
	SET		isValid = (case when (T.isLastChunk <> 0 AND T.copyId <> @l_defCopyId) then 1 else AFC.isValid end),
			streamNum = @l_streamNum, lastChunkNumber = T.chunkNumber,
			physicalSize = (AFC.physicalSize + T.physicalSize - ISNULL(O.physicalSize, 0)), logicalSize = (AFC.logicalSize + T.logicalSize - ISNULL(O.logicalSize, 0)),
			drivePoolId = @i_drivePoolId,
flags = (CASE WHEN T.afc_flags & 128 = 0 THEN AFC.flags | T.afc_flags
ELSE (AFC.flags & ~32) | T.afc_flags END),
			modifiedTime = @i_createTime, mediaType = @l_mediaType,
			unCompSize = ((CASE WHEN AFC.unCompSize = -1 THEN 0 ELSE AFC.unCompSize END) + T.unCompSize - ISNULL(O.unCompSize, 0))
	FROM	archFileCopy AFC, #ArchFileInChunk T LEFT OUTER JOIN @updatedArchFileChunkSizes O ON T.ArchFileId = O.ArchFileId
	WHERE	AFC.archFileId = T.archFileId AND AFC.commCellId = @i_commCellId AND AFC.archCopyId = T.copyId
END
ELSE
BEGIN
	UPDATE	archFileCopy
	SET		isValid = (case when (T.isLastChunk <> 0 AND T.copyId <> @l_defCopyId) then 1 else AFC.isValid end),
			streamNum = @l_streamNum, lastChunkNumber = T.chunkNumber,
			physicalSize = (AFC.physicalSize + T.physicalSize), logicalSize = (AFC.logicalSize + T.logicalSize),
			drivePoolId = @i_drivePoolId,
flags = (CASE WHEN T.afc_flags & 128 = 0 THEN AFC.flags | T.afc_flags
ELSE (AFC.flags & ~32) | T.afc_flags END),
			modifiedTime = @i_createTime, mediaType = @l_mediaType,
			unCompSize = ((CASE WHEN AFC.unCompSize = -1 THEN 0 ELSE AFC.unCompSize END) + T.unCompSize)
	FROM	archFileCopy AFC, #ArchFileInChunk T
	WHERE	AFC.archFileId = T.archFileId AND AFC.commCellId = @i_commCellId AND AFC.archCopyId = T.copyId
END
DELETE	FROM #ArchFileInChunk
WHERE	(afc_flags & 16) = 0
IF EXISTS (SELECT archFileId FROM #ArchFileInChunk)
BEGIN
	UPDATE	archFileCopyDedup
	SET		primaryObjects = (D.primaryObjects + T.primaryObjects), secondaryObjects = (D.secondaryObjects + T.secondaryObjects),
			primaryObjSize = (D.primaryObjSize + T.primaryObjSize), secondaryObjSize = (D.secondaryObjSize + T.secondaryObjSize),
			primaryMetaDataSize = (D.primaryMetaDataSize + T.primaryMetaDataSize),
			secondaryMetaDataSize = (D.secondaryMetaDataSize + T.secondaryMetaDataSize),
			SIDBStoreId = @l_SIDBStoreId
	FROM	archFileCopyDedup D, #ArchFileInChunk T
	WHERE	D.archFileId = T.archFileId AND D.commCellId = @i_commCellId AND D.archCopyId = T.copyId
	IF @@ERROR = 0 AND @@ROWCOUNT = 0
	BEGIN
		INSERT	INTO archFileCopyDedup
		SELECT	archFileId,	@i_commCellId, copyId, @l_SIDBStoreId,
				primaryObjects, secondaryObjects,
				primaryObjSize, secondaryObjSize,
				primaryMetaDataSize, secondaryMetaDataSize,
				0, 0
		FROM	#ArchFileInChunk
		IF	@l_SIDBStoreId > 0 AND EXISTS (SELECT * FROM #ArchFileInChunk T LEFT OUTER JOIN archFileSubStore S WITH (NOLOCK) ON S.archFileId = T.archFileId AND commCellId = @i_commCellId AND SIDBStoreId = @l_SIDBStoreId WHERE S.archFileId IS NULL)
		BEGIN
			INSERT	INTO archFileSubStore (archFileId, commCellId, SIDBStoreId, SIDBSubStoreId, primaryObjects, secondaryObjects)
			SELECT	DISTINCT T.archFileId,	@i_commCellId, @l_SIDBStoreId, I.SubStoreId, 0, 0
			FROM	IdxSIDBSubStore I WITH (NOLOCK), #ArchFileInChunk T
						LEFT OUTER JOIN archFileSubStore S WITH (NOLOCK)
							ON S.archFileId = T.archFileId AND commCellId = @i_commCellId AND SIDBStoreId = @l_SIDBStoreId
			WHERE	I.SIDBStoreId = @l_SIDBStoreId
					AND S.archFileId IS NULL
		END
	END
	DELETE	FROM #ArchFileInChunk
WHERE	(afc_flags & 32) = 0
	IF EXISTS (SELECT archFileId FROM #ArchFileInChunk)
	BEGIN
		UPDATE	archChunkMappingNASDedup
		SET		primaryObjects = (D.primaryObjects + T.primaryObjects), secondaryObjects = (D.secondaryObjects + T.secondaryObjects),
				primaryObjSize = (D.primaryObjSize + T.primaryObjSize), secondaryObjSize = (D.secondaryObjSize + T.secondaryObjSize),
				primaryMetaDataSize = (D.primaryMetaDataSize + T.primaryMetaDataSize),
				secondaryMetaDataSize = (D.secondaryMetaDataSize + T.secondaryMetaDataSize)
		FROM	archChunkMappingNASDedup D, #ArchFileInChunk T
		WHERE	D.archFileId = T.archFileId AND D.commCellId = @i_commCellId AND D.archChunkId = @i_archChunkId AND D.chunkCommCellId = 2
		IF @@ERROR = 0 AND @@ROWCOUNT = 0
		INSERT	INTO archChunkMappingNASDedup
		SELECT	archFileId,	@i_commCellId, @i_archChunkId, 2, copyId, @l_SIDBStoreId,
				primaryObjects, secondaryObjects,
				primaryObjSize, secondaryObjSize,
				primaryMetaDataSize, secondaryMetaDataSize,
				0, 0
		FROM	#ArchFileInChunk
	END
END
SELECT	@retVal = @@ERROR
FINISH:
--This select is resulting multiple row to the caller of archChunkCloseCursor
--SELECT @retVal
RETURN @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkClose')
	delete from GxQscripts where name = 'archChunkClose'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkClose')
	delete from GXDBVersions where aliasname = 'archChunkClose'
GO

insert into GXDBVersions values(2, 'archChunkClose',  '00010031000200120000', 'archChunkClose', '00010031000200120000')
GO

