

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkByJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkByJob.sp,v $ $Id: archChunkByJob.sp,v 1.1.2.1 2018/04/16 14:45:30 chandru Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archChunkByJob <<<'

IF EXISTS (select * from sysobjects where name='archChunkByJob')
	drop procedure archChunkByJob
IF EXISTS (select * from GxQscripts where name='archChunkByJob')
	delete from GxQscripts where name = 'archChunkByJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkByJob')
	delete from GXDBVersions where aliasname = 'archChunkByJob'
GO
print '... Creating Procedure: archChunkByJob'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archChunkByJob
  @i_jobId integer,
  @i_commCellId integer,
  @i_dataType integer,
  @i_copyPrecedence integer,
  @i_includeAgedData integer,
  @i_excludeSystemState integer,
  @i_excludeInvalidAF integer,
  @i_preferAccessible integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @archGroupId integer;
  DECLARE @archCopyId integer;
  DECLARE @streamNum integer;
  DECLARE @mediaGroupId integer;
  DECLARE @mediaId integer;
  DECLARE @volumeId integer;
  DECLARE @archChunkId bigint;
  DECLARE @fileMarkerNo integer;
  DECLARE @version integer;
  DECLARE @chunkPhysicalSize bigint;
  DECLARE @chunkLogicalSize bigint;
  DECLARE @appId integer;
  DECLARE @appType integer;
  DECLARE @dataType integer;
  DECLARE @archFileId integer;
  DECLARE @chunkNumber integer;
  DECLARE @physicalOffset bigint;
  DECLARE @logicalOffset bigint;
  DECLARE @physicalSize bigint;
  DECLARE @logicalSize bigint;
SET NOCOUNT ON
IF object_id('tempdb.dbo.#tempAFCopy') IS NOT NULL DROP TABLE #tempAFCopy
IF object_id('tempdb.dbo.#tempAFile') IS NOT NULL DROP TABLE #tempAFile
IF object_id('tempdb.dbo.#tempChunk') IS NOT NULL DROP TABLE #tempChunk
CREATE TABLE #tempAFile (archFileId int, archGroupId int, appId int, fileType int)
CREATE TABLE #tempAFCopy (archFileId int, archCopyId int, streamNum int)
CREATE TABLE #tempChunk (archFileId int, archChunkId bigint, chunkCommcellId int,chunkNumber int,
	physicalOffset bigint, logicalOffset bigint, physicalSize bigint, logicalSize bigint,
	volumeId int, mediaId int, fileMarkerNo int, version int, chunkPhysicalSize bigint, chunkLogicalSize bigint)
INSERT INTO #tempAFile
SELECT id, archGroupId, appId, fileType FROM archFile WITH (READUNCOMMITTED)
WHERE  jobId = @i_jobId AND commCellId = @i_commCellId
   AND (@i_dataType = 0 OR fileType = @i_dataType)
   AND (@i_excludeSystemState = 0 OR name = '' OR name = 'N/A' OR name = 'Not Named' OR name like 'RefCopySrcAppId_%') --Reference copy jobs will save the original subclient id in archive file name which need not be filtered
   AND (@i_excludeInvalidAF = 0 OR isValid = 1)
IF @i_copyPrecedence = 0 AND  @i_preferAccessible <> 0
BEGIN
	DECLARE getPreferredArchFileCopy CURSOR FOR
	SELECT archFileId
	FROM #tempAFile T, archFile AF WITH (READUNCOMMITTED)
	WHERE T.archFileId = AF.id
		AND AF.commCellId = @i_commCellId
AND AF.flags & 2 = 0
	OPEN  getPreferredArchFileCopy
	DECLARE @l_inarchFileId		INT
	DECLARE @l_outArchCopyId	INT
	DECLARE @l_outAFC_isValid	INT
	DECLARE @l_outAFC_flag		INT
	DECLARE @l_error			INT = 0
	FETCH NEXT FROM getPreferredArchFileCopy INTO @l_inarchFileId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		EXEC	@l_error = archFileCopyPreferred @l_inarchFileId, @i_commCellId, @i_includeAgedData, @i_preferAccessible, @i_preferAccessible,
					@l_outArchCopyId OUTPUT, @l_outAFC_isValid OUTPUT, @l_outAFC_flag OUTPUT
		IF @l_error = 0 AND @l_outArchCopyId <> 0 AND @l_outAFC_isValid = 1
		BEGIN
			INSERT INTO #tempAFCopy
			SELECT @l_inarchFileId, @l_outArchCopyId, streamNum
			FROM archFileCopy WITH (READUNCOMMITTED)
			WHERE archCopyId = @l_outArchCopyId
				AND archFileId	= @l_inarchFileId
				AND commCellId	= @i_commCellId
		END
		FETCH NEXT FROM getPreferredArchFileCopy INTO @l_inarchFileId
	END
	CLOSE		getPreferredArchFileCopy
	DEALLOCATE	getPreferredArchFileCopy
END
DECLARE getArchFileCopy CURSOR FOR
SELECT A.archFileId, A.archCopyId, A.streamNum
FROM   archFileCopy A WITH (READUNCOMMITTED), #tempAFile B, archGroupCopy C WITH (READUNCOMMITTED)
WHERE  A.commCellId = @i_commCellId AND A.archFileId = B.archFileId
AND A.lastChunkNumber > 0 AND (@i_includeAgedData <> 0 OR (A.flags & 256) = 0)
AND A.archCopyId = C.id AND (@i_copyPrecedence = 0 OR C.copy = @i_copyPrecedence)
AND C.type <> 5 -- SELECT only none transitive copy files/chunks for restore
ORDER BY A.archFileId ASC, A.isValid DESC, C.copy ASC
OPEN  getArchFileCopy
DECLARE @l_archFileId int
DECLARE @l_archCopyId int
DECLARE @l_streamNum int
FETCH NEXT FROM getArchFileCopy INTO @l_archFileId, @l_archCopyId, @l_streamNum
WHILE @@FETCH_STATUS = 0
BEGIN
	INSERT INTO #tempAFCopy
	SELECT @l_archFileId, @l_archCopyId, @l_streamNum
	WHERE  NOT EXISTS (SELECT * FROM #tempAFCopy WHERE archFileId = @l_archFileId)
	FETCH NEXT FROM getArchFileCopy INTO @l_archFileId, @l_archCopyId, @l_streamNum
END
CLOSE getArchFileCopy
DEALLOCATE getArchFileCopy
INSERT INTO #tempChunk
SELECT A.archFileId, A.archChunkId, A.chunkCommcellId,A.chunkNumber,
       A.physicalOffset, A.logicalOffset, A.physicalSize, A.logicalSize, 0, 0, 0, 0, 0, 0
FROM   archChunkMapping A WITH (READUNCOMMITTED), #tempAFCopy T
WHERE  A.archFileId = T.archFileId AND A.commCellId = @i_commCellId AND A.archCopyId = T.archCopyId
		AND A.chunkNumber > 0
UPDATE #tempChunk
SET    volumeId = A.volumeId, mediaId = (SELECT MediaId FROM MMVolume WITH (READUNCOMMITTED) WHERE VolumeId = A.volumeId),
       fileMarkerNo = A.fileMarkerNo, version = A.version,
       chunkPhysicalSize = A.physicalSize, chunkLogicalSize = A.logicalSize
FROM   #tempChunk T, archChunk A WITH (READUNCOMMITTED)
WHERE  T.archChunkId = A.id AND A.commCellId = T.chunkCommcellId
SELECT A.archGroupId, B.archCopyId, B.streamNum,
       mediaGroupId = (SELECT mediaGroupId FROM archStream WITH (READUNCOMMITTED) WHERE archGroupCopyId = B.archCopyId AND stream = B.streamNum),
       C.mediaId, C.volumeId, C.archChunkId, C.fileMarkerNo, C.version, C.chunkPhysicalSize, C.chunkLogicalSize,
       A.appId, appType = (SELECT appTypeId FROM APP_Application WITH (READUNCOMMITTED) WHERE id = A.appId), A.fileType,
       C.archFileId, C.chunkNumber, C.physicalOffset, C.logicalOffset, C.physicalSize, C.logicalSize
FROM  #tempAFile A, #tempAFCopy B, #tempChunk C
WHERE A.archFileId = C.archFileId AND B.archFileId = C.archFileId
ORDER BY C.archChunkId, C.archFileId
IF object_id('tempdb.dbo.#tempAFCopy') IS NOT NULL DROP TABLE #tempAFCopy
IF object_id('tempdb.dbo.#tempAFile') IS NOT NULL DROP TABLE #tempAFile
IF object_id('tempdb.dbo.#tempChunk') IS NOT NULL DROP TABLE #tempChunk
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkByJob')
	delete from GxQscripts where name = 'archChunkByJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkByJob')
	delete from GXDBVersions where aliasname = 'archChunkByJob'
GO

insert into GXDBVersions values(2, 'archChunkByJob',  '00010001000200010000', 'archChunkByJob', '00010001000200010000')
GO

