

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkAppSizeCalc.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc.  The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkAppSizeCalc.sp,v $ $Id: archChunkAppSizeCalc.sp,v 1.5.36.4 2019/03/22 10:04:16 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archChunkAppSizeCalc')
BEGIN
	print '>>> Drop Stored Procedure: archChunkAppSizeCalc <<<'
	drop procedure archChunkAppSizeCalc
END
IF EXISTS (select * from GxQscripts where name='archChunkAppSizeCalc')
	delete from GxQscripts where name = 'archChunkAppSizeCalc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkAppSizeCalc')
	delete from GXDBVersions where aliasname = 'archChunkAppSizeCalc'
GO
print '... Creating Procedure: archChunkAppSizeCalc'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archChunkAppSizeCalc
  @i_jobId INT,
  @i_commCellId INT,
  @i_archCopyId INT,
  @i_attempStart INT,
  @i_attemptUnCompSize BIGINT
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @retVal integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @totalBackupSize BIGINT
DECLARE @now INT = dbo.GetUnixTime(GetUTCDate())
IF OBJECT_ID('tempdb.dbo.#tempArchFileCopy') IS NOT NULL DROP TABLE #tempArchFileCopy
CREATE TABLE #tempArchFileCopy (
		archFileId int, commCellId int, archCopyId int, archGroupId int, physicalSize bigint, unCompSize bigint, PRIMARY KEY (archFileId, commCellId))
IF EXISTS (SELECT	1 FROM archChunkMapping ACM WITH (READUNCOMMITTED)
			WHERE	ACM.jobId = @i_jobId
					AND ACM.commCellId = @i_commCellId
					AND ACM.chunkNumber > 0
					AND ACM.unCompSize = -1)
BEGIN
	INSERT INTO #tempArchFileCopy
	SELECT	AFC.archFileId, AFC.commCellId, AFC.archCopyId, AF.archGroupId, AFC.physicalSize, 0
	FROM	archFile AF WITH (READUNCOMMITTED), archFileCopy AFC WITH (READUNCOMMITTED), archGroup AG WITH (READUNCOMMITTED)
	WHERE	AF.id = AFC.archFileId
			AND AF.commCellId = AFC.commCellId
			AND AF.archGroupId = AG.id
			AND (AFC.archCopyId = @i_archCopyId OR (@i_archCopyId = 0 AND AFC.archCopyId IN (AG.defaultCopy, AG.defaultSnapCopy)))
			AND AF.jobId = @i_jobId
			AND AF.commCellId = @i_commCellId
			AND AF.cTime >= @i_attempStart
			AND AF.isValid = 1
			AND AFC.isValid = 1
	SET	@retVal	=	@@ERROR
	IF	@retVal != 0 GOTO CX_EXIT
	SELECT	@totalBackupSize = SUM(physicalSize)
	FROM	#tempArchFileCopy
	SET	@retVal	=	@@ERROR
	IF	@retVal != 0 GOTO CX_EXIT
	UPDATE	#tempArchFileCopy
	SET		unCompSize = ((physicalSize * 1.0)/@totalBackupSize) * @i_attemptUnCompSize
	WHERE   @totalBackupSize > 0
	SET	@retVal	=	@@ERROR
	IF	@retVal != 0 GOTO CX_EXIT
	UPDATE	AFC
	SET		unCompSize = tAFC.unCompSize
	FROM	archFileCopy AFC, #tempArchFileCopy tAFC
	WHERE   AFC.archFileId = tAFC.archFileId
			AND AFC.commCellId = tAFC.commCellId
			AND AFC.archCopyId = tAFC.archCopyId
			AND AFC.unCompSize = -1
			AND tAFC.physicalSize > 0
	SET	@retVal	=	@@ERROR
	IF	@retVal != 0 GOTO CX_EXIT
	UPDATE	ACM
	SET		unCompSize = (ACM.physicalSize*1.0/T.physicalSize) * T.unCompSize
	FROM	archChunkMapping ACM, #tempArchFileCopy T
	WHERE	ACM.archFileId = T.archFileId
			AND ACM.commCellId = T.commCellId
			AND ACM.archCopyId = T.archCopyId
			AND ACM.chunkNumber > 0
			AND ACM.unCompSize = -1
			AND T.physicalSize > 0
	SET	@retVal	=	@@ERROR
	IF	@retVal != 0 GOTO CX_EXIT
END
CX_EXIT:
	IF OBJECT_ID('tempdb.dbo.#tempArchFileCopy') IS NOT NULL DROP TABLE #tempArchFileCopy
	SELECT @retVal
	RETURN @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkAppSizeCalc')
	delete from GxQscripts where name = 'archChunkAppSizeCalc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkAppSizeCalc')
	delete from GXDBVersions where aliasname = 'archChunkAppSizeCalc'
GO

insert into GXDBVersions values(2, 'archChunkAppSizeCalc',  '00010005003600040000', 'archChunkAppSizeCalc', '00010005003600040000')
GO

