

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archCheckSrcDestVersionCompatibility.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archCheckSrcDestVersionCompatibility.sp,v $ $Id: archCheckSrcDestVersionCompatibility.sp,v 1.1.2.2.20.1 2021/03/02 19:41:07 pnara Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archCheckSrcDestVersionCompatibility')
BEGIN
	print '>>> Drop Stored Procedure: archCheckSrcDestVersionCompatibility <<<'
	drop procedure archCheckSrcDestVersionCompatibility
END
IF EXISTS (select * from GxQscripts where name='archCheckSrcDestVersionCompatibility')
	delete from GxQscripts where name = 'archCheckSrcDestVersionCompatibility'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCheckSrcDestVersionCompatibility')
	delete from GXDBVersions where aliasname = 'archCheckSrcDestVersionCompatibility'
GO
print '... Creating Procedure: archCheckSrcDestVersionCompatibility'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archCheckSrcDestVersionCompatibility
  @i_jobId integer,
  @i_srcClientId integer,
  @i_destClientId integer
AS
  DECLARE @o_errorCode integer = 0
  DECLARE @o_srcClientName NVARCHAR(255) = ''
  DECLARE @o_destClientName NVARCHAR(255) = ''
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
--
-- Recalls to WebServer may fail when CS is upgraded but not MAs
-- so skip version check if source or destination is CommServe itself.
--
IF @i_srcClientId = 2 OR @i_destClientId = 2
	goto FINISH
IF EXISTS(SELECT 1 FROM GXGlobalParam WITH(READUNCOMMITTED) WHERE name = 'SkipMediaAgentVersionCompatibilityCheck' AND modified = 0 AND value = 'true')
	goto FINISH
DECLARE @l_opType INT = dbo.GetJobTypeForJobID(@i_jobId)
--
-- Don't allow backups or restores if client version is higher than MediaAgent
-- Skip check for DR backups
--
IF	@l_opType <> 11 /*CVOpType::CSDRBKP*/
BEGIN
	IF EXISTS
	(
		SELECT 	1
		FROM	(
					SELECT  VC.PMClientId SrcClientId
					FROM 	APP_VMToPMMap VC WITH(READUNCOMMITTED)
					WHERE 	VC.VMClientId = @i_srcClientId
					UNION ALL
					SELECT @i_srcClientId SrcClientId
				) S,
				App_Client SCN WITH(READUNCOMMITTED),
				simInstalledPackages SPKG WITH(READUNCOMMITTED),
				(
					SELECT  VC.PMClientId DestClientId
					FROM 	APP_VMToPMMap VC WITH(READUNCOMMITTED)
					WHERE 	VC.VMClientId = @i_destClientId
					UNION ALL
					SELECT @i_destClientId DestClientId
				) D,
				App_Client DCN WITH(READUNCOMMITTED),
				simInstalledPackages DPKG WITH(READUNCOMMITTED)
		WHERE	SCN.id = S.SrcClientId
				AND SCN.id = SPKG.ClientId
				AND DCN.id = D.DestClientId
				AND DCN.id = DPKG.ClientId
AND SPKG.simPackageID IN (1, 1002)
AND DPKG.simPackageID IN (1, 1002)
				AND
				(
					SCN.releaseId > DCN.releaseId
					OR (SCN.releaseId = DCN.releaseId AND dbo.GetServicePackNumber(SPKG.HighestSP) > dbo.GetServicePackNumber(DPKG.HighestSP))
				)
	)
	BEGIN
SET @o_errorCode = 1012
		SELECT @o_srcClientName = displayName FROM App_Client WITH(READUNCOMMITTED) WHERE id = @i_srcClientId
		SELECT @o_destClientName = displayName FROM App_Client WITH(READUNCOMMITTED) WHERE id = @i_destClientId
	END
END
FINISH:
SELECT	@o_errorCode, @o_srcClientName, @o_destClientName
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archCheckSrcDestVersionCompatibility')
	delete from GxQscripts where name = 'archCheckSrcDestVersionCompatibility'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCheckSrcDestVersionCompatibility')
	delete from GXDBVersions where aliasname = 'archCheckSrcDestVersionCompatibility'
GO

insert into GXDBVersions values(2, 'archCheckSrcDestVersionCompatibility',  'v1.1.2.2.20.1', 'archCheckSrcDestVersionCompatibility', 'v1.1.2.2.20.1')
GO

