

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archCheckSourceCopyHasPartialJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archCheckSourceCopyHasPartialJobs.sp,v $ $Id: archCheckSourceCopyHasPartialJobs.sp,v 1.1.2.10 2020/05/10 01:16:47 pveeravalli Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archCheckSourceCopyHasPartialJobs')
BEGIN
	print '>>> Drop Stored Procedure: archCheckSourceCopyHasPartialJobs <<<'
	drop procedure archCheckSourceCopyHasPartialJobs
END
IF EXISTS (select * from GxQscripts where name='archCheckSourceCopyHasPartialJobs')
	delete from GxQscripts where name = 'archCheckSourceCopyHasPartialJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCheckSourceCopyHasPartialJobs')
	delete from GXDBVersions where aliasname = 'archCheckSourceCopyHasPartialJobs'
GO
print '... Creating Procedure: archCheckSourceCopyHasPartialJobs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archCheckSourceCopyHasPartialJobs
  @i_copyId integer,
  @i_oldSrcCopyId integer,
  @i_newSrcCopyId integer
AS
  DECLARE @archErrorCode integer;
SET NOCOUNT ON
IF object_id('tempdb.dbo.#TempPartialAF') IS NOT NULL DROP TABLE #TempPartialAF
CREATE TABLE #TempPartialAF (archFileId INT, commCellId INT, archCopyId INT, encKeyType INT, encKey VARCHAR(1024))
DECLARE @l_defCopyId integer
DECLARE @l_dedupeFlags integer
DECLARE @l_extendedFlags integer
SELECT	@l_defCopyId = (case when AGC.isSnapCopy = 0 then AG.defaultCopy else AG.defaultSnapCopy end), @l_dedupeFlags = AGC.dedupeFlags, @l_extendedFlags = extendedFlags
FROM	archGroup AG, archGroupCopy AGC
WHERE	AG.id = AGC.archGroupId AND AGC.id = @i_copyId
-- If copy is dedupe we always decrypt and encrypt the data so we can allow changing source copy
IF ((@l_dedupeFlags & 262144) = 0)
BEGIN
	IF	@i_oldSrcCopyId = 0 OR @i_newSrcCopyId = 0
	BEGIN
		IF	@i_oldSrcCopyId = 0
			SET @i_oldSrcCopyId = @l_defCopyId
		ELSE
		IF	@i_newSrcCopyId = 0
			SET	@i_newSrcCopyId = @l_defCopyId
	END
	IF OBJECT_ID('tempdb..#lt_Copies') IS NOT NULL DROP TABLE #lt_Copies
	CREATE TABLE #lt_Copies (copyId smallint, oldSrcCopyId smallint, newSrcCopyId smallint)
	IF OBJECT_ID('tempdb..#lt_PrimaryCopies') IS NOT NULL DROP TABLE #lt_PrimaryCopies
	CREATE TABLE #lt_PrimaryCopies (copyId smallint, defCopyId smallint)
	--For global policy check partial AFs on all dependent copies
IF (@l_extendedFlags & (1 | 4096)) > 0
	BEGIN
		INSERT 	INTO #lt_Copies
		SELECT	DAGC.id, (case when DAGC.sourceCopyId = 0 THEN (case when DAGC.isSnapCopy = 0 then DAG.defaultCopy else DAG.defaultSnapCopy end) else DAGC.sourceCopyId end),
				(case when DAGC.sourceCopyId = 0 THEN (case when DAGC.isSnapCopy = 0 then DAG.defaultCopy else DAG.defaultSnapCopy end) else DAGC.sourceCopyId end)
        FROM    archGroupCopy DAGC WITH (READUNCOMMITTED)
                INNER JOIN archGroup DAG WITH (READUNCOMMITTED) ON DAGC.archGroupId = DAG.id
                INNER JOIN archCopyToGlobalPolicy DAGC2GAG WITH (READUNCOMMITTED) ON DAGC2GAG.copyId = DAGC.Id
        INNER JOIN archGroupCopy GAGC ON GAGC.archGroupId = DAGC2GAG.globalPolicyId
        WHERE GAGC.id = @i_copyId
	END
	ELSE
	BEGIN
		INSERT INTO #lt_Copies
		SELECT @i_copyId, @i_oldSrcCopyId, @i_newSrcCopyId
	END
	--Populate transitive copies
	--In case of GACP we should populate all dependent copies as source copies.
	INSERT INTO #lt_Copies
	SELECT 	TC.id, C.copyId, C.copyId
	FROM	#lt_Copies C,
			archCopyMediaRefreshProp MR WITH (READUNCOMMITTED),
			archGroupCopy TC WITH (READUNCOMMITTED)
WHERE	(MR.copyId = C.copyId OR MR.copyId = @i_copyId AND (@l_extendedFlags & (1) > 0))
			AND MR.targetCopyId = TC.id
AND TC.type = 5
	--Get primary copies for each copy in the copies list
	INSERT INTO #lt_PrimaryCopies
	SELECT	C.copyId, (case when AGC.isSnapCopy = 0 then AG.defaultCopy else AG.defaultSnapCopy end)
	FROM	#lt_Copies C, archGroupCopy AGC, archGroup AG
	WHERE	C.copyId = AGC.id AND AGC.archGroupId = AG.id
	-- Get partial archive files
	INSERT	INTO #TempPartialAF
	SELECT	Dest.archFileId, Dest.commCellId, Dest.archCopyId, Dest.encKeyType, Dest.encKey
	FROM	archFileCopy Src, archFileCopy Dest, #lt_Copies C
	WHERE	Src.archFileId = Dest.archFileId AND Src.commCellId = Dest.commCellId
			AND Src.archCopyId = C.oldSrcCopyId AND Dest.archCopyId = C.copyId
			AND Dest.isValid = 0 AND (Dest.flags & 256) = 0
			AND Dest.physicalSize > 0
	--
	-- If copy has Edge archFile follow below steps to find archFile is partial in current copy.
	-- 1. Get all source copies in copy hierarchy
	-- 2. Find latest size of archFile from all copies
	-- 3. Compare the latest size with the size in current copy to know whether archFile is partial in current copy.
	-- 4. Treat all current running AFs as partial.
	--
	--  Time	ArchFile	Primay	 ==>	Sec	 	==>		Third
	--
	--	T1		AF1			50 Chunks		50 Chunks		50 Chunks
	--
	--	T2		AF1			100 Chunks		50 Chunks		50 Chunks
	--
	IF EXISTS
	(
		SELECT	1
		FROM 	archFile AF, archFileCopy AFC, #lt_Copies C
		WHERE	AF.id = AFC.archFileId AND AF.commCellId = AFC.commCellId
AND AFC.archCopyId = C.copyId AND (AF.flags & (32768|2097152)) > 0
	)
	BEGIN
		--Get All parent source copies till primary copy T -> S -> P
		WITH SourceCopies (copyId, srcCopyId) AS
		(
			(
				SELECT 	copyId, oldSrcCopyId
				FROM	#lt_Copies
				UNION ALL
				SELECT 	copyId, defCopyId
				FROM	#lt_PrimaryCopies
			)
			UNION ALL
			SELECT	SC.copyId, AGC.sourceCopyId
			FROM	archGroupCopy AGC, SourceCopies SC
			WHERE	AGC.id = SC.srcCopyId AND AGC.sourceCopyId > 0
		)
		INSERT	INTO #TempPartialAF
		SELECT	Dest.archFileId, Dest.commCellId, Dest.archCopyId, Dest.encKeyType, Dest.encKey
		FROM	archFileCopy Src, archFileCopy Dest, #lt_Copies C,
				(
					SELECT 	AFC.archFileId, AFC.commCellId, MAX(AFC.physicalSize) physicalSize
					FROM 	archFile AF, archFileCopy AFC, SourceCopies SC
					WHERE	AF.id = AFC.archFileId AND AF.commCellId = AFC.commCellId
AND AFC.archCopyId = SC.srcCopyId AND (AF.flags & (32768|2097152)) > 0
					GROUP BY AFC.archFileId, AFC.commCellId
				) AS MaxSrc
		WHERE	Src.archFileId = Dest.archFileId AND Src.commCellId = Dest.commCellId
				AND Src.archCopyId = C.oldSrcCopyId AND Dest.archCopyId = C.copyId
				AND Src.archFileId = MaxSrc.archFileId AND Src.commCellId = MaxSrc.commCellId
				AND MaxSrc.physicalSize <> Dest.physicalSize
				AND Dest.physicalSize > 0
		-- We are closing current runnings AFs so no need of treating them as partial.
		-- 4. Treat all current running AFs as partial.
		-- INSERT	INTO #TempPartialAF
		-- SELECT	Src.archFileId, Src.commCellId, Src.encKeyType, Src.encKey
		-- FROM 	archFileCopy Src, archFileCopy Dest,
				-- (
					-- SELECT 	AFC.archFileId, AFC.commCellId, ROW_NUMBER() OVER (PARTITION BY AF.appId, AFC.streamNum ORDER BY AFC.archFileId DESC) AS RowNum
					-- FROM 	archFile AF, archFileCopy AFC
					-- WHERE	AF.id = AFC.archFileId AND AF.commCellId = AFC.commCellId  AND AF.commCellId = 2
							-- AND AFC.archCopyId = @l_defCopyId AND (AF.flags & (CVA_AF_EDGE_DRIVE_FLAG|CVA_AF_REUSABLE_FLAG)) > 0
							-- AND AF.backupLevel <> 1 /*FULL*/
				-- ) AS T
		-- WHERE 	Src.archFileId = Dest.archFileId AND Src.commCellId = Dest.commCellId
				-- AND Src.archCopyId = @i_oldSrcCopyId AND Dest.archCopyId = @i_copyId
				-- AND Dest.archFileId = T.archFileId AND Dest.commCellId = T.commCellId
				-- AND T.RowNum = 1
	END
	DELETE	#TempPartialAF
	FROM	archFileCopy AFC, #TempPartialAF T, #lt_Copies C
	WHERE	AFC.archFileId = T.archFileId AND AFC.commCellId = T.commCellId AND AFC.archCopyId = C.newSrcCopyId AND T.archCopyId = C.copyId
		AND AFC.encKeyType = T.encKeyType AND AFC.encKey = T.encKey
	DELETE	#TempPartialAF
	FROM	#TempPartialAF T, archFile AF, JMJobDataStats J
	WHERE	AF.id = T.archFileId AND AF.commCellId = T.commCellId
		AND J.jobId = AF.jobId AND J.commCellId = AF.commCellId AND J.dataType = AF.fileType AND J.archGrpCopyId = T.archCopyId
		AND (J.status NOT IN (101, 102, 103) OR (J.disabled & 256) <> 0)
	-- If copy has partial AFs don't allow changing source copy.
	IF EXISTS (SELECT * FROM #TempPartialAF)
		SELECT 1
	ELSE
	BEGIN
		--Close current running edge AFs
		UPDATE 	EAF
SET		flags = EAF.flags | 1048576
		FROM	archFile EAF INNER JOIN
				(
					SELECT 	AFC.archFileId, AFC.commCellId, ROW_NUMBER() OVER (PARTITION BY AF.appId, AFC.streamNum ORDER BY AFC.archFileId DESC) AS RowNum
					FROM 	archFile AF, archFileCopy AFC, #lt_PrimaryCopies C
					WHERE	AF.id = AFC.archFileId AND AF.commCellId = AFC.commCellId  AND AF.commCellId = 2
AND AFC.archCopyId = C.defCopyId AND (AF.flags & (32768|2097152)) > 0
							AND AF.backupLevel = 2 /*INCR*/
				) AS T 	ON EAF.id = T.archFileId AND EAF.commCellId = T.commCellId AND T.RowNum = 1
		SELECT 0
	END
END
ELSE
BEGIN
	SELECT 0
END
DROP TABLE #TempPartialAF
GO

IF EXISTS (select * from GxQscripts where name = 'archCheckSourceCopyHasPartialJobs')
	delete from GxQscripts where name = 'archCheckSourceCopyHasPartialJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCheckSourceCopyHasPartialJobs')
	delete from GXDBVersions where aliasname = 'archCheckSourceCopyHasPartialJobs'
GO

insert into GXDBVersions values(2, 'archCheckSourceCopyHasPartialJobs',  '00010001000200100000', 'archCheckSourceCopyHasPartialJobs', '00010001000200100000')
GO

