

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archCheckOldSystemStateData.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archCheckOldSystemStateData.sp,v $ $Id: archCheckOldSystemStateData.sp,v 1.3.294.3 2019/06/03 18:20:37 hkapadia Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archCheckOldSystemStateData')
BEGIN
	print '>>> Drop Stored Procedure: archCheckOldSystemStateData <<<'
	drop procedure archCheckOldSystemStateData
END
IF EXISTS (select * from GxQscripts where name='archCheckOldSystemStateData')
	delete from GxQscripts where name = 'archCheckOldSystemStateData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCheckOldSystemStateData')
	delete from GXDBVersions where aliasname = 'archCheckOldSystemStateData'
GO
print '... Creating Procedure: archCheckOldSystemStateData'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archCheckOldSystemStateData
  @dummy integer
AS
  DECLARE @o_retVal INTEGER;
	SET NOCOUNT ON
	DECLARE	@errorCode		INTEGER
	SET			@errorCode		= 0
	-------------------------------------------------------------------------------
	-- Table variable declarations
	-------------------------------------------------------------------------------
	DECLARE @tblBackupSetIdList TABLE (
			BackupSetId 		int,
			oldSysStateAFExists int
			primary key (BackupSetId)
			)
	DECLARE @tblBackupSetWithOldSysStateAF TABLE (
			BackupSetId int
			primary key (BackupSetId)
			)
	DECLARE @tblBackupSetWithSCPolicy TABLE (
			BackupSetId 		int,
			SCPolicyId			int,
			AppId						int,
			AssociatedAppId	int,
			isSysStateSC		int
			primary key (AppId)
			)
	INSERT INTO @tblBackupSetIdList
	SELECT	id, 0
	FROM	APP_BackupSetName	WITH (NOLOCK)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Get all BackupSets/SubClients with SubClient Policy
	INSERT INTO @tblBackupSetWithSCPolicy
	SELECT APP.BackupSet, CAST(PROP.attrVal as INT), APP.Id, 0, 0
	FROM APP_Application APP WITH (NOLOCK), App_BackupSetProp PROP WITH (NOLOCK)
	WHERE	APP.BackupSet = PROP.ComponentNameId
	AND		PROP.attrName IN (N'Associated subclient Policy')
	AND		PROP.modified = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Get all Associated SubClients
	UPDATE @tblBackupSetWithSCPolicy
	SET AssociatedAppId = CAST(PROP.attrVal as INT)
	FROM @tblBackupSetWithSCPolicy T, APP_SubClientProp PROP WITH (NOLOCK)
	WHERE	T.AppId = PROP.ComponentNameId
	AND		PROP.attrName IN (N'Associated subclient Policy')
	AND		PROP.modified = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Get all System State SubClients
	UPDATE @tblBackupSetWithSCPolicy
	SET isSysStateSC = 1
	FROM @tblBackupSetWithSCPolicy T, APP_SubClientProp PROP WITH (NOLOCK)
	WHERE	T.AssociatedAppId = PROP.ComponentNameId
	AND		PROP.attrName IN (N'System State Subclient', N'System State')
	AND		PROP.attrVal = '1'
	AND		PROP.modified = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	INSERT INTO @tblBackupSetWithOldSysStateAF
	SELECT DISTINCT APP.BackupSet
	FROM 	APP_Application APP WITH (NOLOCK), APP_SubClientProp PROP WITH (NOLOCK), archFile AF WITH (NOLOCK)
	WHERE	APP.id = PROP.ComponentNameId
	AND		PROP.attrName IN (N'System State Subclient', N'System State')
	AND		PROP.attrVal = '1'
	AND		PROP.modified = 0
	AND		APP.id = AF.appId
	AND		AF.isValid = 1
	AND		AF.backupLevel <> 512
	AND		AF.name NOT IN ('', 'N/A', 'Not Named')
	UNION
	SELECT DISTINCT T.BackupSetId
	FROM 	@tblBackupSetWithSCPolicy T, archFile AF WITH (NOLOCK)
	WHERE	T.isSysStateSC = 1
	AND		T.AppId = AF.appId
	AND		AF.isValid = 1
	AND		AF.backupLevel <> 512
	AND		AF.name NOT IN ('', 'N/A', 'Not Named')
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE	@tblBackupSetIdList
	SET		oldSysStateAFExists = 1
	FROM	@tblBackupSetIdList A, @tblBackupSetWithOldSysStateAF B
	WHERE	A.BackupSetId = B.BackupSetId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Update the OldSystemStateDataPresent column
	UPDATE 	APP_BackupSetProp
	SET 	attrVal = BKPUPSET.oldSysStateAFExists
	FROM 	APP_BackupSetProp PROP, @tblBackupSetIdList BKPUPSET
	WHERE PROP.ComponentNameId = BKPUPSET.BackupSetId
	AND		PROP.attrname IN (N'Pre 7.0 System State Archive Files Exist')
	AND		PROP.modified = 0
	AND		CAST(PROP.attrVal as INT) != BKPUPSET.oldSysStateAFExists
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
CX_EXIT:
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'archCheckOldSystemStateData')
	delete from GxQscripts where name = 'archCheckOldSystemStateData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCheckOldSystemStateData')
	delete from GXDBVersions where aliasname = 'archCheckOldSystemStateData'
GO

insert into GXDBVersions values(2, 'archCheckOldSystemStateData',  '00010003029400030000', 'archCheckOldSystemStateData', '00010003029400030000')
GO

