

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archCheckDataAcessNodeConfigurationAllowed.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  archCheckDataAcessNodeConfigurationAllowed.sp                   */
/*                                                                            */
/*  Description :  To Check if addition of new dataAccessNodes are allowed    */
/*																			  */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archCheckDataAcessNodeConfigurationAllowed.sp,v $ $Id: archCheckDataAcessNodeConfigurationAllowed.sp,v 1.1.2.1 2018/12/31 23:20:47 kjaiswal Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archCheckDataAcessNodeConfigurationAllowed')
BEGIN
	print '>>> Drop Stored Procedure: archCheckDataAcessNodeConfigurationAllowed <<<'
	drop procedure archCheckDataAcessNodeConfigurationAllowed
END
IF EXISTS (select * from GxQscripts where name='archCheckDataAcessNodeConfigurationAllowed')
	delete from GxQscripts where name = 'archCheckDataAcessNodeConfigurationAllowed'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCheckDataAcessNodeConfigurationAllowed')
	delete from GXDBVersions where aliasname = 'archCheckDataAcessNodeConfigurationAllowed'
GO
print '... Creating Procedure: archCheckDataAcessNodeConfigurationAllowed'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archCheckDataAcessNodeConfigurationAllowed
  @i_XMLInput XML
AS
  DECLARE @o_isAllowed INT
  DECLARE @o_proxyClientId INT
  DECLARE @o_ProxyEntityType INT
  DECLARE @o_ProxyClientGroupID INT
DECLARE @isTmpTablePrePopulated BIT = 0
DECLARE @idoc int = 0
DECLARE @xmlText  XML
DECLARE @isAllowed INT = 1
IF object_id('tempdb.dbo.#InputDataAccessNodeConfigs') is not null
	SET @isTmpTablePrePopulated = 1
ELSE
	CREATE TABLE #InputDataAccessNodeConfigs -- only populate appID and copyID if this table is being created in the caller
	(
		ProxyCLientId	 INT,
		ProxyEntityType		INT,
		ProxyClientGroupID	INT,
		ClientId	 INT,
		appTypeId	INT,
		instanceId	INT,
		bkpsetid  INT,
		subclientID INT,
		isAllowed	INT
	)
IF @isTmpTablePrePopulated = 0
BEGIN
	EXEC sp_xml_preparedocument @idoc OUTPUT, @i_XMLInput;
	INSERT INTO #InputDataAccessNodeConfigs
	SELECT ProxyCLientId, ProxyEntityType, ProxyClientGroupID, aa.ClientId, aa.appTypeId, aa.instance, aa.backupSet, aa.id, 1
	FROM OPENXML(@idoc, '/App_DataAccessNodeConfigAllowedCheck/dataAccessNodeConfigs', 2)
				WITH (  ProxyCLientId		INT		'proxyClient/@clientId',
						ProxyEntityType		INT		'proxyClient/@_type_',
						ProxyClientGroupID	INT		'proxyClient/@clientGroupId',
						ClientId			INT		'pseudoEntity/@clientId',
						appTypeId			INT		'pseudoEntity/@appTypeId',
						instanceid			INT		'pseudoEntity/@instanceId',
						bkpsetid			INT		'pseudoEntity/@bkpsetid',
						subclientID			INT		'pseudoEntity/@subclientID'
					  ) AS x INNER JOIN APP_Application aa ON (ISNULL(x.clientID,0) = 0 OR x.ClientId = aa.clientId)
							AND (ISNULL(x.appTypeId,0) = 0 OR x.appTypeId = aa.appTypeId) AND (ISNULL(x.instanceid,0) = 0 OR x.instanceid = aa.instance)
							AND (ISNULL(x.bkpsetid,0) = 0 OR x.bkpsetid = aa.backupSet) AND (ISNULL(x.subclientID,0) = 0 OR x.subclientID = aa.id)
END
IF EXISTS (SELECT 1 FROM #InputDataAccessNodeConfigs t, App_Client c, simInstalledPackages P
			WHERE ((ProxyEntityType = 3 AND c.id = t.ProxyCLientId) OR (ProxyEntityType = 28 AND c.id IN (SELECT clientID FROM APP_ClientGroupAssoc where clientGroupID = ProxyClientGroupID))) AND P.clientID = c.id AND (c.releaseID < 16 OR (c.releaseID = 16 AND P.HighestSP < 14 )))
BEGIN
	--if the subclient is mapped to a non default DDB then do not allow the configuration
	UPDATE #InputDataAccessNodeConfigs
	SET isAllowed = 0
	FROM #InputDataAccessNodeConfigs t, App_Client c, simInstalledPackages P, archSubClientCopyDDBMap M, ArchCopySIDBSTore CS
	WHERE  P.clientID = c.id AND (c.releaseID < 16 OR (c.releaseID = 16 AND P.HighestSP < 14 ))
AND M.appID = t.subclientID AND CS.SIDBStoreID = M.SIDBStoreID and CS.flags & 2 = 0
		AND ((ProxyEntityType = 3 AND c.id = t.ProxyCLientId) OR (ProxyEntityType = 28 AND c.id IN (SELECT clientID FROM APP_ClientGroupAssoc where clientGroupID = ProxyClientGroupID)))
	IF @@ROWCOUNT > 0
		SET @isAllowed = 0
END
IF @isTmpTablePrePopulated = 0
BEGIN
	SELECT MIN(isAllowed), ProxyCLientId, ProxyEntityType, ProxyClientGroupID
	FROM #InputDataAccessNodeConfigs
	GROUP BY ProxyCLientId, ProxyEntityType, ProxyClientGroupID
	IF object_id('tempdb.dbo.#InputDataAccessNodeConfigs') is not null DROP TABLE #InputDataAccessNodeConfigs
END
GO

IF EXISTS (select * from GxQscripts where name = 'archCheckDataAcessNodeConfigurationAllowed')
	delete from GxQscripts where name = 'archCheckDataAcessNodeConfigurationAllowed'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCheckDataAcessNodeConfigurationAllowed')
	delete from GXDBVersions where aliasname = 'archCheckDataAcessNodeConfigurationAllowed'
GO

insert into GXDBVersions values(2, 'archCheckDataAcessNodeConfigurationAllowed',  '00010001000200010000', 'archCheckDataAcessNodeConfigurationAllowed', '00010001000200010000')
GO

