

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archCheckCoreMA.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archCheckCoreMA.sp,v $ $Id: archCheckCoreMA.sp,v 1.1.2.13.4.1 2021/03/10 23:23:04 anarulkar Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archCheckCoreMA')
BEGIN
	print '>>> Drop Stored Procedure: archCheckCoreMA <<<'
	drop procedure archCheckCoreMA
END
IF EXISTS (select * from GxQscripts where name='archCheckCoreMA')
	delete from GxQscripts where name = 'archCheckCoreMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCheckCoreMA')
	delete from GXDBVersions where aliasname = 'archCheckCoreMA'
GO
print '... Creating Procedure: archCheckCoreMA'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archCheckCoreMA
  @i_clientId integer,
  @i_jobId bigint,
  @i_libraryId integer,
  @i_clientName nvarchar(255)
AS
  DECLARE @o_hasCoreMAOverride int;
  DECLARE @o_hasAccessToLibrary int = 0;
DECLARE @l_coreMA INT = 0
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
-- isWinUnix
-- Windows - N_WIN_PACKAGE_MEDIAAGENT_CORE
-- Unix - N_UNIX_PACKAGES_MEDIAAGENT_CORE
DECLARE  @physicalClientTable TABLE (ClientId INTEGER, ClientName NVARCHAR(255), hasCoreMAPackageID INTEGER, hasFullMAPackageID INTEGER, releaseId INTEGER, ServicePackId INTEGER, taskXml XML, isWinUnix INTEGER)
DECLARE @adminUserId    nvarchar(50)
DECLARE @adminName      nvarchar(510)
SELECT      TOP 1 @adminUserId = CAST(id AS nvarchar(50)), @adminName = login
FROM  UMUsers WITH (READUNCOMMITTED)
WHERE ((flags & 0x40) <> 0)
DECLARE @SA_KEY_DISABLED_TRUE		INT = 1
DECLARE @SA_KEY_DISABLED_FALSE		INT = 0
DECLARE @SA_KEY_DISABLED_NOT_SET	INT = -1
DECLARE @isSADisabledSetTrue INT = @SA_KEY_DISABLED_NOT_SET
DECLARE @phyClientId			INT = 0
DECLARE @now int = dbo.getUnixTime(GETUTCDATE())
IF (@i_clientId = 0 AND LEN(@i_clientName) > 0)
BEGIN
	SELECT	@i_clientId = id
	FROM	APP_Client WITH (READUNCOMMITTED)
	WHERE	name = @i_clientName
END
IF NOT EXISTS (SELECT 1 FROM MMConfigs WITH (READUNCOMMITTED) WHERE name = 'MMCONFIG_CONFIG_STORAGE_ACCELERATOR_ENABLED' AND value = 1)
BEGIN
	GOTO PROCEXIT
END
--
-- Check if StorageAccelerator is enabled or disabled
--
IF EXISTS (SELECT PMClientId FROM APP_VMToPMMap WITH (READUNCOMMITTED) WHERE VMClientId = @i_clientId)
BEGIN
	SET @phyClientId = (SELECT attrVal FROM APP_ClientProp APPC WITH (READUNCOMMITTED) WHERE componentNameId=@i_clientId AND attrname='Active Physical Node')
END
ELSE
BEGIN
	SET @phyClientId = @i_clientId
END
SELECT @isSADisabledSetTrue = ISNULL((CASE WHEN CONVERT(NVARCHAR(10), value) = N'true' THEN 1 WHEN CONVERT(NVARCHAR(10), value) = 'false' THEN 0 END), -1)
FROM 	APP_AdvanceSettings WITH(READUNCOMMITTED)
WHERE   keyname = 'DisableStorageAccelerator'
AND     entityId = @phyClientId
AND     entityType = 3
AND     relativePath = 'CommServDB.Client'
AND	enabled = 1
AND     deleted = 0
IF @isSADisabledSetTrue = @SA_KEY_DISABLED_TRUE
BEGIN
	GOTO PROCEXIT
END
-- Check if it is cloud MP
IF NOT EXISTS (SELECT 1	FROM MMMountPath WITH (READUNCOMMITTED) WHERE LibraryId = @i_libraryId
	AND MountPathTypeId = 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/)
BEGIN
	GOTO PROCEXIT
END
INSERT INTO @physicalClientTable
SELECT  PKG.clientId, '',
MAX(CASE WHEN PKG.simPackageID IN (54, 1305) THEN 1 ELSE 0 END) coreMA,
MAX(CASE WHEN PKG.simPackageID IN (1301, 51) THEN 1 ELSE 0 END) fullMA,
		MIN(CN.releaseId),
		MIN(PKG.HighestSP), '', 0
FROM 	(
			SELECT @i_clientId clientId
			UNION ALL
			SELECT  PMClientId
			FROM	APP_VMToPMMap WITH (READUNCOMMITTED)
			WHERE	VMClientId = @i_clientId
		) AS C
		INNER JOIN App_Client CN WITH(READUNCOMMITTED) ON C.clientId = CN.id
		INNER JOIN SimInstalledPackages PKG WITH (READUNCOMMITTED) ON CN.id = PKG.clientId
--WHERE	PKG.simPackageID IN (54, 1305, 1301, 51)
-- Removing the above where because if a client does not have any core/MA package then we want to consider it and push core MA package.
GROUP BY PKG.ClientId
UPDATE @physicalClientTable
SET clientName = APPC.name,
isWinUnix = (CASE WHEN S.Type = 'Windows' THEN 54 WHEN S.Type = 'Unix' THEN 1305 END)
FROM APP_Client APPC WITH (READUNCOMMITTED)
	INNER JOIN simOperatingSystem S WITH (READUNCOMMITTED) ON APPC.simOperatingSystemId = S.id
WHERE ClientId = APPC.id
	-- Not supported config so exit.
	IF EXISTS
	(
		SELECT 	1
		FROM 	@physicalClientTable
		WHERE 	hasCoreMAPackageID = 1 AND hasFullMAPackageID = 1
				AND (releaseId < 16 OR (releaseId = 16 AND ServicePackId < 20))
	)
	BEGIN
		GOTO PROCEXIT
	END
	-- As discussed with Prasad
	-- If CORE(N) - MA(Y) - DISABLED(Y) 	--> COREMA NO	-- NO PUSH
	-- If CORE(N) - MA(N) - DISABLED(Y)		--> COREMA NO 	-- NO PUSH
	-- If CORE(Y) - MA(N) - DISABLED(Y)		--> COREMA NO	-- NO PUSH
	-- IF CORE(Y) - MA(Y) - DISABLED(Y)		--> COREMA NO	-- NO PUSH
	-- Above conditions are taken care by checking disabled Key to true in above code.
	-- Below conditions are to be taken care by below code
	-- If CORE(N) - MA(Y) - DISABLED(NA)	--> COREMA YES
	-- If CORE(N) - MA(Y) - DISABLED(N) 	--> COREMA YES
	-- IF CORE(Y) - MA(Y) - DISABLED(NA)	--> COREMA YES
	-- IF CORE(Y) - MA(Y) - DISABLED(N)		--> COREMA YES
	-- If CORE(N) - MA(N) - DISABLED(NA)	--> COREMA NO 	-- PUSH
	-- If CORE(N) - MA(N) - DISABLED(N)		--> COREMA YES 	-- PUSH
	-- If CORE(Y) - MA(N) - DISABLED(NA) 	--> COREMA YES
	-- If CORE(Y) - MA(N) - DISABLED(N)		--> COREMA YES
	-- core MA or full MA
	IF EXISTS(SELECT 1 FROM @physicalClientTable WHERE ((hasCoreMAPackageID = 1) OR (hasFullMAPackageID = 1)))
    	SET @l_coreMA = 1
	-- Check if client has access to cloud library
	IF EXISTS
	(
		SELECT 1
		FROM 	MMMountPath MP WITH (READUNCOMMITTED)
				INNER JOIN MMMountPathToStorageDevice SD WITH (READUNCOMMITTED) ON MP.MountPathId = SD.MountPathId
				INNER JOIN MMDeviceController DC WITH (READUNCOMMITTED) ON SD.DeviceId = DC.DeviceId
		WHERE 	MP.LibraryId = @i_libraryId
				AND MP.MountPathTypeId = 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
				AND DC.clientId = @i_clientId
	)
	BEGIN
		SET @o_hasAccessToLibrary = 1
	END
BEGIN TRAN TaskRequest
	IF @l_coreMA = 0 AND NOT EXISTS (SELECT 1 FROM MMEntityProp E WITH (UPDLOCK, SERIALIZABLE),
@physicalClientTable T WHERE T.clientId = E.EntityId AND E.EntityType = 18 AND E.propertyName = 'ClientStorageAcceleratorPushInstallTime'
						AND E.longlongVal > (@now - (7 * 24 * 60 * 60))) -- Attempt to install is NOT made or made 7 days or before.
	-- Check if this client is eligible for Core MA push
	AND EXISTS (SELECT c.id FROM APP_Client C WITH(NOLOCK)
				INNER JOIN APP_ClientProp acp WITH(NOLOCK) ON c.id=acp.componentNameId
				INNER JOIN @physicalClientTable T ON c.id = T.clientId
			WHERE attrName = 'Binary Set ID' and attrVal in (1, 3, 41, 40, 17, 26, 18, 42)
			)
	BEGIN
		-- Could not find coreMA criteria for package. Check if above certain SP level, if so we can push the package.
		UPDATE T
		SET taskXml = '<TMMsg_CreateTaskReq>
				  <processinginstructioninfo/>
				  <taskInfo>
				    <task>
					  <ownerId>' + CONVERT(varchar(10), @adminUserId) + '</ownerId>
					  <ownerName>' + @adminName + '</ownerName>
				      <taskName></taskName>
				      <taskFlags>
				        <disabled>false</disabled>
				      </taskFlags>
				      <taskType>IMMEDIATE</taskType>
				      <initiatedFrom>COMMANDLINE</initiatedFrom>
				    </task>
				    <associations>
					  <clientId>' + CONVERT(varchar(10), T.ClientId) + '</clientId>
				      <clientName>' + T.clientName + '</clientName>
				    </associations>
				    <subTasks>
				      <subTask>
				        <subTaskType>ADMIN</subTaskType>
				        <operationType>INSTALL_CLIENT</operationType>
				      </subTask>
				      <options>
				        <adminOpts>
				          <updateOption/>
				          <clientInstallOption>
				            <clientDetails>
				              <clientEntity>
								<clientId>' + CONVERT(varchar(10), T.ClientId) + '</clientId>
	        			        <clientName>' + T.clientName + '</clientName>
				              </clientEntity>
				            </clientDetails>
			            <installerOption>
			              <RemoteClient>false</RemoteClient>
			              <requestType>PRE_DECLARE_CLIENT</requestType>
			              <Operationtype>INSTALL_CLIENT</Operationtype>
			              <clientComposition>
	                		<overrideSoftwareCache>false</overrideSoftwareCache>
               				<clientInfo>
                  				<client>
                    				<jobResulsDir>
                      					<path></path>
                    				</jobResulsDir>
                    				<cvdPort>0</cvdPort>
                  				</client>
                  				<clientProps/>
                			</clientInfo>
			                <components>
	                		  <componentInfo>
								<ComponentId>' + CONVERT(varchar(10), T.IsWinUnix) + '</ComponentId>
			                    <ComponentName>MediaAgent Core</ComponentName>
	                		    <consumeLicense>true</consumeLicense>
			                    <clientSidePackage>true</clientSidePackage>
	                		  </componentInfo>
			                </components>
	                		<packageDeliveryOption>CopyPackage</packageDeliveryOption>
			                <clientRoles>
	                		  <bLaptopBackup>false</bLaptopBackup>
			                  <bNetworkProxy>false</bNetworkProxy>
	                		</clientRoles>
			              </clientComposition>
			              <installFlags>
	                		<allowMultipleInstances>false</allowMultipleInstances>
			                <disableOSFirewall>false</disableOSFirewall>
			                <forceReboot>false</forceReboot>
	                		<stopOracleServices>false</stopOracleServices>
			                <overrideClientInfo>true</overrideClientInfo>
	                		<skipConfigureLaptopBackupMonitor>false</skipConfigureLaptopBackupMonitor>
			                <skipConfigureProcessManager>false</skipConfigureProcessManager>
	                		<skipConfigureMigrationAssistant>false</skipConfigureMigrationAssistant>
			                <autoInstallPassiveNodes>false</autoInstallPassiveNodes>
	                		<autoRebootPassiveNodes>false</autoRebootPassiveNodes>
			                <hideApps>false</hideApps>
			              </installFlags>
			            </installerOption>
			          </clientInstallOption>
		        	</adminOpts>
	        	<commonOpts>
		          <notifyUserOnJobCompletion>false</notifyUserOnJobCompletion>
	        	</commonOpts>
		      </options>
		      <subTaskOperation>OVERWRITE</subTaskOperation>
		    </subTasks>
		  </taskInfo>
		</TMMsg_CreateTaskReq>'
		FROM @physicalClientTable T
		WHERE hasCoreMAPackageID = 0
		AND (releaseId > 16) OR (releaseId = 16 AND ServicePackId >= 20)
		INSERT INTO TM_CreateTaskRequest
		SELECT taskXml, 1, '', 0, 1, 0, dbo.getUnixTime(GETUTCDATE())
		FROM @physicalClientTable T
		WHERE taskXml IS NOT NULL
		-- Update reattempt time
		UPDATE E
		SET longlongVal = @now,
		modified = @now
		FROM MMEntityProp E, @physicalClientTable T
		WHERE E.EntityId = T.clientId
AND E.EntityType = 18
AND E.propertyName = 'ClientStorageAcceleratorPushInstallTime'
AND E.propDataType = 1
		-- Create record for not found entries
		INSERT  INTO MMEntityProp (EntityId, EntityType, propertyName, propDataType, intVal, longlongVal, stringVal, created, modified, CommCellId)
SELECT T.clientId, 18, 'ClientStorageAcceleratorPushInstallTime', 1, 0, @now, '', @now, @now, 2
		FROM @physicalClientTable T
LEFT OUTER JOIN MMEntityProp ME WITH (READUNCOMMITTED) ON T.clientId = ME.EntityId AND ME.EntityType = 18
AND ME.propertyName = 'ClientStorageAcceleratorPushInstallTime' AND ME.propDataType = 1
		WHERE taskXml IS NOT NULL
		AND ME.EntityId IS NULL
	END
COMMIT TRAN TaskRequest
PROCEXIT:
SELECT @l_coreMA, @o_hasAccessToLibrary
GO

IF EXISTS (select * from GxQscripts where name = 'archCheckCoreMA')
	delete from GxQscripts where name = 'archCheckCoreMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCheckCoreMA')
	delete from GXDBVersions where aliasname = 'archCheckCoreMA'
GO

insert into GXDBVersions values(2, 'archCheckCoreMA',  'v1.1.2.13.4.1', 'archCheckCoreMA', 'v1.1.2.13.4.1')
GO

