

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archCheckCopyTypeConvAllowed.sp] ---------- 

  -- ----------------------------------------------------------------------
  --
 --           Copyright (c) 1998  CommVault Systems, Inc.
 --                  All rights reserved.
 --
 --
 --        This is unpublished proprietary source code of CommVault
 --        Systems, Inc. The copyright notice above does not evidence
 --        any actual or intended publication of such source code.
 -- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archCheckCopyTypeConvAllowed <<<'

IF EXISTS (select * from sysobjects where name='archCheckCopyTypeConvAllowed')
	drop procedure archCheckCopyTypeConvAllowed
IF EXISTS (select * from GxQscripts where name='archCheckCopyTypeConvAllowed')
	delete from GxQscripts where name = 'archCheckCopyTypeConvAllowed'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCheckCopyTypeConvAllowed')
	delete from GXDBVersions where aliasname = 'archCheckCopyTypeConvAllowed'
GO
print '... Creating Procedure: archCheckCopyTypeConvAllowed'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archCheckCopyTypeConvAllowed
-- SP Input Params
  @i_StoragePolicyId INTEGER,
  @i_StoragePolicyCopyId INTEGER,
  @i_ToSPCType INTEGER
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_errorCode integer
  DECLARE @o_errorMessage NVARCHAR(1024)
SET NOCOUNT ON
DECLARE @errorCode INTEGER
DECLARE @ErrorMessage NVARCHAR(MAX) = N''
DECLARE @l_defaultSPCId INTEGER
DECLARE @l_sourceSPCId INTEGER
DECLARE @l_SPCType INTEGER
DECLARE @l_SPFlag	INTEGER
DECLARE @l_StoragePolicyName NVARCHAR(512)
DECLARE @l_StoragePolicyCopyName NVARCHAR(256)
DECLARE @l_SourceCopyName NVARCHAR(256)
DECLARE @l_SourceCopyType INTEGER
SET		@errorCode = 0
SET		@l_defaultSPCId = -1
SET		@l_sourceSPCId = -1
SET		@l_SPCType = -1
SET		@l_SPFlag = -1
SET     @l_SourceCopyType = -1
DECLARE @l_IsSnapCopy INTEGER = -1
DECLARE @l_defaultSnapPrimaryCopyId INTEGER = -1
DECLARE @l_isMirrorCopy INTEGER = -1
SELECT @l_StoragePolicyName = name, @l_defaultSPCId = defaultCopy, @l_SPFlag = flags,  @l_defaultSnapPrimaryCopyId = defaultSnapCopy
FROM archGroup WITH (NOLOCK)
WHERE id  = @i_StoragePolicyId
SELECT	@errorCode = @@ERROR, @ErrorMessage = ERROR_MESSAGE()
IF	@errorCode <> 0
	GOTO CX_EXIT
SELECT @l_StoragePolicyCopyName = name, @l_SPCType = type, @l_sourceSPCId = sourceCopyId, @l_IsSnapCopy = isSnapCopy
FROM archGroupCopy WITH (NOLOCK)
WHERE	id = @i_StoragePolicyCopyId
Select @l_SourceCopyName = name ,@l_SourceCopyType=type FROM archGroupCopy WITH (NOLOCK) where  id = @l_sourceSPCId
SELECT	@errorCode = @@ERROR, @ErrorMessage = ERROR_MESSAGE()
IF	@errorCode <> 0
	GOTO CX_EXIT
IF @i_StoragePolicyCopyId = @l_defaultSPCId
BEGIN
	SET	@errorCode = -1
	GOTO CX_EXIT
END
IF (@l_sourceSPCId = 0)
	SET	@l_sourceSPCId = @l_defaultSPCId
IF @l_SPFlag & 256 <> 0
BEGIN
	SET @errorCode = -2
	GOTO CX_EXIT
END
IF  ( (@l_IsSnapCopy = 1) AND ((@i_StoragePolicyCopyId=@l_defaultSnapPrimaryCopyId) OR (@l_isMirrorCopy>0)))
BEGIN
	SET	@errorCode = -3
	GOTO CX_EXIT
END
if ((@l_SPCType = 2) and  (@i_ToSPCType = 1) and (@l_SourceCopyType = 2))
BEGIN
 if EXISTS (SELECT id from archgroupcopy where sourceCopyid = @l_sourceSPCId)
 BEGIN
    SET	@errorCode = -8
	GOTO CX_EXIT
 END
END
IF (@i_ToSPCType = 2)
BEGIN
	IF @l_SPCType != 1
	BEGIN
		SET	@errorCode = -4
		GOTO CX_EXIT
	END
	-- Check whether source copy is spool copy, if yes the check whether there is at least one active synchronous copy exists
	IF EXISTS (SELECT * FROM archAgingRule WHERE copyId = @l_sourceSPCId AND	retentionDays = 0 AND fullCycles = 0)
	BEGIN
		DECLARE @tblDestCopyForSource TABLE (copyId INT, sourceCopyId INT, defaultCopyId INT, archGroupId INT, flags INT, dedupeFlags INT, maxMultiplex INT, isSnapCopy INT, isMirrorCopy INT)
		INSERT INTO @tblDestCopyForSource
		EXEC ArchDestinationCopyList @l_sourceSPCId
		IF (@l_IsSnapCopy <> 1 AND NOT EXISTS (
													SELECT * FROM @tblDestCopyForSource T, archGroupCopy
													WHERE T.copyId = id AND type = 1 AND isActive = 1 AND T.copyId <> @i_StoragePolicyCopyId AND T.sourceCopyId = @l_sourceSPCId
											  )
											  )
		OR (@l_IsSnapCopy =  1 AND NOT EXISTS (
													SELECT * FROM @tblDestCopyForSource T, archGroupCopy AGC
													WHERE T.copyId = AGC.id AND AGC.type = 1 AND AGC.isActive = 1 AND T.copyId <> @i_StoragePolicyCopyId AND T.sourceCopyId = @l_sourceSPCId AND AGC.isMirrorCopy = 0 AND AGC.isSnapCopy = 1
											  )
							   AND NOT EXISTS (
													SELECT * FROM archMaterializeSnapshotProp
													WHERE enabled = 1 AND type = 0 AND archGroupId = @i_StoragePolicyId AND ( CASE WHEN sourceCopyId = 0 THEN @l_defaultSnapPrimaryCopyId ELSE sourceCopyId END) = @l_sourceSPCId
											  )
			)
		BEGIN
			SET	@errorCode = -5
			GOTO CX_EXIT
		END
	END
	-- Check whether is any synchronous destination copy exists
	BEGIN
		DECLARE @tblDestCopy TABLE (copyId INT, sourceCopyId INT, defaultCopyId INT, archGroupId INT, flags INT, dedupeFlags INT, maxMultiplex INT, isSnapCopy INT, isMirrorCopy INT)
		INSERT INTO @tblDestCopy
		EXEC ArchDestinationCopyList @i_StoragePolicyCopyId
		IF (EXISTS (SELECT * FROM @tblDestCopy T, archGroupCopy WHERE T.copyId = id AND type = 1 AND T.sourceCopyId = @i_StoragePolicyCopyId AND (T.isSnapCopy = 0 OR (T.isSnapCopy = 1 AND T.isMirrorCopy = 0))))
		BEGIN
			SET	@errorCode = -6
			GOTO CX_EXIT
		END
	END
END
ELSE
BEGIN
	IF @l_SPCType != 2
	BEGIN
		SET	@errorCode = -7
		GOTO CX_EXIT
	END
END
CX_EXIT:
	IF @errorCode = -1
		SET @ErrorMessage = 'Error: Storage Policy [' + @l_StoragePolicyName + '] Storage Policy Copy [' + @l_StoragePolicyCopyName + '] is a Primary Copy'
	ELSE IF @errorCode = -2
		SET @ErrorMessage = 'Error: Storage Policy [' + @l_StoragePolicyName + '] is a Global Deduplication Storage Policy'
	ELSE IF @errorCode = -3
		SET @ErrorMessage = 'Error: Storage Policy [' + @l_StoragePolicyName + '] Storage Policy Copy [' + @l_StoragePolicyCopyName + '] is a Snap Copy'
	ELSE IF @errorCode = -4
		SET @ErrorMessage = 'Error: Storage Policy [' + @l_StoragePolicyName + '] Storage Policy Copy [' + @l_StoragePolicyCopyName + '] is not a Synchronous Copy'
	ELSE IF @errorCode = -5
		SET @ErrorMessage = 'Error: Source copy is a spool copy and needs at least one active Synchronous Copy'
	ELSE IF @errorCode = -6
		SET @ErrorMessage = 'Error: Storage Policy [' + @l_StoragePolicyName + '] Storage Policy Copy [' + @l_StoragePolicyCopyName + '] is source to at least one Synchronous Copy'
	ELSE IF @errorCode = -7
		SET @ErrorMessage = 'Error: Storage Policy [' + @l_StoragePolicyName + '] Storage Policy Copy [' + @l_StoragePolicyCopyName + '] is not a Selective Copy'
    ELSE IF @errorCode = -8
	    SET @ErrorMessage = 'Error: Cannot convert Storage Policy [' + @l_StoragePolicyName + '] Storage Policy Copy [' + @l_StoragePolicyCopyName + '] to Synchronous copy as the source copy[' + @l_SourceCopyName+ '] is Selective'
	SELECT	@errorCode, @ErrorMessage
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'archCheckCopyTypeConvAllowed')
	delete from GxQscripts where name = 'archCheckCopyTypeConvAllowed'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCheckCopyTypeConvAllowed')
	delete from GXDBVersions where aliasname = 'archCheckCopyTypeConvAllowed'
GO

insert into GXDBVersions values(2, 'archCheckCopyTypeConvAllowed',  '00000000000000000000', 'archCheckCopyTypeConvAllowed', '00000000000000000000')
GO

