

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archCheckConflictingAnalyticsJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archCheckConflictingAnalyticsJob.sp,v $ $Id: archCheckConflictingAnalyticsJob.sp,v 1.1.2.12 2020/12/04 20:27:06 bzhu Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archCheckConflictingAnalyticsJob')
BEGIN
	print '>>> Drop Stored Procedure: archCheckConflictingAnalyticsJob <<<'
	drop procedure archCheckConflictingAnalyticsJob
END
IF EXISTS (select * from GxQscripts where name='archCheckConflictingAnalyticsJob')
	delete from GxQscripts where name = 'archCheckConflictingAnalyticsJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCheckConflictingAnalyticsJob')
	delete from GXDBVersions where aliasname = 'archCheckConflictingAnalyticsJob'
GO
print '... Creating Procedure: archCheckConflictingAnalyticsJob'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archCheckConflictingAnalyticsJob
  @i_jobId BIGINT
AS
  DECLARE @o_retVal integer;
SET @o_retVal =0
--GET IDAAGENT
declare @idaTypeValue int = null
SELECT @idaTypeValue = dbo.GetJobOption(@i_jobId, 900055445)
DECLARE @clientGroupID INT = 0
DECLARE @subClientID INT = 0
DECLARE @dataSourceID INT = 0
DECLARE @onlineCrawlJob INT = 0
SELECT @clientGroupID = CASE optionId WHEN 1152211801 THEN value ELSE @clientGroupID END,
@subClientID = CASE optionId WHEN 38201114 THEN value ELSE @subClientID END,
@dataSourceID = CASE optionId WHEN 608389867 THEN value ELSE @dataSourceID END,
@onlineCrawlJob = CASE optionId WHEN 136250708 THEN value ELSE @onlineCrawlJob END
	FROM dbo.GetAllJobOptions(@i_jobId)
WHERE optionId IN (38201114, 1152211801, 608389867, 136250708 )
declare @iDATypes table
(
	typeId int PRIMARY KEY
)
--support for NAS agent
DECLARE @agentType INT = dbo.GetJobOption(@i_jobId, 140004)
IF @agentType = 13
	insert into @iDATypes(typeId)
VALUES (13)
else
begin
	-- Exchange Email Data
	if (@idaTypeValue = 0 or @idaTypeValue = 2)
	begin
		insert into @iDATypes(typeId)
		select distinct i.type from APP_AppTypeGroupAssoc a inner join APP_AppTypeGroup g on g.appTypeGroupId = a.appGroupId
		inner join APP_iDAType i on i.type = a.appTypeId
		where g.groupName in ('APPGRP_ExchangeMailboxArchiver', 'APPGRP_ExchangeComplainceArchiver', 'APPGRP_ExchangeMailbox', 'APPGRP_MS_EXCHANGE','APPGRP_XchangeDB')
	end
	-- File System Data
	if (@idaTypeValue = 1 or @idaTypeValue = 2)
	begin
		insert into @iDATypes(typeId)
		select distinct i.type from APP_AppTypeGroupAssoc a inner join APP_AppTypeGroup g on g.appTypeGroupId = a.appGroupId
		inner join APP_iDAType i on i.type = a.appTypeId
		where g.groupName in ('APPGRP_FileSystemLikeIDA')
		and ( i.ccpType in (33 /*CV_APPTYPE_WINDOWS_FILESYSTEM*/, 58 /*CV_APPTYPE_MS_FILE_ARCHIVER*/, 63 /*CV_APPTYPE_APPLEMAC_FS*/)
		or i.type = 63 )
	end
end
IF @clientGroupID > 0
--CLIENT GROUP LEVEL
--Allow to run analytics job if there exists at least one row for the given jobid
BEGIN
IF NOT EXISTS (SELECT  1 FROM JMJobInfo WHERE opType = 53 and subOpType = 112 AND dbo.GetJobOption(jobId, 1152211801) = @clientGroupID
AND dbo.GetJobOption(jobId, 900055445) = @idaTypeValue)
		SET @o_retVal = 1
END
ELSE
BEGIN
	-- allow only one job to run at subclient level for online crawl job
IF @subClientID > 0 AND EXISTS (SELECT  1 FROM JMJobInfo WHERE (opType = 53) AND (subOpType = 130 OR subOpType = 143) AND (jobId <> @i_jobId) AND (dbo.GetJobOption(jobId, 38201114) = @subClientID)
AND (dbo.GetJobOption(jobId, 900055445) = @idaTypeValue))
	BEGIN
		SET @o_retVal = 0
	END
	-- allow only one job to run at data source level
	ELSE IF @dataSourceID > 0 AND EXISTS (SELECT  1 FROM JMAdminJobInfoTable WHERE opType IN (113 /*SUBCLIENTCONTENTINDEX*/, 112 /*DATA_ANALYTICS2*/, 130 /*ONLINE_CRAWL*/, 53 /*OFFLINECONTENTINDEX*/, 143 /*SOLR_INDEX_IMPORT*/)
		AND jobId <> @i_jobId AND LibraryID = @dataSourceID
AND dbo.GetJobOption(jobId, 900055445) = @idaTypeValue)
	BEGIN
		SET @o_retVal = 0
	END
	ELSE IF @onlineCrawlJob = 1  -- allow multiple jobs for online crawl job for same client
	BEGIN
		SET @o_retVal = 1
	END
	ELSE
	BEGIN
		IF object_id('tempdb.dbo.#tmpFLAClients') is not null DROP TABLE #tmpFLAClients
		CREATE TABLE #tmpFLAClients (clientId INT)
		INSERT INTO #tmpFLAClients (clientId)
		SELECT T.ref.value('@clientId', 'int')
			FROM TM_JobXMLOptions C WITH (NOLOCK)
			CROSS APPLY C.xmlValue.nodes('/TMMsg_JobOption/adminOpts/contentIndexingOption/clients') T(ref)
			where jobId =@i_jobId
		IF NOT EXISTS (SELECT 1 FROM ArchFLAIndexingRunning F INNER JOIN #tmpFLAClients T ON F.clientId = T.clientId AND appType IN (SELECT typeId FROM @iDATypes) AND adminjobId <> @i_jobId)
			SET @o_retVal = 1
		IF object_id('tempdb.dbo.#tmpFLAClients') is not null DROP TABLE #tmpFLAClients
	END
END
SELECT @o_retVal
GO

IF EXISTS (select * from GxQscripts where name = 'archCheckConflictingAnalyticsJob')
	delete from GxQscripts where name = 'archCheckConflictingAnalyticsJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCheckConflictingAnalyticsJob')
	delete from GXDBVersions where aliasname = 'archCheckConflictingAnalyticsJob'
GO

insert into GXDBVersions values(2, 'archCheckConflictingAnalyticsJob',  '00010001000200120000', 'archCheckConflictingAnalyticsJob', '00010001000200120000')
GO

