

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archCanDeletePolicyOrCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archCanDeletePolicyOrCopy.sp,v $ $Id: archCanDeletePolicyOrCopy.sp,v 1.39.2.38 2020/05/10 01:16:17 pveeravalli Exp $";
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archCanDeletePolicyOrCopy')
BEGIN
	print '>>> Drop Stored Procedure: archCanDeletePolicyOrCopy <<<'
	drop procedure archCanDeletePolicyOrCopy
END
IF EXISTS (select * from GxQscripts where name='archCanDeletePolicyOrCopy')
	delete from GxQscripts where name = 'archCanDeletePolicyOrCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCanDeletePolicyOrCopy')
	delete from GXDBVersions where aliasname = 'archCanDeletePolicyOrCopy'
GO
print '... Creating Procedure: archCanDeletePolicyOrCopy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archCanDeletePolicyOrCopy
  @i_archGroupId INTEGER,
  @i_copyId INTEGER
AS
  DECLARE @amErrorCode INTEGER;
  DECLARE @policyType INTEGER;
  DECLARE @hasEZBackupSet INTEGER;
  DECLARE @jobIdList VARCHAR(max);
  DECLARE @criticalJobIdList VARCHAR(max);
  DECLARE @reserveXML XML;
--jobIdList- list of jobs which can be killed
--criticalJobIdList -- list of jobs which are critical and cannot be killed as part of SP/copy deletion
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
/**********************************************/
/* Initialize and declare temparary variables */
/**********************************************/
SET	@amErrorCode	= 0
SET @policyType		= 0
SET @hasEZBackupSet	= 0
SET @jobIdList		= ''
DECLARE @xmlText XML = NULL
/***************************/
/* Create temparary tables */
/***************************/
CREATE	TABLE #copyIdList (
		copyId INT,
		flags INT,
		siloAppId INT,
		siloBackupsetId INT
)
CREATE	TABLE #adminJobList (
		jobId INT, opType INT
)
CREATE	TABLE #latestFilterAF (
		archFileId	INT,
		commCellId	INT,
		archGroupId	INT,
		appId		INT,
		cTime		INT
)
if object_id('tempdb.dbo.#ReqDDBBackupJobs') is not null DROP TABLE #ReqDDBBackupJobs
CREATE	TABLE #ReqDDBBackupJobs (
		SIDBStoreId			INTEGER,
		SubStoreId			INTEGER,
		commCellId			INTEGER,
		JobId				INTEGER,
		JobCommCellId		INTEGER,
		AppId				INTEGER
		)
if object_id('tempdb.dbo.#tempRunningKillableJobs') is not null DROP TABLE #tempRunningKillableJobs
CREATE	TABLE #tempRunningKillableJobs (JobId INTEGER)
if object_id('tempdb.dbo.#tempRunningCriticalJobs') is not null DROP TABLE #tempRunningCriticalJobs
CREATE	TABLE #tempRunningCriticalJobs (JobId INTEGER)
CREATE INDEX Idx_ReqDDBBackupJobs_1 ON #ReqDDBBackupJobs (SIDBStoreId, SubStoreId, CommCellId)
CREATE INDEX Idx_ReqDDBBackupJobs_2 ON #ReqDDBBackupJobs (JobId, JobCommCellId)
DECLARE	@l_defCopyId		INTEGER
DECLARE	@l_defSnapCopyId	INTEGER
DECLARE	@l_archGroupFalgs	INTEGER
SET		@l_defCopyId		= 0
SET		@l_defSnapCopyId	= 0
SET		@l_archGroupFalgs	= 0
DECLARE @isInlineCopy INT = 0
DECLARE	@RetainDDBBkpsOfSealedStores	INTEGER
SET	@RetainDDBBkpsOfSealedStores	= 0
SELECT @RetainDDBBkpsOfSealedStores = isnull(value, 0)
FROM mmconfigs
WHERE name = 'DA_CONFIG_RETAIN_DDB_BACKUPS_OF_SEALED_STORES'
IF	@i_copyId > 0
BEGIN
	DECLARE	@l_siloAppId	INTEGER = 0
	DECLARE	@l_copyType		INTEGER = 0
	DECLARE	@l_copyFlags	INTEGER = 0
	DECLARE	@l_srcCopyId	INTEGER = 0
	DECLARE	@l_isSnapCopy	INTEGER = 0
	DECLARE	@l_isMirrorCopy	INTEGER = 0
	DECLARE @l_copyExtendedFlags INTEGER = 0
	SELECT	@i_archGroupId = archGroupId, @l_siloAppId = siloAppId, @l_copyFlags = flags, @l_copyType = type,
			@l_isSnapCopy = isSnapCopy, @l_isMirrorCopy = isMirrorCopy, @l_srcCopyId = sourceCopyId, @l_copyExtendedFlags = extendedFlags
	FROM	archGroupCopy WITH (NOLOCK) WHERE id = @i_copyId
	SELECT @l_defCopyId = defaultCopy, @l_defSnapCopyId = defaultSnapCopy, @policyType = type, @l_archGroupFalgs = flags
	FROM	archGroup WITH (NOLOCK) WHERE id = @i_archGroupId
	IF	@l_defCopyId = @i_copyId
	BEGIN
SET	@amErrorCode = 16
		GOTO CX_ERROR_EXIT
	END
	ELSE
	IF	@l_defSnapCopyId = @i_copyId
		AND EXISTS (SELECT * FROM archGroupCopy WITH (NOLOCK) WHERE archGroupId = @i_archGroupId AND id <> @i_copyId AND isSnapCopy = 1)
	BEGIN
SET	@amErrorCode = 82
		GOTO CX_ERROR_EXIT
	END
IF @l_copyFlags & 1024 > 0
		SET @isInlineCopy = 1
	IF	@l_defSnapCopyId = @i_copyId
	BEGIN
		--kill all snap jobs, if default snap copy is being deleted
		INSERT INTO #tempRunningKillableJobs
			SELECT A.JobId
			FROM JMBkpJobInfo A WITH (NOLOCK), JMJobInfo B WITH (NOLOCK)
			WHERE A.JobId = B.JobId AND A.CommCellId = B.CommCellId
				AND (A.currentPolicy = @i_archGroupId OR A.dataPolicy = @i_archGroupId OR A.logPolicy = @i_archGroupId)
				AND B.OpType in (59, 60)
	END
	IF	@l_isSnapCopy = 1 AND @i_copyId <> @l_defSnapCopyId
	AND EXISTS (SELECT * FROM archMaterializeSnapshotProp WITH (NOLOCK)
				WHERE archGroupId = @i_archGroupId AND enabled = 1 AND sourceCopyId = @i_copyId)
	BEGIN
SET	@amErrorCode = 102
		GOTO CX_ERROR_EXIT
	END
	IF	@l_isSnapCopy = 1 AND @i_copyId <> @l_defSnapCopyId
	AND EXISTS (SELECT * FROM archDeferredCatalogProp WITH (NOLOCK)
				WHERE archGroupId = @i_archGroupId AND enabled = 1 AND sourceCopyId = @i_copyId)
	BEGIN
SET	@amErrorCode = 146
		GOTO CX_ERROR_EXIT
	END
IF	@l_copyType = 1 AND @l_isSnapCopy = 1 AND @l_isMirrorCopy = 0 AND @i_copyId <> @l_defSnapCopyId
	AND EXISTS (SELECT * FROM archAgingRule WHERE copyId = @l_defSnapCopyId AND retentionDays = 0 AND fullCycles = 0)
AND NOT EXISTS (SELECT * FROM archMaterializeSnapshotProp WHERE archGroupId = @i_archGroupId AND enabled = 1 AND type = 0 AND (sourceCopyId = 0 OR sourceCopyId = @l_defSnapCopyId))
	AND NOT EXISTS (SELECT * FROM archGroupCopy WITH (NOLOCK) WHERE archGroupId = @i_archGroupId AND isActive = 1
AND type = 1 AND isSnapCopy = 1 AND isMirrorCopy = 0 AND id NOT IN (@i_copyId, @l_defSnapCopyId))
	BEGIN
SET	@amErrorCode = 103
		GOTO CX_ERROR_EXIT
	END
IF	@l_copyType = 1 AND @l_isSnapCopy = 0 AND @i_copyId <> @l_defCopyId
	AND EXISTS (SELECT * FROM archAgingRule WHERE copyId = @l_defCopyId AND retentionDays = 0 AND fullCycles = 0)
	AND NOT EXISTS (SELECT * FROM archGroupCopy WITH (NOLOCK) WHERE archGroupId = @i_archGroupId AND isActive = 1
AND type = 1 AND isSnapCopy = 0 AND id NOT IN (@i_copyId, @l_defCopyId))
	BEGIN
SET	@amErrorCode = 103
		GOTO CX_ERROR_EXIT
	END
IF	(@l_copyFlags & 16777216) <> 0
	BEGIN
		IF	EXISTS (SELECT * FROM archFileCopy WITH (NOLOCK) WHERE archCopyId = @i_copyId and (flags & 256) = 0)
		BEGIN
SET	@amErrorCode = 92
			GOTO CX_ERROR_EXIT
		END
	END
IF	(@l_copyFlags & 524288) <> 0 AND @l_srcCopyId > 0
	BEGIN
		IF	EXISTS (SELECT * FROM archGroupCopy WITH (NOLOCK) WHERE id = @l_srcCopyId)
		BEGIN
SET	@amErrorCode = 99
			GOTO CX_ERROR_EXIT
		END
	END
	IF	EXISTS (SELECT * FROM archGroupCopy WITH (NOLOCK) WHERE archGroupId = @i_archGroupId AND sourceCopyId = @i_copyId
AND type <> 5 AND (flags & 524288) = 0)
	BEGIN
SET	@amErrorCode = 17
		GOTO CX_ERROR_EXIT
	END
	IF	EXISTS (SELECT * FROM archContentIndexingRules WITH (NOLOCK) WHERE archGroupId = @i_archGroupId AND sourceCopyId = @i_copyId
				AND enabled = 1)
	BEGIN
SET	@amErrorCode = 138
		GOTO CX_ERROR_EXIT
	END
	-- When trying to delete the default Replica/Vault copy or the Default Mirror copy, fail the delete request.
IF @l_isSnapCopy = 1 AND (@l_copyExtendedFlags & 524288) > 0
	BEGIN
	IF	EXISTS (	SELECT	1
						FROM	archGroupCopy WITH (READUNCOMMITTED)
						WHERE	archGroupId = @i_archGroupId
								AND isSnapCopy = 1 AND isMirrorCopy = @l_isMirrorCopy
								AND sourceCopyId > 0
								AND id <> @i_copyId
								AND sourceCopyId = @l_defSnapCopyId)
	BEGIN
			IF @l_isMirrorCopy = 1
SET	@amErrorCode = 213
			ELSE
SET	@amErrorCode = 212
		GOTO CX_ERROR_EXIT
		END
	END
	INSERT	INTO #copyIdList
	SELECT	@i_copyId, @l_copyFlags, @l_siloAppId, 0
	-----Check if valid DDB backup job exists on this copy.
	--IF EXISTS (SELECT 1 FROM MMConfigs WITH (READUNCOMMITTED) WHERE name = 'MMCONFIG_DEDUP_DDB_SUBCLIENT_TO_SEC_COPY' AND value > 0)
	-- Removing the above check due to the following scenario
	-- 1. Backup DDB to primary copy
	-- 2. Promote secondary copy to become primary
	-- 3. Attempt to delete the old primary will skip the below checks and valid DDB backups may get pruned.
	BEGIN
		--Get all DDB Backup jobs which are pointing to this copy (being deleted)
		INSERT INTO #ReqDDBBackupJobs
			SELECT DISTINCT SS.SIDBStoreId, SS.SubStoreId, SS.commCellId, SS.LastSnapJobId, ISNULL(C.id, SS.commCellId), J.AppId
			FROM IdxSIDBSubStore SS WITH (NOLOCK)
				INNER JOIN IdxSIDBStore S WITH (NOLOCK) ON 	SS.SIDBStoreId = S.SIDBStoreId AND	SS.commCellId = S.commCellId
				INNER JOIN JMJobDataStats J WITH (NOLOCK) ON J.JobId = SS.LastSnapJobId AND J.commCellId = SS.commCellId
				LEFT OUTER JOIN APP_CommCell C WITH (NOLOCK) ON RTRIM(LTRIM(SS.DDBBackupCSGUID)) = RTRIM(LTRIM(C.csGUID))
			WHERE	SS.LastSnapJobId > 0
				AND	(S.flags & 256) = 0
				AND	(@RetainDDBBkpsOfSealedStores = 1 OR (@RetainDDBBkpsOfSealedStores = 0 AND S.SealedTime = 0))
				AND J.status = 100
				AND J.archGrpId = @i_archGroupId
				AND J.archGrpCopyId = @i_copyId
		--Get all the old DDB backups which are pointing to this policy (being deleted)
		INSERT INTO #ReqDDBBackupJobs
			SELECT DISTINCT SS.SIDBStoreId, SS.SubStoreId, SS.commCellId, SS.LastSnapJobId, ISNULL(C.id, SS.commCellId), J.AppId
			FROM IdxSIDBSubStoreBackupInfo SS WITH (NOLOCK)
				INNER JOIN IdxSIDBStore S WITH (NOLOCK) ON 	SS.SIDBStoreId = S.SIDBStoreId AND	SS.commCellId = S.commCellId
				INNER JOIN JMJobDataStats J WITH (NOLOCK) ON J.JobId = SS.LastSnapJobId	AND J.commCellId = SS.commCellId
				LEFT OUTER JOIN APP_CommCell C WITH (NOLOCK) ON RTRIM(LTRIM(SS.DDBBackupCSGUID)) = RTRIM(LTRIM(C.csGUID))
			WHERE	SS.LastSnapJobId > 0
				AND	(S.flags & 256) = 0
				AND	(@RetainDDBBkpsOfSealedStores = 1 OR (@RetainDDBBkpsOfSealedStores = 0 AND S.SealedTime = 0))
				AND J.status = 100
				AND J.archGrpId = @i_archGroupId
				AND J.archGrpCopyId = @i_copyId
		-- Check if these jobs are available on any other copy. If so then this copy is OK to delete.
		DELETE T
		FROM #ReqDDBBackupJobs T
			LEFT OUTER JOIN JMJobDataStats J WITH (READUNCOMMITTED) ON T.JobId = J.jobId AND T.JobCommCellId = J.commCellId
		WHERE J.status = 100
			AND J.archGrpId = @i_archGroupId
			AND J.archGrpCopyId <> @i_copyId
		-- filter out DDB Bkp jobs for its own store.
		IF EXISTS (SELECT * FROM #ReqDDBBackupJobs T, archCopySIDBStore ACS WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
			   WHERE T.SIDBStoreId = ACS.SIDBStoreId
			   AND T.commCellId = ACS.commCellId
			   AND ACS.copyId = AGC.id
			   AND AGC.archGroupId <> @i_archGroupId
			   --filter out GDSP Primary copies so that they do not interfere in decision to delete the StoragePolicy/Copy
AND AGC.dedupeFlags & 268435456 = 0
			   AND AGC.id <> @i_copyId
			)
		BEGIN
			SET @xmlText  =	(	SELECT (
									SELECT  DISTINCT A.ID AS '@subclientId',
										C.name AS '@clientName',
										IDA.displayName as '@appName',
										I.name AS '@instanceName',
										BS.name AS '@backupsetName',
										A.subclientName AS '@subclientName',
										A.appTypeId AS '@applicationId'
									FROM #ReqDDBBackupJobs T
										INNER JOIN archCopySIDBStore ACS WITH (NOLOCK) ON ACS.SIDBStoreId = T.SIDBStoreId AND ACS.commCellId = T.commCellId
										INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON AGC.id = ACS.copyId
										INNER JOIN APP_Application A WITH(NOLOCK) ON A.id = T.appId
										INNER JOIN APP_Client C WITH(NOLOCK) ON C.id = A.clientId
										INNER JOIN APP_BackupSetName BS WITH(NOLOCK) ON BS.id = A.backupSet
										INNER JOIN APP_iDAType IDA WITH(NOLOCK) ON IDA.type = A.appTypeId
										INNER JOIN APP_InstanceName I WITH(NOLOCK) ON I.id = A.instance
									WHERE AGC.archGroupId <> @i_archGroupId
AND AGC.dedupeFlags & 268435456 = 0 --filter out GDSP Primary copies so that they do not interfere in decision to delete the StoragePolicy/Copy
										AND AGC.id <> @i_copyId
									FOR XML PATH('entity'), TYPE
								)
								FOR XML PATH('Associations'), TYPE
							)
SET @amErrorCode = 110
			GOTO CX_ERROR_EXIT
		END
	END
	-------------------Fix End
	--If any auxcopy is running and copy to be deleted is source copy, then prevent deletion of such copy
	INSERT INTO #tempRunningCriticalJobs
		SELECT 	jobId
		FROM 	JMAdminJobInfoTable WITH(READUNCOMMITTED)
		WHERE	archGrpID = @i_archGroupId
			AND
			(
				CASE
					WHEN opType =  13 /*AUXCOPY*/
						THEN (CASE WHEN EXISTS(SELECT 1 FROM archChunkToCopy WITH(NOLOCK) WHERE adminJobId = JMAdminJobInfoTable.jobId
							AND archCopyId = @i_copyId) THEN 1 ELSE 0 END)
					WHEN opType = 104 /*AUXCOPY2*/
						THEN (CASE WHEN EXISTS(SELECT 1 FROM archChunkToReplicate WITH(NOLOCK) WHERE adminJobId = JMAdminJobInfoTable.jobId
							AND SrcCopyId = @i_copyId) THEN 1 ELSE 0 END)
					ELSE 0
				END
			) = 1
	--if aux is running and copy being deleted is destination copy then kill it
	INSERT INTO #tempRunningKillableJobs
		SELECT 	jobId
		FROM 	JMAdminJobInfoTable WITH(READUNCOMMITTED)
		WHERE archGrpID = @i_archGroupId
					AND
					(
						CASE
							WHEN opType =  13 /*AUXCOPY*/ AND archGrpCopyID = @i_copyId
								THEN (CASE WHEN EXISTS(SELECT 1 FROM archChunkToCopy WITH(NOLOCK) WHERE adminJobId = JMAdminJobInfoTable.jobId
									AND destCopyId = @i_copyId) THEN 1 ELSE 0 END)
							WHEN opType = 104 /*AUXCOPY2*/ AND archGrpCopyID = @i_copyId
								THEN (CASE WHEN EXISTS(SELECT 1 FROM archChunkToReplicate WITH(NOLOCK) WHERE adminJobId = JMAdminJobInfoTable.jobId
									AND destCopyId = @i_copyId) THEN 1 ELSE 0 END)
							WHEN opType IN (53 /*OFFLINECONTENTINDEX*/, 57 /*ONLINECONTENTINDEX*/)
THEN (CASE WHEN EXISTS(SELECT 1 FROM archContentIndexingAF WITH(NOLOCK) WHERE archCopyId = @i_copyId AND operationType = 1) THEN 1 ELSE 0 END)
							WHEN opType = 31 /*ARCHIVECHECK*/ AND archGrpCopyID = @i_copyId  --copy level DV
								THEN 1
							ELSE 0
						END
					) = 1
	--SP level auxCopyJobs, if there do not exist any other destination copy other than copy being deleted, then kill that aux copy job
	INSERT INTO #tempRunningKillableJobs
		SELECT 	jobId
		FROM 	JMAdminJobInfoTable WITH(READUNCOMMITTED)
		WHERE archGrpID = @i_archGroupId AND archGrpCopyID = 0 AND opType in (13 /*AUXCOPY*/, 104 /*AUXCOPY2*/)
			AND	(
				CASE
					WHEN opType =  13 /*AUXCOPY*/
						THEN (CASE WHEN NOT EXISTS(SELECT 1 FROM archChunkToCopy WITH(NOLOCK) WHERE adminJobId = JMAdminJobInfoTable.jobId
									AND destCopyId <> @i_copyId) THEN 1 ELSE 0 END)
					WHEN opType = 104 /*AUXCOPY2*/
						THEN (CASE WHEN NOT EXISTS(SELECT 1 FROM archChunkToReplicate WITH(NOLOCK) WHERE adminJobId = JMAdminJobInfoTable.jobId
									AND destCopyId <> @i_copyId) THEN 1 ELSE 0 END)
					ELSE 0
				END
			) = 1
	INSERT INTO #tempRunningCriticalJobs
		SELECT 	jobId
		FROM 	JMAdminJobInfoTable WITH(READUNCOMMITTED)
		WHERE archGrpID = @i_archGroupId
			AND archGrpCopyID = 0
			AND opType in (13 /*AUXCOPY*/, 104 /*AUXCOPY2*/)
			AND	jobid NOT IN (SELECT jobId from #tempRunningKillableJobs)
			AND (
				CASE
					WHEN opType =  13 /*AUXCOPY*/
						THEN (CASE WHEN EXISTS(SELECT 1 FROM archChunkToCopy (READUNCOMMITTED) WHERE adminJobId = JMAdminJobInfoTable.jobId
									AND destCopyId = @i_copyId) THEN 1 ELSE 0 END)
					WHEN opType = 104 /*AUXCOPY2*/
						THEN (CASE WHEN EXISTS(SELECT 1 FROM archChunkToReplicate (READUNCOMMITTED) WHERE adminJobId = JMAdminJobInfoTable.jobId
									AND destCopyId = @i_copyId) THEN 1 ELSE 0 END)
					ELSE 0
				END
			) = 1
	--SP level DV jobs,
	--Running on current copy + another copy = critical
	--Running on only current copy = killable
	INSERT INTO #tempRunningCriticalJobs
		SELECT 	jobId
		FROM 	JMAdminJobInfoTable WITH(READUNCOMMITTED)
		WHERE archGrpID = @i_archGroupId AND opType = 31 /*ARCHIVECHECK*/ AND  archGrpCopyID = 0
			AND	( --Running on current copy
				EXISTS(SELECT TOP 1 1 FROM archChunkToVerify WITH(NOLOCK) WHERE adminJobId = JMAdminJobInfoTable.jobId AND archCopyId = @i_copyId)
				OR 	EXISTS(SELECT TOP 1 1 FROM archChunkToVerify2 WITH(NOLOCK) WHERE adminJobId = JMAdminJobInfoTable.jobId AND srcCopyId = @i_copyId)
				OR 	EXISTS(SELECT TOP 1 1 FROM archChunkToVerifyHistory WITH(NOLOCK) WHERE adminJobId = JMAdminJobInfoTable.jobId AND archCopyId = @i_copyId)
			)
			AND	( --Running on other then current copy
				EXISTS(SELECT TOP 1 1 FROM archChunkToVerify WITH(NOLOCK) WHERE adminJobId = JMAdminJobInfoTable.jobId AND archCopyId <> @i_copyId)
				OR 	EXISTS(SELECT TOP 1 1 FROM archChunkToVerify2 WITH(NOLOCK) WHERE adminJobId = JMAdminJobInfoTable.jobId AND srcCopyId <> @i_copyId)
				OR 	EXISTS(SELECT TOP 1 1 FROM archChunkToVerifyHistory WITH(NOLOCK) WHERE adminJobId = JMAdminJobInfoTable.jobId AND archCopyId <> @i_copyId)
			)
	INSERT INTO #tempRunningKillableJobs
		SELECT 	jobId
		FROM 	JMAdminJobInfoTable WITH(READUNCOMMITTED)
		WHERE archGrpID = @i_archGroupId AND opType = 31 /*ARCHIVECHECK*/ AND  archGrpCopyID = 0
			AND	( --Running on current copy
				EXISTS(SELECT TOP 1 1 FROM archChunkToVerify WITH(NOLOCK) WHERE adminJobId = JMAdminJobInfoTable.jobId AND archCopyId = @i_copyId)
				OR 	EXISTS(SELECT TOP 1 1 FROM archChunkToVerify2 WITH(NOLOCK) WHERE adminJobId = JMAdminJobInfoTable.jobId AND srcCopyId = @i_copyId)
				OR 	EXISTS(SELECT TOP 1 1 FROM archChunkToVerifyHistory WITH(NOLOCK) WHERE adminJobId = JMAdminJobInfoTable.jobId AND archCopyId = @i_copyId)
			)
			AND	( --Not Running on other then current copy
				NOT EXISTS(SELECT TOP 1 1 FROM archChunkToVerify WITH(NOLOCK) WHERE adminJobId = JMAdminJobInfoTable.jobId AND archCopyId <> @i_copyId)
				AND NOT	EXISTS(SELECT TOP 1 1 FROM archChunkToVerify2 WITH(NOLOCK) WHERE adminJobId = JMAdminJobInfoTable.jobId AND srcCopyId <> @i_copyId)
				AND NOT	EXISTS(SELECT TOP 1 1 FROM archChunkToVerifyHistory WITH(NOLOCK) WHERE adminJobId = JMAdminJobInfoTable.jobId AND archCopyId <> @i_copyId)
			)
	--Media Refresh Job
	DECLARE @l_destMediaCopyId INT = 0
	DECLARE @l_destMediaPolicyId INT = 0
	SELECT @l_destMediaPolicyId = AG.id, @l_destMediaCopyId = AGC.destMediaCopyId
	FROM archGroup AG WITH(READUNCOMMITTED), archGroupCopy AGC WITH(READUNCOMMITTED)
	WHERE AG.defaultCopy = AGC.destMediaCopyId AND AGC.id = @i_copyId AND AGC.destMediaCopyId > 0
	/*Media Refresh For Deleting Copy
	* 1. Job is running for current copy --killable
	* 2. Job is running at storage policy level for all copies for this we have to check if current copy is involved in job or not. -- criticalJob
	*	 We do following for checking copy involment
	*    a. Look at archChunkToCopy.archCopyId
	* 3. Current copy is dependent copy of GACP then look for job running on GACP policy and current copy is involved in it. --critical job
	*/
	INSERT INTO #tempRunningKillableJobs
		SELECT 	jobId
		FROM 	JMAdminJobInfoTable WITH(READUNCOMMITTED)
		WHERE	opType = 74 /*MEDIAREFRESHING*/
			AND archGrpID = @i_archGroupId AND	archGrpCopyID = @i_copyId
	INSERT INTO #tempRunningCriticalJobs
		SELECT 	jobId
		FROM 	JMAdminJobInfoTable WITH(READUNCOMMITTED)
		WHERE 	opType = 74 /*MEDIAREFRESHING*/
			AND
			(
				(
					archGrpID = @i_archGroupId
					AND archGrpCopyID = 0
					AND EXISTS(--running on current copy
								SELECT TOP 1 1
								FROM archChunkToCopy WITH(READUNCOMMITTED)
								WHERE adminJobId = JMAdminJobInfoTable.jobId
									AND archCopyId = @i_copyId
							)
					AND EXISTS(--runnning on another copy
								SELECT TOP 1 1
								FROM archChunkToCopy WITH(READUNCOMMITTED)
								WHERE adminJobId = JMAdminJobInfoTable.jobId
									AND archCopyId <> @i_copyId
							)
				)
				OR
				(
					@l_destMediaCopyId > 0
					AND archGrpID = @l_destMediaPolicyId
					AND EXISTS(--running on current copy
								SELECT TOP 1 1
								FROM archChunkToCopy ACC WITH(READUNCOMMITTED), JMJobDataStats JS WITH(READUNCOMMITTED)
								WHERE ACC.adminJobId = JMAdminJobInfoTable.jobId
									AND ACC.archCopyId = @l_destMediaCopyId
									AND ACC.backupJobId = JS.jobId
									AND ACC.CommCellId = JS.CommCellId
									AND JS.archGrpCopyId = @i_copyId
							)
					AND EXISTS(--runnning on another copy
								SELECT TOP 1 1
								FROM archChunkToCopy ACC WITH(READUNCOMMITTED), JMJobDataStats JS WITH(READUNCOMMITTED)
								WHERE ACC.adminJobId = JMAdminJobInfoTable.jobId
									AND ACC.archCopyId = @l_destMediaCopyId
									AND ACC.backupJobId = JS.jobId
									AND ACC.CommCellId = JS.CommCellId
									AND JS.archGrpCopyId <> @i_copyId
							)
				)
			)
	INSERT INTO #tempRunningKillableJobs
		SELECT 	jobId
		FROM 	JMAdminJobInfoTable WITH(READUNCOMMITTED)
		WHERE 	opType = 74 /*MEDIAREFRESHING*/
			AND
			(
				(
					archGrpID = @i_archGroupId
					AND archGrpCopyID = 0
					AND EXISTS(--running on current copy
								SELECT TOP 1 1
								FROM archChunkToCopy WITH(READUNCOMMITTED)
								WHERE adminJobId = JMAdminJobInfoTable.jobId
									AND archCopyId = @i_copyId
							)
					AND NOT EXISTS(--not runnning on any other copy
								SELECT TOP 1 1
								FROM archChunkToCopy WITH(READUNCOMMITTED)
								WHERE adminJobId = JMAdminJobInfoTable.jobId
									AND archCopyId <> @i_copyId
							)
				)
				OR
				(
					@l_destMediaCopyId > 0
					AND archGrpID = @l_destMediaPolicyId
					AND EXISTS(--running on current copy
								SELECT TOP 1 1
								FROM archChunkToCopy ACC WITH(READUNCOMMITTED), JMJobDataStats JS WITH(READUNCOMMITTED)
								WHERE ACC.adminJobId = JMAdminJobInfoTable.jobId
									AND ACC.archCopyId = @l_destMediaCopyId
									AND ACC.backupJobId = JS.jobId
									AND ACC.CommCellId = JS.CommCellId
									AND JS.archGrpCopyId = @i_copyId
							)
					AND NOT EXISTS(--not runnning on any other copy
								SELECT TOP 1 1
								FROM archChunkToCopy ACC WITH(READUNCOMMITTED), JMJobDataStats JS WITH(READUNCOMMITTED)
								WHERE ACC.adminJobId = JMAdminJobInfoTable.jobId
									AND ACC.archCopyId = @l_destMediaCopyId
									AND ACC.backupJobId = JS.jobId
									AND ACC.CommCellId = JS.CommCellId
									AND JS.archGrpCopyId <> @i_copyId
							)
				)
			)
	--Job running at SP level are critical jobs
	--Snap Backup WorkFlow Job -- ignore this as it is workflow job, only child jobs matter
	INSERT INTO #tempRunningCriticalJobs
		SELECT 	jobId
		FROM 	JMAdminJobInfoTable WITH(READUNCOMMITTED)
		WHERE	archGrpID = @i_archGroupId
			AND archGrpCopyID = 0
			AND opType <> 11 --DRBACKUP, job is only associated to primary copy and primary copy is not allowed to delete, only case remaining is inline copy(for that ignore this job),
			AND opType NOT IN (13 /*AUXCOPY*/, 104 /*AUXCOPY2*/, 74 /*MEDIAREFRESHING*/, 31 /*ARCHIVECHECK*/) -- Sp levels of these jobs type are already taken care of
			AND opType NOT IN (95 /*DELAYEDCATALOGWORKFLOW*/, 61 /*SNAPTOTAPEWORKFLOW*/) -- ignore workflow jobs, these are not running on this copy
	--Kill all only-copy level jobs
	INSERT INTO #tempRunningKillableJobs
		SELECT 	jobId
		FROM 	JMAdminJobInfoTable WITH(READUNCOMMITTED)
		WHERE	archGrpCopyID = @i_copyId
			AND jobid NOT IN (SELECT jobId from #tempRunningCriticalJobs)
	--We have taken care of all known job-types in above queries,
	--but if there are some other type of jobs, then better to prevent copy-deletion,
	--if someone report, will add check for that job in future
	INSERT INTO #tempRunningCriticalJobs
		SELECT 	JM.jobId
		FROM JMAdminJobInfoTable JM WITH (NOLOCK)
			INNER JOIN MMResourceToJob R WITH (NOLOCK) ON R.JobId_l = JM.jobId
			INNER JOIN archStream S WITH (NOLOCK) ON R.DestMediaGroupId = S.mediaGroupId
		WHERE  S.archGroupCopyId = @i_copyId
			AND JM.archGrpID = @i_archGroupId
			AND JM.jobId NOT IN (SELECT jobId from #tempRunningKillableJobs UNION SELECT JobId FROM #tempRunningCriticalJobs)
	/* Check source media reservation for restore jobs */
	-- checks if there are any restore running, restores are critical jobs we cannot kill them as part of storage-policy/copy deletion
	INSERT INTO #tempRunningCriticalJobs
		SELECT 	JM.jobId
		FROM JMAdminJobInfoTable JM WITH (NOLOCK), MMResourceToJob J WITH (NOLOCK), MMResource R WITH (NOLOCK), archStream S WITH (NOLOCK)
		WHERE R.MediaGroupId = S.mediaGroupId
			AND S.archGroupCopyId = @i_copyId
			AND J.ReservationId = R.ReservationId
			AND R.ReservationType = 1 --RESERVE_TYPE_READ
			AND J.JobId_l = JM.jobId
			AND JM.archGrpID = @i_archGroupId
			AND JM.jobId NOT IN (SELECT jobID from #tempRunningKillableJobs UNION SELECT jobId FROM #tempRunningCriticalJobs) -- don't consider already filtered jobs
END
ELSE IF	@i_archGroupId > 1
BEGIN
	SELECT @l_defCopyId = defaultCopy, @l_defSnapCopyId = defaultSnapCopy, @policyType = type, @l_archGroupFalgs = flags
	FROM	archGroup WITH (NOLOCK) WHERE id = @i_archGroupId
	IF	@@ROWCOUNT = 0
	BEGIN
SET	@amErrorCode = 3
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO #tempRunningKillableJobs
		SELECT A.JobId
		FROM JMBkpJobInfo A WITH (NOLOCK), JMJobInfo B WITH (NOLOCK)
		WHERE A.JobId = B.JobId AND A.CommCellId = B.CommCellId
			AND (A.currentPolicy = @i_archGroupId OR A.dataPolicy = @i_archGroupId OR A.logPolicy = @i_archGroupId)
IF (@l_archGroupFalgs & 536870912) <> 0
	BEGIN
SET	@amErrorCode = 0X1000000b
		GOTO CX_ERROR_EXIT
	END
IF ( (@l_archGroupFalgs & 256) <> 0  OR
(@l_archGroupFalgs & 16384) <> 0 OR
(@l_archGroupFalgs & 8388608) <> 0  )
	BEGIN
	    DECLARE @l_errorCode int
SET @l_errorCode = (CASE WHEN @l_archGroupFalgs & 256 > 0 THEN 95
WHEN @l_archGroupFalgs & 16384 > 0 THEN 111
ELSE 194 END)
		IF EXISTS (SELECT 1 FROM MMVolume V WITH (NOLOCK),  archStream S WITH (NOLOCK), archCopyToGlobalPolicy CG WITH (NOLOCK)
		           WHERE V.MediaGroupId = S.mediaGroupId  AND V.VolumeFlags IN (1, 2, 7)
				   AND CG.globalPolicyId = @i_archGroupId AND CG.copyId = S.archGroupCopyId )
		BEGIN
			SET	@amErrorCode = @l_errorCode
		END
			-- Check if there are any primaries pointing to GDSP and has subclient associated.
			DECLARE @tblPrimariesToGDSP table (agId int)
			INSERT INTO @tblPrimariesToGDSP
			SELECT AG.id
			FROM archGroup AG WITH (NOLOCK),
			archCopyToGlobalPolicy GC  WITH (NOLOCK)
			WHERE GC.globalPolicyId = @i_archGroupId
			AND (GC.copyID = AG.defaultCopy OR GC.copyId = AG.defaultSnapCopy)
			IF	EXISTS (SELECT 1 FROM APP_Application A WITH (NOLOCK), @tblPrimariesToGDSP T
						WHERE	(A.dataArchGrpId = T.agId OR A.logArchGrpId = T.agId))
			BEGIN
				SET	@amErrorCode = @l_errorCode
			END
			-- Check if there are any secondary copies created to any of the primary copies.
			IF EXISTS (SELECT 1 FROM archGroupCopy AGC WITH (NOLOCK), archGroup AG WITH (NOLOCK), @tblPrimariesToGDSP T
						WHERE AGC.archGroupId = T.agId
						AND NOT EXISTS(SELECT GC.copyId FROM archCopyToGlobalPolicy GC WITH(NOLOCK) WHERE GC.globalPolicyId = @i_archGroupId
						AND GC.copyId = AGC.id))
			BEGIN
				SET	@amErrorCode = @l_errorCode
			END
	END
	INSERT	INTO #copyIdList
	SELECT	id, flags, siloAppId, 0
	FROM	archGroupCopy WITH (NOLOCK)
	WHERE	archGroupId = @i_archGroupId
	IF	EXISTS (SELECT * FROM archFileCopy A WITH (NOLOCK), #copyIdList T
WHERE A.archCopyId = T.copyId and (A.flags & 256) = 0 AND (T.flags & 16777216) <> 0)
	BEGIN
SET	@amErrorCode = 92
		GOTO CX_ERROR_EXIT
	END
	UPDATE	#copyIdList SET siloBackupsetId = APP_Application.backupSet
	FROM	APP_Application WITH (NOLOCK)
	WHERE	APP_Application.id = #copyIdList.siloAppId AND #copyIdList.siloAppId > 0
	IF	EXISTS (
	SELECT 1 FROM APP_Application App WITH (NOLOCK)
				LEFT OUTER JOIN #copyIdList T1 ON App.backupSet = T1.siloBackupsetId
LEFT OUTER JOIN App_InstanceProp IPROP WITH(NOLOCK) ON App.instance = IPROP.componentNameId AND IPROP.attrName =  'Distributed Cluster Type' AND IPROP.attrVal = 7 AND IPROP.modified = 0
				WHERE	(dataArchGrpId = @i_archGroupId OR logArchGrpId = @i_archGroupId) AND T1.siloBackupsetId IS NULL AND IPROP.id IS NULL
					)
	BEGIN
SET	@amErrorCode = 67
		GOTO CX_ERROR_EXIT
	END
	/* Is this an incremental storage policy? */
	IF	EXISTS (SELECT * FROM archGroup WITH (NOLOCK) WHERE incrSP = @i_archGroupId)
	BEGIN
SET	@amErrorCode = 66
		GOTO CX_ERROR_EXIT
	END
DECLARE @DDBBkpsToRetain INT = 0
DECLARE @prevDDBBkpsRetained INT = 0
DECLARE @err INT = 0
SET @DDBBkpsToRetain = (SELECT value FROM MMConfigs WITH (READUNCOMMITTED) WHERE name = 'MMCONFIG_RETAIN_NO_OF_DDB_BACKUPS')
IF @DDBBkpsToRetain > 1
BEGIN
    -- T.rn >= @DDBBkpsToRetain because we maintain old backup info in IdxSIDBSubStoreBackupInfo and latest in IdxSIDBSubStore table
    -- Delete the old DDB Backups
    DELETE I
    FROM IdxSIDBSubStoreBackupInfo I,
		(SELECT SIDBStoreId, SubStoreId, LastSnapJobId, ROW_NUMBER() OVER(PARTITION BY SIDBStoreId, SubStoreId ORDER BY LastSnapTime DESC) AS rn
		FROM IdxSIDBSubStoreBackupInfo WITH (READUNCOMMITTED)
		) T
    WHERE I.SIDBStoreId = T.SIDBStoreId
	AND I.SubStoreId = T.SubStoreId
	AND I.LastSnapJobId = T.LastSnapJobId
	AND T.rn >= @DDBBkpsToRetain
    SET	@err	=	@@ERROR
END
ELSE
BEGIN
    DELETE FROM IdxSIDBSubStoreBackupInfo
END
	--Get all DDB Backup jobs which are pointing to this policy (being deleted)
	INSERT INTO #ReqDDBBackupJobs
		SELECT DISTINCT SS.SIDBStoreId, SS.SubStoreId, SS.commCellId, SS.LastSnapJobId, ISNULL(C.id, SS.commCellId), J.AppId
		FROM IdxSIDBSubStore SS WITH (NOLOCK)
			INNER JOIN IdxSIDBStore S WITH (NOLOCK) ON 	SS.SIDBStoreId = S.SIDBStoreId AND	SS.commCellId = S.commCellId
			INNER JOIN JMBkpStats J WITH (NOLOCK) ON J.JobId = SS.LastSnapJobId AND J.commCellId = SS.commCellId
			LEFT OUTER JOIN APP_CommCell C WITH (NOLOCK) ON RTRIM(LTRIM(SS.DDBBackupCSGUID)) = RTRIM(LTRIM(C.csGUID))
		WHERE	SS.LastSnapJobId > 0
AND	(S.flags & 256) = 0
			AND	(@RetainDDBBkpsOfSealedStores = 1 OR (@RetainDDBBkpsOfSealedStores = 0 AND S.SealedTime = 0))
			AND J.dataStatus = 0 -- DATA_STATUS_VALID    -- pick only those jobs which are still valid.(like delete jobs from MP)
			AND J.dataArchGrpId = @i_archGroupId
	--Get all the old DDB backups which are pointing to this policy (being deleted)
	INSERT INTO #ReqDDBBackupJobs
		SELECT DISTINCT SS.SIDBStoreId, SS.SubStoreId, SS.commCellId, SS.LastSnapJobId, ISNULL(C.id, SS.commCellId), J.AppId
		FROM IdxSIDBSubStoreBackupInfo SS WITH (NOLOCK)
			INNER JOIN IdxSIDBStore S WITH (NOLOCK) ON 	SS.SIDBStoreId = S.SIDBStoreId AND	SS.commCellId = S.commCellId
			INNER JOIN JMBkpStats J WITH (NOLOCK) ON J.JobId = SS.LastSnapJobId AND J.commCellId = SS.commCellId
			LEFT OUTER JOIN APP_CommCell C WITH (NOLOCK) ON RTRIM(LTRIM(SS.DDBBackupCSGUID)) = RTRIM(LTRIM(C.csGUID))
		WHERE	SS.LastSnapJobId > 0
AND	(S.flags & 256) = 0
			AND	(@RetainDDBBkpsOfSealedStores = 1 OR (@RetainDDBBkpsOfSealedStores = 0 AND S.SealedTime = 0))
			AND J.dataStatus = 0 -- DATA_STATUS_VALID    -- pick only those jobs which are still valid.(like delete jobs from MP)
			AND J.dataArchGrpId = @i_archGroupId
	-- filter out DDB Bkp jobs for its own store.
	IF EXISTS (SELECT 1 FROM #ReqDDBBackupJobs T, archCopySIDBStore ACS WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
		   WHERE T.SIDBStoreId = ACS.SIDBStoreId
		   AND T.commCellId = ACS.commCellId
		   AND ACS.copyId = AGC.id
		   AND AGC.archGroupId <> @i_archGroupId
		   --filter out GDSP Primary copies so that they do not interfere in decision to delete the StoragePolicy/Copy
AND AGC.dedupeFlags & 268435456 = 0
		)
	BEGIN
			SET @xmlText  =	(	SELECT (
									SELECT  DISTINCT A.ID AS '@subclientId',
										C.name AS '@clientName',
										IDA.displayName as '@appName',
										I.name AS '@instanceName',
										BS.name AS '@backupsetName',
										A.subclientName AS '@subclientName',
										A.appTypeId AS '@applicationId'
									FROM #ReqDDBBackupJobs T
										INNER JOIN archCopySIDBStore ACS WITH (NOLOCK) ON ACS.SIDBStoreId = T.SIDBStoreId AND ACS.commCellId = T.commCellId
										INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON AGC.id = ACS.copyId
										INNER JOIN APP_Application A WITH(NOLOCK) ON A.id = T.appId
										INNER JOIN APP_Client C WITH(NOLOCK) ON C.id = A.clientId
										INNER JOIN APP_BackupSetName BS WITH(NOLOCK) ON BS.id = A.backupSet
										INNER JOIN APP_iDAType IDA WITH(NOLOCK) ON IDA.type = A.appTypeId
										INNER JOIN APP_InstanceName I WITH(NOLOCK) ON I.id = A.instance
									WHERE AGC.archGroupId <> @i_archGroupId
AND AGC.dedupeFlags & 268435456 = 0 	 --filter out GDSP Primary copies so that they do not interfere in decision to delete the StoragePolicy/Copy
									FOR XML PATH('entity'), TYPE
								)
								FOR XML PATH('Associations'), TYPE
							)
SET @amErrorCode = 110
		   GOTO CX_ERROR_EXIT
	END
	/* Has EZ backupset (CV_STATUS_EZ_BSET = 0x0040) */
	IF	EXISTS (SELECT * FROM APP_Application A WITH (NOLOCK), APP_BackupsetName B WITH (NOLOCK)
				WHERE	(dataArchGrpId = @i_archGroupId OR logArchGrpId = @i_archGroupId)
					AND B.id = A.backupSet AND B.status = 0x0040)
		SET	@hasEZBackupSet = 1
	--If there are any backup running on SP, then pick them for kill operation
	INSERT INTO #tempRunningKillableJobs
		SELECT JobId
		FROM 	JMBkpJobInfo WITH(READUNCOMMITTED)
		WHERE	(currentPolicy = @i_archGroupId OR dataPolicy = @i_archGroupId OR logPolicy = @i_archGroupId)
END
ELSE
BEGIN
SET	@amErrorCode = 3
	GOTO CX_ERROR_EXIT
END
/* Is any Filter archive file still needed? */
INSERT	INTO #latestFilterAF
SELECT	0, 0, archGroupId, appId, MAX(cTime)
FROM	archFile WITH (NOLOCK)
WHERE	fileType = 5 AND isValid = 1
GROUP BY archGroupId, appId
/* Filter archive files can be deleted if there are new Filter archive files in other storage policies */
DELETE	#latestFilterAF
FROM	#latestFilterAF a, (SELECT appId, cTime FROM #latestFilterAF WHERE archGroupId <> @i_archGroupId) b
WHERE	a.archGroupId = @i_archGroupId
	AND b.appId = a.appId AND b.cTime > a.cTime
DELETE	#latestFilterAF
WHERE	archGroupId <> @i_archGroupId
IF	@i_copyId > 0
BEGIN
	UPDATE	#latestFilterAF
	SET		archFileId = b.id, commCellId = b.commCellId
	FROM	#latestFilterAF a, archFile b
	WHERE	b.archGroupId = @i_archGroupId
		AND b.appId = a.appId AND b.cTime = a.cTime
	/* Remove Filter archive files if they are not available in this copy */
	DELETE	#latestFilterAF
	FROM	#latestFilterAF a LEFT OUTER JOIN archFileCopy b
		ON	b.archFileId = a.archFileId AND b.commCellId = a.commCellId
AND b.archCopyId = @i_copyId AND b.isValid = 1 AND (b.flags & 256) = 0
	WHERE	b.archFileId IS NULL
	/* Filter archive files can be deleted if they are also available in another copy */
	DELETE	#latestFilterAF
	FROM	#latestFilterAF a, archFileCopy b
	WHERE	b.archFileId = a.archFileId AND b.commCellId = a.commCellId
AND b.archCopyId <> @i_copyId AND b.isValid = 1 AND (b.flags & 256) = 0
END
/*	Can't delete this policy or copy because it has the latest Filter archive files
	which are still needed for older backup jobs in different storage policies. */
IF	EXISTS (
	SELECT *
	FROM	#latestFilterAF a, archFile b WITH (NOLOCK)
	WHERE	b.archGroupId <> @i_archGroupId
		AND b.appId = a.appId AND b.cTime < a.cTime AND b.isValid = 1)
BEGIN
SET @amErrorCode = 57
	GOTO CX_ERROR_EXIT
END
IF @i_copyId = 0
BEGIN
	/*
	* Check for MediaRefresh Job
	* 1. Job is running for current policy --killable job
	* 2. Job is running for GACP policy of any of the copy in current policy. --critical job
	*/
	INSERT INTO #tempRunningKillableJobs
		SELECT 	jobId
		FROM 	JMAdminJobInfoTable WITH(READUNCOMMITTED)
		WHERE	opType = 74 /*MEDIAREFRESHING*/
			AND archGrpID = @i_archGroupId
	--Dont allow deletion of SP, if media-refresh is running on GACP level
	INSERT INTO #tempRunningCriticalJobs
		SELECT 	jobId
		FROM 	JMAdminJobInfoTable WITH(READUNCOMMITTED)
		WHERE	opType = 74 /*MEDIAREFRESHING*/
			AND archGrpID IN (
								SELECT AG.id
								FROM archGroup AG WITH (READUNCOMMITTED), ArchGroupCopy AGC WITH (READUNCOMMITTED), #copyIdList L
								WHERE AGC.id = L.copyId AND AG.defaultCopy = AGC.destMediaCopyId AND AGC.destMediaCopyId > 0
							)
	/*
	* Check for all other admin Jobs
	* 1. Job is running for current policy -- killable
	* 2. running on GDSP -- non-killable
	*/
	--jobs running on SP level are killable
	INSERT INTO #tempRunningKillableJobs
		SELECT 	jobId
		FROM 	JMAdminJobInfoTable WITH(READUNCOMMITTED)
		WHERE	@i_copyId = 0
			AND archGrpID = @i_archGroupId
	/*--Jobs running on GDSP are not killable, they are critical
	INSERT INTO #tempCriticalRunningJobs
		SELECT 	jobId
		FROM 	JMAdminJobInfoTable WITH(READUNCOMMITTED)
		WHERE	@i_copyId = 0
				AND archGrpID IN (
					SELECT AGCHost.archGroupId FROM archGroupCopy AGCHost JOIN archGroupCopy AGCDep ON AGCHost.SIDBStoreId = AGCDep.SIDBStoreId
WHERE AGCDep.archGroupId = @i_archGroupId AND (AGCDep.dedupeFlags & 134217728) > 0  AND (AGCHost.dedupeFlags & 268435456) > 0
									)
	*/
	/* Check dangling reservation to avoid foreign key constraint violation,
	MMResourceToJob.DestMediaGroupId references to MMMediaGroup.MediaGroupId */
	INSERT INTO #tempRunningCriticalJobs
		SELECT 	JM.jobId
		FROM JMAdminJobInfoTable JM WITH (NOLOCK), MMResourceToJob R WITH (NOLOCK), archStream S WITH (NOLOCK), #copyIdList T
		WHERE R.DestMediaGroupId = S.mediaGroupId AND S.archGroupCopyId = T.copyId
			AND R.JobId_l = JM.jobId
			AND JM.archGrpID = @i_archGroupId
			AND JM.jobId NOT IN (SELECT jobID from #tempRunningKillableJobs UNION SELECT jobId FROM #tempRunningCriticalJobs)
	/* Check source media reservation for restore jobs */
	-- checks if there are any restore running, restores are critical jobs we cannot kill them as part of storage-policy/copy deletion
	INSERT INTO #tempRunningCriticalJobs
		SELECT 	JM.jobId
		FROM JMAdminJobInfoTable JM WITH (NOLOCK), MMResourceToJob J WITH (NOLOCK), MMResource R WITH (NOLOCK), archStream S WITH (NOLOCK), #copyIdList T
		WHERE R.MediaGroupId = S.mediaGroupId
			AND S.archGroupCopyId = T.copyId
			AND J.ReservationId = R.ReservationId
			AND J.JobId_l = JM.jobId
			AND JM.archGrpID = @i_archGroupId
			AND JM.jobId NOT IN (SELECT jobID from #tempRunningKillableJobs UNION SELECT jobId FROM #tempRunningCriticalJobs) -- don't consider already filtered jobs
END
/* Check if any snap of this policy or copy is still mounted */
IF EXISTS ( SELECT *
			FROM SMSnapResource A WITH (NOLOCK), SMVolume B WITH (NOLOCK)
			WHERE A.SMVolumeId = B.SMVolumeId
			AND B.CopyId IN (SELECT copyId FROM #copyIdList) )
BEGIN
SET	@amErrorCode = 85
	GOTO CX_ERROR_EXIT
END
/* Check if any snap of this policy or copy is still not deleted for snap vault or mirror */
/*
   For LREP case we will have to prevent copy deletion for Primary Snap Copy as it is equivalent of Vault in non-LREP case
   Also we should prevent copy deletion here only if we have an associated SMRelation. This is to handle case where LREP copy is associated with an invalid DFM entry and hence
   it has no associated snap or storage service
*/
IF	EXISTS (SELECT * FROM	archGroupCopy AGC WITH (NOLOCK) INNER JOIN Archgroup AG WITH (NOLOCK) ON AGC.archGroupId = AG.id
			INNER JOIN SMCopyToRelationMap SMCR WITH (NOLOCK) ON AGC.id = SMCR.ArchGroupCopyId
			LEFT OUTER JOIN ArchGroupControlHost AGCH ON AGCH.ArchGroupId = AG.id AND AGCH.SMReplicationProtocolType = 1
			WHERE	AGC.id IN (SELECT copyId FROM #copyIdList)
				AND (AGC.id <> @l_defSnapCopyId OR AGCH.ArchGroupId is not null) AND isSnapCopy = 1)
BEGIN
SET	@amErrorCode = 100
	GOTO CX_ERROR_EXIT
END
/* Check if any snap of this policy or copy is still not deleted for mirror copy for Offline Replication */
IF	EXISTS (SELECT 1	FROM archGroupCopy AGC (NOLOCK)
						INNER JOIN Archgroup AG (NOLOCK) ON AGC.archGroupId = AG.id
						INNER JOIN SMVolume VOL (NOLOCK) ON VOL.CopyId = AGC.id
						LEFT OUTER JOIN ArchGroupControlHost AGCH ON AGCH.ArchGroupId = AG.id
			WHERE		AGC.id IN (SELECT copyId FROM #copyIdList)
						AND AGCH.ArchGroupId IS NULL
						AND AGC.id <> @l_defSnapCopyId
						AND isSnapCopy = 1)
BEGIN
SET	@amErrorCode = 100
	GOTO CX_ERROR_EXIT
END
CX_ERROR_EXIT:
SET @jobIdList = ''
SET @criticalJobIdList = ''
--Priority, throw critical jobs if any otherwise throw all running jobs which can be killed
IF EXISTS (SELECT TOP 1 1 from #tempRunningCriticalJobs)
BEGIN
	SET @criticalJobIdList = ISNULL(STUFF((select DISTINCT ','+CAST(jobId as varchar(20)) from #tempRunningCriticalJobs for xml path('')),1,1,''),'')
SET	@amErrorCode = 26
END
IF EXISTS (SELECT TOP 1 1 from #tempRunningKillableJobs)
BEGIN
	SET @jobIdList = ISNULL(STUFF((select DISTINCT ','+CAST(jobId as varchar(20)) from #tempRunningKillableJobs for xml path('')),1,1,''),'')
END
DROP TABLE #adminJobList
DROP TABLE #latestFilterAF
DROP TABLE #copyIdList
DROP TABLE #ReqDDBBackupJobs
DROP TABLE #tempRunningKillableJobs
DROP TABLE #tempRunningCriticalJobs
SELECT	@amErrorCode, @policyType, @hasEZBackupSet, @jobIdList, @criticalJobIdList, @xmlText
RETURN	@amErrorCode;
GO

IF EXISTS (select * from GxQscripts where name = 'archCanDeletePolicyOrCopy')
	delete from GxQscripts where name = 'archCanDeletePolicyOrCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCanDeletePolicyOrCopy')
	delete from GXDBVersions where aliasname = 'archCanDeletePolicyOrCopy'
GO

insert into GXDBVersions values(2, 'archCanDeletePolicyOrCopy',  '00010039000200380000', 'archCanDeletePolicyOrCopy', '00010039000200380000')
GO

